/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.Chart;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.DefaultImageView;
import ncsa.hdf.view.DefaultTextView;
import ncsa.hdf.view.MathConversionDialog;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTableView
extends JInternalFrame
implements TableView,
ActionListener,
MouseListener {
    private static final long serialVersionUID = -7452459299532863847L;
    private final ViewManager viewer;
    private char NT = (char)32;
    private Dataset dataset;
    private Object dataValue;
    private JTable table;
    private JLabel cellLabel;
    private JTextArea cellValueField;
    private boolean isValueChanged;
    private final Toolkit toolkit;
    private boolean isReadOnly;
    private boolean isDisplayTypeChar;
    private boolean isDataTransposed;
    private boolean isRegRef;
    private boolean isObjRef;
    private final JCheckBoxMenuItem checkFixedDataLength;
    private int fixedDataLength;
    private final JCheckBoxMenuItem checkScientificNotation;
    private final JCheckBoxMenuItem checkHex;
    private final JCheckBoxMenuItem checkBin;
    private final DecimalFormat scientificFormat = new DecimalFormat("###.#####E0#");
    private final NumberFormat normalFormat;
    private NumberFormat numberFormat = this.normalFormat = null;
    private boolean showAsHex = false;
    private boolean showAsBin = false;
    private final boolean[] startEditing = new boolean[]{false};
    private JPopupMenu popupMenu;
    private ViewType viewType;
    private JTextField frameField;
    private long curFrame = 0L;
    private long maxFrame = 1L;
    private Object fillValue = null;
    private BitSet bitmask;
    private ViewProperties.BITMASK_OP bitmaskOP = ViewProperties.BITMASK_OP.EXTRACT;
    private int binaryOrder;
    private int indexBase = 0;
    private static final int FLOAT_BUFFER_SIZE = 524288;
    private static final int INT_BUFFER_SIZE = 524288;
    private static final int SHORT_BUFFER_SIZE = 0x100000;
    private static final int LONG_BUFFER_SIZE = 262144;
    private static final int DOUBLE_BUFFER_SIZE = 262144;
    private static final int BYTE_BUFFER_SIZE = 0x200000;
    private Object currentEditingCellValue = null;

    public DefaultTableView(ViewManager viewManager) {
        this(viewManager, null);
    }

    public DefaultTableView(ViewManager viewManager, HashMap hashMap) {
        int n;
        String string;
        Object object;
        this.setDefaultCloseOperation(2);
        this.viewer = viewManager;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isValueChanged = false;
        this.isReadOnly = false;
        this.isRegRef = false;
        this.isObjRef = false;
        this.viewType = ViewType.TABLE;
        this.fixedDataLength = -1;
        HObject hObject = null;
        this.popupMenu = null;
        this.bitmask = null;
        if (ViewProperties.isIndexBase1()) {
            this.indexBase = 1;
        }
        this.checkFixedDataLength = new JCheckBoxMenuItem("Fixed Data Length", false);
        this.checkScientificNotation = new JCheckBoxMenuItem("Show Scientific Notation", false);
        this.checkHex = new JCheckBoxMenuItem("Show Hexadecimal", false);
        this.checkBin = new JCheckBoxMenuItem("Show Binary", false);
        if (hashMap != null) {
            hObject = (HObject)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT);
            this.bitmask = (BitSet)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASK);
            this.bitmaskOP = (ViewProperties.BITMASK_OP)((Object)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASKOP));
            object = (Boolean)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.CHAR);
            if (object != null) {
                this.isDisplayTypeChar = (Boolean)object;
            }
            if ((object = (Boolean)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.TRANSPOSED)) != null) {
                this.isDataTransposed = (Boolean)object;
            }
            if ((object = (Boolean)hashMap.get((Object)ViewProperties.DATA_VIEW_KEY.INDEXBASE1)) != null) {
                this.indexBase = ((Boolean)object).booleanValue() ? 1 : 0;
            }
        }
        if (hObject == null) {
            hObject = this.viewer.getTreeView().getCurrentObject();
        }
        if (hObject == null || !(hObject instanceof Dataset)) {
            return;
        }
        this.dataset = (Dataset)hObject;
        this.isReadOnly = this.dataset.getFileFormat().isReadOnly();
        object = this.dataset.getDims();
        long l = 1L;
        for (int i = 0; i < ((Object)object).length; ++i) {
            l *= object[i];
        }
        if (this.dataset.getHeight() <= 0 || this.dataset.getWidth() <= 0 || l <= 0L) {
            return;
        }
        if (this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4")) && this.dataset instanceof CompoundDS) {
            this.isReadOnly = true;
        }
        if (!this.isReadOnly && (string = this.dataset.getCompression()) != null && string.startsWith("SZIP") && !string.endsWith("ENCODE_ENABLED")) {
            this.isReadOnly = true;
        }
        Datatype datatype = this.dataset.getDatatype();
        this.isDisplayTypeChar = this.isDisplayTypeChar && (datatype.getDatatypeSize() == 1 || datatype.getDatatypeClass() == 10 && datatype.getBasetype().getDatatypeClass() == 2);
        this.dataset.setEnumConverted(ViewProperties.isConvertEnum());
        if (this.dataset instanceof CompoundDS) {
            this.isDataTransposed = false;
            this.setFrameIcon(ViewProperties.getTableIcon());
            this.table = this.createTable((CompoundDS)this.dataset);
        } else {
            this.setFrameIcon(ViewProperties.getDatasetIcon());
            this.table = this.createTable((ScalarDS)this.dataset);
            if (datatype.getDatatypeClass() == 7) {
                this.table.addMouseListener(this);
                if (datatype.getDatatypeSize() > 8) {
                    this.isReadOnly = true;
                    this.isRegRef = true;
                } else {
                    this.isObjRef = true;
                }
            }
        }
        if (this.table == null) {
            this.viewer.showStatus("Creating table failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        this.table.setName("data");
        ColumnHeader columnHeader = new ColumnHeader(this.table);
        columnHeader.setName("columnHeaders");
        this.table.setTableHeader(columnHeader);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        this.table.setGridColor(Color.gray);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(100);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(100);
        RowHeader rowHeader = new RowHeader(this.table, this.dataset);
        rowHeader.setName("rowHeaders");
        JViewport jViewport = new JViewport();
        jViewport.add(rowHeader);
        jViewport.setPreferredSize(rowHeader.getPreferredSize());
        jScrollPane.setRowHeader(jViewport);
        this.cellLabel = new JLabel("");
        this.cellLabel.setBorder(new EtchedBorder(1));
        Dimension dimension = this.cellLabel.getPreferredSize();
        dimension.width = 75;
        this.cellLabel.setPreferredSize(dimension);
        this.cellLabel.setHorizontalAlignment(4);
        this.cellValueField = new JTextArea();
        this.cellValueField.setLineWrap(true);
        this.cellValueField.setWrapStyleWord(true);
        this.cellValueField.setEditable(false);
        this.cellValueField.setBackground(new Color(255, 255, 240));
        JScrollPane jScrollPane2 = new JScrollPane(this.cellValueField);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(50);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(50);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.cellLabel, "West");
        jPanel.add((Component)jScrollPane2, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jScrollPane);
        jSplitPane.setDividerLocation(25);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.add(jSplitPane);
        StringBuffer stringBuffer = new StringBuffer("TableView  -  ");
        stringBuffer.append(hObject.getName());
        stringBuffer.append("  -  ");
        stringBuffer.append(hObject.getPath());
        stringBuffer.append("  -  ");
        stringBuffer.append(this.dataset.getFile());
        this.setTitle(stringBuffer.toString());
        int n2 = this.dataset.getRank();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray = this.dataset.getSelectedDims();
        long[] lArray2 = this.dataset.getStride();
        long[] lArray3 = this.dataset.getStartDims();
        int n3 = Math.min(3, n2);
        if (n2 > 2) {
            this.curFrame = lArray3[nArray[2]] + (long)this.indexBase;
            this.maxFrame = (long)object[nArray[2]];
        }
        stringBuffer.append(" [ dims");
        stringBuffer.append(nArray[0]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(nArray[n]);
        }
        stringBuffer.append(", start");
        stringBuffer.append(lArray3[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray3[nArray[n]]);
        }
        stringBuffer.append(", count");
        stringBuffer.append(lArray[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray[nArray[n]]);
        }
        stringBuffer.append(", stride");
        stringBuffer.append(lArray2[nArray[0]]);
        for (n = 1; n < n3; ++n) {
            stringBuffer.append("x");
            stringBuffer.append(lArray2[nArray[n]]);
        }
        stringBuffer.append(" ] ");
        this.setJMenuBar(this.createMenuBar());
        this.viewer.showStatus(stringBuffer.toString());
        n = this.table.getFontMetrics(this.table.getFont()).getHeight();
        rowHeader.setRowHeight(n);
        this.table.setRowHeight(n);
        if (this.isRegRef || this.isObjRef) {
            this.popupMenu = this.createPopupMenu();
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        boolean bl = !this.isReadOnly;
        boolean bl2 = this.dataset.getRank() > 2;
        JMenu jMenu = new JMenu("Table", false);
        jMenu.setMnemonic('T');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Export Data to Text File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save table as text");
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Export Data to Binary File");
        if (this.dataset instanceof ScalarDS) {
            jMenu.add(jMenu2);
        }
        jMenuItem = new JMenuItem("Native Order");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save table as binary Native Order");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Little Endian");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save table as binary Little Endian");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Big Endian");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save table as binary Big Endian");
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Import Data from Text File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Import data from file");
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        jMenuItem = this.checkFixedDataLength;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Fixed data length");
        if (this.dataset instanceof ScalarDS) {
            jMenu.add(jMenuItem);
        }
        JMenu jMenu3 = new JMenu("Import Data from Binary File");
        if (this.dataset instanceof ScalarDS) {
            jMenu.add(jMenu3);
        }
        jMenuItem = new JMenuItem("Native Order");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Order as Native Order");
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("Little Endian");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Order as Little Endian");
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("Big Endian");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Order as Big Endian");
        jMenu3.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Copy data");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Paste data");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Copy to New Dataset");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Write selection to dataset");
        jMenuItem.setEnabled(bl && this.dataset instanceof ScalarDS);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Changes to File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save dataset");
        jMenuItem.setEnabled(bl);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2, true));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Select all data");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, true));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Show Lineplot");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show chart");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Statistics");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show statistics");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Math Conversion");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Math conversion");
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = this.checkScientificNotation;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show scientific notation");
        if (this.dataset instanceof ScalarDS) {
            jMenu.add(jMenuItem);
        }
        boolean bl3 = this.NT == 'B' || this.NT == 'S' || this.NT == 'I' || this.NT == 'J';
        jMenuItem = this.checkHex;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show hexadecimal");
        if (this.dataset instanceof ScalarDS && bl3) {
            jMenu.add(jMenuItem);
        }
        jMenuItem = this.checkBin;
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show binary");
        if (this.dataset instanceof ScalarDS && bl3) {
            jMenu.add(jMenuItem);
        }
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close");
        jMenu.add(jMenuItem);
        jMenuBar.add(new JLabel("     "));
        Insets insets = new Insets(0, 2, 0, 2);
        JButton jButton = new JButton(ViewProperties.getChartIcon());
        jMenuBar.add(jButton);
        jButton.setToolTipText("Line Plot");
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        jButton.setActionCommand("Show chart");
        if (bl2) {
            jMenuBar.add(new JLabel("     "));
            jButton = new JButton(ViewProperties.getFirstIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("First");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("First page");
            jButton = new JButton(ViewProperties.getPreviousIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Previous");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Previous page");
            this.frameField = new JTextField(String.valueOf(this.curFrame));
            this.frameField.setMaximumSize(new Dimension(50, 30));
            jMenuBar.add(this.frameField);
            this.frameField.setMargin(insets);
            this.frameField.addActionListener(this);
            this.frameField.setActionCommand("Go to frame");
            JLabel jLabel = new JLabel(String.valueOf(this.maxFrame), 0);
            jLabel.setMaximumSize(new Dimension(50, 30));
            jMenuBar.add(jLabel);
            jButton = new JButton(ViewProperties.getNextIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Next");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Next page");
            jButton = new JButton(ViewProperties.getLastIcon());
            jMenuBar.add(jButton);
            jButton.setToolTipText("Last");
            jButton.setMargin(insets);
            jButton.addActionListener(this);
            jButton.setActionCommand("Last page");
        }
        return jMenuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Close")) {
                this.dispose();
                return;
            }
            if (string.equals("Save table as text")) {
                try {
                    this.saveAsText();
                    return;
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    return;
                }
            }
            if (string.startsWith("Save table as binary")) {
                if (string.equals("Save table as binary Native Order")) {
                    this.binaryOrder = 1;
                }
                if (string.equals("Save table as binary Little Endian")) {
                    this.binaryOrder = 2;
                }
                if (string.equals("Save table as binary Big Endian")) {
                    this.binaryOrder = 3;
                }
                try {
                    this.saveAsBinary();
                    return;
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    return;
                }
            }
            if (string.equals("Copy data")) {
                this.copyData();
                return;
            }
            if (string.equals("Paste data")) {
                this.pasteData();
                return;
            }
            if (string.equals("Import data from file")) {
                String string2 = this.dataset.getFileFormat().getParent();
                JFileChooser jFileChooser = new JFileChooser(string2);
                jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterText());
                int n = jFileChooser.showOpenDialog(this);
                if (n != 0) {
                    return;
                }
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                String string3 = file.getAbsolutePath();
                this.importTextData(string3);
                return;
            }
            if (string.startsWith("Order as")) {
                if (string.equals("Order as Native Order")) {
                    this.binaryOrder = 1;
                }
                if (string.equals("Order as Little Endian")) {
                    this.binaryOrder = 2;
                }
                if (string.equals("Order as Big Endian")) {
                    this.binaryOrder = 3;
                }
                this.importBinaryData();
                return;
            }
            if (string.equals("Write selection to dataset")) {
                JTable jTable = this.getTable();
                if (jTable.getSelectedColumnCount() <= 0 || jTable.getSelectedRowCount() <= 0) {
                    JOptionPane.showMessageDialog(this, "Select table cells to write.", "HDFView", 1);
                    return;
                }
                TreeView treeView = this.viewer.getTreeView();
                TreeNode treeNode = this.viewer.getTreeView().findTreeNode(this.dataset);
                Group group = (Group)((DefaultMutableTreeNode)treeNode.getParent()).getUserObject();
                TreeNode treeNode2 = this.dataset.getFileFormat().getRootNode();
                if (treeNode2 == null) {
                    return;
                }
                Vector<Object> vector = new Vector<Object>(this.dataset.getFileFormat().getNumberOfMembers() + 5);
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode2).depthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    vector.add(defaultMutableTreeNode.getUserObject());
                }
                NewDatasetDialog newDatasetDialog = new NewDatasetDialog((JFrame)((Object)this.viewer), group, vector, this);
                newDatasetDialog.setVisible(true);
                HObject hObject = (HObject)newDatasetDialog.getObject();
                if (hObject != null) {
                    Group group2 = newDatasetDialog.getParentGroup();
                    try {
                        treeView.addObject(hObject, group2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                vector.setSize(0);
                return;
            }
            if (string.equals("Save dataset")) {
                try {
                    this.updateValueInFile();
                    return;
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    return;
                }
            }
            if (string.equals("Select all data")) {
                try {
                    this.selectAll();
                    return;
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    return;
                }
            }
            if (string.equals("Show chart")) {
                this.showLineplot();
                return;
            }
            if (string.equals("First page")) {
                this.firstPage();
                return;
            }
            if (string.equals("Previous page")) {
                this.previousPage();
                return;
            }
            if (string.equals("Next page")) {
                this.nextPage();
                return;
            }
            if (string.equals("Last page")) {
                this.lastPage();
                return;
            }
            if (string.equals("Show statistics")) {
                try {
                    Object object2 = null;
                    object2 = this.getSelectedData();
                    if (this.dataset instanceof CompoundDS) {
                        int n = this.table.getSelectedColumnCount();
                        if (n != 1) {
                            JOptionPane.showMessageDialog(this, "Please select one colunm a time for compound dataset.", this.getTitle(), 0);
                            return;
                        }
                    } else if (object2 == null) {
                        object2 = this.dataValue;
                    }
                    double[] dArray = new double[2];
                    double[] dArray2 = new double[2];
                    Tools.findMinMax(object2, dArray, this.fillValue);
                    if (Tools.computeStatistics(object2, dArray2, this.fillValue) > 0) {
                        String string4 = "Min                      = " + dArray[0] + "\nMax                      = " + dArray[1] + "\nMean                     = " + dArray2[0] + "\nStandard deviation = " + dArray2[1];
                        JOptionPane.showMessageDialog(this, string4, "Statistics", 1);
                    }
                    object2 = null;
                    System.gc();
                    return;
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    return;
                }
            }
            if (string.equals("Math conversion")) {
                try {
                    this.mathConversion();
                    return;
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), exception, this.getTitle(), 0);
                    return;
                }
            }
            if (string.startsWith("Go to frame")) {
                int n = 0;
                try {
                    n = Integer.parseInt(this.frameField.getText().trim()) - this.indexBase;
                }
                catch (Exception exception) {
                    n = -1;
                }
                this.gotoPage(n);
                return;
            }
            if (string.equals("Show scientific notation")) {
                if (this.checkScientificNotation.isSelected()) {
                    this.numberFormat = this.scientificFormat;
                    this.checkHex.setSelected(false);
                    this.checkBin.setSelected(false);
                    this.showAsHex = false;
                    this.showAsBin = false;
                } else {
                    this.numberFormat = this.normalFormat;
                }
                this.updateUI();
                return;
            }
            if (string.equals("Show hexadecimal")) {
                this.showAsHex = this.checkHex.isSelected();
                if (this.showAsHex) {
                    this.checkScientificNotation.setSelected(false);
                    this.checkBin.setSelected(false);
                    this.showAsBin = false;
                    this.numberFormat = this.normalFormat;
                }
                this.updateUI();
                return;
            }
            if (string.equals("Show binary")) {
                this.showAsBin = this.checkBin.isSelected();
                if (this.showAsBin) {
                    this.checkScientificNotation.setSelected(false);
                    this.checkHex.setSelected(false);
                    this.showAsHex = false;
                    this.numberFormat = this.normalFormat;
                }
                this.updateUI();
                return;
            }
            if (string.equals("Fixed data length")) {
                if (!this.checkFixedDataLength.isSelected()) {
                    this.fixedDataLength = -1;
                    this.updateUI();
                    return;
                }
                String string5 = JOptionPane.showInputDialog(this, "Enter fixed data length when importing text data\n\nFor example, for a text string of \"12345678\"\n\t\tenter 2, the data will be 12, 34, 56, 78\n\t\tenter 4, the data will be 1234, 5678\n", "");
                if (string5 == null || string5.length() < 1) {
                    this.checkFixedDataLength.setSelected(false);
                    return;
                }
                try {
                    this.fixedDataLength = Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    this.fixedDataLength = -1;
                }
                if (this.fixedDataLength >= 1) return;
                this.checkFixedDataLength.setSelected(false);
                return;
            }
            if (!string.startsWith("Show data as")) return;
            this.viewType = string.endsWith("table") ? ViewType.TABLE : (string.endsWith("image") ? ViewType.IMAGE : ViewType.TABLE);
            Object object3 = this.getSelectedData();
            if (object3 == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "No data selected.", this.getTitle(), 0);
                return;
            }
            int n = Array.getLength(object3);
            int n2 = 0;
            while (n2 < n) {
                if (this.isRegRef) {
                    this.showRegRefData((String)Array.get(object3, n2));
                } else if (this.isObjRef) {
                    this.showObjRefData(Array.getLong(object3, n2));
                }
                ++n2;
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public void dispose() {
        if (this.isValueChanged && !this.isReadOnly) {
            int n = JOptionPane.showConfirmDialog(this, "\"" + this.dataset.getName() + "\" has changed.\n" + "Do you want to save the changes?", this.getTitle(), 0);
            if (n == 0) {
                this.updateValueInFile();
            } else {
                this.dataset.clearData();
            }
        }
        if (this.dataset instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)this.dataset;
            if (scalarDS.isImage()) {
                scalarDS.clearData();
            }
            this.dataValue = null;
            this.table = null;
        }
        this.viewer.removeDataView(this);
        super.dispose();
    }

    private void previousPage() {
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray = this.dataset.getStartDims();
        long[] lArray2 = this.dataset.getDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long l = lArray[nArray[2]];
        if (l == 0L) {
            return;
        }
        this.gotoPage(lArray[nArray[2]] - 1L);
    }

    private void nextPage() {
        long[] lArray;
        int[] nArray;
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray2 = this.dataset.getStartDims();
        long l = lArray2[(nArray = this.dataset.getSelectedIndex())[2]];
        if (l == (lArray = this.dataset.getDims())[nArray[2]] - 1L) {
            return;
        }
        this.gotoPage(lArray2[nArray[2]] + 1L);
    }

    private void firstPage() {
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray = this.dataset.getStartDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getDims();
        long l = lArray[nArray[2]];
        if (l == 0L) {
            return;
        }
        this.gotoPage(0L);
    }

    private void lastPage() {
        long[] lArray;
        int[] nArray;
        int n = this.dataset.getRank();
        if (n < 3) {
            return;
        }
        long[] lArray2 = this.dataset.getStartDims();
        long l = lArray2[(nArray = this.dataset.getSelectedIndex())[2]];
        if (l == (lArray = this.dataset.getDims())[nArray[2]] - 1L) {
            return;
        }
        this.gotoPage(lArray[nArray[2]] - 1L);
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    private void showLineplot() {
        Object object;
        int n;
        int n2;
        double d;
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.table.getSelectedColumns();
        if (nArray == null || nArray2 == null || nArray.length <= 0 || nArray2.length <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select rows/columns to draw line plot.", this.getTitle(), 0);
            return;
        }
        int n3 = this.table.getRowCount();
        int n4 = this.table.getColumnCount();
        LineplotOption lineplotOption = new LineplotOption((JFrame)((Object)this.viewer), "Line Plot Options -- " + this.dataset.getName(), n3, n4);
        lineplotOption.setVisible(true);
        int n5 = lineplotOption.getPlotBy();
        if (n5 == -1) {
            return;
        }
        boolean bl = n5 == 0;
        int n6 = lineplotOption.getXindex();
        double[][] dArray = null;
        int n7 = 0;
        String string = "Lineplot - " + this.dataset.getPath() + this.dataset.getName();
        String[] stringArray = null;
        double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] dArray3 = null;
        if (bl) {
            string = string + " - by row";
            n7 = nArray.length;
            if (n7 > 10) {
                this.toolkit.beep();
                n7 = 10;
                JOptionPane.showMessageDialog(this, "More than 10 rows are selected.\nThe first 10 rows will be displayed.", this.getTitle(), 2);
            }
            stringArray = new String[n7];
            dArray = new double[n7][nArray2.length];
            d = 0.0;
            for (n2 = 0; n2 < n7; ++n2) {
                stringArray[n2] = String.valueOf(nArray[n2]);
                for (int i = 0; i < nArray2.length; ++i) {
                    dArray[n2][i] = 0.0;
                    try {
                        dArray[n2][i] = d = Double.parseDouble(this.table.getValueAt(nArray[n2], nArray2[i]).toString());
                        dArray2[0] = Math.min(dArray2[0], d);
                        dArray2[1] = Math.max(dArray2[1], d);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (n6 >= 0) {
                dArray3 = new double[nArray2.length];
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    dArray3[n2] = 0.0;
                    try {
                        dArray3[n2] = d = Double.parseDouble(this.table.getValueAt(n6, nArray2[n2]).toString());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        } else {
            string = string + " - by column";
            n7 = nArray2.length;
            if (n7 > 10) {
                this.toolkit.beep();
                n7 = 10;
                JOptionPane.showMessageDialog(this, "More than 10 columns are selected.\nThe first 10 columns will be displayed.", this.getTitle(), 2);
            }
            stringArray = new String[n7];
            dArray = new double[n7][nArray.length];
            d = 0.0;
            for (n2 = 0; n2 < n7; ++n2) {
                stringArray[n2] = this.table.getColumnName(nArray2[n2]);
                for (int i = 0; i < nArray.length; ++i) {
                    dArray[n2][i] = 0.0;
                    try {
                        dArray[n2][i] = d = Double.parseDouble(this.table.getValueAt(nArray[i], nArray2[n2]).toString());
                        dArray2[0] = Math.min(dArray2[0], d);
                        dArray2[1] = Math.max(dArray2[1], d);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (n6 >= 0) {
                dArray3 = new double[nArray.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    dArray3[n2] = 0.0;
                    try {
                        dArray3[n2] = d = Double.parseDouble(this.table.getValueAt(nArray[n2], n6).toString());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((n = this.removeInvalidPlotData(dArray, dArray3, dArray2)) < dArray[0].length) {
            object = new double[dArray.length][n];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.arraycopy(dArray[n2], 0, object[n2], 0, n);
            }
            dArray = object;
            if (dArray3 != null) {
                double[] dArray4 = new double[n];
                System.arraycopy(dArray3, 0, dArray4, 0, n);
                dArray3 = dArray4;
            }
        }
        if (dArray2[0] == dArray2[1]) {
            dArray2[1] = dArray2[1] + 1.0;
            dArray2[0] = dArray2[0] - 1.0;
        } else if (dArray2[0] > dArray2[1]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot show line plot for the selected data. \nPlease check the data range: (" + dArray2[0] + ", " + dArray2[1] + ").", this.getTitle(), 0);
            dArray = null;
            return;
        }
        object = new Chart((JFrame)((Object)this.viewer), string, 1, dArray, dArray3, dArray2);
        ((Chart)object).setLineLabels(stringArray);
        String string2 = this.dataValue.getClass().getName();
        char c = string2.charAt(string2.lastIndexOf("[") + 1);
        if (c == 'B' || c == 'S' || c == 'I' || c == 'J') {
            ((Chart)object).setTypeToInteger();
        }
        ((Dialog)object).setVisible(true);
    }

    private int removeInvalidPlotData(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        boolean bl = false;
        if (dArray == null || dArray3 == null) {
            return -1;
        }
        dArray3[0] = Double.POSITIVE_INFINITY;
        dArray3[1] = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray[0].length; ++i) {
            bl = false;
            for (int j = 0; j < dArray.length; ++j) {
                bl = Tools.isNaNINF(dArray[j][i]);
                if (dArray2 != null) {
                    boolean bl2 = bl = bl || Tools.isNaNINF(dArray2[i]);
                }
                if (bl) break;
                dArray[j][n] = dArray[j][i];
                if (dArray2 != null) {
                    dArray2[n] = dArray2[i];
                }
                dArray3[0] = Math.min(dArray3[0], dArray[j][n]);
                dArray3[1] = Math.max(dArray3[1], dArray[j][n]);
            }
            if (bl) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Object getSelectedData() {
        if (this.dataset instanceof CompoundDS) {
            return this.getSelectedCompoundData();
        }
        return this.getSelectedScalarData();
    }

    private Object getSelectedScalarData() {
        Object[] objectArray = null;
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.table.getSelectedColumns();
        if (nArray == null || nArray.length <= 0 || nArray2 == null || nArray2.length <= 0) {
            return null;
        }
        int n = nArray2.length * nArray.length;
        if (this.table.getColumnCount() == nArray2.length && this.table.getRowCount() == nArray.length) {
            return this.dataValue;
        }
        objectArray = null;
        if (this.isRegRef) {
            objectArray = new String[n];
        } else {
            switch (this.NT) {
                case 'B': {
                    objectArray = new byte[n];
                    break;
                }
                case 'S': {
                    objectArray = new short[n];
                    break;
                }
                case 'I': {
                    objectArray = new int[n];
                    break;
                }
                case 'J': {
                    objectArray = new long[n];
                    break;
                }
                case 'F': {
                    objectArray = new float[n];
                    break;
                }
                case 'D': {
                    objectArray = new double[n];
                    break;
                }
                default: {
                    objectArray = null;
                }
            }
        }
        if (objectArray == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported data type.", this.getTitle(), 0);
            return null;
        }
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getSelectedColumn();
        int n4 = this.table.getColumnCount();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                n5 = nArray[i] * n4 + nArray2[j];
                Array.set(objectArray, n6, Array.get(this.dataValue, n5));
                ++n6;
            }
        }
        return objectArray;
    }

    private Object getSelectedCompoundData() {
        Object[] objectArray = null;
        int n = this.table.getSelectedColumnCount();
        int n2 = this.table.getSelectedRowCount();
        if (n <= 0 || n2 <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data is selected.", this.getTitle(), 0);
            return null;
        }
        Object object = null;
        try {
            object = ((List)this.dataset.getData()).get(this.table.getSelectedColumn());
        }
        catch (Exception exception) {
            return null;
        }
        int n3 = Array.getLength(object);
        String string = object.getClass().getName();
        int n4 = string.lastIndexOf("[");
        int n5 = 32;
        if (n4 >= 0) {
            n5 = string.charAt(n4 + 1);
        }
        if (n5 == 66) {
            objectArray = new byte[n3];
        } else if (n5 == 83) {
            objectArray = new short[n3];
        } else if (n5 == 73) {
            objectArray = new int[n3];
        } else if (n5 == 74) {
            objectArray = new long[n3];
        } else if (n5 == 70) {
            objectArray = new float[n3];
        } else if (n5 == 68) {
            objectArray = new double[n3];
        } else {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported data type.", this.getTitle(), 0);
            return null;
        }
        System.arraycopy(object, 0, objectArray, 0, n3);
        return objectArray;
    }

    private JTable createTable(ScalarDS scalarDS) {
        Datatype datatype;
        int n;
        Object object;
        JTable jTable = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = scalarDS.getRank();
        if (n4 <= 0) {
            try {
                scalarDS.init();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception, "createTable:" + this.getTitle(), 0);
                this.dataValue = null;
                return null;
            }
            n4 = scalarDS.getRank();
        }
        long[] lArray = scalarDS.getSelectedDims();
        n2 = (int)lArray[0];
        n3 = 1;
        if (n4 > 1) {
            n2 = scalarDS.getHeight();
            n3 = scalarDS.getWidth();
        }
        this.dataValue = null;
        try {
            this.dataValue = scalarDS.getData();
            if (this.dataValue == null) {
                JOptionPane.showMessageDialog(this, "No data read", "ScalarDS createTable:" + this.getTitle(), 2);
                return null;
            }
            if (Tools.applyBitmask(this.dataValue, this.bitmask, this.bitmaskOP)) {
                this.isReadOnly = true;
                String string = "Extract bits ";
                if (this.bitmaskOP == ViewProperties.BITMASK_OP.AND) {
                    string = "Apply bitwise AND ";
                }
                object = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 1), string + this.bitmask, 3, 2, this.getFont(), Color.RED));
                this.setBorder((Border)object);
            }
            scalarDS.convertFromUnsignedC();
            this.dataValue = scalarDS.getData();
            if (Array.getLength(this.dataValue) <= n2) {
                n3 = 1;
            }
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, throwable, "ScalarDS createTable:" + this.getTitle(), 0);
            this.dataValue = null;
        }
        if (this.dataValue == null) {
            return null;
        }
        this.fillValue = scalarDS.getFillValue();
        boolean bl = scalarDS.isUnsigned();
        object = this.dataValue.getClass().getName();
        int n5 = ((String)object).lastIndexOf("[");
        if (n5 >= 0) {
            this.NT = ((String)object).charAt(n5 + 1);
        }
        boolean bl2 = ((String)object).startsWith("[Ljava.lang.String;");
        if (this.isDisplayTypeChar && (this.NT == 'B' || this.NT == 'S')) {
            int n6 = Array.getLength(this.dataValue);
            char[] cArray = new char[n6];
            for (n = 0; n < n6; ++n) {
                if (this.NT == 'B') {
                    cArray[n] = (char)Array.getByte(this.dataValue, n);
                    continue;
                }
                if (this.NT != 'S') continue;
                cArray[n] = (char)Array.getShort(this.dataValue, n);
            }
            this.dataValue = cArray;
        } else if (this.NT == 'B' && this.dataset.getDatatype().getDatatypeClass() == 10 && (datatype = this.dataset.getDatatype().getBasetype()).getDatatypeClass() == 3) {
            this.dataValue = Dataset.byteToString((byte[])this.dataValue, datatype.getDatatypeSize());
        }
        final String[] stringArray = new String[n3];
        final int n7 = n2;
        n = n3;
        long[] lArray2 = this.dataset.getStartDims();
        long[] lArray3 = this.dataset.getStride();
        int[] nArray = this.dataset.getSelectedIndex();
        final int n8 = (int)lArray2[nArray[0]];
        final int n9 = (int)lArray3[nArray[0]];
        int n10 = 0;
        int n11 = 1;
        if (n4 > 1) {
            n10 = (int)lArray2[nArray[1]];
            n11 = (int)lArray3[nArray[1]];
        }
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = String.valueOf(n10 + this.indexBase + i * n11);
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = 254175303655079056L;
            private final StringBuffer stringBuffer = new StringBuffer();
            private final Datatype dtype = DefaultTableView.access$000(DefaultTableView.this).getDatatype();
            private final Datatype btype = this.dtype.getBasetype();
            private final int typeSize = this.dtype.getDatatypeSize();
            private final boolean isArray = this.dtype.getDatatypeClass() == 10;
            private final boolean isStr = DefaultTableView.access$100(DefaultTableView.this) == 'L';
            private final boolean isInt = DefaultTableView.access$100(DefaultTableView.this) == 'B' || DefaultTableView.access$100(DefaultTableView.this) == 'S' || DefaultTableView.access$100(DefaultTableView.this) == 'I' || DefaultTableView.access$100(DefaultTableView.this) == 'J';
            private final boolean isUINT64 = this.dtype.isUnsigned() && DefaultTableView.access$100(DefaultTableView.this) == 'J';
            private Object theValue;
            boolean isNaturalOrder = DefaultTableView.access$000(DefaultTableView.this).getRank() == 1 || DefaultTableView.access$000(DefaultTableView.this).getSelectedIndex()[0] < DefaultTableView.access$000(DefaultTableView.this).getSelectedIndex()[1];

            @Override
            public int getColumnCount() {
                return stringArray.length;
            }

            @Override
            public int getRowCount() {
                return n7;
            }

            @Override
            public String getColumnName(int n2) {
                return stringArray[n2];
            }

            @Override
            public Object getValueAt(int n8, int n2) {
                if (DefaultTableView.this.startEditing[0]) {
                    return "";
                }
                if (this.isArray) {
                    int n3 = this.dtype.getDatatypeSize() / this.btype.getDatatypeSize();
                    this.stringBuffer.setLength(0);
                    int n4 = (n8 * n + n2) * n3;
                    int n5 = n4 + n3;
                    if (DefaultTableView.this.isDisplayTypeChar) {
                        for (int i = n4; i < n5; ++i) {
                            this.stringBuffer.append(Array.getChar(DefaultTableView.this.dataValue, i));
                            if (this.stringBuffer.length() <= 0 || i >= n5 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    } else if (this.isUINT64) {
                        for (int i = n4; i < n5; ++i) {
                            Long l = (Long)Array.get(DefaultTableView.this.dataValue, i);
                            if (l < 0L) {
                                l = l << 1 >>> 1;
                                BigInteger bigInteger = new BigInteger("9223372036854775808");
                                BigInteger bigInteger2 = new BigInteger(l.toString());
                                BigInteger bigInteger3 = bigInteger.add(bigInteger2);
                                this.stringBuffer.append(bigInteger3.toString());
                            } else {
                                this.stringBuffer.append(Array.get(DefaultTableView.this.dataValue, i));
                            }
                            if (this.stringBuffer.length() <= 0 || i >= n5 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    } else {
                        for (int i = n4; i < n5; ++i) {
                            this.stringBuffer.append(Array.get(DefaultTableView.this.dataValue, i));
                            if (this.stringBuffer.length() <= 0 || i >= n5 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    }
                    this.theValue = this.stringBuffer;
                } else {
                    int n6 = n2 * n7 + n8;
                    if (DefaultTableView.this.dataset.getRank() > 1) {
                        n6 = DefaultTableView.this.isDataTransposed && this.isNaturalOrder || !DefaultTableView.this.isDataTransposed && !this.isNaturalOrder ? n2 * n7 + n8 : n8 * n + n2;
                    }
                    this.theValue = Array.get(DefaultTableView.this.dataValue, n6);
                    if (this.isStr) {
                        return this.theValue;
                    }
                    if (this.isUINT64) {
                        Long l = (Long)this.theValue;
                        if (l < 0L) {
                            l = l << 1 >>> 1;
                            BigInteger bigInteger = new BigInteger("9223372036854775808");
                            BigInteger bigInteger4 = new BigInteger(l.toString());
                            BigInteger bigInteger5 = bigInteger.add(bigInteger4);
                            this.theValue = bigInteger5.toString();
                        }
                    } else if (DefaultTableView.this.showAsHex && this.isInt) {
                        this.theValue = Long.toHexString(Long.valueOf(this.theValue.toString()));
                    } else if (DefaultTableView.this.showAsBin && this.isInt) {
                        this.theValue = Tools.toBinaryString(Long.valueOf(this.theValue.toString()), this.typeSize);
                    } else if (DefaultTableView.this.numberFormat != null) {
                        this.theValue = DefaultTableView.this.numberFormat.format(this.theValue);
                    }
                }
                return this.theValue;
            }
        };
        jTable = new JTable(abstractTableModel){
            private static final long serialVersionUID = -145476220959400488L;
            private final Datatype dtype;
            private final boolean isArray;
            {
                super(tableModel);
                this.dtype = DefaultTableView.this.dataset.getDatatype();
                this.isArray = this.dtype.getDatatypeClass() == 10;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return !DefaultTableView.this.isReadOnly && !DefaultTableView.this.isDisplayTypeChar && !this.isArray && !DefaultTableView.this.showAsBin && !DefaultTableView.this.showAsHex;
            }

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                MouseEvent mouseEvent;
                int n3;
                if (!this.isCellEditable(n, n2)) {
                    return super.editCellAt(n, n2, eventObject);
                }
                if (eventObject instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)eventObject;
                    if (keyEvent.getID() == 401) {
                        ((DefaultTableView)DefaultTableView.this).startEditing[0] = true;
                    }
                } else if (eventObject instanceof MouseEvent && (n3 = (mouseEvent = (MouseEvent)eventObject).getClickCount()) > 1) {
                    DefaultTableView.this.currentEditingCellValue = this.getValueAt(n, n2);
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n2 = this.getEditingColumn();
                super.editingStopped(changeEvent);
                ((DefaultTableView)DefaultTableView.this).startEditing[0] = false;
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    CellEditor cellEditor = (CellEditor)object;
                    String string = (String)cellEditor.getCellEditorValue();
                    try {
                        DefaultTableView.this.updateValueInMemory(string, n, n2);
                    }
                    catch (Exception exception) {
                        DefaultTableView.this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, exception, DefaultTableView.this.getTitle(), 0);
                    }
                }
            }

            @Override
            public boolean isCellSelected(int n, int n2) {
                if (this.getSelectedRow() == n && this.getSelectedColumn() == n2) {
                    DefaultTableView.this.cellLabel.setText(String.valueOf(n8 + DefaultTableView.this.indexBase + n * n9) + ", " + DefaultTableView.this.table.getColumnName(n2) + "  =  ");
                    Object object = this.getValueAt(n, n2);
                    String string = null;
                    if (DefaultTableView.this.isRegRef) {
                        String string2 = (String)object;
                        String string3 = string2.substring(string2.indexOf(58) + 1, string2.indexOf(32));
                        long[] lArray = new long[]{-1L};
                        try {
                            lArray[0] = Long.valueOf(string3);
                            HObject hObject = FileFormat.findObject(DefaultTableView.this.dataset.getFileFormat(), lArray);
                            string = hObject.getFullName() + " " + string2.substring(string2.indexOf("{"));
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                    } else if (DefaultTableView.this.isObjRef) {
                        Long l = (Long)object;
                        long[] lArray = new long[]{l};
                        try {
                            HObject hObject = FileFormat.findObject(DefaultTableView.this.dataset.getFileFormat(), lArray);
                            string = hObject.getFullName();
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                    }
                    if (string == null && object != null) {
                        string = object.toString();
                    }
                    DefaultTableView.this.cellValueField.setText(string);
                }
                return super.isCellSelected(n, n2);
            }
        };
        jTable.setName("ScalarDS");
        return jTable;
    }

    private JTable createTable(CompoundDS compoundDS) {
        JTable jTable = null;
        int n = compoundDS.getRank();
        if (n <= 0) {
            compoundDS.init();
        }
        long[] lArray = compoundDS.getStartDims();
        long[] lArray2 = compoundDS.getStride();
        int[] nArray = compoundDS.getSelectedIndex();
        final int n2 = (int)lArray[nArray[0]];
        final int n3 = (int)lArray2[nArray[0]];
        if (compoundDS.getHeight() > 10000) {
            compoundDS.setConvertByteToString(false);
        }
        this.dataValue = null;
        try {
            this.dataValue = compoundDS.getData();
        }
        catch (Throwable throwable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, throwable, "TableView" + this.getTitle(), 0);
            this.dataValue = null;
        }
        if (this.dataValue == null || !(this.dataValue instanceof List)) {
            return null;
        }
        final int n4 = compoundDS.getHeight();
        int n5 = compoundDS.getSelectedMemberCount();
        String[] stringArray = new String[n5];
        int n6 = 0;
        String[] stringArray2 = compoundDS.getMemberNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!compoundDS.isMemberSelected(i)) continue;
            stringArray[n6] = stringArray2[i];
            stringArray[n6] = stringArray[n6].replaceAll("\u0095", "->");
            ++n6;
        }
        String[] stringArray3 = stringArray;
        int n7 = compoundDS.getWidth();
        if (n7 > 1) {
            stringArray3 = new String[n7 * stringArray.length];
            int n8 = stringArray.length / 2;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    stringArray3[i * stringArray.length + j] = j == n8 ? i + 1 + "\n " + stringArray[j] : " \n " + stringArray[j];
                }
            }
        }
        final String[] stringArray4 = stringArray3;
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -2176296469630678304L;
            CompoundDS compound;
            int[] orders;
            Datatype[] types;
            StringBuffer stringBuffer;
            int nFields;
            int nRows;
            int nSubColumns;
            {
                this.compound = (CompoundDS)DefaultTableView.this.dataset;
                this.orders = this.compound.getSelectedMemberOrders();
                this.types = this.compound.getSelectedMemberTypes();
                this.stringBuffer = new StringBuffer();
                this.nFields = ((List)DefaultTableView.this.dataValue).size();
                this.nRows = this.getRowCount();
                this.nSubColumns = this.nFields > 0 ? this.getColumnCount() / this.nFields : 0;
            }

            @Override
            public int getColumnCount() {
                return stringArray4.length;
            }

            @Override
            public int getRowCount() {
                return n4;
            }

            @Override
            public String getColumnName(int n) {
                return stringArray4[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                boolean bl;
                if (DefaultTableView.this.startEditing[0]) {
                    return "";
                }
                int n3 = n2;
                int n42 = n;
                if (this.nSubColumns > 1) {
                    int n5 = n2 / this.nFields;
                    n3 = n2 - n5 * this.nFields;
                    n42 = n * this.orders[n3] * this.nSubColumns + n5 * this.orders[n3];
                } else {
                    n42 = n * this.orders[n3];
                }
                Object e = ((List)DefaultTableView.this.dataValue).get(n3);
                if (e == null) {
                    return "Null";
                }
                this.stringBuffer.setLength(0);
                boolean bl2 = bl = this.types[n3].getDatatypeClass() == 3;
                if (bl && e instanceof byte[]) {
                    int n6 = this.types[n3].getDatatypeSize();
                    String string = new String((byte[])e, n42 * n6, n6);
                    int n7 = string.indexOf(0);
                    if (n7 > 0) {
                        string = string.substring(0, n7);
                    }
                    this.stringBuffer.append(string.trim());
                } else {
                    String string;
                    int n8;
                    Datatype datatype = this.types[n3];
                    if (datatype.getDatatypeClass() == 10) {
                        datatype = this.types[n3].getBasetype();
                    }
                    boolean bl3 = false;
                    if (datatype.isUnsigned() && (n8 = (string = e.getClass().getName()).lastIndexOf("[")) >= 0) {
                        bl3 = string.charAt(n8 + 1) == 'J';
                    }
                    for (int i = 0; i < this.orders[n3]; ++i) {
                        Long l;
                        Object object = Array.get(e, n42 + i);
                        if (bl3 && (l = (Long)object) < 0L) {
                            l = l << 1 >>> 1;
                            BigInteger bigInteger = new BigInteger("9223372036854775808");
                            BigInteger bigInteger2 = new BigInteger(l.toString());
                            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
                            object = bigInteger3.toString();
                        }
                        if (i > 0) {
                            this.stringBuffer.append(", ");
                        }
                        this.stringBuffer.append(object);
                    }
                }
                return this.stringBuffer;
            }
        };
        jTable = new JTable(abstractTableModel){
            private static final long serialVersionUID = 3221288637329958074L;
            int lastSelectedRow;
            int lastSelectedColumn;
            {
                super(tableModel);
                this.lastSelectedRow = -1;
                this.lastSelectedColumn = -1;
            }

            @Override
            public boolean isCellEditable(int n, int n22) {
                return !DefaultTableView.this.isReadOnly;
            }

            @Override
            public boolean editCellAt(int n, int n22, EventObject eventObject) {
                MouseEvent mouseEvent;
                int n32;
                if (!this.isCellEditable(n, n22)) {
                    return super.editCellAt(n, n22, eventObject);
                }
                if (eventObject instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)eventObject;
                    if (keyEvent.getID() == 401) {
                        ((DefaultTableView)DefaultTableView.this).startEditing[0] = true;
                    }
                } else if (eventObject instanceof MouseEvent && (n32 = (mouseEvent = (MouseEvent)eventObject).getClickCount()) > 1) {
                    DefaultTableView.this.currentEditingCellValue = this.getValueAt(n, n22);
                }
                return super.editCellAt(n, n22, eventObject);
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n22 = this.getEditingColumn();
                super.editingStopped(changeEvent);
                ((DefaultTableView)DefaultTableView.this).startEditing[0] = false;
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    CellEditor cellEditor = (CellEditor)object;
                    String string = (String)cellEditor.getCellEditorValue();
                    try {
                        DefaultTableView.this.updateValueInMemory(string, n, n22);
                    }
                    catch (Exception exception) {
                        DefaultTableView.this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, exception, DefaultTableView.this.getTitle(), 0);
                    }
                }
            }

            @Override
            public boolean isCellSelected(int n, int n22) {
                if (this.lastSelectedRow == n && this.lastSelectedColumn == n22) {
                    return super.isCellSelected(n, n22);
                }
                this.lastSelectedRow = n;
                this.lastSelectedColumn = n22;
                if (this.getSelectedRow() == n && this.getSelectedColumn() == n22) {
                    DefaultTableView.this.cellLabel.setText(String.valueOf(n2 + DefaultTableView.this.indexBase + n * n3) + ", " + DefaultTableView.this.table.getColumnName(n22) + "  =  ");
                    DefaultTableView.this.cellValueField.setText(this.getValueAt(n, n22).toString());
                }
                return super.isCellSelected(n, n22);
            }
        };
        if (n7 > 1) {
            MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer(n7, stringArray.length);
            Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
            }
        }
        jTable.setName("CompoundDS");
        return jTable;
    }

    private void gotoPage(long l) {
        if (this.dataset.getRank() < 3 || l == this.curFrame - (long)this.indexBase) {
            return;
        }
        if (this.isValueChanged) {
            this.updateValueInFile();
        }
        long[] lArray = this.dataset.getStartDims();
        int[] nArray = this.dataset.getSelectedIndex();
        long[] lArray2 = this.dataset.getDims();
        if (l < 0L || l >= lArray2[nArray[2]]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Frame number must be between" + this.indexBase + " and " + (lArray2[nArray[2]] - 1L + (long)this.indexBase), this.getTitle(), 0);
            return;
        }
        lArray[nArray[2]] = l;
        this.curFrame = l + (long)this.indexBase;
        this.dataset.clearData();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.dataValue = this.dataset.getData();
            if (this.dataset instanceof ScalarDS) {
                ((ScalarDS)this.dataset).convertFromUnsignedC();
                this.dataValue = this.dataset.getData();
            }
        }
        catch (Exception exception) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dataValue = null;
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.frameField.setText(String.valueOf(this.curFrame));
        this.updateUI();
    }

    private void copyData() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = this.table.getSelectedRowCount();
        int n4 = this.table.getSelectedColumnCount();
        int n5 = n + n3;
        int n6 = n2 + n4;
        try {
            for (int i = n; i < n5; ++i) {
                stringBuffer.append(this.table.getValueAt(i, n2).toString());
                for (int j = n2 + 1; j < n6; ++j) {
                    stringBuffer.append("\t");
                    stringBuffer.append(this.table.getValueAt(i, j).toString());
                }
                stringBuffer.append("\n");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "Copying data to system clipboard failed. \nUsing \"export/import data\" for copying/pasting large data.", this.getTitle(), 0);
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private void pasteData() {
        int n = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (n == 1) {
            return;
        }
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getRowCount();
        int n4 = this.table.getSelectedRow();
        int n5 = this.table.getSelectedColumn();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n6 = n4;
        int n7 = n5;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = "";
        try {
            String string2 = (String)clipboard.getData(DataFlavor.stringFlavor);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens() && n6 < n3) {
                string = stringTokenizer.nextToken();
                if (this.fixedDataLength < 1) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\t");
                    while (stringTokenizer2.hasMoreTokens() && n7 < n2) {
                        try {
                            this.updateValueInMemory(stringTokenizer2.nextToken(), n6, n7);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        ++n7;
                    }
                    ++n6;
                    n7 = n5;
                    continue;
                }
                int n8 = string.length();
                for (int i = 0; i < n8; i += this.fixedDataLength) {
                    try {
                        String string3 = string.substring(i, i + this.fixedDataLength);
                        this.updateValueInMemory(string3, n6, n7);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    ++n7;
                }
            }
        }
        catch (Throwable throwable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, throwable, this.getTitle(), 0);
        }
        this.table.updateUI();
    }

    private void importTextData(String string) {
        int n = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (n == 1) {
            return;
        }
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getRowCount();
        int n4 = this.table.getSelectedRow();
        int n5 = this.table.getSelectedColumn();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (this.dataset instanceof CompoundDS) {
            n5 = 0;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
        String string3 = ViewProperties.getDataDelimiter();
        String string4 = "";
        if (this.dataset instanceof CompoundDS) {
            string4 = "\t";
        } else if (string3.equalsIgnoreCase("Tab")) {
            string4 = "\t";
        } else if (string3.equalsIgnoreCase("Space")) {
            string4 = " " + string4;
        } else if (string3.equalsIgnoreCase("Comma")) {
            string4 = ",";
        } else if (string3.equalsIgnoreCase("Colon")) {
            string4 = ":";
        } else if (string3.equalsIgnoreCase("Semi-Colon")) {
            string4 = ";";
        }
        String string5 = null;
        int n6 = n5;
        for (int i = n4; string2 != null && i < n3; ++i) {
            if (this.fixedDataLength > 0) {
                int n7 = string2.length();
                for (int j = 0; j < n7; j += this.fixedDataLength) {
                    try {
                        String string6 = string2.substring(j, j + this.fixedDataLength);
                        this.updateValueInMemory(string6, i, n6);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    ++n6;
                }
            } else {
                try {
                    stringTokenizer = new StringTokenizer(string2, string4);
                    while (stringTokenizer.hasMoreTokens() && n6 < n2) {
                        string5 = stringTokenizer.nextToken();
                        if (this.dataset instanceof ScalarDS) {
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string5);
                            while (stringTokenizer2.hasMoreTokens() && n6 < n2) {
                                this.updateValueInMemory(stringTokenizer2.nextToken(), i, n6);
                                ++n6;
                            }
                            continue;
                        }
                        this.updateValueInMemory(string5, i, n6);
                        ++n6;
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            n6 = 0;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.table.updateUI();
    }

    private void importBinaryData() {
        String string = this.dataset.getFileFormat().getParent();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterBinary());
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string2 = file.getAbsolutePath();
        int n2 = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (n2 == 1) {
            return;
        }
        this.getBinaryDatafromFile(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBinaryDatafromFile(String string) {
        String string2 = string;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ByteBuffer byteBuffer = null;
        try {
            fileInputStream = new FileInputStream(string2);
            long l = fileInputStream.getChannel().size();
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            Object object = this.dataset.getData();
            int n = Array.getLength(object);
            String string3 = object.getClass().getName();
            char c = string3.charAt(string3.lastIndexOf("[") + 1);
            if (c == 'B') {
                long l2 = n;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int n2 = (int)Math.min(l, l2);
                int n3 = n2 - 0x200000;
                int n4 = 0;
                int n5 = 0;
                byte[] byArray = new byte[0x200000];
                do {
                    n4 = n3 <= 0 ? n3 + 0x200000 : 0x200000;
                    bufferedInputStream.read(byteBuffer.array(), 0, n4);
                    byteBuffer.get(byArray, 0, n4);
                    System.arraycopy(byArray, 0, this.dataValue, n5 * 0x200000, n4);
                    byteBuffer.clear();
                    ++n5;
                } while ((n3 -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (c == 'S') {
                long l3 = n * 2;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int n6 = (int)Math.min(l, l3);
                int n7 = n6 - 0x200000;
                int n8 = 0;
                int n9 = 0;
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                short[] sArray = new short[0x100000];
                do {
                    n8 = n7 <= 0 ? n7 + 0x200000 : 0x200000;
                    bufferedInputStream.read(byteBuffer.array(), 0, n8);
                    shortBuffer.get(sArray, 0, n8 / 2);
                    System.arraycopy(sArray, 0, this.dataValue, n9 * 0x100000, n8 / 2);
                    byteBuffer.clear();
                    shortBuffer.clear();
                    ++n9;
                } while ((n7 -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (c == 'I') {
                long l4 = n * 4;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int n10 = (int)Math.min(l, l4);
                int n11 = n10 - 0x200000;
                int n12 = 0;
                int n13 = 0;
                int[] nArray = new int[524288];
                byte[] byArray = byteBuffer.array();
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                do {
                    n12 = n11 <= 0 ? n11 + 0x200000 : 0x200000;
                    bufferedInputStream.read(byArray, 0, n12);
                    intBuffer.get(nArray, 0, n12 / 4);
                    System.arraycopy(nArray, 0, this.dataValue, n13 * 524288, n12 / 4);
                    byteBuffer.clear();
                    intBuffer.clear();
                    ++n13;
                } while ((n11 -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (c == 'J') {
                long l5 = n * 8;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int n14 = (int)Math.min(l, l5);
                int n15 = n14 - 0x200000;
                int n16 = 0;
                int n17 = 0;
                long[] lArray = new long[262144];
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                do {
                    n16 = n15 <= 0 ? n15 + 0x200000 : 0x200000;
                    bufferedInputStream.read(byteBuffer.array(), 0, n16);
                    longBuffer.get(lArray, 0, n16 / 8);
                    System.arraycopy(lArray, 0, this.dataValue, n17 * 262144, n16 / 8);
                    byteBuffer.clear();
                    longBuffer.clear();
                    ++n17;
                } while ((n15 -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (c == 'F') {
                long l6 = n * 4;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int n18 = (int)Math.min(l, l6);
                int n19 = n18 - 0x200000;
                int n20 = 0;
                int n21 = 0;
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                float[] fArray = new float[524288];
                do {
                    n20 = n19 <= 0 ? n19 + 0x200000 : 0x200000;
                    bufferedInputStream.read(byteBuffer.array(), 0, n20);
                    floatBuffer.get(fArray, 0, n20 / 4);
                    System.arraycopy(fArray, 0, this.dataValue, n21 * 524288, n20 / 4);
                    byteBuffer.clear();
                    floatBuffer.clear();
                    ++n21;
                } while ((n19 -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (c == 'D') {
                long l7 = n * 8;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int n22 = (int)Math.min(l, l7);
                int n23 = n22 - 0x200000;
                int n24 = 0;
                int n25 = 0;
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                double[] dArray = new double[262144];
                do {
                    n24 = n23 <= 0 ? n23 + 0x200000 : 0x200000;
                    bufferedInputStream.read(byteBuffer.array(), 0, n24);
                    doubleBuffer.get(dArray, 0, n24 / 8);
                    System.arraycopy(dArray, 0, this.dataValue, n25 * 262144, n24 / 8);
                    byteBuffer.clear();
                    doubleBuffer.clear();
                    ++n25;
                } while ((n23 -= 0x200000) > -2097152);
                this.isValueChanged = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                bufferedInputStream.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.table.updateUI();
    }

    private void saveAsText() throws Exception {
        int n;
        JFileChooser jFileChooser = new JFileChooser(this.dataset.getFile());
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterText());
        jFileChooser.setDialogTitle("Save Current Data To Text File --- " + this.dataset.getName());
        File file = new File(this.dataset.getName() + ".txt");
        jFileChooser.setSelectedFile(file);
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        List<FileFormat> list = this.viewer.getTreeView().getCurrentFiles();
        if (list != null) {
            Object object2 = null;
            for (FileFormat fileFormat : list) {
                if (!fileFormat.getFilePath().equals(string)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + string + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        String string2 = ViewProperties.getDataDelimiter();
        String string3 = "";
        if (this.dataset instanceof CompoundDS) {
            string3 = "\t";
        }
        if (string2.equalsIgnoreCase("Tab")) {
            string3 = "\t";
        } else if (string2.equalsIgnoreCase("Space")) {
            string3 = " " + string3;
        } else if (string2.equalsIgnoreCase("Comma")) {
            string3 = "," + string3;
        } else if (string2.equalsIgnoreCase("Colon")) {
            string3 = ":" + string3;
        } else if (string2.equalsIgnoreCase("Semi-Colon")) {
            string3 = ";" + string3;
        }
        int n3 = this.table.getColumnCount();
        int n4 = this.table.getRowCount();
        for (int i = 0; i < n4; ++i) {
            printWriter.print(this.table.getValueAt(i, 0));
            for (int j = 1; j < n3; ++j) {
                printWriter.print(string3);
                printWriter.print(this.table.getValueAt(i, j));
            }
            printWriter.println();
        }
        printWriter.flush();
        printWriter.close();
        this.viewer.showStatus("Data save to: " + string);
    }

    private void saveAsBinary() throws Exception {
        int n;
        JFileChooser jFileChooser = new JFileChooser(this.dataset.getFile());
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilterBinary());
        jFileChooser.setDialogTitle("Save Current Data To Binary File --- " + this.dataset.getName());
        File file = new File(this.dataset.getName() + ".bin");
        jFileChooser.setSelectedFile(file);
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        List<FileFormat> list = this.viewer.getTreeView().getCurrentFiles();
        if (list != null) {
            Object object2 = null;
            for (FileFormat fileFormat : list) {
                if (!fileFormat.getFilePath().equals(string)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + string + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        if (this.dataset instanceof ScalarDS) {
            Object object = this.dataset.getData();
            String string2 = object.getClass().getName();
            char c = string2.charAt(string2.lastIndexOf("[") + 1);
            ByteBuffer byteBuffer = null;
            int n3 = Array.getLength(object);
            if (c == 'B') {
                byte[] lArray = new byte[n3];
                lArray = (byte[])object;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int longBuffer = n3 - 0x200000;
                int n13 = 0;
                int n14 = 0;
                do {
                    n13 = longBuffer <= 0 ? longBuffer + 0x200000 : 0x200000;
                    byteBuffer.clear();
                    byteBuffer.put(lArray, n14 * 0x200000, n13);
                    dataOutputStream.write(byteBuffer.array(), 0, n13);
                    ++n14;
                } while ((longBuffer -= 0x200000) > -2097152);
                dataOutputStream.flush();
                dataOutputStream.close();
            } else if (c == 'S') {
                short[] fArray = new short[n3];
                fArray = (short[])object;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                ShortBuffer floatBuffer = byteBuffer.asShortBuffer();
                int n16 = n3 - 0x100000;
                int n17 = 0;
                int n18 = 0;
                do {
                    n17 = n16 <= 0 ? n16 + 0x100000 : 0x100000;
                    byteBuffer.clear();
                    floatBuffer.clear();
                    floatBuffer.put(fArray, n18 * 0x100000, n17);
                    dataOutputStream.write(byteBuffer.array(), 0, n17 * 2);
                    ++n18;
                } while ((n16 -= 0x100000) > -1048576);
                dataOutputStream.flush();
                dataOutputStream.close();
            } else if (c == 'I') {
                int[] dArray = new int[n3];
                dArray = (int[])object;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                IntBuffer doubleBuffer = byteBuffer.asIntBuffer();
                int n19 = n3 - 524288;
                int n20 = 0;
                int n21 = 0;
                do {
                    n20 = n19 <= 0 ? n19 + 524288 : 524288;
                    byteBuffer.clear();
                    doubleBuffer.clear();
                    doubleBuffer.put(dArray, n21 * 524288, n20);
                    dataOutputStream.write(byteBuffer.array(), 0, n20 * 4);
                    ++n21;
                } while ((n19 -= 524288) > -524288);
                dataOutputStream.flush();
                dataOutputStream.close();
            } else if (c == 'J') {
                long[] lArray = new long[n3];
                lArray = (long[])object;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                int n4 = n3 - 262144;
                int n5 = 0;
                int n6 = 0;
                do {
                    n5 = n4 <= 0 ? n4 + 262144 : 262144;
                    byteBuffer.clear();
                    longBuffer.clear();
                    longBuffer.put(lArray, n6 * 262144, n5);
                    dataOutputStream.write(byteBuffer.array(), 0, n5 * 8);
                    ++n6;
                } while ((n4 -= 262144) > -262144);
                dataOutputStream.flush();
                dataOutputStream.close();
            } else if (c == 'F') {
                float[] fArray = new float[n3];
                fArray = (float[])object;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                int n7 = n3 - 524288;
                int n8 = 0;
                int n9 = 0;
                do {
                    n8 = n7 <= 0 ? n7 + 524288 : 524288;
                    byteBuffer.clear();
                    floatBuffer.clear();
                    floatBuffer.put(fArray, n9 * 524288, n8);
                    dataOutputStream.write(byteBuffer.array(), 0, n8 * 4);
                    ++n9;
                } while ((n7 -= 524288) > -524288);
                dataOutputStream.flush();
                dataOutputStream.close();
            } else if (c == 'D') {
                double[] dArray = new double[n3];
                dArray = (double[])object;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                int n10 = n3 - 262144;
                int n11 = 0;
                int n12 = 0;
                do {
                    n11 = n10 <= 0 ? n10 + 262144 : 262144;
                    byteBuffer.clear();
                    doubleBuffer.clear();
                    doubleBuffer.put(dArray, n12 * 262144, n11);
                    dataOutputStream.write(byteBuffer.array(), 0, n11 * 8);
                    ++n12;
                } while ((n10 -= 262144) > -262144);
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        this.viewer.showStatus("Data save to: " + string);
    }

    @Override
    public void updateValueInFile() {
        if (this.isReadOnly || this.showAsBin || this.showAsHex) {
            return;
        }
        if (!this.isValueChanged) {
            return;
        }
        try {
            this.dataset.write();
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return;
        }
        this.isValueChanged = false;
    }

    private void selectAll() throws Exception {
        this.table.selectAll();
    }

    private void mathConversion() throws Exception {
        if (this.isReadOnly) {
            return;
        }
        int n = this.table.getSelectedColumnCount();
        if (this.dataset instanceof CompoundDS && n > 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Please select one colunm a time for math conversion for compound dataset.", this.getTitle(), 0);
            return;
        }
        Object object = this.getSelectedData();
        if (object == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data is selected.", this.getTitle(), 0);
            return;
        }
        MathConversionDialog mathConversionDialog = new MathConversionDialog((JFrame)((Object)this.viewer), object);
        mathConversionDialog.setVisible(true);
        if (mathConversionDialog.isConverted()) {
            if (this.dataset instanceof CompoundDS) {
                Object var4_4 = null;
                try {
                    var4_4 = ((List)this.dataset.getData()).get(this.table.getSelectedColumn());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (var4_4 != null) {
                    int n2 = Array.getLength(object);
                    System.arraycopy(object, 0, var4_4, 0, n2);
                }
            } else {
                int n3 = this.table.getSelectedRowCount();
                int n4 = this.table.getSelectedRow();
                int n5 = this.table.getSelectedColumn();
                int n6 = this.table.getColumnCount();
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < n3; ++i) {
                    n8 = (n4 + i) * n6 + n5;
                    System.arraycopy(object, n7, this.dataValue, n8, n);
                    n7 += n;
                }
            }
            object = null;
            System.gc();
            this.table.updateUI();
            this.isValueChanged = true;
        }
    }

    private void updateValueInMemory(String string, int n, int n2) throws Exception {
        if (this.currentEditingCellValue != null && this.currentEditingCellValue.toString().equals(string)) {
            return;
        }
        if (this.dataset instanceof ScalarDS) {
            this.updateScalarData(string, n, n2);
        } else if (this.dataset instanceof CompoundDS) {
            this.updateCompoundData(string, n, n2);
        }
    }

    private void updateScalarData(String string, int n, int n2) throws Exception {
        BigInteger bigInteger;
        if (!(this.dataset instanceof ScalarDS) || string == null || (string = string.trim()) == null || this.showAsBin || this.showAsHex) {
            return;
        }
        int n3 = 0;
        n3 = this.isDataTransposed ? n2 * this.table.getRowCount() + n : n * this.table.getColumnCount() + n2;
        ScalarDS scalarDS = (ScalarDS)this.dataset;
        boolean bl = scalarDS.isUnsigned();
        String string2 = this.dataset.getOriginalClass().getName();
        char c = string2.charAt(string2.lastIndexOf("[") + 1);
        if (bl) {
            long l = -1L;
            long l2 = Long.MAX_VALUE;
            if (c == 'B') {
                l2 = 255L;
                l = Long.parseLong(string);
                if (l < 0L) {
                    throw new NumberFormatException("Negative value for unsigned integer: " + l);
                }
                if (l > l2) {
                    throw new NumberFormatException("Data value is out of range: " + l);
                }
            } else if (c == 'S') {
                l2 = 65535L;
                l = Long.parseLong(string);
                if (l < 0L) {
                    throw new NumberFormatException("Negative value for unsigned integer: " + l);
                }
                if (l > l2) {
                    throw new NumberFormatException("Data value is out of range: " + l);
                }
            } else if (c == 'I') {
                l2 = 0xFFFFFFFFL;
                l = Long.parseLong(string);
                if (l < 0L) {
                    throw new NumberFormatException("Negative value for unsigned integer: " + l);
                }
                if (l > l2) {
                    throw new NumberFormatException("Data value is out of range: " + l);
                }
            } else if (c == 'J') {
                bigInteger = new BigInteger(string);
                BigInteger bigInteger2 = new BigInteger("18446744073709551615");
                if (bigInteger.compareTo(bigInteger2) > 0) {
                    throw new NumberFormatException("Negative value for unsigned integer: " + string);
                }
                if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                    throw new NumberFormatException("Data value is out of range: " + string);
                }
            }
        }
        switch (this.NT) {
            case 'B': {
                byte by = 0;
                by = Byte.parseByte(string);
                Array.setByte(this.dataValue, n3, by);
                break;
            }
            case 'S': {
                short s = 0;
                s = Short.parseShort(string);
                Array.setShort(this.dataValue, n3, s);
                break;
            }
            case 'I': {
                int n4 = 0;
                n4 = Integer.parseInt(string);
                Array.setInt(this.dataValue, n3, n4);
                break;
            }
            case 'J': {
                long l = 0L;
                if (c == 'J') {
                    bigInteger = new BigInteger(string);
                    l = bigInteger.longValue();
                } else {
                    l = Long.parseLong(string);
                }
                Array.setLong(this.dataValue, n3, l);
                break;
            }
            case 'F': {
                float f = 0.0f;
                f = Float.parseFloat(string);
                Array.setFloat(this.dataValue, n3, f);
                break;
            }
            case 'D': {
                double d = 0.0;
                d = Double.parseDouble(string);
                Array.setDouble(this.dataValue, n3, d);
                break;
            }
            default: {
                Array.set(this.dataValue, n3, string);
            }
        }
        this.isValueChanged = true;
    }

    private void updateCompoundData(String string, int n, int n2) throws Exception {
        StringTokenizer stringTokenizer;
        if (!(this.dataset instanceof CompoundDS) || string == null || (string = string.trim()) == null) {
            return;
        }
        CompoundDS compoundDS = (CompoundDS)this.dataset;
        List list = (List)compoundDS.getData();
        int[] nArray = compoundDS.getSelectedMemberOrders();
        Datatype[] datatypeArray = compoundDS.getSelectedMemberTypes();
        int n3 = list.size();
        int n4 = this.table.getColumnCount() / n3;
        int n5 = this.table.getRowCount();
        int n6 = n2;
        int n7 = 0;
        int n8 = 1;
        if (n4 > 1) {
            int n9 = n2 / n3;
            n6 = n2 - n9 * n3;
            n7 = n * nArray[n6] * n4 + n9 * nArray[n6];
        } else {
            n7 = n * nArray[n6];
        }
        n8 = nArray[n6];
        Object e = list.get(n6);
        if (Array.get(e, 0) instanceof String) {
            Array.set(e, n7, string);
            this.isValueChanged = true;
            return;
        }
        if (datatypeArray[n6].getDatatypeClass() == 3) {
            int n10 = datatypeArray[n6].getDatatypeSize();
            byte[] byArray = string.getBytes();
            byte[] byArray2 = (byte[])e;
            int n11 = Math.min(n10, byArray.length);
            System.arraycopy(byArray, 0, byArray2, n7 *= n10, n11);
            n7 += n11;
            n11 = n10 - byArray.length;
            for (int i = 0; i < n11; ++i) {
                byArray2[n7 + i] = 32;
            }
            this.isValueChanged = true;
            return;
        }
        int n12 = 32;
        String string2 = e.getClass().getName();
        int n13 = string2.lastIndexOf("[");
        if (n13 >= 0) {
            n12 = string2.charAt(n13 + 1);
        }
        if ((stringTokenizer = new StringTokenizer(string, ",")).countTokens() < n8) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of data point < " + n8 + ".", this.getTitle(), 0);
            return;
        }
        String string3 = "";
        this.isValueChanged = true;
        switch (n12) {
            case 66: {
                byte by = 0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    by = Byte.parseByte(string3);
                    Array.setByte(e, n7 + i, by);
                }
                break;
            }
            case 83: {
                short s = 0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    s = Short.parseShort(string3);
                    Array.setShort(e, n7 + i, s);
                }
                break;
            }
            case 73: {
                int n14 = 0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    n14 = Integer.parseInt(string3);
                    Array.setInt(e, n7 + i, n14);
                }
                break;
            }
            case 74: {
                long l = 0L;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    BigInteger bigInteger = new BigInteger(string3);
                    l = bigInteger.longValue();
                    Array.setLong(e, n7 + i, l);
                }
                break;
            }
            case 70: {
                float f = 0.0f;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    f = Float.parseFloat(string3);
                    Array.setFloat(e, n7 + i, f);
                }
                break;
            }
            case 68: {
                double d = 0.0;
                for (int i = 0; i < n8; ++i) {
                    string3 = stringTokenizer.nextToken().trim();
                    d = Double.parseDouble(string3);
                    Array.setDouble(e, n7 + i, d);
                }
                break;
            }
            default: {
                this.isValueChanged = false;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isRegRef && !this.isObjRef) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if (mouseEvent.isPopupTrigger() || n == 4 || System.getProperty("os.name").startsWith("Mac") && n == 18) {
            if (this.popupMenu != null) {
                this.popupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (mouseEvent.getClickCount() == 2) {
            this.viewType = ViewType.TABLE;
            HObject hObject = null;
            try {
                hObject = this.getDataObject();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            }
            if (hObject == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "No data selected.", this.getTitle(), 0);
                return;
            }
            int n2 = Array.getLength(hObject);
            for (int i = 0; i < n2; ++i) {
                if (this.isRegRef) {
                    this.showRegRefData((String)Array.get(hObject, i));
                    continue;
                }
                if (!this.isObjRef) continue;
                this.showObjRefData(Array.getLong(hObject, i));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show As Table");
        jMenuItem.setMnemonic(84);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show data as table");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show As Image");
        jMenuItem.setMnemonic(73);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show data as image");
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void showObjRefData(long l) {
        Object object;
        long[] lArray = new long[]{l};
        HObject hObject = FileFormat.findObject(this.dataset.getFileFormat(), lArray);
        if (hObject == null || !(hObject instanceof ScalarDS)) {
            return;
        }
        ScalarDS scalarDS = (ScalarDS)hObject;
        ScalarDS scalarDS2 = null;
        Constructor<?> constructor = null;
        Object[] objectArray = null;
        Object object2 = null;
        try {
            object = new Class[]{FileFormat.class, String.class, String.class};
            constructor = scalarDS.getClass().getConstructor((Class<?>)object);
            objectArray = new Object[]{scalarDS.getFileFormat(), scalarDS.getName(), scalarDS.getPath()};
            scalarDS2 = (ScalarDS)constructor.newInstance(objectArray);
            object2 = scalarDS2.getData();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, "Object Reference:" + this.getTitle(), 0);
            object2 = null;
        }
        if (object2 == null) {
            return;
        }
        object = new StringBuffer();
        Font font = this.getFont();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Data pointed by object reference", 3, 2, font, Color.RED));
        JInternalFrame jInternalFrame = null;
        HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS> hashMap = new HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS>(1);
        hashMap.put(ViewProperties.DATA_VIEW_KEY.OBJECT, scalarDS2);
        switch (this.viewType) {
            case TEXT: {
                jInternalFrame = new DefaultTextView(this.viewer, hashMap);
                break;
            }
            case IMAGE: {
                jInternalFrame = new DefaultImageView(this.viewer, hashMap);
                break;
            }
            default: {
                jInternalFrame = new DefaultTableView(this.viewer, hashMap);
            }
        }
        if (jInternalFrame != null) {
            this.viewer.addDataView((DataView)((Object)jInternalFrame));
            ((StringBuffer)object).append(scalarDS2.getName());
            ((StringBuffer)object).append("  -  ");
            ((StringBuffer)object).append(scalarDS2.getPath());
            ((StringBuffer)object).append("  -  ");
            ((StringBuffer)object).append(this.dataset.getFile());
            jInternalFrame.setTitle(((StringBuffer)object).toString());
            jInternalFrame.setBorder(compoundBorder);
        }
    }

    private void showRegRefData(String string) {
        Class[] classArray;
        boolean bl = false;
        if (string == null || string.length() <= 0) {
            return;
        }
        bl = string.indexOf(45) <= 0;
        String string2 = string.substring(string.indexOf(58) + 1, string.indexOf(32));
        long[] lArray = new long[]{-1L};
        try {
            lArray[0] = Long.valueOf(string2);
        }
        catch (Exception exception) {
            return;
        }
        String string3 = string.substring(string.indexOf(123) + 1, string.indexOf(125));
        if (string3 == null || string3.length() <= 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            return;
        }
        HObject hObject = FileFormat.findObject(this.dataset.getFileFormat(), lArray);
        if (hObject == null || !(hObject instanceof ScalarDS)) {
            return;
        }
        ScalarDS scalarDS = (ScalarDS)hObject;
        ScalarDS scalarDS2 = null;
        Constructor<?> constructor = null;
        Object[] objectArray = null;
        try {
            classArray = new Class[]{FileFormat.class, String.class, String.class};
            constructor = scalarDS.getClass().getConstructor(classArray);
            objectArray = new Object[]{scalarDS.getFileFormat(), scalarDS.getName(), scalarDS.getPath()};
        }
        catch (Exception exception) {
            constructor = null;
        }
        classArray = new StringBuffer();
        Font font = this.getFont();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Data pointed by region reference", 3, 2, font, Color.RED));
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            Object object3;
            try {
                scalarDS2 = (ScalarDS)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                continue;
            }
            if (scalarDS2 == null) continue;
            try {
                scalarDS2.init();
            }
            catch (Exception exception) {
                continue;
            }
            int n2 = scalarDS2.getRank();
            long[] lArray2 = scalarDS2.getStartDims();
            long[] lArray3 = scalarDS2.getSelectedDims();
            int n3 = 0;
            String string4 = null;
            String string5 = stringTokenizer.nextToken();
            classArray.setLength(0);
            classArray.append(string5);
            classArray.append(" at ");
            string5 = string5.replace('(', ' ');
            string5 = string5.replace(')', ' ');
            if (bl) {
                object3 = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    lArray3[n3] = 1L;
                    string4 = ((StringTokenizer)object3).nextToken().trim();
                    lArray2[n3] = Long.valueOf(string4);
                    ++n3;
                }
            } else {
                object3 = string5.substring(0, string5.indexOf(45));
                object2 = string5.substring(string5.indexOf(45) + 1);
                object = new StringTokenizer((String)object3, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string4 = ((StringTokenizer)object).nextToken().trim();
                    lArray2[n3] = Long.valueOf(string4);
                    ++n3;
                }
                n3 = 0;
                object = new StringTokenizer((String)object2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string4 = ((StringTokenizer)object).nextToken().trim();
                    lArray3[n3] = Long.valueOf(string4) - lArray2[n3] + 1L;
                    ++n3;
                }
            }
            object3 = null;
            try {
                object3 = scalarDS2.getData();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception, "Region Reference:" + this.getTitle(), 0);
                object3 = null;
            }
            object2 = null;
            object = new HashMap(1);
            ((HashMap)object).put(ViewProperties.DATA_VIEW_KEY.OBJECT, scalarDS2);
            switch (this.viewType) {
                case TEXT: {
                    object2 = new DefaultTextView(this.viewer, (HashMap)object);
                    break;
                }
                case IMAGE: {
                    object2 = new DefaultImageView(this.viewer, (HashMap)object);
                    break;
                }
                default: {
                    object2 = new DefaultTableView(this.viewer, (HashMap)object);
                }
            }
            if (object2 == null) continue;
            this.viewer.addDataView((DataView)object2);
            classArray.append(scalarDS2.getName());
            classArray.append("  -  ");
            classArray.append(scalarDS2.getPath());
            classArray.append("  -  ");
            classArray.append(this.dataset.getFile());
            ((JInternalFrame)object2).setTitle(classArray.toString());
            ((JComponent)object2).setBorder(compoundBorder);
        }
    }

    static /* synthetic */ char access$100(DefaultTableView defaultTableView) {
        return defaultTableView.NT;
    }

    private class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        private static final long serialVersionUID = -3697496960833719169L;
        private final CompoundBorder subBorder = new CompoundBorder(new MatteBorder(1, 0, 1, 0, Color.darkGray), new MatteBorder(1, 0, 1, 0, Color.white));
        private final CompoundBorder majorBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 0, Color.darkGray), new MatteBorder(1, 2, 1, 0, Color.white));
        Vector lines = new Vector();
        int nMajorcolumns = 1;
        int nSubcolumns = 1;

        public MultiLineHeaderRenderer(int n, int n2) {
            this.nMajorcolumns = n;
            this.nSubcolumns = n2;
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            String string = object == null ? "" : object.toString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            this.lines.clear();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.lines.addElement(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n2 / this.nSubcolumns * this.nSubcolumns == n2) {
                this.setBorder(this.majorBorder);
            } else {
                this.setBorder(this.subBorder);
            }
            this.setListData(this.lines);
            return this;
        }
    }

    private class RowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -8963879626159783226L;

        public RowHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setBackground(Color.lightGray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            if (object != null) {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class RowHeader
    extends JTable {
        private static final long serialVersionUID = -1548007702499873626L;
        private int currentRowIndex = -1;
        private int lastRowIndex = -1;
        private JTable parentTable;

        public RowHeader(JTable jTable, Dataset dataset) {
            long[] lArray = dataset.getStartDims();
            long[] lArray2 = dataset.getStride();
            int[] nArray = dataset.getSelectedIndex();
            final int n = (int)lArray[nArray[0]];
            final int n2 = (int)lArray2[nArray[0]];
            final int n3 = jTable.getRowCount();
            this.parentTable = jTable;
            AbstractTableModel abstractTableModel = new AbstractTableModel(){
                private static final long serialVersionUID = -8117073107569884677L;

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public int getRowCount() {
                    return n3;
                }

                @Override
                public String getColumnName(int n4) {
                    return " ";
                }

                @Override
                public Object getValueAt(int n4, int n22) {
                    return String.valueOf(n + DefaultTableView.this.indexBase + n4 * n2);
                }
            };
            this.setModel(abstractTableModel);
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new RowHeaderRenderer());
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.parentTable == null) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.parentTable.clearSelection();
            this.parentTable.setRowSelectionInterval(nArray[0], nArray[nArray.length - 1]);
            this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    n = 0;
                }
                if (this.currentRowIndex < 0) {
                    this.currentRowIndex = 0;
                }
                this.parentTable.clearSelection();
                if (n > this.currentRowIndex) {
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, n);
                } else {
                    this.parentTable.setRowSelectionInterval(n, this.currentRowIndex);
                }
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getID();
            if (n == 500) {
                if (this.currentRowIndex < 0) {
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                } else if (mouseEvent.isShiftDown()) {
                    if (this.lastRowIndex < 0) {
                        this.parentTable.addRowSelectionInterval(0, this.currentRowIndex);
                    } else if (this.lastRowIndex < this.currentRowIndex) {
                        this.parentTable.addRowSelectionInterval(this.lastRowIndex, this.currentRowIndex);
                    } else {
                        this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.lastRowIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                }
                this.lastRowIndex = this.currentRowIndex;
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            } else if (n == 501) {
                this.currentRowIndex = this.rowAtPoint(mouseEvent.getPoint());
            }
        }
    }

    private class ColumnHeader
    extends JTableHeader {
        private static final long serialVersionUID = -3179653809792147055L;
        private int currentColumnIndex;
        private int lastColumnIndex;
        private JTable parentTable;

        public ColumnHeader(JTable jTable) {
            super(jTable.getColumnModel());
            this.currentColumnIndex = -1;
            this.lastColumnIndex = -1;
            this.parentTable = jTable;
            this.setReorderingAllowed(false);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            if (mouseEvent.getID() == 506) {
                if (this.getResizingColumn() != null) {
                    return;
                }
                int n = this.columnAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    n = 0;
                }
                if (this.currentColumnIndex < 0) {
                    this.currentColumnIndex = 0;
                }
                this.parentTable.clearSelection();
                if (n > this.currentColumnIndex) {
                    this.parentTable.setColumnSelectionInterval(this.currentColumnIndex, n);
                } else {
                    this.parentTable.setColumnSelectionInterval(n, this.currentColumnIndex);
                }
                this.parentTable.setRowSelectionInterval(0, this.parentTable.getRowCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            int n = mouseEvent.getID();
            if (n == 500) {
                if (this.currentColumnIndex < 0) {
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    this.parentTable.addColumnSelectionInterval(this.currentColumnIndex, this.currentColumnIndex);
                } else if (mouseEvent.isShiftDown()) {
                    if (this.lastColumnIndex < 0) {
                        this.parentTable.addColumnSelectionInterval(0, this.currentColumnIndex);
                    } else if (this.lastColumnIndex < this.currentColumnIndex) {
                        this.parentTable.addColumnSelectionInterval(this.lastColumnIndex, this.currentColumnIndex);
                    } else {
                        this.parentTable.addColumnSelectionInterval(this.currentColumnIndex, this.lastColumnIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setColumnSelectionInterval(this.currentColumnIndex, this.currentColumnIndex);
                }
                this.lastColumnIndex = this.currentColumnIndex;
                this.parentTable.setRowSelectionInterval(0, this.parentTable.getRowCount() - 1);
            } else if (n == 501) {
                this.currentColumnIndex = this.columnAtPoint(mouseEvent.getPoint());
            }
        }
    }

    private class LineplotOption
    extends JDialog
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -3457035832213978906L;
        public static final int NO_PLOT = -1;
        public static final int ROW_PLOT = 0;
        public static final int COLUMN_PLOT = 1;
        private int idx_xaxis;
        private int nRows;
        private int nCols;
        private int plotType;
        private JRadioButton rowButton;
        private JRadioButton colButton;
        private JComboBox rowBox;
        private JComboBox colBox;

        public LineplotOption(JFrame jFrame, String string, int n, int n2) {
            int n3;
            super(jFrame, string, true);
            this.idx_xaxis = -1;
            this.nRows = 0;
            this.nCols = 0;
            this.plotType = -1;
            this.nRows = n;
            this.nCols = n2;
            this.rowBox = new JComboBox();
            this.rowBox.setEditable(false);
            this.colBox = new JComboBox();
            this.colBox.setEditable(false);
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setPreferredSize(new Dimension(400, 150));
            jPanel.setLayout(new BorderLayout(10, 10));
            long[] lArray = DefaultTableView.this.dataset.getStartDims();
            long[] lArray2 = DefaultTableView.this.dataset.getStride();
            int[] nArray = DefaultTableView.this.dataset.getSelectedIndex();
            int n4 = (int)lArray[nArray[0]];
            int n5 = (int)lArray2[nArray[0]];
            this.rowBox.addItem("array index");
            for (n3 = 0; n3 < n; ++n3) {
                this.rowBox.addItem("row " + (n4 + n3 * n5));
            }
            this.colBox.addItem("array index");
            for (n3 = 0; n3 < n2; ++n3) {
                this.colBox.addItem("column " + DefaultTableView.this.table.getColumnName(n3));
            }
            this.rowButton = new JRadioButton("Row");
            this.colButton = new JRadioButton("Column", true);
            this.rowButton.addItemListener(this);
            this.colButton.addItemListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rowButton);
            buttonGroup.add(this.colButton);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel2.add(new JLabel(" Series in:", 4));
            jPanel2.add(new JLabel(" For abscissa use:", 4));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel3.add(this.colButton);
            jPanel3.add(this.colBox);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(2, 1, 5, 5));
            jPanel4.add(this.rowButton);
            jPanel4.add(this.rowBox);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(new LineBorder(Color.lightGray));
            jPanel5.setLayout(new GridLayout(1, 3, 20, 5));
            jPanel5.add(jPanel2);
            jPanel5.add(jPanel3);
            jPanel5.add(jPanel4);
            JPanel jPanel6 = new JPanel();
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(this);
            jButton.setActionCommand("Ok");
            jPanel6.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(this);
            jButton2.setActionCommand("Cancel");
            jPanel6.add(jButton2);
            jPanel.add((Component)new JLabel(" Select plot options:"), "North");
            jPanel.add((Component)jPanel5, "Center");
            jPanel.add((Component)jPanel6, "South");
            this.colBox.setEnabled(this.colButton.isSelected());
            this.rowBox.setEnabled(this.rowButton.isSelected());
            Point point = this.getParent().getLocation();
            point.x += 450;
            point.y += 200;
            this.setLocation(point);
            this.pack();
        }

        int getXindex() {
            return this.idx_xaxis;
        }

        int getPlotBy() {
            return this.plotType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Cancel")) {
                this.plotType = -1;
                this.dispose();
            } else if (string.equals("Ok")) {
                if (this.colButton.isSelected()) {
                    this.idx_xaxis = this.colBox.getSelectedIndex() - 1;
                    this.plotType = 1;
                } else {
                    this.idx_xaxis = this.rowBox.getSelectedIndex() - 1;
                    this.plotType = 0;
                }
                this.dispose();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object.equals(this.colButton) || object.equals(this.rowButton)) {
                this.colBox.setEnabled(this.colButton.isSelected());
                this.rowBox.setEnabled(this.rowButton.isSelected());
            }
        }
    }

    private static enum ViewType {
        TABLE,
        IMAGE,
        TEXT;

    }
}

