/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ncsa.hdf.view.ViewProperties;

public class MathConversionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 5136554941147830371L;
    private JTextField aField;
    private JTextField bField;
    private JTextArea infoArea;
    private JList functionList;
    private Object dataValue;
    private char NT;
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private String[] functionDescription;
    private boolean isConverted = false;

    public MathConversionDialog(JFrame jFrame, Object object) {
        super(jFrame, "Convert Data...", true);
        this.dataValue = object;
        this.NT = (char)32;
        String string = object.getClass().getName();
        int n = string.lastIndexOf("[");
        if (n >= 0) {
            this.NT = string.charAt(n + 1);
        }
        String[] stringArray = new String[]{"[a, b]", "abs (x)", "a + b * x", "pow (x, a)", "exp (x)", "ln (x)", "log (a, x)", "sin (x)", "cos (x)", "tan (x)"};
        this.functionList = new JList<String>(stringArray);
        this.functionList.setSelectionMode(0);
        this.functionList.addListSelectionListener(this);
        String[] stringArray2 = new String[]{"The filter by lower and upper bounds. x=a if x<a; x=b if x>b.\ne.g.\n x=5, [0, 127]=5\n x=-5, [0, 127]=0\n x=255, [0, 127]=127.", "The absolute value of a number, the number without its sign.\ne.g.\n abs(5)=5\n abs(-5)=5.", "Linear function.\ne.g.\n a=5, b=2, x=2.5, a+b*x=10.", "The result of a number raised to power of a.\ne.g.\n x=2.5, a=10, pow(x, a)=9536.743\n x=25, a=0.5, pow(x, a)=5.", "The exponential number e (i.e., 2.718...) raised to the power of x.\ne.g.\n exp(5.0)=148.41316\n exp(5.5)=244.69193", "The natural logarithm (base e) of x.\ne.g.\n ln(20.085541)=3\n ln(10)=2.302585", "The logarithm of x to the base of a, \"a\" must be an integer > 0.\ne.g.\n log(10, 2)=3.321928\n log(2, 10)=0.30103", "The trigonometric sine of angle x in radians.\ne.g.\n sin(0.523599)=0.5\n sin(1.047198)=0.866025", "The trigonometric cosine of angle x in radians.\ne.g.\n cos(0.523599)=0.866025\n cos(1.047198)=0.5", "The trigonometric tangent of angle x in radians.\ne.g.\n tan(0.785398)=1\n tan(1.047198)=1.732051"};
        this.functionDescription = stringArray2;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        int n2 = 500 + (ViewProperties.getFontSize() - 12) * 15;
        int n3 = 300 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n2, n3));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        JScrollPane jScrollPane = new JScrollPane(this.functionList);
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(4, 1, 5, 5));
        jPanel5.add(new JLabel("a = "));
        jPanel5.add(new JLabel("b = "));
        jPanel5.add(new JLabel("                     "));
        jPanel5.add(new JLabel("                     "));
        jPanel4.add((Component)jPanel5, "West");
        jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(4, 1, 5, 5));
        this.aField = new JTextField("0");
        jPanel5.add(this.aField);
        this.bField = new JTextField("1");
        jPanel5.add(this.bField);
        jPanel5.add(new JLabel("                     "));
        jPanel5.add(new JLabel("                     "));
        jPanel4.add((Component)jPanel5, "Center");
        jPanel3.add((Component)jPanel4, "East");
        jPanel3.setBorder(new TitledBorder("Converting Data With A Mathematic Function"));
        this.infoArea = new JTextArea(4, 80);
        jPanel3.add((Component)this.infoArea, "South");
        this.infoArea.setEditable(false);
        this.infoArea.setLineWrap(true);
        this.infoArea.setBackground(Color.lightGray);
        this.infoArea.setWrapStyleWord(true);
        this.aField.setEnabled(false);
        this.bField.setEnabled(false);
        jPanel.add((Component)jPanel3, "Center");
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    private boolean convertData() {
        double d = 0.0;
        double d2 = 1.0;
        int n = this.functionList.getSelectedIndex();
        try {
            if (n == 0 || n == 2) {
                d = Double.parseDouble(this.aField.getText().trim());
                d2 = Double.parseDouble(this.bField.getText().trim());
            } else if (n == 3) {
                d = Double.parseDouble(this.aField.getText().trim());
            } else if (n == 6 && (d = (double)Integer.parseInt(this.aField.getText().trim())) <= 0.0) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "a must be an integer greater than zero.", this.getTitle(), 0);
                return false;
            }
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return false;
        }
        int n2 = Array.getLength(this.dataValue);
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.NT) {
            case 'B': {
                byte[] byArray = (byte[])this.dataValue;
                for (int i = 0; i < n2; ++i) {
                    d4 = byArray[i];
                    d3 = this.y(n, d4, d, d2);
                    if (d3 > 127.0 || d3 < -128.0) {
                        JOptionPane.showMessageDialog(this, "Invalid byte value: " + (long)d3, this.getTitle(), 0);
                        return false;
                    }
                    byArray[i] = (byte)d3;
                }
                break;
            }
            case 'S': {
                short[] sArray = (short[])this.dataValue;
                for (int i = 0; i < n2; ++i) {
                    d4 = sArray[i];
                    d3 = this.y(n, d4, d, d2);
                    if (d3 > 32767.0 || d3 < -32768.0) {
                        JOptionPane.showMessageDialog(this, "Invalid short value: " + (long)d3, this.getTitle(), 0);
                        return false;
                    }
                    sArray[i] = (short)d3;
                }
                break;
            }
            case 'I': {
                int[] nArray = (int[])this.dataValue;
                for (int i = 0; i < n2; ++i) {
                    d4 = nArray[i];
                    d3 = this.y(n, d4, d, d2);
                    if (d3 > 2.147483647E9 || d3 < -2.147483648E9) {
                        JOptionPane.showMessageDialog(this, "Invalid int value: " + (long)d3, this.getTitle(), 0);
                        return false;
                    }
                    nArray[i] = (int)d3;
                }
                break;
            }
            case 'J': {
                long[] lArray = (long[])this.dataValue;
                for (int i = 0; i < n2; ++i) {
                    d4 = lArray[i];
                    d3 = this.y(n, d4, d, d2);
                    if (d3 > 9.223372036854776E18 || d3 < -9.223372036854776E18) {
                        JOptionPane.showMessageDialog(this, "Invalid long value: " + (long)d3, this.getTitle(), 0);
                        return false;
                    }
                    lArray[i] = (long)d3;
                }
                break;
            }
            case 'F': {
                float[] fArray = (float[])this.dataValue;
                for (int i = 0; i < n2; ++i) {
                    d4 = fArray[i];
                    d3 = this.y(n, d4, d, d2);
                    if (d3 > 3.4028234663852886E38 || d3 < -3.4028234663852886E38 || d3 == Double.NaN) {
                        JOptionPane.showMessageDialog(this, "Invalid float value: " + d3, this.getTitle(), 0);
                        return false;
                    }
                    fArray[i] = (float)d3;
                }
                break;
            }
            case 'D': {
                double[] dArray = (double[])this.dataValue;
                for (int i = 0; i < n2; ++i) {
                    d4 = dArray[i];
                    d3 = this.y(n, d4, d, d2);
                    if (d3 > Double.MAX_VALUE || d3 < -1.7976931348623157E308 || d3 == Double.NaN) {
                        JOptionPane.showMessageDialog(this, "Invalid double value: " + d3, this.getTitle(), 0);
                        return false;
                    }
                    dArray[i] = d3;
                }
                break;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.isConverted = this.convertData();
            this.dispose();
        }
        if (string.equals("Cancel")) {
            this.isConverted = false;
            this.dispose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (!listSelectionEvent.getSource().equals(this.functionList)) {
            return;
        }
        if (this.functionList.isSelectionEmpty()) {
            return;
        }
        int n = this.functionList.getSelectedIndex();
        this.infoArea.setText(this.functionDescription[n]);
        if (n == 0 || n == 2) {
            this.aField.setEnabled(true);
            this.bField.setEnabled(true);
        } else if (n == 3 || n == 6) {
            this.aField.setEnabled(true);
            this.bField.setEnabled(false);
        } else {
            this.aField.setEnabled(false);
            this.bField.setEnabled(false);
        }
    }

    private double y(int n, double d, double d2, double d3) {
        double d4 = d;
        switch (n) {
            case 0: {
                if (d < d2) {
                    d4 = d2;
                    break;
                }
                if (!(d > d3)) break;
                d4 = d3;
                break;
            }
            case 1: {
                d4 = Math.abs(d);
                break;
            }
            case 2: {
                d4 = d2 + d3 * d;
                break;
            }
            case 3: {
                d4 = Math.pow(d, d2);
                break;
            }
            case 4: {
                d4 = Math.exp(d);
                break;
            }
            case 5: {
                d4 = Math.log(d);
                break;
            }
            case 6: {
                d4 = Math.log(d) / Math.log(d2);
                break;
            }
            case 7: {
                d4 = Math.sin(d);
                break;
            }
            case 8: {
                d4 = Math.cos(d);
                break;
            }
            case 9: {
                d4 = Math.tan(d);
                break;
            }
            default: {
                d4 = d;
            }
        }
        return d4;
    }

    public boolean isConverted() {
        return this.isConverted;
    }
}

