/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewAttributeDialog
extends JDialog
implements ActionListener,
ItemListener,
HyperlinkListener {
    private static final long serialVersionUID = 4883237570834215275L;
    public static final int DEFAULT_STRING_ATTRIBUTE_LENGTH = 256;
    private HObject hObject;
    private Attribute newAttribute;
    private JTextField nameField;
    private JComboBox typeChoice;
    private JTextField valueField;
    private JComboBox objChoice;
    private FileFormat fileFormat;
    private JTextField lengthField;
    private JLabel arrayLengthLabel;
    private final boolean isH5;
    private JDialog helpDialog;
    private JRadioButton h4GrAttrRadioButton;

    public NewAttributeDialog(Dialog dialog, HObject hObject, Enumeration<?> enumeration) {
        super(dialog, "New Attribute...", true);
        this.hObject = hObject;
        this.newAttribute = null;
        this.isH5 = hObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.helpDialog = null;
        this.fileFormat = hObject.getFileFormat();
        this.typeChoice = new JComboBox();
        this.typeChoice.addItem("string");
        this.typeChoice.addItem("byte (8-bit)");
        this.typeChoice.addItem("short (16-bit)");
        this.typeChoice.addItem("int (32-bit)");
        this.typeChoice.addItem("unsigned byte (8-bit)");
        this.typeChoice.addItem("unsigned short (16-bit)");
        this.typeChoice.addItem("unsigned int (32-bit)");
        this.typeChoice.addItem("long (64-bit)");
        this.typeChoice.addItem("float");
        this.typeChoice.addItem("double");
        if (this.isH5) {
            this.typeChoice.addItem("object reference");
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 10));
        int n = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 180 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("Cancel");
        jButton2.setMnemonic(67);
        JButton jButton3 = new JButton(" Help ");
        jButton3.setActionCommand("Show help");
        jButton3.setMnemonic(72);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1, 3, 3));
        jPanel3.add(new JLabel("Name: "));
        jPanel3.add(new JLabel("Type: "));
        this.arrayLengthLabel = new JLabel("Max String Length: ");
        jPanel3.add(this.arrayLengthLabel);
        jPanel3.add(new JLabel("Value: "));
        jPanel3.add(new JLabel("Object List: "));
        jPanel2.add("West", jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2, 3, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("GR");
        JRadioButton jRadioButton2 = new JRadioButton("SD");
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        jRadioButton2.setSelected(true);
        jPanel5.add(jRadioButton2);
        jPanel5.add(jRadioButton);
        jPanel4.add((Component)this.typeChoice, "Center");
        jPanel4.add((Component)jPanel5, "East");
        this.h4GrAttrRadioButton = jRadioButton;
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1, 3, 3));
        this.nameField = new JTextField("", 30);
        jPanel3.add(this.nameField);
        if (!this.isH5 && hObject instanceof Group && ((Group)hObject).isRoot()) {
            jPanel3.add(jPanel4);
        } else {
            jPanel3.add(this.typeChoice);
        }
        this.lengthField = new JTextField("1");
        jPanel3.add(this.lengthField);
        this.valueField = new JTextField("0");
        jPanel3.add(this.valueField);
        this.objChoice = new JComboBox();
        jPanel3.add(this.objChoice);
        jPanel2.add("Center", jPanel3);
        jPanel.add("Center", jPanel2);
        jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add("South", jPanel2);
        this.typeChoice.addItemListener(this);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        this.objChoice.addItemListener(this);
        this.objChoice.setEnabled(false);
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            HObject hObject2 = (HObject)defaultMutableTreeNode.getUserObject();
            if (hObject2 instanceof Group && ((Group)hObject2).isRoot()) continue;
            String string = hObject2.getFullName();
            this.objChoice.addItem(string);
        }
        Point point = dialog.getLocation();
        point.x += 50;
        point.y += 80;
        this.setLocation(point);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            if (this.createAttribute()) {
                this.dispose();
            }
        } else if (string.equals("Cancel")) {
            this.newAttribute = null;
            this.dispose();
        } else if (string.equals("Show help")) {
            if (this.helpDialog == null) {
                this.createHelpDialog();
            }
            this.helpDialog.setVisible(true);
        } else if (string.equals("Hide help") && this.helpDialog != null) {
            this.helpDialog.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.typeChoice)) {
            int n = this.typeChoice.getSelectedIndex();
            this.objChoice.setEnabled(false);
            this.lengthField.setEnabled(true);
            if (n == 0) {
                this.arrayLengthLabel.setText("Max String Length: ");
            } else if (this.typeChoice.getSelectedItem().equals("object reference")) {
                this.lengthField.setText("1");
                this.lengthField.setEnabled(false);
                this.arrayLengthLabel.setText("Array Size: ");
                this.objChoice.setEnabled(true);
                this.valueField.setText("");
            } else {
                this.arrayLengthLabel.setText("Array Size: ");
            }
        } else if (object.equals(this.objChoice)) {
            Object object2;
            String string = (String)this.objChoice.getSelectedItem();
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            long l = -1L;
            try {
                object2 = this.fileFormat.get(string);
                l = ((HObject)object2).getOID()[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l > 0L) {
                if (this.valueField.getText().length() > 1) {
                    this.valueField.setText(this.valueField.getText() + "," + l);
                    object2 = new StringTokenizer(this.valueField.getText(), ",");
                    this.lengthField.setText(String.valueOf(((StringTokenizer)object2).countTokens()));
                } else {
                    this.valueField.setText(String.valueOf(l));
                    this.lengthField.setText("1");
                }
            }
        }
    }

    private boolean createAttribute() {
        int n;
        Object object;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        Object[] objectArray = null;
        String string = (String)this.typeChoice.getSelectedItem();
        String string2 = this.valueField.getText();
        String string3 = this.nameField.getText();
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string3 == null || string3.length() < 1) {
            JOptionPane.showMessageDialog(this, "No attribute name.", this.getTitle(), 0);
            return false;
        }
        String string4 = this.lengthField.getText();
        int n7 = 0;
        if (string4 == null || string4.length() <= 0) {
            n7 = 1;
        } else {
            try {
                n7 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                n7 = -1;
            }
        }
        if (n7 <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid attribute length.", this.getTitle(), 0);
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n8 = Math.min(n7, stringTokenizer.countTokens());
        if (string.startsWith("byte")) {
            object = new byte[n7];
            for (int i = 0; i < n8; ++i) {
                String string5 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = Byte.parseByte(string5);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            objectArray = object;
            n3 = 0;
            n4 = 1;
            n5 = -1;
        } else if (string.startsWith("short")) {
            object = new short[n7];
            for (int i = 0; i < n8; ++i) {
                String string6 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = Short.parseShort(string6);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            objectArray = object;
            n3 = 0;
            n4 = 2;
            n5 = -1;
        } else if (string.startsWith("int")) {
            object = new int[n7];
            for (int i = 0; i < n8; ++i) {
                String string7 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = Integer.parseInt(string7);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            objectArray = object;
            n3 = 0;
            n4 = 4;
            n5 = -1;
        } else if (string.startsWith("unsigned byte")) {
            object = new byte[n7];
            int n9 = 0;
            for (n = 0; n < n8; ++n) {
                String string8 = stringTokenizer.nextToken().trim();
                try {
                    n9 = Short.parseShort(string8);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > 255) {
                    n9 = 255;
                }
                object[n] = (byte)n9;
            }
            objectArray = object;
            n3 = 0;
            n4 = 1;
            n5 = -1;
            n6 = 0;
        } else if (string.startsWith("unsigned short")) {
            object = new short[n7];
            int n10 = 0;
            for (n = 0; n < n8; ++n) {
                String string9 = stringTokenizer.nextToken().trim();
                try {
                    n10 = Integer.parseInt(string9);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (n10 < 0) {
                    n10 = 0;
                } else if (n10 > 65535) {
                    n10 = 65535;
                }
                object[n] = (short)n10;
            }
            objectArray = object;
            n3 = 0;
            n4 = 2;
            n5 = -1;
            n6 = 0;
        } else if (string.startsWith("unsigned int")) {
            object = new int[n7];
            long l = 0L;
            for (int i = 0; i < n8; ++i) {
                String string10 = stringTokenizer.nextToken().trim();
                try {
                    l = Long.parseLong(string10);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (l < 0L) {
                    l = 0L;
                }
                if (l > 0xFFFFFFFFL) {
                    l = 0xFFFFFFFFL;
                }
                object[i] = (int)l;
            }
            objectArray = object;
            n3 = 0;
            n4 = 4;
            n5 = -1;
            n6 = 0;
        } else if (string.startsWith("long")) {
            object = new long[n7];
            for (int i = 0; i < n8; ++i) {
                String string11 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = (byte)Long.parseLong(string11);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            objectArray = object;
            n3 = 0;
            n4 = 8;
            n5 = -1;
        } else if (string.startsWith("unsigned long")) {
            object = new long[n7];
            BigInteger bigInteger = BigInteger.valueOf(0L);
            for (n = 0; n < n8; ++n) {
                String string12 = stringTokenizer.nextToken().trim();
                try {
                    bigInteger = new BigInteger(string12);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
                object[n] = (byte)bigInteger.longValue();
            }
            objectArray = object;
            n3 = 0;
            n4 = 8;
            n5 = -1;
            n6 = 0;
        } else if (string.startsWith("float")) {
            object = new float[n7];
            for (int i = 0; i < n8; ++i) {
                String string13 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = (byte)Float.parseFloat(string13);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (!Float.isInfinite(object[i]) && !Float.isNaN(object[i])) continue;
                object[i] = (byte)0.0f;
            }
            objectArray = object;
            n3 = 1;
            n4 = 4;
            n5 = -1;
        } else if (string.startsWith("double")) {
            object = new double[n7];
            for (int i = 0; i < n8; ++i) {
                String string14 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = (byte)Double.parseDouble(string14);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (!Double.isInfinite(object[i]) && !Double.isNaN(object[i])) continue;
                object[i] = (byte)0.0;
            }
            objectArray = object;
            n3 = 1;
            n4 = 8;
            n5 = -1;
        } else if (string.startsWith("object reference")) {
            n7 = stringTokenizer.countTokens();
            object = new long[n7];
            for (int i = 0; i < n7; ++i) {
                String string15 = stringTokenizer.nextToken().trim();
                try {
                    object[i] = (byte)Long.parseLong(string15);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, numberFormatException.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            objectArray = object;
            n3 = 7;
            n4 = 8;
            n5 = -1;
        } else if (string.equals("string")) {
            try {
                n2 = Integer.parseInt(this.lengthField.getText());
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n2 <= 0) {
                n2 = 256;
            }
            if (string2.length() > n2) {
                string2 = string2.substring(0, n2);
            }
            n3 = 3;
            n4 = n2;
            objectArray = object = (Object)new String[]{string2};
            n7 = this.isH5 ? 1 : n2;
        }
        object = null;
        try {
            object = this.fileFormat.createDatatype(n3, n4, n5, n6);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return false;
        }
        long[] lArray = new long[]{n7};
        Attribute attribute = new Attribute(string3, (Datatype)object, lArray);
        attribute.setValue(objectArray);
        try {
            if (!this.isH5 && this.hObject instanceof Group && ((Group)this.hObject).isRoot() && this.h4GrAttrRadioButton.isSelected()) {
                this.hObject.getFileFormat().writeAttribute(this.hObject, attribute, false);
                if (this.hObject.getMetadata() == null) {
                    this.hObject.getMetadata().add(attribute);
                }
            } else {
                this.hObject.writeMetadata(attribute);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return false;
        }
        this.newAttribute = attribute;
        return true;
    }

    private void createHelpDialog() {
        Serializable serializable;
        this.helpDialog = new JDialog((Dialog)this, "Creation New Attribute");
        JPanel jPanel = (JPanel)this.helpDialog.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 500 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 400 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("  Ok  ");
        jButton.addActionListener(this);
        jButton.setActionCommand("Hide help");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jPanel.add((Component)jScrollPane, "Center");
        try {
            serializable = null;
            URL uRL = null;
            URL uRL2 = null;
            String string = ViewProperties.getViewRoot();
            try {
                serializable = new URL("file:" + string + "/lib/jhdfview.jar");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                uRL = new URL("file:" + string + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                uRL2 = new URL("file:" + string + "/src/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            URL[] uRLArray = new URL[]{serializable, uRL, uRL2};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            URL uRL3 = uRLClassLoader.findResource("ncsa/hdf/view/NewAttrHelp.html");
            jEditorPane.setPage(uRL3);
            jEditorPane.addHyperlinkListener(this);
        }
        catch (Exception exception) {
            jEditorPane.setContentType("text/html");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("<body>");
            stringBuffer.append("ERROR: cannot load help information.");
            stringBuffer.append("</body>");
            stringBuffer.append("</html>");
            jEditorPane.setText(stringBuffer.toString());
        }
        serializable = this.helpDialog.getOwner().getLocation();
        ((Point)serializable).x += 50;
        ((Point)serializable).y += 80;
        this.helpDialog.setLocation((Point)serializable);
        this.helpDialog.validate();
        this.helpDialog.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public Attribute getAttribute() {
        return this.newAttribute;
    }
}

