/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class NewLinkDialog
extends JDialog
implements ActionListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 7100424106041533918L;
    private JTextField nameField;
    private JComboBox parentChoice;
    private JComboBox targetObject;
    private String currentDir;
    private JTextField targetFile;
    private JButton targetFileButton;
    private JRadioButton hardLink;
    private JRadioButton softLink;
    private JRadioButton externalLink;
    private JCheckBox checkUnsigned;
    private List groupList;
    private List objList;
    private HObject newObject;
    private FileFormat fileFormat;
    private final Toolkit toolkit;
    private ViewManager viewer;
    private final List fileList;

    public NewLinkDialog(JFrame jFrame, Group group, List list) {
        super(jFrame, "New Link...", true);
        JButton jButton;
        Serializable serializable;
        this.viewer = (ViewManager)((Object)jFrame);
        this.fileList = this.viewer.getTreeView().getCurrentFiles();
        this.newObject = null;
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.objList = list;
        this.currentDir = ViewProperties.getWorkDir();
        this.parentChoice = new JComboBox();
        this.targetObject = new JComboBox();
        this.targetObject.setEditable(false);
        this.groupList = new Vector(list.size());
        HObject hObject = null;
        Iterator iterator = list.iterator();
        String string = null;
        int n = -1;
        int n2 = -1;
        while (iterator.hasNext()) {
            hObject = (HObject)iterator.next();
            ++n2;
            if (hObject instanceof Group) {
                serializable = (Group)hObject;
                this.groupList.add(hObject);
                if (((Group)serializable).isRoot()) {
                    string = "/";
                    n = n2;
                } else {
                    string = ((HObject)serializable).getPath() + ((HObject)serializable).getName() + "/";
                }
                this.parentChoice.addItem(string);
            } else {
                string = hObject.getPath() + hObject.getName();
            }
            this.targetObject.addItem(string);
        }
        this.targetObject.removeItemAt(n);
        this.objList.remove(n);
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        serializable = (JPanel)this.getContentPane();
        ((Container)serializable).setLayout(new BorderLayout(5, 5));
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n3 = 600 + (ViewProperties.getFontSize() - 12) * 15;
        int n4 = 280 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)serializable).setPreferredSize(new Dimension(n3, n4));
        JButton jButton2 = new JButton("   Ok   ");
        jButton2.setActionCommand("Ok");
        jButton2.setMnemonic(79);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Cancel");
        jButton3.setMnemonic(67);
        jButton3.setActionCommand("Cancel");
        jButton3.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        ((Container)serializable).add(jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1, 5, 5));
        jPanel3.add(new JLabel("Link name: "));
        jPanel3.add(new JLabel("Parent group: "));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel4.add(new JLabel("Type of Link: "));
        JButton jButton4 = new JButton(ViewProperties.getHelpIcon());
        jButton4.setToolTipText("Help on Links");
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        jButton4.addActionListener(this);
        jButton4.setActionCommand("Help on Links");
        jPanel4.add(jButton4);
        jPanel3.add(jPanel4);
        jPanel3.add(new JLabel("Target File: "));
        jPanel3.add(new JLabel("Target Object: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1, 5, 5));
        this.nameField = new JTextField();
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 3));
        this.hardLink = new JRadioButton("Hard Link ", true);
        jPanel5.add(this.hardLink);
        this.softLink = new JRadioButton("Soft Link ");
        jPanel5.add(this.softLink);
        this.externalLink = new JRadioButton("External Link ");
        jPanel5.add(this.externalLink);
        jPanel5.setBorder(new TitledBorder(""));
        jPanel3.add(jPanel5);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hardLink);
        buttonGroup.add(this.softLink);
        buttonGroup.add(this.externalLink);
        this.hardLink.addItemListener(this);
        this.softLink.addItemListener(this);
        this.externalLink.addItemListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        this.targetFile = new JTextField();
        jPanel6.add((Component)this.targetFile, "Center");
        this.targetFile.getDocument().addDocumentListener(this);
        this.targetFile.addActionListener(this);
        this.targetFile.setActionCommand("Link to File");
        this.targetFileButton = jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse File");
        jButton.addActionListener(this);
        jPanel6.add((Component)jButton, "East");
        jPanel3.add(jPanel6);
        this.targetFile.setEnabled(false);
        this.targetFileButton.setEnabled(false);
        jPanel3.add(this.targetObject);
        jPanel2.add((Component)jPanel3, "Center");
        ((Container)serializable).add(jPanel2, "Center");
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 100;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Help on Links")) {
            JOptionPane.showMessageDialog(this, "The Type of Link specifies which type of link the user wants to create. \nIt could be hard, soft or external links. \n\n<html><b>Hard Link</b></html> \nHard Link creates a hard link to a pre-existing object in an HDF5 file. \nThe target object must already exist in the file.\nThe HDF5 library keeps a count of all hard links pointing to an object. \n\n<html><b>Soft Link</b></html> \nSoft Link creates a new soft link to an object in an HDF5 file. \nSoft links are only for use only if the target object is in the current file. \nUnlike hard links, a soft link in an HDF5 file is allowed to dangle, \nmeaning that the target object need not exist at the time that the link is created.\nThe HDF5 library does not keep a count of soft links  \n\n<html><b>External Link</b></html> \nExternal Link creates a new soft link to an external object, which is an object\nin a different HDF5 file from the location of the link. External links are \nallowed to dangle like soft links. \n\nSoft links and external links are also known as symbolic links as they use \na name to point to an object; hard links employ an object's address in the file.  \n\n\n");
        }
        if (string.equals("Browse File")) {
            String string2 = null;
            string2 = this.openTargetFile();
            if (string2 == null) {
                return;
            }
            this.targetFile.setText(string2);
        }
        if (string.equals("Ok")) {
            this.newObject = this.createLink();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        }
    }

    private String openTargetFile() {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir);
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        this.currentDir = file.isDirectory() ? file.getPath() : file.getParent();
        return file.getAbsolutePath();
    }

    private final List breadthFirstUserObjects(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            vector.add(defaultMutableTreeNode.getUserObject());
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HObject createLink() {
        String string = null;
        Group group = null;
        HObject hObject = null;
        string = this.nameField.getText().trim();
        if (string == null || string.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Link name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Link name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        if (this.hardLink.isSelected()) {
            HObject hObject2 = (HObject)this.objList.get(this.targetObject.getSelectedIndex());
            if (hObject2 == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Target object is null.", this.getTitle(), 0);
                return null;
            }
            if (hObject2 instanceof Group && ((Group)hObject2).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot make a link to the root group.", this.getTitle(), 0);
                return null;
            }
            try {
                return this.fileFormat.createLink(group, string, hObject2);
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                return null;
            }
        }
        if (this.softLink.isSelected()) {
            String string2 = this.targetObject.getEditor().getItem().toString();
            if (string2.length() < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Target object name is not specified.", this.getTitle(), 0);
                return null;
            }
            HObject hObject3 = null;
            try {
                hObject3 = this.fileFormat.get(this.targetObject.getEditor().getItem().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = null;
            if (hObject3 == null && !(string3 = this.targetObject.getEditor().getItem().toString()).startsWith("/")) {
                string3 = "/" + string3;
            }
            if (hObject3 instanceof Group && ((Group)hObject3).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot make a link to the root group.", this.getTitle(), 0);
                return null;
            }
            try {
                if (hObject3 != null) {
                    return this.fileFormat.createLink(group, string, hObject3, 1);
                }
                if (string3 == null) return hObject;
                return this.fileFormat.createLink(group, string, string3, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                return null;
            }
        }
        if (!this.externalLink.isSelected()) return hObject;
        String string4 = this.targetFile.getText();
        FileFormat fileFormat = null;
        int n = 20;
        File file = new File(string4);
        if (!file.exists()) {
            return null;
        }
        FileFormat fileFormat2 = FileFormat.getFileFormat("HDF5");
        try {
            fileFormat = fileFormat2.createInstance(string4, n);
            fileFormat.open();
        }
        catch (Exception exception) {
            return null;
        }
        HObject hObject4 = null;
        try {
            hObject4 = fileFormat.get(this.targetObject.getEditor().getItem().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            fileFormat.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string5 = null;
        if (hObject4 == null) {
            String string6 = null;
            string6 = this.targetObject.getEditor().getItem().toString();
            if (string6.length() < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Target object name not specified.", this.getTitle(), 0);
                return null;
            }
            string5 = string4 + "://" + string6;
        }
        try {
            if (hObject4 != null) {
                return this.fileFormat.createLink(group, string, hObject4, 64);
            }
            if (string5 == null) return hObject;
            return this.fileFormat.createLink(group, string, string5, 64);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return null;
        }
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.targetObject.setEnabled(true);
        this.getTargetFileObjs();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.targetObject.setEnabled(true);
        this.getTargetFileObjs();
    }

    private void getTargetFileObjs() {
        FileFormat fileFormat = null;
        int n = 20;
        String string = null;
        string = this.targetFile.getText();
        if (string == null || string.length() < 1) {
            return;
        }
        String string2 = this.fileFormat.getAbsolutePath();
        if (string2.equals(string)) {
            this.targetObject.setEnabled(false);
        }
        if (this.isFileOpen(string)) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.targetObject.setEnabled(false);
            return;
        }
        FileFormat fileFormat2 = FileFormat.getFileFormat("HDF5");
        try {
            fileFormat = fileFormat2.createInstance(string, n);
            fileFormat.open();
        }
        catch (Exception exception) {
            this.targetObject.setEnabled(false);
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Invalid File Format", this.getTitle(), 0);
            return;
        }
        this.retriveObjects(fileFormat);
        try {
            fileFormat.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isFileOpen(String string) {
        boolean bl = false;
        FileFormat fileFormat2 = null;
        for (FileFormat fileFormat2 : this.fileList) {
            if (!fileFormat2.getFilePath().equals(string)) continue;
            bl = true;
            if (!fileFormat2.isThisType(FileFormat.getFileFormat("HDF5"))) {
                this.targetObject.setEnabled(false);
            }
            this.retriveObjects(fileFormat2);
            break;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JRadioButton && (object.equals(this.hardLink) || object.equals(this.softLink) || object.equals(this.externalLink))) {
            if (this.hardLink.isSelected()) {
                this.targetFile.setEnabled(false);
                this.targetFileButton.setEnabled(false);
                this.targetObject.setEnabled(true);
                this.targetObject.setEditable(false);
                this.retriveObjects(this.fileFormat);
            } else if (this.softLink.isSelected()) {
                this.targetFile.setEnabled(false);
                this.targetFileButton.setEnabled(false);
                this.targetObject.setEnabled(true);
                this.targetObject.setEditable(true);
                this.retriveObjects(this.fileFormat);
            } else if (this.externalLink.isSelected()) {
                this.targetFile.setEnabled(true);
                this.targetFileButton.setEnabled(true);
                this.targetObject.setEnabled(true);
                this.targetObject.setEditable(true);
                this.targetObject.removeAllItems();
            }
        }
    }

    private void retriveObjects(FileFormat fileFormat) {
        List list = this.breadthFirstUserObjects(fileFormat.getRootNode());
        Vector<HObject> vector = new Vector<HObject>(list.size());
        HObject hObject = null;
        Iterator iterator = list.iterator();
        List list2 = list;
        String string = null;
        int n = -1;
        int n2 = -1;
        this.targetObject.removeAllItems();
        while (iterator.hasNext()) {
            hObject = (HObject)iterator.next();
            ++n2;
            if (hObject instanceof Group) {
                Group group = (Group)hObject;
                vector.add(hObject);
                if (group.isRoot()) {
                    string = "/";
                    n = n2;
                } else {
                    string = group.getPath() + group.getName() + "/";
                }
            } else {
                string = hObject.getPath() + hObject.getName();
            }
            this.targetObject.addItem(string);
        }
        this.targetObject.removeItemAt(n);
        list2.remove(n);
    }
}

