/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import ncsa.hdf.view.ViewProperties;

public class UserOptionsDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -8521813136101442590L;
    private final JFrame viewer;
    private String H4toH5Path;
    private JTextField H4toH5Field;
    private JTextField UGField;
    private JTextField workField;
    private JTextField fileExtField;
    private JTextField maxMemberField;
    private JTextField startMemberField;
    private JComboBox fontSizeChoice;
    private JComboBox fontTypeChoice;
    private JComboBox delimiterChoice;
    private JComboBox imageOriginChoice;
    private JComboBox indexBaseChoice;
    private JComboBox choiceTreeView;
    private JComboBox choiceMetaDataView;
    private JComboBox choiceTextView;
    private JComboBox choiceTableView;
    private JComboBox choiceImageView;
    private JComboBox choicePaletteView;
    private String rootDir;
    private String workDir;
    private JCheckBox checkCurrentUserDir;
    private JCheckBox checkAutoContrast;
    private JCheckBox checkConvertEnum;
    private JCheckBox checkShowValues;
    private JButton currentDirButton;
    private JRadioButton checkReadOnly;
    private JRadioButton checkIndexType;
    private JRadioButton checkIndexOrder;
    private JRadioButton checkIndexNative;
    private JRadioButton checkLibVersion;
    private JRadioButton checkReadAll;
    private int fontSize;
    private boolean isFontChanged;
    private boolean isUserGuideChanged;
    private boolean isWorkDirChanged;
    private static String indexType;
    private static String indexOrder;
    private static Vector<String> treeViews;
    private static Vector<String> imageViews;
    private static Vector<String> tableViews;
    private static Vector<String> textViews;
    private static Vector<String> metaDataViews;
    private static Vector<String> paletteViews;

    public UserOptionsDialog(JFrame jFrame, String string) {
        super(jFrame, "User Options", true);
        this.viewer = jFrame;
        this.rootDir = string;
        this.isFontChanged = false;
        this.isUserGuideChanged = false;
        this.isWorkDirChanged = false;
        this.fontSize = ViewProperties.getFontSize();
        this.workDir = ViewProperties.getWorkDir();
        if (this.workDir == null) {
            this.workDir = this.rootDir;
        }
        treeViews = ViewProperties.getTreeViewList();
        metaDataViews = ViewProperties.getMetaDataViewList();
        textViews = ViewProperties.getTextViewList();
        tableViews = ViewProperties.getTableViewList();
        imageViews = ViewProperties.getImageViewList();
        paletteViews = ViewProperties.getPaletteViewList();
        indexType = ViewProperties.getIndexType();
        indexOrder = ViewProperties.getIndexOrder();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 550 + (ViewProperties.getFontSize() - 12) * 15;
        jPanel.setPreferredSize(new Dimension(n, n2));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("General Setting", this.createGeneralOptionPanel());
        jTabbedPane.addTab("Default Module", this.createModuleOptionPanel());
        jTabbedPane.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Set options");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("Cancel");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel.add("Center", jTabbedPane);
        jPanel.add("South", jPanel2);
        Point point = this.getParent().getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.isFontChanged = false;
            this.isUserGuideChanged = false;
            this.isWorkDirChanged = false;
            this.fontSize = ViewProperties.getFontSize();
            this.workDir = ViewProperties.getWorkDir();
            if (this.workDir == null) {
                this.workDir = this.rootDir;
            }
        }
        super.setVisible(bl);
    }

    private JPanel createGeneralOptionPanel() {
        JButton jButton;
        String[] stringArray = new String[]{"12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "48"};
        this.fontSizeChoice = new JComboBox<String>(stringArray);
        this.fontSizeChoice.setSelectedItem(String.valueOf(ViewProperties.getFontSize()));
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String string = ViewProperties.getFontType();
        this.fontTypeChoice = new JComboBox<String>(stringArray2);
        boolean bl = false;
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equalsIgnoreCase(string)) continue;
                bl = true;
            }
        }
        if (!bl) {
            string = this.viewer.getFont().getFamily();
            ViewProperties.setFontType(string);
        }
        this.fontTypeChoice.setSelectedItem(string);
        String[] stringArray3 = new String[]{"Tab", "Comma", "Space", "Colon", "Semi-Colon"};
        this.delimiterChoice = new JComboBox<String>(stringArray3);
        this.delimiterChoice.setSelectedItem(ViewProperties.getDataDelimiter());
        String[] stringArray4 = new String[]{"UpperLeft", "LowerLeft", "UpperRight", "LowerRight"};
        this.imageOriginChoice = new JComboBox<String>(stringArray4);
        this.imageOriginChoice.setSelectedItem(ViewProperties.getImageOrigin());
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new SoftBevelBorder(1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.checkCurrentUserDir = new JCheckBox("\"Current Working Directory\" or", false);
        jPanel2.add((Component)this.checkCurrentUserDir, "West");
        this.checkCurrentUserDir.addActionListener(this);
        this.checkCurrentUserDir.setActionCommand("Set current dir to user.dir");
        this.workField = new JTextField(this.workDir);
        jPanel2.add((Component)this.workField, "Center");
        this.currentDirButton = jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse current dir");
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "East");
        TitledBorder titledBorder = new TitledBorder("Default Working Directory");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("User's Guide:  "), "West");
        this.UGField = new JTextField(ViewProperties.getUsersGuide());
        jPanel2.add((Component)this.UGField, "Center");
        jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse UG");
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "East");
        titledBorder = new TitledBorder("Help Document");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 8, 8));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Extension: "), "West");
        this.fileExtField = new JTextField(ViewProperties.getFileExtension());
        jPanel3.add((Component)this.fileExtField, "Center");
        titledBorder = new TitledBorder("File Extension");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel3.setBorder(titledBorder);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkReadOnly = new JRadioButton("Read Only", ViewProperties.isReadOnly());
        jPanel4.add(this.checkReadOnly);
        JRadioButton jRadioButton = new JRadioButton("Read/Write", !ViewProperties.isReadOnly());
        jPanel4.add(jRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkReadOnly);
        buttonGroup.add(jRadioButton);
        titledBorder = new TitledBorder("Default File Access Mode");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel4.setBorder(titledBorder);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkLibVersion = new JRadioButton("Earliest", ViewProperties.isEarlyLib());
        jPanel5.add(this.checkLibVersion);
        JRadioButton jRadioButton2 = new JRadioButton("Latest", !ViewProperties.isReadOnly());
        jPanel5.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkLibVersion);
        buttonGroup.add(jRadioButton2);
        titledBorder = new TitledBorder("Default Lib Version");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel5.setBorder(titledBorder);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 8, 8));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Font Size:"), "West");
        jPanel3.add((Component)this.fontSizeChoice, "Center");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Font Type:"), "West");
        jPanel3.add((Component)this.fontTypeChoice, "Center");
        jPanel2.add(jPanel3);
        titledBorder = new TitledBorder("Text Font");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4, 8, 8));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.checkAutoContrast = new JCheckBox("Autogain Image Contrast");
        this.checkAutoContrast.setSelected(ViewProperties.isAutoContrast());
        jPanel3.add((Component)this.checkAutoContrast, "Center");
        JButton jButton2 = new JButton(ViewProperties.getHelpIcon());
        jButton2.setToolTipText("Help on Auto Contrast");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Help on Auto Contrast");
        jPanel3.add((Component)jButton2, "West");
        jPanel2.add(jPanel3);
        this.checkShowValues = new JCheckBox("Show Values");
        jPanel2.add(this.checkShowValues);
        this.checkShowValues.setSelected(ViewProperties.showImageValues());
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Image Origin:"), "West");
        jPanel3.add((Component)this.imageOriginChoice, "Center");
        jPanel2.add(jPanel3);
        titledBorder = new TitledBorder("Image");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 20, 8));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jButton2 = new JButton(ViewProperties.getHelpIcon());
        jButton2.setToolTipText("Help on Convert Enum");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Help on Convert Enum");
        jPanel3.add((Component)jButton2, "West");
        this.checkConvertEnum = new JCheckBox("Convert Enum");
        this.checkConvertEnum.setSelected(ViewProperties.isConvertEnum());
        jPanel3.add((Component)this.checkConvertEnum, "Center");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        String[] stringArray5 = new String[]{"0-based", "1-based"};
        this.indexBaseChoice = new JComboBox<String>(stringArray5);
        if (ViewProperties.isIndexBase1()) {
            this.indexBaseChoice.setSelectedIndex(1);
        } else {
            this.indexBaseChoice.setSelectedIndex(0);
        }
        jPanel3.add((Component)new JLabel("Index Base: "), "West");
        jPanel3.add((Component)this.indexBaseChoice, "Center");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Data Delimiter:"), "West");
        jPanel3.add((Component)this.delimiterChoice, "Center");
        jPanel2.add(jPanel3);
        titledBorder = new TitledBorder("Data");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 8, 8));
        int n = ViewProperties.getMaxMembers();
        this.checkReadAll = new JRadioButton("Open All", n <= 0 || n == Integer.MAX_VALUE);
        this.checkReadAll.addItemListener(this);
        jPanel2.add(this.checkReadAll);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Start Member: "), "West");
        this.startMemberField = new JTextField(String.valueOf(ViewProperties.getStartMembers()));
        jPanel3.add((Component)this.startMemberField, "Center");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Member Count: "), "West");
        this.maxMemberField = new JTextField(String.valueOf(ViewProperties.getMaxMembers()));
        jPanel3.add((Component)this.maxMemberField, "Center");
        jPanel2.add(jPanel3);
        this.startMemberField.setEnabled(!this.checkReadAll.isSelected());
        this.maxMemberField.setEnabled(!this.checkReadAll.isSelected());
        titledBorder = new TitledBorder("Objects to Open");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 8, 8));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkIndexType = new JRadioButton("By Name", indexType.compareTo("H5_INDEX_NAME") == 0);
        jPanel6.add(this.checkIndexType);
        JRadioButton jRadioButton3 = new JRadioButton("By Creation Order", indexType.compareTo("H5_INDEX_CRT_ORDER") == 0);
        jPanel6.add(jRadioButton3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.checkIndexType);
        buttonGroup2.add(jRadioButton3);
        titledBorder = new TitledBorder("Indexing Type");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel6.setBorder(titledBorder);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 3, 8, 8));
        this.checkIndexOrder = new JRadioButton("Increments", indexOrder.compareTo("H5_ITER_INC") == 0);
        jPanel7.add(this.checkIndexOrder);
        JRadioButton jRadioButton4 = new JRadioButton("Decrements", indexOrder.compareTo("H5_ITER_DEC") == 0);
        jPanel7.add(jRadioButton4);
        this.checkIndexNative = new JRadioButton("Native", indexOrder.compareTo("H5_ITER_NATIVE") == 0);
        jPanel7.add(this.checkIndexNative);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.checkIndexOrder);
        buttonGroup3.add(jRadioButton4);
        buttonGroup3.add(this.checkIndexNative);
        titledBorder = new TitledBorder("Indexing Order");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel7.setBorder(titledBorder);
        jPanel2.add(jPanel7);
        titledBorder = new TitledBorder("Display Indexing Options");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.workDir.equals(System.getProperty("user.dir"))) {
            this.checkCurrentUserDir.setSelected(true);
            this.workField.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createModuleOptionPanel() {
        this.choiceTreeView = new JComboBox<String>(treeViews);
        this.choiceTableView = new JComboBox<String>(tableViews);
        this.choiceTextView = new JComboBox<String>(textViews);
        this.choiceImageView = new JComboBox<String>(imageViews);
        this.choiceMetaDataView = new JComboBox<String>(metaDataViews);
        this.choicePaletteView = new JComboBox<String>(paletteViews);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 1, 10, 10));
        jPanel.setBorder(new SoftBevelBorder(1));
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = new TitledBorder("TreeView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)this.choiceTreeView, "Center");
        JPanel jPanel3 = new JPanel();
        titledBorder = new TitledBorder("MetaDataView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel3.setBorder(titledBorder);
        jPanel.add(jPanel3);
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add((Component)this.choiceMetaDataView, "Center");
        JPanel jPanel4 = new JPanel();
        titledBorder = new TitledBorder("TextView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel4.setBorder(titledBorder);
        jPanel.add(jPanel4);
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add((Component)this.choiceTextView, "Center");
        JPanel jPanel5 = new JPanel();
        titledBorder = new TitledBorder("TableView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel5.setBorder(titledBorder);
        jPanel.add(jPanel5);
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)this.choiceTableView, "Center");
        JPanel jPanel6 = new JPanel();
        titledBorder = new TitledBorder("ImageView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel6.setBorder(titledBorder);
        jPanel.add(jPanel6);
        jPanel6.setLayout(new BorderLayout(5, 5));
        jPanel6.add((Component)this.choiceImageView, "Center");
        JPanel jPanel7 = new JPanel();
        titledBorder = new TitledBorder("PaletteView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel7.setBorder(titledBorder);
        jPanel.add(jPanel7);
        jPanel7.setLayout(new BorderLayout(5, 5));
        jPanel7.add((Component)this.choicePaletteView, "Center");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Set options")) {
            this.setUserOptions();
            this.setVisible(false);
        } else if (string.equals("Cancel")) {
            this.isFontChanged = false;
            this.setVisible(false);
        } else if (string.equals("Set current dir to user.dir")) {
            boolean bl = this.checkCurrentUserDir.isSelected();
            this.workField.setEnabled(!bl);
            this.currentDirButton.setEnabled(!bl);
        } else if (string.equals("Browse UG")) {
            JFileChooser jFileChooser = new JFileChooser(this.rootDir);
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string2 = file.getAbsolutePath();
            if (string2 == null) {
                return;
            }
            this.UGField.setText(string2);
        } else if (string.equals("Browse current dir")) {
            JFileChooser jFileChooser = new JFileChooser(this.rootDir);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showDialog(this, "Select");
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string3 = file.getAbsolutePath();
            if (string3 == null) {
                return;
            }
            this.workField.setText(string3);
        } else if (string.equals("Browse h4toh5")) {
            JFileChooser jFileChooser = new JFileChooser(this.rootDir);
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string4 = file.getAbsolutePath();
            if (string4 == null) {
                return;
            }
            this.H4toH5Path = string4;
            this.H4toH5Field.setText(string4);
        } else if (string.startsWith("Add Module")) {
            String string5 = JOptionPane.showInputDialog(this, "Type the full path of the new module:", string, -1);
            if (string5 == null || string5.length() < 1) {
                return;
            }
            try {
                Class.forName(string5);
            }
            catch (Exception exception) {
                try {
                    ViewProperties.loadExtClass().loadClass(string5);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(this, "Cannot find module:\n " + string5 + "\nPlease check the module name and classpath.", "HDFView", 0);
                    return;
                }
            }
            if (string.endsWith("TreeView") && !treeViews.contains(string5)) {
                treeViews.add(string5);
                this.choiceTreeView.addItem(string5);
            } else if (string.endsWith("MetadataView") && !metaDataViews.contains(string5)) {
                metaDataViews.add(string5);
                this.choiceMetaDataView.addItem(string5);
            } else if (string.endsWith("TextView") && !textViews.contains(string5)) {
                textViews.add(string5);
                this.choiceTextView.addItem(string5);
            } else if (string.endsWith("TableView") && !tableViews.contains(string5)) {
                tableViews.add(string5);
                this.choiceTableView.addItem(string5);
            } else if (string.endsWith("ImageView") && !imageViews.contains(string5)) {
                imageViews.add(string5);
                this.choiceImageView.addItem(string5);
            } else if (string.endsWith("PaletteView") && !paletteViews.contains(string5)) {
                paletteViews.add(string5);
                this.choicePaletteView.addItem(string5);
            }
        } else if (string.startsWith("Delete Module")) {
            JComboBox jComboBox = (JComboBox)object;
            if (jComboBox.getItemCount() == 1) {
                JOptionPane.showMessageDialog(this, "Cannot delete the last module.", string, 0);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "Do you want to delete the selected module?", string, 0);
            if (n == 1) {
                return;
            }
            String string6 = (String)jComboBox.getSelectedItem();
            jComboBox.removeItem(string6);
            if (string.endsWith("TreeView")) {
                treeViews.remove(string6);
            } else if (string.endsWith("MetadataView")) {
                metaDataViews.remove(string6);
            } else if (string.endsWith("TextView")) {
                textViews.remove(string6);
            } else if (string.endsWith("TableView")) {
                tableViews.remove(string6);
            } else if (string.endsWith("ImageView")) {
                imageViews.remove(string6);
            } else if (string.endsWith("PaletteView")) {
                paletteViews.remove(string6);
            }
        } else if (string.equals("Help on Auto Contrast")) {
            JOptionPane.showMessageDialog(this, "Auto Contrast does the following to compute a gain/bias \nthat will stretch the pixels in the image to fit the pixel \nvalues of the graphics system. For example, it stretches unsigned\nshort data to fit the full range of an unsigned short. Later \ncode simply takes the high order byte and passes it to the graphics\nsystem (which expects 0-255). It uses some statistics on the pixels \nto prevent outliers from throwing off the gain/bias calculations much.\n\nTo compute the gain/bias we... \nFind the mean and std. deviation of the pixels in the image \nmin = mean - 3 * std.dev. \nmax = mean + 3 * std.dev. \nsmall fudge factor because this tends to overshoot a bit \nStretch to 0-USHRT_MAX \n        gain = USHRT_MAX / (max-min) \n        bias = -min \n\nTo apply the gain/bias to a pixel, use the formula \ndata[i] = (data[i] + bias) * gain \n\n\n\n");
        } else if (string.equals("Help on Convert Enum")) {
            JOptionPane.showMessageDialog(this, "Convert enum data to strings. \nFor example, a dataset of an enum type of (R=0, G=, B=2) \nhas values of (0, 2, 2, 2, 1, 1). With conversion, the data values are \nshown as (R, B, B, B, G, G).\n\n\n");
        }
    }

    private void setUserOptions() {
        String string;
        String string2 = this.UGField.getText();
        if (string2 != null && string2.length() > 0) {
            this.isUserGuideChanged = !(string2 = string2.trim()).equals(ViewProperties.getUsersGuide());
            ViewProperties.setUsersGuide(string2);
        }
        String string3 = this.workField.getText();
        if (this.checkCurrentUserDir.isSelected()) {
            string3 = "user.dir";
        }
        if (string3 != null && string3.length() > 0) {
            this.isWorkDirChanged = !(string3 = string3.trim()).equals(ViewProperties.getWorkDir());
            ViewProperties.setWorkDir(string3);
        }
        if ((string = this.fileExtField.getText()) != null && string.length() > 0) {
            string = string.trim();
            ViewProperties.setFileExtension(string);
        }
        if (this.checkReadOnly.isSelected()) {
            ViewProperties.setReadOnly(true);
        } else {
            ViewProperties.setReadOnly(false);
        }
        if (this.checkLibVersion.isSelected()) {
            ViewProperties.setEarlyLib(true);
        } else {
            ViewProperties.setEarlyLib(false);
        }
        int n = 12;
        try {
            n = Integer.parseInt((String)this.fontSizeChoice.getSelectedItem());
            ViewProperties.setFontSize(n);
            if (this.fontSize != ViewProperties.getFontSize()) {
                this.isFontChanged = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = (String)this.fontTypeChoice.getSelectedItem();
        if (!string4.equalsIgnoreCase(ViewProperties.getFontType())) {
            this.isFontChanged = true;
            ViewProperties.setFontType(string4);
        }
        ViewProperties.setDataDelimiter((String)this.delimiterChoice.getSelectedItem());
        ViewProperties.setImageOrigin((String)this.imageOriginChoice.getSelectedItem());
        if (this.checkIndexType.isSelected()) {
            ViewProperties.setIndexType("H5_INDEX_NAME");
        } else {
            ViewProperties.setIndexType("H5_INDEX_CRT_ORDER");
        }
        if (this.checkIndexOrder.isSelected()) {
            ViewProperties.setIndexOrder("H5_ITER_INC");
        } else if (this.checkIndexNative.isSelected()) {
            ViewProperties.setIndexOrder("H5_ITER_NATIVE");
        } else {
            ViewProperties.setIndexOrder("H5_ITER_DEC");
        }
        if (this.checkReadAll.isSelected()) {
            ViewProperties.setStartMembers(0);
            ViewProperties.setMaxMembers(-1);
        } else {
            int n2;
            try {
                n2 = Integer.parseInt(this.maxMemberField.getText());
                ViewProperties.setMaxMembers(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = Integer.parseInt(this.startMemberField.getText());
                ViewProperties.setStartMembers(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Vector[] vectorArray = new Vector[]{treeViews, metaDataViews, textViews, tableViews, imageViews, paletteViews};
        JComboBox[] jComboBoxArray = new JComboBox[]{this.choiceTreeView, this.choiceMetaDataView, this.choiceTextView, this.choiceTableView, this.choiceImageView, this.choicePaletteView};
        for (int i = 0; i < 6; ++i) {
            Object object = jComboBoxArray[i].getSelectedItem();
            vectorArray[i].remove(object);
            vectorArray[i].add(0, object);
        }
        ViewProperties.setAutoContrast(this.checkAutoContrast.isSelected());
        ViewProperties.setShowImageValue(this.checkShowValues.isSelected());
        ViewProperties.setConvertEnum(this.checkConvertEnum.isSelected());
        if (this.indexBaseChoice.getSelectedIndex() == 0) {
            ViewProperties.setIndexBase1(false);
        } else {
            ViewProperties.setIndexBase1(true);
        }
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    public boolean isUserGuideChanged() {
        return this.isUserGuideChanged;
    }

    public boolean isWorkDirChanged() {
        return this.isWorkDirChanged;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.checkReadAll)) {
            this.startMemberField.setEnabled(!this.checkReadAll.isSelected());
            this.maxMemberField.setEnabled(!this.checkReadAll.isSelected());
        }
    }
}

