/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.sona;

import gigahorse.FullResponse;
import java.io.Serializable;
import sbt.internal.sona.OAuthClient;
import sbt.internal.sona.PackageDeploymentValidationError;
import sbt.internal.sona.PackageDeploymentValidationError$;
import sbt.internal.sona.PublisherStatus;
import sbt.internal.sona.SonaClient;
import sbt.internal.sona.SonaClient$PrettyPrint$;
import sbt.internal.sona.codec.JsonProtocol$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import sjsonnew.JsonFormat;
import sjsonnew.JsonReader;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;
import sjsonnew.support.scalajson.unsafe.PrettyPrinter$;

public final class SonaClient$ {
    public static SonaClient$ MODULE$;
    private final String host;
    private final String baseUrl;
    private final Function1<FullResponse, JValue> asJson;
    private final Function1<FullResponse, PublisherStatus> asPublisherStatus;

    static {
        new SonaClient$();
    }

    public String host() {
        return this.host;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public Function1<FullResponse, JValue> asJson() {
        return this.asJson;
    }

    public <A1> Function1<FullResponse, A1> as(JsonFormat<A1> evidence$1) {
        return this.asJson().andThen((Function1 & Serializable & scala.Serializable)js -> Converter$.MODULE$.fromJsonUnsafe(js, (JsonReader)evidence$1));
    }

    public Function1<FullResponse, PublisherStatus> asPublisherStatus() {
        return this.asPublisherStatus;
    }

    public SonaClient oauthClient(String userName, String userToken, FiniteDuration uploadRequestTimeout) {
        return new SonaClient(new OAuthClient(userName, userToken), uploadRequestTimeout);
    }

    public String failedDeploymentErrorText(String deploymentId, Option<JValue> errors, Logger log) {
        String string;
        Option errorsText = errors.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.presentDeploymentValidationErrors((JValue)x$3, log));
        Option option = errorsText;
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            string = new StringBuilder(25).append(" with validation errors:\n").append(value).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String errorsMessagePart = string;
        return new StringBuilder(18).append("deployment ").append(deploymentId).append(" failed").append(errorsMessagePart).toString();
    }

    private String presentDeploymentValidationErrors(JValue errorsNode, Logger log) {
        Option<Seq<PackageDeploymentValidationError>> option = PackageDeploymentValidationError$.MODULE$.parse(errorsNode);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq errors = (Seq)some.value();
            Seq errorsPresented = (Seq)errors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PackageDeploymentValidationError packageDeploymentValidationError = x0$1;
                if (packageDeploymentValidationError != null) {
                    String packageDescriptor = packageDeploymentValidationError.packageDescriptor();
                    Seq<String> packageErrors = packageDeploymentValidationError.packageErrors();
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(17).append(packageDescriptor).append("\n               |").append(SonaClient$PrettyPrint$.MODULE$.indent(SonaClient$PrettyPrint$.MODULE$.asList(packageErrors), 2)).toString())).stripMargin();
                }
                throw new MatchError((Object)packageDeploymentValidationError);
            }, Seq$.MODULE$.canBuildFrom());
            return SonaClient$PrettyPrint$.MODULE$.indent(SonaClient$PrettyPrint$.MODULE$.asList((Seq<String>)errorsPresented), 2);
        }
        if (None$.MODULE$.equals(option)) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> "Sonatype deployment validation errors JSON format has changed. Please update to the latest sbt version or report the issue to the sbt project");
            return PrettyPrinter$.MODULE$.apply(errorsNode);
        }
        throw new MatchError(option);
    }

    private SonaClient$() {
        MODULE$ = this;
        this.host = "central.sonatype.com";
        this.baseUrl = new StringBuilder(15).append("https://").append(this.host()).append("/api/v1").toString();
        this.asJson = (Function1 & Serializable & scala.Serializable)r -> (JValue)Parser$.MODULE$.parseFromByteBuffer(r.bodyAsByteBuffer()).get();
        this.asPublisherStatus = this.as(JsonProtocol$.MODULE$.PublisherStatusFormat());
    }
}

