/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import sbt.internal.util.ScalaKeywords$;
import sbt.internal.util.Types$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Util$ {
    public static final Util$ MODULE$ = new Util$();
    private static Regex Hyphen;
    private static Regex Camel;
    private static boolean isMac;
    private static boolean isWindows;
    private static boolean isCygwin;
    private static boolean isNonCygwinWindows;
    private static boolean isCygwinWindows;
    private static boolean isEmacs;
    private static int majorJavaVersion;
    private static Path javaHome;
    private static volatile int bitmap$0;

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("getId", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("threadId", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public <T> List<T> makeList(int size, T value) {
        return (List)package$.MODULE$.List().fill(size, (Function0 & Serializable)() -> value);
    }

    public <A, B> Tuple2<Seq<A>, Seq<B>> separateE(Seq<Either<A, B>> ps) {
        return this.separate(ps, Types$.MODULE$.idFun());
    }

    public <T, A, B> Tuple2<Seq<A>, Seq<B>> separate(Seq<T> ps, Function1<T, Either<A, B>> f) {
        Tuple2 tuple2 = (Tuple2)ps.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$), (Function2 & Serializable)(xs, y) -> MODULE$.prependEither((Tuple2)xs, (Either)((Either)f.apply(y))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq a = (Seq)tuple2._1();
        Seq b = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)a, (Object)b);
        Seq a2 = (Seq)tuple22._1();
        Seq b2 = (Seq)tuple22._2();
        return new Tuple2(a2.reverse(), b2.reverse());
    }

    public <A, B> Tuple2<Seq<A>, Seq<B>> prependEither(Tuple2<Seq<A>, Seq<B>> acc, Either<A, B> next) {
        Either<A, B> either = next;
        if (either instanceof Left) {
            Object l;
            Left left = (Left)either;
            Object object = l = left.value();
            return new Tuple2(((SeqOps)acc._1()).$plus$colon(object), acc._2());
        }
        if (either instanceof Right) {
            Object r;
            Right right = (Right)either;
            Object object = r = right.value();
            return new Tuple2(acc._1(), ((SeqOps)acc._2()).$plus$colon(object));
        }
        throw new MatchError(either);
    }

    public <A, B> Function2<A, B, Tuple2<A, B>> pairID() {
        return (Function2 & Serializable)(a, b) -> new Tuple2(a, b);
    }

    private Regex Hyphen$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 1) == 0) {
                Hyphen = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("-(\\p{javaLowerCase})"));
                bitmap$0 |= 1;
            }
        }
        return Hyphen;
    }

    private Regex Hyphen() {
        if ((bitmap$0 & 1) == 0) {
            return this.Hyphen$lzycompute();
        }
        return Hyphen;
    }

    public boolean hasHyphen(String s) {
        return s.indexOf(45) >= 0;
    }

    public String hyphenToCamel(String s) {
        if (this.hasHyphen(s)) {
            return this.Hyphen().replaceAllIn((CharSequence)s, (Function1 & Serializable)x$2 -> x$2.group(1).toUpperCase(Locale.ENGLISH));
        }
        return s;
    }

    private Regex Camel$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 2) == 0) {
                Camel = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\p{javaLowerCase})(\\p{javaUpperCase})"));
                bitmap$0 |= 2;
            }
        }
        return Camel;
    }

    private Regex Camel() {
        if ((bitmap$0 & 2) == 0) {
            return this.Camel$lzycompute();
        }
        return Camel;
    }

    public String camelToHyphen(String s) {
        return this.Camel().replaceAllIn((CharSequence)s, (Function1 & Serializable)m -> new StringBuilder(1).append(m.group(1)).append("-").append(m.group(2).toLowerCase(Locale.ENGLISH)).toString());
    }

    public String quoteIfKeyword(String s) {
        if (ScalaKeywords$.MODULE$.values().apply((Object)s)) {
            return new StringBuilder(2).append("`").append(s).append("`").toString();
        }
        return s;
    }

    private boolean isMac$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 4) == 0) {
                isMac = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
                bitmap$0 |= 4;
            }
        }
        return isMac;
    }

    public boolean isMac() {
        if ((bitmap$0 & 4) == 0) {
            return this.isMac$lzycompute();
        }
        return isMac;
    }

    private boolean isWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 8) == 0) {
                isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
                bitmap$0 |= 8;
            }
        }
        return isWindows;
    }

    public boolean isWindows() {
        if ((bitmap$0 & 8) == 0) {
            return this.isWindows$lzycompute();
        }
        return isWindows;
    }

    private boolean isCygwin$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 0x10) == 0) {
                boolean bl;
                Option os = scala.sys.package$.MODULE$.env().get((Object)"OSTYPE");
                Option option = os;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String x = (String)some.value();
                    bl = x.toLowerCase(Locale.ENGLISH).contains("cygwin");
                } else {
                    bl = false;
                }
                isCygwin = bl;
                bitmap$0 |= 0x10;
            }
        }
        return isCygwin;
    }

    public boolean isCygwin() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.isCygwin$lzycompute();
        }
        return isCygwin;
    }

    private boolean isNonCygwinWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 0x20) == 0) {
                isNonCygwinWindows = this.isWindows() && !this.isCygwin();
                bitmap$0 |= 0x20;
            }
        }
        return isNonCygwinWindows;
    }

    public boolean isNonCygwinWindows() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.isNonCygwinWindows$lzycompute();
        }
        return isNonCygwinWindows;
    }

    private boolean isCygwinWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 0x40) == 0) {
                isCygwinWindows = this.isWindows() && this.isCygwin();
                bitmap$0 |= 0x40;
            }
        }
        return isCygwinWindows;
    }

    public boolean isCygwinWindows() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.isCygwinWindows$lzycompute();
        }
        return isCygwinWindows;
    }

    private boolean isEmacs$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 0x80) == 0) {
                isEmacs = scala.sys.package$.MODULE$.env().contains((Object)"INSIDE_EMACS");
                bitmap$0 |= 0x80;
            }
        }
        return isEmacs;
    }

    public boolean isEmacs() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.isEmacs$lzycompute();
        }
        return isEmacs;
    }

    public <A> List<A> nil() {
        return package$.MODULE$.List().empty();
    }

    public <A> Seq<A> nilSeq() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public <A> Option<A> none() {
        return None$.MODULE$;
    }

    public <A> A AnyOps(A value) {
        return value;
    }

    public <A1, A2> PartialFunction<A1, A2> reduceIntents(Seq<PartialFunction<A1, A2>> intents) {
        return (PartialFunction)intents.toList().reduceLeft((Function2 & Serializable)(x$3, x$4) -> x$3.orElse(x$4));
    }

    private int majorJavaVersion$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 0x100) == 0) {
                majorJavaVersion = Util$.liftedTree1$1();
                bitmap$0 |= 0x100;
            }
        }
        return majorJavaVersion;
    }

    public int majorJavaVersion() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.majorJavaVersion$lzycompute();
        }
        return majorJavaVersion;
    }

    public long threadId() {
        if (this.majorJavaVersion() < 19) {
            Thread thread = Thread.currentThread();
            if (thread instanceof Object && true) {
                Object object;
                Thread thread2;
                Thread qual1 = thread2 = thread;
                try {
                    object = Util$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                return BoxesRunTime.unboxToLong((Object)((Long)object));
            }
            throw new MatchError((Object)thread);
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof Object && true) {
            Object object;
            Thread thread3;
            Thread qual2 = thread3 = thread;
            try {
                object = Util$.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return BoxesRunTime.unboxToLong((Object)((Long)object));
        }
        throw new MatchError((Object)thread);
    }

    private Path javaHome$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((bitmap$0 & 0x200) == 0) {
                javaHome = ((String)scala.sys.package$.MODULE$.props().apply((Object)"java.home")).endsWith("jre") ? Paths.get((String)scala.sys.package$.MODULE$.props().apply((Object)"java.home"), new String[0]).getParent() : Paths.get((String)scala.sys.package$.MODULE$.props().apply((Object)"java.home"), new String[0]);
                bitmap$0 |= 0x200;
            }
        }
        return javaHome;
    }

    public Path javaHome() {
        if ((bitmap$0 & 0x200) == 0) {
            return this.javaHome$lzycompute();
        }
        return javaHome;
    }

    private static final /* synthetic */ int liftedTree1$1() {
        int n;
        try {
            String javaVersion = (String)scala.sys.package$.MODULE$.props().get("java.version").getOrElse((Function0 & Serializable)() -> "1.0");
            n = javaVersion.startsWith("1.") ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(javaVersion.split("\\.")[1])) : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(javaVersion.split("\\.")[0]));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                n = 0;
            }
            throw throwable;
        }
        return n;
    }

    private Util$() {
    }
}

