/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import com.sun.jna.LastErrorException;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.NGUnixDomainSocket;
import sbt.internal.NGUnixDomainSocketLibrary;

public class NGUnixDomainServerSocket
extends ServerSocket {
    private static final int DEFAULT_BACKLOG = 50;
    private final AtomicInteger fd;
    private final int backlog;
    private boolean isBound;
    private boolean isClosed;

    public NGUnixDomainServerSocket() throws IOException {
        this(50, null);
    }

    public NGUnixDomainServerSocket(int n) throws IOException {
        this(n, null);
    }

    public NGUnixDomainServerSocket(String string) throws IOException {
        this(50, string);
    }

    public NGUnixDomainServerSocket(int n, String string) throws IOException {
        try {
            this.fd = new AtomicInteger(NGUnixDomainSocketLibrary.socket(1, 1, 0));
            this.backlog = n;
            if (string != null) {
                this.bind(new NGUnixDomainServerSocketAddress(string));
            }
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    @Override
    public synchronized void bind(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof NGUnixDomainServerSocketAddress)) {
            throw new IllegalArgumentException("endpoint must be an instance of NGUnixDomainServerSocketAddress");
        }
        if (this.isBound) {
            throw new IllegalStateException("Socket is already bound");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        NGUnixDomainServerSocketAddress nGUnixDomainServerSocketAddress = (NGUnixDomainServerSocketAddress)socketAddress;
        NGUnixDomainSocketLibrary.SockaddrUn sockaddrUn = new NGUnixDomainSocketLibrary.SockaddrUn(nGUnixDomainServerSocketAddress.getPath());
        try {
            int n = this.fd.get();
            NGUnixDomainSocketLibrary.bind(n, sockaddrUn, sockaddrUn.size());
            NGUnixDomainSocketLibrary.listen(n, this.backlog);
            this.isBound = true;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this;
        synchronized (object) {
            if (!this.isBound) {
                throw new IllegalStateException("Socket is not bound");
            }
            if (this.isClosed) {
                throw new IllegalStateException("Socket is already closed");
            }
        }
        try {
            object = new NGUnixDomainSocketLibrary.SockaddrUn();
            IntByReference intByReference = new IntByReference();
            intByReference.setValue(object.size());
            int n = NGUnixDomainSocketLibrary.accept(this.fd.get(), (NGUnixDomainSocketLibrary.SockaddrUn)((Object)object), intByReference);
            return new NGUnixDomainSocket(n);
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        try {
            NGUnixDomainSocketLibrary.close(this.fd.getAndSet(-1));
            this.isClosed = true;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    public static class NGUnixDomainServerSocketAddress
    extends SocketAddress {
        private final String path;

        public NGUnixDomainServerSocketAddress(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }
    }
}

