/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sbt.Highlight$;
import sbt.State;
import sbt.State$;
import sbt.State$StateOpsImpl$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.Util$;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.RichParser;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.IO$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CommandUtil$
implements Serializable {
    public static final CommandUtil$ MODULE$ = new CommandUtil$();

    private CommandUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CommandUtil$.class);
    }

    public Seq<String> readLines(Seq<File> files) {
        return (Seq)((IterableOps)files.flatMap((Function1 & Serializable)_$1 -> IO$.MODULE$.readLines(_$1, IO$.MODULE$.readLines$default$2()))).flatMap((Function1 & Serializable)s -> MODULE$.processLine((String)s));
    }

    public Option<String> processLine(String s) {
        String s2 = s.trim();
        if (this.ignoreLine(s2)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)s2);
    }

    public boolean ignoreLine(String s) {
        return s.isEmpty() || s.startsWith("#");
    }

    private Function1<File, Object> canRead() {
        return (Function1 & Serializable)_$2 -> _$2.canRead();
    }

    public Seq<File> notReadable(Seq<File> files) {
        return (Seq)files.filterNot(this.canRead());
    }

    public Seq<File> readable(Seq<File> files) {
        return (Seq)files.filter(this.canRead());
    }

    public File bootDirectory(State state) {
        File file;
        try {
            file = state.configuration().provider().scalaProvider().launcher().bootDirectory();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            file = new File(".").getAbsoluteFile();
        }
        return file;
    }

    public Seq<String> aligned(String pre, String sep, Seq<Tuple2<String, String>> in) {
        if (in.isEmpty()) {
            return Util$.MODULE$.nilSeq();
        }
        int width = BoxesRunTime.unboxToInt((Object)in.iterator().map((Function1 & Serializable)_$3 -> ((String)_$3._1()).length()).max((Ordering)Ordering.Int$.MODULE$));
        return (Seq)in.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String a = (String)tuple2._1();
                String b = (String)tuple2._2();
                return new StringBuilder(0).append(pre).append(MODULE$.fill(a, width)).append(sep).append(b).toString();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String fill(String s, int size) {
        return new StringBuilder(0).append(s).append(DefaultParsers$.MODULE$.$times(" ", package$.MODULE$.max(size - s.length(), 0))).toString();
    }

    public <T> State withAttribute(State s, AttributeKey<T> key, String ifMissing, Function1<T, State> f) {
        Option<T> option = State$StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(s), key);
        if (None$.MODULE$.equals(option)) {
            State$StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).error(() -> CommandUtil$.withAttribute$$anonfun$1(ifMissing));
            return State$StateOpsImpl$.MODULE$.fail$extension(State$.MODULE$.StateOpsImpl(s));
        }
        if (option instanceof Some) {
            Object nav = ((Some)option).value();
            return (State)f.apply(nav);
        }
        throw new MatchError(option);
    }

    public Parser<String> singleArgument(Set<String> exampleStrings) {
        Parser arg = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.NotSpaceClass()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.any()).$times())).map((Function1 & Serializable)x$1 -> {
            char c = BoxesRunTime.unboxToChar((Object)x$1._1());
            Seq seq = (Seq)x$1._2();
            return ((IterableOnceOps)seq.$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c))).mkString();
        });
        RichParser richParser = DefaultParsers$.MODULE$.richParser(arg);
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.token(richParser.examples(exampleStrings, richParser.examples$default$2())));
    }

    public String detail(String selected, Map<String, String> detailMap) {
        Option option = detailMap.get((Object)selected);
        if (option instanceof Some) {
            String exactDetail = (String)((Some)option).value();
            return exactDetail;
        }
        if (None$.MODULE$.equals(option)) {
            String string;
            try {
                Map<String, String> details = this.searchHelp(selected, detailMap);
                string = details.isEmpty() ? new StringBuilder(37).append("No matches for regular expression '").append(selected).append("'.").toString() : this.layoutDetails(details);
            }
            catch (PatternSyntaxException pse) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(53).append("Invalid regular expression (java.util.regex syntax).\n").append(pse.getMessage()).toString());
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    public Map<String, String> searchHelp(String selected, Map<String, String> detailMap) {
        Pattern pattern = Pattern.compile(selected, 66);
        return (Map)detailMap.flatMap((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            String string2 = (String)x$1._2();
            Option<String> contentMatches = Highlight$.MODULE$.showMatches(pattern, string2);
            Option<String> keyMatches = Highlight$.MODULE$.showMatches(pattern, string);
            String keyString = Highlight$.MODULE$.bold((String)keyMatches.getOrElse(() -> CommandUtil$.$anonfun$3(string)));
            String contentString = (String)contentMatches.getOrElse(() -> CommandUtil$.$anonfun$4(string2));
            if (keyMatches.isDefined() || contentMatches.isDefined()) {
                return (Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)keyString, (Object)contentString), (List)Nil$.MODULE$));
            }
            return Util$.MODULE$.nilSeq();
        });
    }

    public String layoutDetails(Map<String, String> details) {
        return ((IterableOnceOps)details.map((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            String string2 = (String)x$1._2();
            return new StringBuilder(4).append(string).append("\n\n  ").append(string2).toString();
        })).mkString("\n", "\n\n", "\n");
    }

    public final int HelpPatternFlags() {
        return 66;
    }

    public boolean isSbtBuild(File baseDir) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(baseDir), "project").exists() || syntax$.MODULE$.singleFileFinder(baseDir).$times((FileFilter)FileFilter$.MODULE$.globFilter("*.sbt")).get().nonEmpty();
    }

    private static final String withAttribute$$anonfun$1(String ifMissing$1) {
        return ifMissing$1;
    }

    private static final String $anonfun$3(String k$1) {
        return k$1;
    }

    private static final String $anonfun$4(String v$1) {
        return v$1;
    }
}

