/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileSystems;
import sbt.State;
import sbt.Watched;
import sbt.Watched$WatchSource$;
import sbt.internal.LabeledFunctions$;
import sbt.internal.LegacyWatched$;
import sbt.internal.io.EventMonitor;
import sbt.internal.io.WatchState;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.internal.util.KeyTag$;
import sbt.internal.util.Types$;
import sbt.io.MacOSXWatchService;
import sbt.io.PollingWatchService;
import sbt.io.WatchService;
import sbt.io.WatchService$;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Properties$;

public final class Watched$
implements Serializable {
    public static final Watched$WatchSource$ WatchSource;
    private static final Function0<WatchService> newWatchService;
    private static final FiniteDuration PollDelay;
    private static final FiniteDuration AntiEntropy;
    private static final AttributeKey<EventMonitor> ContinuousEventMonitor;
    private static final AttributeKey<WatchState> ContinuousState;
    private static final AttributeKey<WatchService> ContinuousWatchService;
    private static final AttributeKey<Watched> Configuration;
    private static final Function1<WatchState, String> defaultWatchingMessage;
    private static final Function1<WatchState, String> defaultTriggeredMessage;
    private static final Function1<WatchState, String> clearWhenTriggered;
    public static final Watched$ MODULE$;

    private Watched$() {
    }

    static {
        MODULE$ = new Watched$();
        newWatchService = LabeledFunctions$.MODULE$.label((Function0 & Serializable)() -> this.createWatchService(), "Watched.newWatchService");
        PollDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(500)).milliseconds();
        AntiEntropy = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(40)).milliseconds();
        ContinuousEventMonitor = AttributeKey$.MODULE$.apply("watch event monitor", "Internal: maintains watch state and monitor threads.", KeyTag$.MODULE$.given_KeyTag_A(ClassTag$.MODULE$.apply(EventMonitor.class)), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        ContinuousState = AttributeKey$.MODULE$.apply("watch state", "Internal: tracks state for continuous execution.", KeyTag$.MODULE$.given_KeyTag_A(ClassTag$.MODULE$.apply(WatchState.class)), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        ContinuousWatchService = AttributeKey$.MODULE$.apply("watch service", "Internal: tracks watch service for continuous execution.", KeyTag$.MODULE$.given_KeyTag_A(ClassTag$.MODULE$.apply(WatchService.class)), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        Configuration = AttributeKey$.MODULE$.apply("watched-configuration", "Configures continuous execution.", KeyTag$.MODULE$.given_KeyTag_A(ClassTag$.MODULE$.apply(Watched.class)), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        defaultWatchingMessage = LabeledFunctions$.MODULE$.label((Function1 & Serializable)ws -> new StringBuilder(3).append(ws.count()).append(". ").append(this.waitMessage("")).append(" ").toString(), "Watched.projectWatchingMessage");
        defaultTriggeredMessage = LabeledFunctions$.MODULE$.label(Types$.MODULE$.const((Object)""), "Watched.defaultTriggeredMessage");
        clearWhenTriggered = LabeledFunctions$.MODULE$.label(Types$.MODULE$.const((Object)MODULE$.clearScreen()), "Watched.clearWhenTriggered");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Watched$.class);
    }

    public boolean terminateWatch(int key) {
        return this.isEnter(key);
    }

    private String waitMessage(String project) {
        return new StringBuilder(56).append("Waiting for source changes").append(project).append("... (press enter to interrupt)").toString();
    }

    public String clearScreen() {
        return "\u001b[2J\u001b[0;0H";
    }

    public Function0<WatchService> newWatchService() {
        return newWatchService;
    }

    /*
     * Enabled aggressive block sorting
     */
    public WatchService createWatchService(FiniteDuration pollDelay) {
        MacOSXWatchService macOSXWatchService;
        Option option = scala.sys.package$.MODULE$.props().get("sbt.watch.mode");
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            if ("polling".equals(string)) {
                macOSXWatchService = new PollingWatchService(pollDelay);
                return (WatchService)macOSXWatchService;
            }
            if ("nio".equals(string)) {
                macOSXWatchService = WatchService$.MODULE$.WatchServiceAdapter(FileSystems.getDefault().newWatchService());
                return (WatchService)macOSXWatchService;
            }
            if ("closewatch".equals(string)) {
                macOSXWatchService = this.closeWatch$1();
                return (WatchService)macOSXWatchService;
            }
        }
        if (Properties$.MODULE$.isMac()) {
            macOSXWatchService = this.closeWatch$1();
            return (WatchService)macOSXWatchService;
        }
        macOSXWatchService = WatchService$.MODULE$.WatchServiceAdapter(FileSystems.getDefault().newWatchService());
        return (WatchService)macOSXWatchService;
    }

    public void printIfDefined(String msg) {
        if (!msg.isEmpty()) {
            System.out.println(msg);
            return;
        }
    }

    public boolean isEnter(int key) {
        return key == 10 || key == 13;
    }

    public FiniteDuration PollDelay() {
        return PollDelay;
    }

    public FiniteDuration AntiEntropy() {
        return AntiEntropy;
    }

    public WatchService createWatchService() {
        return this.createWatchService(this.PollDelay());
    }

    public State executeContinuously(Watched watched, State s, String next, String repeat) {
        return LegacyWatched$.MODULE$.executeContinuously(watched, s, next, repeat);
    }

    public Function1<WatchState, String> projectWatchingMessage(String projectId) {
        return LabeledFunctions$.MODULE$.label((Function1 & Serializable)ws -> (String)((Option)MODULE$.projectOnWatchMessage(projectId).apply((Object)BoxesRunTime.boxToInteger((int)ws.count()), (Object)projectId, (Object)package$.MODULE$.Nil())).get(), "Watched.projectWatchingMessage");
    }

    public Function3<Object, String, Seq<String>, Option<String>> projectOnWatchMessage(String project) {
        return LabeledFunctions$.MODULE$.label((Function3 & Serializable)(count, _$1, _$2) -> Some$.MODULE$.apply((Object)new StringBuilder(2).append(BoxesRunTime.unboxToInt((Object)count)).append(". ").append(Watched$.MODULE$.waitMessage(new StringBuilder(12).append(" in project ").append(project).toString())).toString()), "Watched.projectOnWatchMessage");
    }

    public Watched multi(Watched base, Seq<Watched> paths) {
        return new Watched.AWatched(paths, base){
            private final Seq paths$2;
            private final Watched base$2;
            private final FiniteDuration pollInterval;
            private final FiniteDuration antiEntropy;
            {
                this.paths$2 = paths$1;
                this.base$2 = base$1;
                this.pollInterval = (FiniteDuration)((IterableOnceOps)((IterableOps)paths$1.$plus$colon((Object)base$1)).map(Watched$::sbt$Watched$$anon$1$$_$$lessinit$greater$$anonfun$3)).min((Ordering)FiniteDuration.FiniteDurationIsOrdered$.MODULE$);
                this.antiEntropy = (FiniteDuration)((IterableOnceOps)((IterableOps)paths$1.$plus$colon((Object)base$1)).map(Watched$::sbt$Watched$$anon$1$$_$$lessinit$greater$$anonfun$4)).min((Ordering)FiniteDuration.FiniteDurationIsOrdered$.MODULE$);
            }

            public Seq watchSources(State s) {
                return (Seq)this.paths$2.foldLeft(this.base$2.watchSources(s), (arg_0, arg_1) -> Watched$.sbt$Watched$$anon$1$$_$watchSources$$anonfun$1(s, arg_0, arg_1));
            }

            public boolean terminateWatch(int key) {
                return this.base$2.terminateWatch(key);
            }

            public FiniteDuration pollInterval() {
                return this.pollInterval;
            }

            public FiniteDuration antiEntropy() {
                return this.antiEntropy;
            }

            public String watchingMessage(WatchState s) {
                return this.base$2.watchingMessage(s);
            }

            public String triggeredMessage(WatchState s) {
                return this.base$2.triggeredMessage(s);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sbt$Watched$$anon$1$$_$$lessinit$greater$$anonfun$3(sbt.Watched ), sbt$Watched$$anon$1$$_$$lessinit$greater$$anonfun$4(sbt.Watched ), sbt$Watched$$anon$1$$_$watchSources$$anonfun$1(sbt.State scala.collection.immutable.Seq sbt.Watched )}, serializedLambda);
            }
        };
    }

    public Watched empty() {
        return new Watched.AWatched();
    }

    public AttributeKey<EventMonitor> ContinuousEventMonitor() {
        return ContinuousEventMonitor;
    }

    public AttributeKey<WatchState> ContinuousState() {
        return ContinuousState;
    }

    public AttributeKey<WatchService> ContinuousWatchService() {
        return ContinuousWatchService;
    }

    public AttributeKey<Watched> Configuration() {
        return Configuration;
    }

    public Function1<WatchState, String> defaultWatchingMessage() {
        return defaultWatchingMessage;
    }

    public Function1<WatchState, String> defaultTriggeredMessage() {
        return defaultTriggeredMessage;
    }

    public Function1<WatchState, String> clearWhenTriggered() {
        return clearWhenTriggered;
    }

    private final MacOSXWatchService closeWatch$1() {
        return new MacOSXWatchService();
    }

    public static final /* synthetic */ FiniteDuration sbt$Watched$$anon$1$$_$$lessinit$greater$$anonfun$3(Watched _$5) {
        return _$5.pollInterval();
    }

    public static final /* synthetic */ FiniteDuration sbt$Watched$$anon$1$$_$$lessinit$greater$$anonfun$4(Watched _$6) {
        return _$6.antiEntropy();
    }

    public static final /* synthetic */ Seq sbt$Watched$$anon$1$$_$watchSources$$anonfun$1(State s$1, Seq _$3, Watched _$4) {
        return (Seq)_$3.$plus$plus(_$4.watchSources(s$1));
    }
}

