/*
 * Decompiled with CFR 0.152.
 */
package xsbt;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scala.util.control.NonFatal$;
import xsbt.IPC;

public final class IPC$
implements Serializable {
    private static final int portMin;
    private static final int portMax;
    private static final InetAddress loopback;
    private static final int socketBacklog;
    public static final IPC$ MODULE$;

    private IPC$() {
    }

    static {
        MODULE$ = new IPC$();
        portMin = 1025;
        portMax = 65536;
        loopback = InetAddress.getByName(null);
        socketBacklog = 50;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IPC$.class);
    }

    public int socketBacklog() {
        return socketBacklog;
    }

    public <T> T client(int port, Function1<IPC, T> f) {
        return this.xsbt$IPC$$$ipc(new Socket(loopback, port), f);
    }

    public <T> T pullServer(Function1<IPC.Server, T> f) {
        Object object;
        try (ServerSocket server = this.makeServer();){
            object = f.apply((Object)new IPC.Server(server));
        }
        return (T)object;
    }

    public IPC.Server unmanagedServer() {
        return new IPC.Server(this.makeServer());
    }

    public ServerSocket makeServer() {
        Random random = new Random();
        return this.createServer$1(random, 10);
    }

    public <T> T server(Function1<IPC, Option<T>> f) {
        return this.serverImpl(this.makeServer(), f);
    }

    public <T> T server(int port, Function1<IPC, Option<T>> f) {
        return this.serverImpl(new ServerSocket(port, 1, loopback), f);
    }

    private <T> T serverImpl(ServerSocket server, Function1<IPC, Option<T>> f) {
        Object object;
        try {
            object = this.listen$1(server, f);
        }
        finally {
            server.close();
        }
        return (T)object;
    }

    public <T> T xsbt$IPC$$$ipc(Socket s, Function1<IPC, T> f) {
        Object object;
        try {
            object = f.apply((Object)new IPC(s));
        }
        finally {
            s.close();
        }
        return (T)object;
    }

    private final int nextPort$1(Random random$1) {
        return random$1.nextInt(portMax - portMin + 1) + portMin;
    }

    private final ServerSocket createServer$1(Random random$2, int attempts) {
        while (attempts > 0) {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(this.nextPort$1(random$2), this.socketBacklog(), loopback);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    --attempts;
                    continue;
                }
                throw throwable;
            }
            return serverSocket;
        }
        throw package$.MODULE$.error("Could not connect to socket: maximum attempts exceeded");
    }

    private final Object listen$1(ServerSocket server$1, Function1 f$1) {
        Option option;
        do {
            if (!((option = (Option)this.xsbt$IPC$$$ipc(server$1.accept(), f$1)) instanceof Some)) continue;
            Object done = ((Some)option).value();
            return done;
        } while (None$.MODULE$.equals(option));
        throw new MatchError((Object)option);
    }
}

