/*
 * Decompiled with CFR 0.152.
 */
package xsbt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import scala.Function1;
import scala.Option;
import xsbt.IPC$;

public final class IPC {
    private final Socket s;
    private final BufferedReader in;
    private final BufferedWriter out;

    public static <T> T client(int n, Function1<IPC, T> function1) {
        return IPC$.MODULE$.client(n, function1);
    }

    public static ServerSocket makeServer() {
        return IPC$.MODULE$.makeServer();
    }

    public static <T> T pullServer(Function1<Server, T> function1) {
        return IPC$.MODULE$.pullServer(function1);
    }

    public static <T> T server(Function1<IPC, Option<T>> function1) {
        return IPC$.MODULE$.server(function1);
    }

    public static <T> T server(int n, Function1<IPC, Option<T>> function1) {
        return IPC$.MODULE$.server(n, function1);
    }

    public static int socketBacklog() {
        return IPC$.MODULE$.socketBacklog();
    }

    public static Server unmanagedServer() {
        return IPC$.MODULE$.unmanagedServer();
    }

    public IPC(Socket s) {
        this.s = s;
        this.in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
    }

    public int port() {
        return this.s.getLocalPort();
    }

    public void send(String s) {
        this.out.write(s);
        this.out.newLine();
        this.out.flush();
    }

    public String receive() {
        return this.in.readLine();
    }

    public static final class Server {
        private final ServerSocket s;

        public Server(ServerSocket s) {
            this.s = s;
        }

        public int port() {
            return this.s.getLocalPort();
        }

        public void close() {
            this.s.close();
        }

        public boolean isClosed() {
            return this.s.isClosed();
        }

        public <T> T connection(Function1<IPC, T> f) {
            return IPC$.MODULE$.xsbt$IPC$$$ipc(this.s.accept(), f);
        }
    }
}

