/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.io.ErrorHandling$;
import sbt.internal.io.Milli$;
import sbt.internal.io.Retry$;
import sbt.io.AllPassFilter$;
import sbt.io.CopyOptions;
import sbt.io.CopyOptions$;
import sbt.io.GlobFilter$;
import sbt.io.NameFilter;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.PathFinder$;
import sbt.io.RichFile;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView$;
import scala.Array$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Exception$;
import scala.util.control.NonFatal$;

public final class IO$ {
    public static IO$ MODULE$;
    private Random random;
    private FileSystem jrtFs;
    private boolean hasPosixFileAttributeView;
    private boolean hasFileOwnerAttributeView;
    private boolean hasDosFileAttributeView;
    private boolean hasAclFileAttributeView;
    private boolean hasBasicFileAttributeView;
    private boolean hasUserDefinedFileAttributeView;
    private scala.collection.immutable.Set<String> supportedFileAttributeViews;
    private final int MaximumTries;
    private final File temporaryDirectory;
    private final int BufferSize;
    private final String FileScheme;
    private final String Newline;
    private final Charset utf8;
    private final Pattern PathSeparatorPattern;
    private final boolean isWindows;
    private final scala.collection.immutable.Seq<Class<? extends IOException>> excludeFileNotFound;
    private volatile int bitmap$0;

    static {
        new IO$();
    }

    private int MaximumTries() {
        return this.MaximumTries;
    }

    private Random random$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.random = new Random();
                this.bitmap$0 |= 1;
            }
        }
        return this.random;
    }

    private Random random() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.random$lzycompute();
        }
        return this.random;
    }

    public File temporaryDirectory() {
        return this.temporaryDirectory;
    }

    private int BufferSize() {
        return this.BufferSize;
    }

    public String FileScheme() {
        return this.FileScheme;
    }

    public String Newline() {
        return this.Newline;
    }

    public Charset utf8() {
        return this.utf8;
    }

    private FileSystem jrtFs$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.jrtFs = FileSystems.getFileSystem(URI.create("jrt:/"));
                this.bitmap$0 |= 2;
            }
        }
        return this.jrtFs;
    }

    private FileSystem jrtFs() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.jrtFs$lzycompute();
        }
        return this.jrtFs;
    }

    public Path classLocationPath(Class<?> cl) {
        URL u = this.classLocation(cl);
        String string = u.getProtocol();
        String string2 = this.FileScheme();
        String string3 = string;
        Option p = !(string2 != null ? !string2.equals(string3) : string3 != null) ? Option$.MODULE$.apply((Object)this.toFile(u).toPath()) : ("jar".equals(string) ? this.urlAsFile(u).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toPath()) : ("jrt".equals(string) ? Option$.MODULE$.apply((Object)this.jrtFs().getPath(u.getPath(), new String[0])) : None$.MODULE$));
        return (Path)p.getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Unable to create File from ").append(u).append(" for ").append(cl).toString()));
    }

    public <A> Path classLocationPath(Manifest<A> mf) {
        return this.classLocationPath(mf.runtimeClass());
    }

    public Option<File> classLocationFileOption(Class<?> cl) {
        URL u = this.classLocation(cl);
        return this.urlAsFile(u);
    }

    public <A> Option<File> classLocationFileOption(Manifest<A> mf) {
        return this.classLocationFileOption(mf.runtimeClass());
    }

    public File classLocationFile(Class<?> cl) {
        return (File)this.classLocationFileOption(cl).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(27).append("Unable to create File from ").append(cl).toString()));
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.runtimeClass());
    }

    public URL classLocation(Class<?> cl) {
        URL uRL;
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            uRL = (URL)IO$.localcl$1(cl).orElse((Function0 & Serializable & scala.Serializable)() -> IO$.syscl$1(clsfile)).map((Function1 & Serializable & scala.Serializable)url -> {
                String string = url.getProtocol();
                if ("jar".equals(string)) {
                    String path = url.getPath();
                    int end = path.indexOf(33);
                    return new URL(end == -1 ? path : path.substring(0, end));
                }
                if ("jrt".equals(string)) {
                    String path = url.getPath();
                    int end = path.indexOf(47, 1);
                    return new URL("jrt", null, end == -1 ? path : path.substring(0, end));
                }
                return url;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl).toString()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
        return uRL;
    }

    public <A> URL classLocation(Manifest<A> mf) {
        return this.classLocation(mf.runtimeClass());
    }

    public <T> URL classfileLocation(Manifest<T> mf) {
        return this.classfileLocation(mf.runtimeClass());
    }

    public URL classfileLocation(Class<?> cl) {
        URL uRL;
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            uRL = (URL)IO$.localcl$2(cl, clsfile).orElse((Function0 & Serializable & scala.Serializable)() -> IO$.syscl$2(clsfile)).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl).toString()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
        return uRL;
    }

    public File toFile(URL url) {
        File file;
        try {
            file = this.uriToFile(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(url.getPath());
        }
        return file;
    }

    public File toFile(URI uri) {
        File file;
        try {
            file = this.uriToFile(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uri.getPath());
        }
        return file;
    }

    public File asFile(URL url) {
        return (File)this.urlAsFile(url).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(19).append("URL is not a file: ").append(url).toString()));
    }

    public Option<File> urlAsFile(URL url) {
        String string = url.getProtocol();
        String string2 = this.FileScheme();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new Some((Object)this.toFile(url));
        }
        if ("jar".equals(string)) {
            String path = url.getPath();
            int end = path.indexOf(33);
            return new Some((Object)this.uriToFile(end == -1 ? path : path.substring(0, end)));
        }
        return None$.MODULE$;
    }

    private File uriToFile(String uriString) {
        return this.uriToFile(new URI(uriString));
    }

    /*
     * Unable to fully structure code
     */
    private File uriToFile(URI uri) {
        block5: {
            block4: {
                part = uri.getSchemeSpecificPart();
                var6_3 = Option$.MODULE$.apply((Object)uri.getScheme());
                if (!None$.MODULE$.equals(var6_3)) break block4;
                v0 = true;
                break block5;
            }
            if (!(var6_3 instanceof Some)) ** GOTO lbl-1000
            var7_4 = (Some)var6_3;
            var8_5 = (String)var7_4.value();
            v1 = this.FileScheme();
            var9_6 = var8_5;
            if (!(v1 != null ? v1.equals(var9_6) == false : var9_6 != null)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        Predef$.MODULE$.assert(v0 != false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$uriToFile$1(java.net.URI ), ()Ljava/lang/String;)((URI)uri));
        var10_7 = Option$.MODULE$.apply((Object)uri.getAuthority());
        if (None$.MODULE$.equals(var10_7) && part.startsWith("/")) {
            return new File(uri);
        }
        if (!part.startsWith("/") && part.contains(":")) {
            return new File(new StringBuilder(2).append("//").append(part).toString());
        }
        return new File(part);
    }

    public void assertDirectory(File file) {
        Predef$.MODULE$.assert(file.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(file.exists() ? "Not a directory: " : "Directory not found: ").append(file).toString());
    }

    public void assertDirectories(Seq<File> file2) {
        file2.foreach((Function1 & Serializable & scala.Serializable)file -> {
            IO$.MODULE$.assertDirectory(file);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<String, String> split(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            return new Tuple2((Object)name.substring(0, lastDot), (Object)name.substring(lastDot + 1));
        }
        return new Tuple2((Object)name, (Object)"");
    }

    public void touch(Traversable<File> files) {
        files.foreach((Function1 & Serializable & scala.Serializable)f -> {
            IO$.MODULE$.touch(f, IO$.MODULE$.touch$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void touch(File file, boolean setModified) {
        Retry$.MODULE$.apply$mVc$sp((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File absFile = file.getAbsoluteFile();
            MODULE$.createDirectory(absFile.getParentFile());
            boolean created = BoxesRunTime.unboxToBoolean(ErrorHandling$.MODULE$.translate((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Could not create file ").append(absFile).toString(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> absFile.createNewFile()));
            if (created || absFile.isDirectory()) {
                return;
            }
            if (setModified && !MODULE$.setModifiedTimeOrFalse(absFile, System.currentTimeMillis())) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(45).append("Could not update last modified time for file ").append(absFile).toString());
            }
        }, (Seq<Class<? extends IOException>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public boolean touch$default$2() {
        return true;
    }

    public void createDirectories(Traversable<File> dirs) {
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            IO$.MODULE$.createDirectory(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void createDirectory(File dir) {
        Path path = dir.toPath();
        try {
            Retry$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Path path;
                try {
                    path = Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof IOException && Files.isDirectory(path, new LinkOption[0])) {
                        path = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                return path;
            }, (Seq<Class<? extends IOException>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{FileAlreadyExistsException.class}));
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(2).append(IO$.failBase$1(dir)).append(": ").append(e).toString(), e);
        }
    }

    public void gzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file == null ? file2 != null : !((Object)file).equals(file2), (Function0 & Serializable & scala.Serializable)() -> "Input file cannot be the same as the output file.");
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, (Function1 & Serializable & scala.Serializable)inputStream -> {
            IO$.$anonfun$gzip$2(out, inputStream);
            return BoxedUnit.UNIT;
        });
    }

    public void gzip(InputStream input, OutputStream output) {
        Using$.MODULE$.gzipOutputStream().apply(output, (Function1 & Serializable & scala.Serializable)gzStream -> {
            IO$.MODULE$.transfer(input, (OutputStream)gzStream);
            return BoxedUnit.UNIT;
        });
    }

    public void gunzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file == null ? file2 != null : !((Object)file).equals(file2), (Function0 & Serializable & scala.Serializable)() -> "Input file cannot be the same as the output file.");
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, (Function1 & Serializable & scala.Serializable)inputStream -> {
            IO$.$anonfun$gunzip$2(out, inputStream);
            return BoxedUnit.UNIT;
        });
    }

    public void gunzip(InputStream input, OutputStream output) {
        Using$.MODULE$.gzipInputStream().apply(input, (Function1 & Serializable & scala.Serializable)gzStream -> {
            IO$.MODULE$.transfer((InputStream)gzStream, output);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Set<File> unzip(File from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (Function1 & Serializable & scala.Serializable)in -> MODULE$.unzipStream((InputStream)in, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzip$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzip$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipURL(URL from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)Using$.MODULE$.urlInputStream().apply(from, (Function1 & Serializable & scala.Serializable)in -> MODULE$.unzipStream((InputStream)in, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzipURL$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipURL$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipStream(InputStream from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        this.createDirectory(toDirectory);
        return (scala.collection.immutable.Set)Using$.MODULE$.zipInputStream().apply(from, (Function1 & Serializable & scala.Serializable)zipInput -> MODULE$.extract((ZipInputStream)zipInput, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzipStream$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipStream$default$4() {
        return true;
    }

    private scala.collection.immutable.Set<File> extract(ZipInputStream from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        HashSet set = new HashSet();
        this.next$1(from, filter, toDirectory, set, preserveLastModified);
        return (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)set);
    }

    public void transfer(File in2, File out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in2, (Function1 & Serializable & scala.Serializable)in -> {
            IO$.MODULE$.transfer((InputStream)in, out);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(File in2, OutputStream out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in2, (Function1 & Serializable & scala.Serializable)in -> {
            IO$.MODULE$.transfer((InputStream)in, out);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(InputStream in, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, (Function1 & Serializable & scala.Serializable)outputStream -> {
            IO$.MODULE$.transfer(in, (OutputStream)outputStream);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    public void transferAndClose(InputStream in, OutputStream out) {
        this.transferImpl(in, out, true);
    }

    private void transferImpl(InputStream in, OutputStream out, boolean close) {
        try {
            byte[] buffer = new byte[this.BufferSize()];
            this.read$1(in, buffer, out);
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action, boolean keepDirectory) {
        Object object;
        File dir = this.createTemporaryDirectory();
        try {
            object = action.apply((Object)dir);
        }
        finally {
            if (!keepDirectory) {
                this.delete(dir);
            }
        }
        return (T)object;
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action) {
        return this.withTemporaryDirectory(action, false);
    }

    public File createTemporaryDirectory() {
        return this.createUniqueDirectory(this.temporaryDirectory());
    }

    public File createUniqueDirectory(File baseDirectory) {
        return this.create$1(0, baseDirectory);
    }

    public <T> T withTemporaryFile(String prefix, String postfix, boolean keepFile, Function1<File, T> action) {
        Object object;
        File file = File.createTempFile(prefix, postfix);
        try {
            object = action.apply((Object)file);
        }
        catch (Throwable throwable) {
            Object object2 = !keepFile ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
            throw throwable;
        }
        Object object3 = !keepFile ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
        return (T)object;
    }

    public <T> T withTemporaryFile(String prefix, String postfix, Function1<File, T> action) {
        return this.withTemporaryFile(prefix, postfix, false, action);
    }

    public Iterable<File> jars(File dir) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(dir, GlobFilter$.MODULE$.apply("*.jar")));
    }

    public void deleteIfEmpty(Set<File> dirs) {
        HashMap isEmpty = new HashMap();
        dirs.foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IO$.visit$1(f, isEmpty, dirs)));
        isEmpty.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$deleteIfEmpty$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$deleteIfEmpty$5(x$2)));
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1 & Serializable & scala.Serializable)file -> {
            IO$.MODULE$.delete(file);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteFilesEmptyDirs(Iterable<File> files) {
        this.delete(files);
        this.deleteEmpty$1(IO$.parents$1(files.toSet()));
    }

    public void delete(File file) {
        Retry$.MODULE$.apply$mVc$sp((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object;
            try {
                FileTreeView$.MODULE$.default().list(file.toPath()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Path dir = (Path)tuple2._1();
                        FileAttributes attrs = (FileAttributes)tuple2._2();
                        if (attrs.isDirectory()) {
                            MODULE$.delete(dir.toFile());
                            return BoxedUnit.UNIT;
                        }
                    }
                    if (tuple2 != null) {
                        Boolean bl;
                        Path f = (Path)tuple2._1();
                        try {
                            bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(f));
                        }
                        catch (IOException iOException) {
                            bl = BoxedUnit.UNIT;
                        }
                        return bl;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            catch (IOException iOException) {}
            try {
                object = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            catch (IOException iOException) {
                object = BoxedUnit.UNIT;
            }
        }, (Seq<Class<? extends IOException>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public File[] listFiles(FileFilter filter, File dir) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir, FileFilter filter) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        if (a == null) {
            return new File[0];
        }
        return a;
    }

    public void jar(Traversable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest), (Option<Object>)None$.MODULE$);
    }

    public void jar(Traversable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest, Option<Object> time) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest), time);
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip, Option<Object> time) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$, time);
    }

    private void archive(Seq<Tuple2<File, String>> sources, File outputFile, Option<java.util.jar.Manifest> manifest, Option<Object> time) {
        Option localTime = time.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)t -> t - (long)TimeZone.getDefault().getOffset(t));
        if (outputFile.isDirectory()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(38).append("Specified output file ").append(outputFile).append(" is a directory.").toString());
        }
        File file = outputFile.getParentFile();
        File outputDir = file == null ? new File(".") : file;
        this.createDirectory(outputDir);
        this.withZipOutput(outputFile, manifest, (Option<Object>)localTime, (Function1<ZipOutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
            IO$.$anonfun$archive$2(manifest, sources, localTime, output);
            return BoxedUnit.UNIT;
        });
    }

    private void writeZip(Seq<Tuple2<File, String>> sources, ZipOutputStream output, Option<Object> time, Function1<String, ZipEntry> createEntry) {
        Seq files = (Seq)((SeqLike)sources.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                if (file.isFile()) {
                    Tuple2 tuple22 = new Tuple2((Object)file, (Object)MODULE$.normalizeToSlash(name));
                    return Nil$.MODULE$.$colon$colon((Object)tuple22);
                }
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._2();
                return name;
            }
            throw new MatchError((Object)tuple2);
        }, (Ordering)Ordering.String$.MODULE$);
        long now = System.currentTimeMillis();
        long emptyCRC = new CRC32().getValue();
        this.allDirectoryPaths((Iterable<Tuple2<File, String>>)files).foreach((Function1 & Serializable & scala.Serializable)name -> {
            IO$.addDirectoryEntry$1(name, output, createEntry, time, now, emptyCRC);
            return BoxedUnit.UNIT;
        });
        files.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            IO$.$anonfun$writeZip$6(this, output, createEntry, time, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private List<String> relativeComponents(String path) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).toList().dropRight(1);
    }

    private List<String> directories(List<String> path) {
        return (List)path.foldLeft((Object)new .colon.colon((Object)"", (List)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(e, l) -> {
            String string = new StringBuilder(1).append((String)e.head()).append((String)l).append("/").toString();
            return e.$colon$colon((Object)string);
        });
    }

    private List<String> directoryPaths(String path) {
        return (List)this.directories(this.relativeComponents(path)).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$directoryPaths$1(x$8)));
    }

    private TreeSet<String> allDirectoryPaths(Iterable<Tuple2<File, String>> files) {
        return (TreeSet)TreeSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.String$.MODULE$).$plus$plus((GenTraversableOnce)files.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._2();
                return MODULE$.directoryPaths(name);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    private String normalizeToSlash(String name) {
        char sep = File.separatorChar;
        if (sep == '/') {
            return name;
        }
        return name.replace(sep, '/');
    }

    private void withZipOutput(File file, Option<java.util.jar.Manifest> manifest, Option<Object> time, Function1<ZipOutputStream, BoxedUnit> f) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(file, (Function1 & Serializable & scala.Serializable)fileOut -> {
            IO$.$anonfun$withZipOutput$1(manifest, time, f, fileOut);
            return BoxedUnit.UNIT;
        });
    }

    public Option<File> relativizeFile(File base, File file) {
        return this.relativize(base, file).map((Function1 & Serializable & scala.Serializable)path -> new File((String)path));
    }

    public Option<String> relativize(File base, File file) {
        Path basePath = IO$.toAbsolutePath$1(base).normalize();
        Path filePath = IO$.toAbsolutePath$1(file).normalize();
        if (filePath.startsWith(basePath)) {
            Option relativePath = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt((Function0 & Serializable & scala.Serializable)() -> basePath.relativize(filePath));
            return relativePath.map((Function1 & Serializable & scala.Serializable)x$9 -> ((Object)x$9).toString());
        }
        return None$.MODULE$;
    }

    public scala.collection.immutable.Set<File> copy(Traversable<Tuple2<File, File>> sources) {
        return this.copy(sources, CopyOptions$.MODULE$.apply());
    }

    public scala.collection.immutable.Set<File> copy(Traversable<Tuple2<File, File>> sources, CopyOptions options) {
        return this.copy(sources, options.overwrite(), options.preserveLastModified(), options.preserveExecutable());
    }

    public scala.collection.immutable.Set<File> copy(Traversable<Tuple2<File, File>> sources, boolean overwrite, boolean preserveLastModified, boolean preserveExecutable) {
        return ((TraversableOnce)sources.map(Function$.MODULE$.tupled((Function2 & Serializable & scala.Serializable)(from, to) -> MODULE$.copyImpl(overwrite, preserveLastModified, preserveExecutable, (File)from, (File)to)), Traversable$.MODULE$.canBuildFrom())).toSet();
    }

    private File copyImpl(boolean overwrite, boolean preserveLastModified, boolean preserveExecutable, File from, File to) {
        block2: {
            if (!overwrite && to.exists() && this.getModifiedTimeOrZero(from) <= this.getModifiedTimeOrZero(to)) break block2;
            if (from.isDirectory()) {
                this.createDirectory(to);
            } else {
                this.createDirectory(to.getParentFile());
                this.copyFile(from, to, preserveLastModified, preserveExecutable);
            }
        }
        return to;
    }

    public void copyDirectory(File source, File target) {
        this.copyDirectory(source, target, CopyOptions$.MODULE$.apply());
    }

    public void copyDirectory(File source, File target, CopyOptions options) {
        this.copyDirectory(source, target, options.overwrite(), options.preserveLastModified(), options.preserveExecutable());
    }

    public void copyDirectory(File source, File target, boolean overwrite, boolean preserveLastModified, boolean preserveExecutable) {
        PathFinder qual$1 = PathFinder$.MODULE$.apply(source).allPaths();
        Function1<File, Option<File>> x$1 = Path$.MODULE$.rebase(source, target);
        boolean x$2 = qual$1.pair$default$2();
        Seq<Tuple2<File, File>> sources = qual$1.pair(x$1, x$2);
        this.copy((Traversable<Tuple2<File, File>>)sources, overwrite, preserveLastModified, preserveExecutable);
    }

    public boolean copyDirectory$default$3() {
        return false;
    }

    public boolean copyDirectory$default$4() {
        return false;
    }

    public boolean copyDirectory$default$5() {
        return true;
    }

    public void copyFile(File sourceFile, File targetFile) {
        this.copyFile(sourceFile, targetFile, CopyOptions$.MODULE$.apply());
    }

    public void copyFile(File sourceFile, File targetFile, CopyOptions options) {
        this.copyFile(sourceFile, targetFile, options.preserveLastModified(), options.preserveExecutable());
    }

    public void copyFile(File sourceFile, File targetFile, boolean preserveLastModified, boolean preserveExecutable) {
        Predef$.MODULE$.require(sourceFile.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Source file '").append(sourceFile.getAbsolutePath()).append("' does not exist.").toString());
        Predef$.MODULE$.require(!sourceFile.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Source file '").append(sourceFile.getAbsolutePath()).append("' is a directory.").toString());
        ((Using)((Object)Using$.MODULE$.fileInputChannel())).apply(sourceFile, (Function1 & Serializable & scala.Serializable)in -> {
            IO$.$anonfun$copyFile$3(this, targetFile, sourceFile, in);
            return BoxedUnit.UNIT;
        });
        if (preserveLastModified) {
            this.copyLastModified(sourceFile, targetFile);
        }
        if (preserveExecutable) {
            this.copyExecutable(sourceFile, targetFile);
            return;
        }
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public boolean copyFile$default$4() {
        return true;
    }

    public Object copyExecutable(File sourceFile, File targetFile) {
        boolean executable = sourceFile.canExecute();
        if (executable) {
            return BoxesRunTime.boxToBoolean((boolean)targetFile.setExecutable(true));
        }
        return BoxedUnit.UNIT;
    }

    public Charset defaultCharset() {
        return this.utf8();
    }

    public void write(File file, String content, Charset charset, boolean append) {
        this.writer(file, content, charset, append, (Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.write(content);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T writer(File file, String content, Charset charset, boolean append, Function1<BufferedWriter, T> f) {
        if (charset.newEncoder().canEncode(content)) {
            return ((Using)((Object)Using$.MODULE$.fileWriter(charset, append))).apply(file, f);
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(36).append("String cannot be encoded by charset ").append(charset.name()).toString());
    }

    public <T> T reader(File file, Charset charset, Function1<BufferedReader, T> f) {
        return ((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, f);
    }

    public String read(File file, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        this.transfer(file, (OutputStream)out);
        return out.toString(charset.name());
    }

    public <T> Charset reader$default$2() {
        return this.defaultCharset();
    }

    public Charset read$default$2() {
        return this.defaultCharset();
    }

    public String readStream(InputStream in, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset readStream$default$2() {
        return this.defaultCharset();
    }

    public byte[] readBytes(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & Serializable & scala.Serializable)in -> MODULE$.readBytes((InputStream)in));
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public void append(File file, String content, Charset charset) {
        this.write(file, content, charset, true);
    }

    public void append(File file, byte[] bytes) {
        this.writeBytes(file, bytes, true);
    }

    public Charset append$default$3() {
        return this.defaultCharset();
    }

    public void write(File file, byte[] bytes) {
        this.writeBytes(file, bytes, false);
    }

    private void writeBytes(File file, byte[] bytes, boolean append) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(append))).apply(file, (Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.write(bytes);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> readLinesURL(URL url, Charset charset) {
        return (List)Using$.MODULE$.urlReader(charset).apply(url, (Function1 & Serializable & scala.Serializable)in -> MODULE$.readLines((BufferedReader)in));
    }

    public List<String> readLines(File file, Charset charset) {
        return (List)((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, (Function1 & Serializable & scala.Serializable)in -> MODULE$.readLines((BufferedReader)in));
    }

    public List<String> readLines(BufferedReader in) {
        return ((List)this.foldLines(in, Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(accum, line) -> {
            String string = line;
            return accum.$colon$colon((Object)string);
        })).reverse();
    }

    public Charset readLinesURL$default$2() {
        return this.defaultCharset();
    }

    public Charset readLines$default$2() {
        return this.defaultCharset();
    }

    public void foreachLine(BufferedReader in, Function1<String, BoxedUnit> f) {
        this.foldLines(in, BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$13, line) -> {
            f.apply((Object)line);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T foldLines(BufferedReader in, T init, Function2<T, String, T> f) {
        return (T)this.readLine$1(init, in, f);
    }

    public void writeLines(File file, Seq<String> lines, Charset charset, boolean append) {
        this.writer(file, (String)lines.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), charset, append, (Function1 & Serializable & scala.Serializable)w -> {
            lines.foreach((Function1 & Serializable & scala.Serializable)line -> {
                IO$.$anonfun$writeLines$3(w, line);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void writeLines(PrintWriter writer, Seq<String> lines) {
        lines.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            writer.println(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void write(Properties properties, String label, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, (Function1 & Serializable & scala.Serializable)output -> {
            properties.store(output, label);
            return BoxedUnit.UNIT;
        });
    }

    public Charset write$default$3() {
        return this.defaultCharset();
    }

    public boolean write$default$4() {
        return false;
    }

    public <T> boolean writer$default$4() {
        return false;
    }

    public Charset writeLines$default$3() {
        return this.defaultCharset();
    }

    public boolean writeLines$default$4() {
        return false;
    }

    public void load(Properties properties, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (Function1 & Serializable & scala.Serializable)input -> {
                properties.load(input);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Pattern PathSeparatorPattern() {
        return this.PathSeparatorPattern;
    }

    public String[] pathSplit(String s) {
        return this.PathSeparatorPattern().split(s);
    }

    public <T> T stash(scala.collection.immutable.Set<File> files, Function0<T> f) {
        return this.withTemporaryDirectory((Function1 & Serializable & scala.Serializable)dir -> {
            Object object;
            Tuple2<File, File>[] stashed = MODULE$.stashLocations((File)dir, (File[])files.toArray(ClassTag$.MODULE$.apply(File.class)));
            MODULE$.move((Traversable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray((Object[])stashed));
            try {
                object = f.apply();
            }
            catch (Exception e) {
                try {
                    MODULE$.move((Traversable<Tuple2<File, File>>)((Traversable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stashed)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.swap(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                    throw e;
                }
                catch (Exception exception) {
                    throw e;
                }
            }
            return object;
        });
    }

    private Tuple2<File, File>[] stashLocations(File dir, File[] files) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$stashLocations$1(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new Tuple2((Object)file, (Object)new File(dir, RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(index))));
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public void move(Traversable<Tuple2<File, File>> files) {
        files.foreach(Function$.MODULE$.tupled((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> {
            IO$.MODULE$.move(x$16, x$17);
            return BoxedUnit.UNIT;
        }));
    }

    public void move(File a, File b) {
        if (b.exists()) {
            this.delete(b);
        }
        this.createDirectory(b.getParentFile());
        if (!a.renameTo(b)) {
            this.copyFile(a, b, true, this.copyFile$default$4());
            this.delete(a);
            return;
        }
    }

    public <T> T gzipFileOut(File file, Function1<OutputStream, T> f) {
        return (T)((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(file, (Function1 & Serializable & scala.Serializable)fout -> Using$.MODULE$.gzipOutputStream().apply((OutputStream)fout, (Function1 & Serializable & scala.Serializable)outg -> Using$.MODULE$.bufferedOutputStream().apply((OutputStream)outg, f)));
    }

    public <T> T gzipFileIn(File file, Function1<InputStream, T> f) {
        return (T)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & Serializable & scala.Serializable)fin -> Using$.MODULE$.gzipInputStream().apply((InputStream)fin, (Function1 & Serializable & scala.Serializable)ing -> Using$.MODULE$.bufferedInputStream().apply((InputStream)ing, f)));
    }

    public URI directoryURI(File dir) {
        this.assertAbsolute(dir);
        return this.directoryURI(dir.toURI().normalize());
    }

    /*
     * Unable to fully structure code
     */
    public URI directoryURI(URI uri) {
        if (!uri.isAbsolute()) {
            return uri;
        }
        str = uri.toASCIIString();
        if (str.endsWith("/")) ** GOTO lbl-1000
        v0 = uri.getScheme();
        var4_3 = this.FileScheme();
        if ((v0 != null ? v0.equals(var4_3) == false : var4_3 != null) || uri.getRawFragment() != null) lbl-1000:
        // 2 sources

        {
            v1 = uri;
        } else {
            v1 = new URI(new StringBuilder(1).append(str).append("/").toString());
        }
        dirURI = v1;
        return dirURI.normalize();
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public URI toURI(File f) {
        String p = f.getPath();
        if (this.isWindows() && new StringOps(Predef$.MODULE$.augmentString(p)).nonEmpty() && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(p)).head()) == File.separatorChar) {
            if (p.startsWith("\\\\")) {
                return new URI(this.FileScheme(), this.normalizeToSlash(p), null);
            }
            return new URI(this.FileScheme(), "", this.normalizeToSlash(p), null);
        }
        if (f.isAbsolute()) {
            return new URI(this.FileScheme(), "", this.normalizeToSlash(IO$.ensureHeadSlash$1(f.getAbsolutePath())), null);
        }
        return new URI(null, this.normalizeToSlash(f.getPath()), null);
    }

    public File resolve(File base, File f) {
        this.assertAbsolute(base);
        File fabs = f.isAbsolute() ? f : new File(this.directoryURI(new File(base, f.getPath())));
        this.assertAbsolute(fabs);
        return fabs;
    }

    public void assertAbsolute(File f) {
        Predef$.MODULE$.assert(f.isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Not absolute: ").append(f).toString());
    }

    public void assertAbsolute(URI uri) {
        Predef$.MODULE$.assert(uri.isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Not absolute: ").append(uri).toString());
    }

    public Seq<File> parseClasspath(String s) {
        if (s.isEmpty()) {
            return Nil$.MODULE$;
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.pathSplit(s))).map((Function1 & Serializable & scala.Serializable)x$18 -> new File((String)x$18), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).toSeq();
    }

    public ObjectInputStream objectInputStream(InputStream wrapped, ClassLoader loader) {
        return new ObjectInputStream(wrapped, loader){
            private final ClassLoader loader$1;

            public Class<?> resolveClass(ObjectStreamClass osc) {
                Class<?> c = Class.forName(osc.getName(), false, this.loader$1);
                if (c == null) {
                    return super.resolveClass(osc);
                }
                return c;
            }
            {
                this.loader$1 = loader$1;
                super(wrapped$1);
            }
        };
    }

    public boolean isPosix() {
        return this.hasPosixFileAttributeView();
    }

    private boolean hasPosixFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.hasPosixFileAttributeView = this.supportedFileAttributeViews().contains((Object)"posix");
                this.bitmap$0 |= 4;
            }
        }
        return this.hasPosixFileAttributeView;
    }

    public boolean hasPosixFileAttributeView() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.hasPosixFileAttributeView$lzycompute();
        }
        return this.hasPosixFileAttributeView;
    }

    private boolean hasFileOwnerAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.hasFileOwnerAttributeView = this.supportedFileAttributeViews().contains((Object)"owner");
                this.bitmap$0 |= 8;
            }
        }
        return this.hasFileOwnerAttributeView;
    }

    public boolean hasFileOwnerAttributeView() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.hasFileOwnerAttributeView$lzycompute();
        }
        return this.hasFileOwnerAttributeView;
    }

    private boolean hasDosFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.hasDosFileAttributeView = this.supportedFileAttributeViews().contains((Object)"dos");
                this.bitmap$0 |= 0x10;
            }
        }
        return this.hasDosFileAttributeView;
    }

    public boolean hasDosFileAttributeView() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.hasDosFileAttributeView$lzycompute();
        }
        return this.hasDosFileAttributeView;
    }

    private boolean hasAclFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.hasAclFileAttributeView = this.supportedFileAttributeViews().contains((Object)"acl");
                this.bitmap$0 |= 0x20;
            }
        }
        return this.hasAclFileAttributeView;
    }

    public boolean hasAclFileAttributeView() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.hasAclFileAttributeView$lzycompute();
        }
        return this.hasAclFileAttributeView;
    }

    private boolean hasBasicFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.hasBasicFileAttributeView = this.supportedFileAttributeViews().contains((Object)"basic");
                this.bitmap$0 |= 0x40;
            }
        }
        return this.hasBasicFileAttributeView;
    }

    public boolean hasBasicFileAttributeView() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.hasBasicFileAttributeView$lzycompute();
        }
        return this.hasBasicFileAttributeView;
    }

    private boolean hasUserDefinedFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.hasUserDefinedFileAttributeView = this.supportedFileAttributeViews().contains((Object)"user");
                this.bitmap$0 |= 0x80;
            }
        }
        return this.hasUserDefinedFileAttributeView;
    }

    public boolean hasUserDefinedFileAttributeView() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.hasUserDefinedFileAttributeView$lzycompute();
        }
        return this.hasUserDefinedFileAttributeView;
    }

    private scala.collection.immutable.Set<String> supportedFileAttributeViews$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.supportedFileAttributeViews = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(FileSystems.getDefault().supportedFileAttributeViews()).asScala()).toSet();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.supportedFileAttributeViews;
    }

    private scala.collection.immutable.Set<String> supportedFileAttributeViews() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.supportedFileAttributeViews$lzycompute();
        }
        return this.supportedFileAttributeViews;
    }

    public void setPermissions(File file, String permissions) {
        new RichFile(Path$.MODULE$.apply(file)).setPermissions((scala.collection.immutable.Set<PosixFilePermission>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(PosixFilePermissions.fromString(permissions)).asScala()).toSet());
    }

    public void chmod(String permissions, File file) {
        this.setPermissions(file, permissions);
    }

    public void setOwner(File file, String owner) {
        new RichFile(Path$.MODULE$.apply(file)).setOwner(owner);
    }

    public void chown(String owner, File file) {
        this.setOwner(file, owner);
    }

    public void setGroup(File file, String group) {
        new RichFile(Path$.MODULE$.apply(file)).setGroup(group);
    }

    public void chgrp(String group, File file) {
        this.setGroup(file, group);
    }

    public long getModifiedTime(File file) {
        return Milli$.MODULE$.getModifiedTime(file);
    }

    public void setModifiedTime(File file, long mtime) {
        Milli$.MODULE$.setModifiedTime(file, mtime);
    }

    public void copyModifiedTime(File fromFile, File toFile) {
        Milli$.MODULE$.copyModifiedTime(fromFile, toFile);
    }

    public long getModifiedTimeOrZero(File file) {
        long l;
        while (true) {
            try {
                l = Retry$.MODULE$.apply$mJc$sp((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Milli$.MODULE$.getModifiedTime(file), (Seq<Class<? extends IOException>>)this.excludeFileNotFound());
            }
            catch (FileNotFoundException fileNotFoundException) {
                Path unnormalized = file.toPath();
                Path normalized = unnormalized.normalize().toAbsolutePath();
                Path path = unnormalized;
                Path path2 = normalized;
                if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                    file = normalized.toFile();
                    continue;
                }
                l = 0L;
            }
            break;
        }
        return l;
    }

    public boolean setModifiedTimeOrFalse(File file, long mtime) {
        boolean bl;
        while (true) {
            try {
                Retry$.MODULE$.apply$mVc$sp((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Milli$.MODULE$.setModifiedTime(file, mtime), (Seq<Class<? extends IOException>>)this.excludeFileNotFound());
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Path unnormalized = file.toPath();
                Path normalized = unnormalized.normalize().toAbsolutePath();
                Path path = unnormalized;
                Path path2 = normalized;
                if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                    file = normalized.toFile();
                    continue;
                }
                bl = false;
            }
            break;
        }
        return bl;
    }

    public boolean copyLastModified(File sourceFile, File targetFile) {
        long last = this.getModifiedTimeOrZero(sourceFile);
        return this.setModifiedTimeOrFalse(targetFile, package$.MODULE$.max(last, 0L));
    }

    private scala.collection.immutable.Seq<Class<? extends IOException>> excludeFileNotFound() {
        return this.excludeFileNotFound;
    }

    private static final Option localcl$1(Class cl$3) {
        return Option$.MODULE$.apply((Object)cl$3.getProtectionDomain().getCodeSource()).flatMap((Function1 & Serializable & scala.Serializable)codeSource -> Option$.MODULE$.apply((Object)codeSource.getLocation()));
    }

    private static final Option syscl$1(String clsfile$1) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable & scala.Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$1)));
    }

    private static final Option localcl$2(Class cl$4, String clsfile$2) {
        return Option$.MODULE$.apply((Object)cl$4.getClassLoader()).flatMap((Function1 & Serializable & scala.Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$2)));
    }

    private static final Option syscl$2(String clsfile$2) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable & scala.Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$2)));
    }

    public static final /* synthetic */ String $anonfun$uriToFile$1(URI uri$1) {
        return new StringBuilder(43).append("Expected protocol to be '").append(MODULE$.FileScheme()).append("' or empty in URI ").append(uri$1).toString();
    }

    private static final String failBase$1(File dir$1) {
        return new StringBuilder(27).append("Could not create directory ").append(dir$1).toString();
    }

    public static final /* synthetic */ void $anonfun$gzip$2(File out$1, BufferedInputStream inputStream) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(out$1, (Function1 & Serializable & scala.Serializable)outputStream -> {
            IO$.MODULE$.gzip(inputStream, outputStream);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$gunzip$2(File out$2, BufferedInputStream inputStream) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(out$2, (Function1 & Serializable & scala.Serializable)outputStream -> {
            IO$.MODULE$.gunzip(inputStream, outputStream);
            return BoxedUnit.UNIT;
        });
    }

    private final void next$1(ZipInputStream from$1, NameFilter filter$4, File toDirectory$4, HashSet set$1, boolean preserveLastModified$4) {
        ZipEntry entry;
        while ((entry = from$1.getNextEntry()) != null) {
            Object object;
            String name = entry.getName();
            if (filter$4.accept(name)) {
                Object object2;
                File target = new File(toDirectory$4, name);
                if (entry.isDirectory()) {
                    this.createDirectory(target);
                    object2 = BoxedUnit.UNIT;
                } else {
                    set$1.$plus$eq((Object)target);
                    object2 = ErrorHandling$.MODULE$.translate((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Error extracting zip entry '").append(name).append("' to '").append(target).append("': ").toString(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(target, (Function1 & Serializable & scala.Serializable)out -> {
                        IO$.MODULE$.transfer((InputStream)from$1, (OutputStream)out);
                        return BoxedUnit.UNIT;
                    }));
                }
                object = preserveLastModified$4 ? BoxesRunTime.boxToBoolean((boolean)this.setModifiedTimeOrFalse(target, entry.getTime())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            from$1.closeEntry();
        }
    }

    private final void read$1(InputStream in$2, byte[] buffer$1, OutputStream out$5) {
        int byteCount;
        while ((byteCount = in$2.read(buffer$1)) >= 0) {
            out$5.write(buffer$1, 0, byteCount);
        }
    }

    private final File create$1(int tries, File baseDirectory$1) {
        File file;
        if (tries > this.MaximumTries()) {
            throw scala.sys.package$.MODULE$.error("Could not create temporary directory.");
        }
        String randomName = new StringBuilder(4).append("sbt_").append(Integer.toHexString(this.random().nextInt())).toString();
        File f = new File(baseDirectory$1, randomName);
        try {
            this.createDirectory(f);
            file = f;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                file = this.create$1(tries + 1, baseDirectory$1);
            }
            throw throwable;
        }
        return file;
    }

    private static final boolean visit$1(File f, HashMap isEmpty$1, Set dirs$1) {
        return BoxesRunTime.unboxToBoolean((Object)isEmpty$1.getOrElseUpdate((Object)f, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dirs$1.apply((Object)f) && f.isDirectory() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.listFiles())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IO$.visit$1(f, isEmpty$1, dirs$1)))));
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfEmpty$4(Tuple2 check$ifrefutable$1) {
        boolean bl;
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null && true == (bl = tuple2._2$mcZ$sp());
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfEmpty$5(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            File f = (File)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (bl) {
                return f.delete();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isEmptyDirectory$1(File dir) {
        return dir.isDirectory() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listFiles(dir))).isEmpty();
    }

    private static final scala.collection.immutable.Set parents$1(scala.collection.immutable.Set fs) {
        return (scala.collection.immutable.Set)fs.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)f.getParentFile())), Set$.MODULE$.canBuildFrom());
    }

    private final void deleteEmpty$1(scala.collection.immutable.Set dirs) {
        scala.collection.immutable.Set empty2;
        while ((empty2 = (scala.collection.immutable.Set)dirs.filter((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)this.isEmptyDirectory$1(dir)))).nonEmpty()) {
            empty2.foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.delete()));
            dirs = IO$.parents$1(empty2);
        }
    }

    public static final /* synthetic */ void $anonfun$archive$2(Option manifest$1, Seq sources$1, Option localTime$1, ZipOutputStream output) {
        Function1 & Serializable & scala.Serializable createEntry = manifest$1.isDefined() ? (Function1 & Serializable & scala.Serializable)x$4 -> new JarEntry((String)x$4) : (Function1 & Serializable & scala.Serializable)x$5 -> new ZipEntry((String)x$5);
        MODULE$.writeZip((Seq<Tuple2<File, String>>)sources$1, output, (Option<Object>)localTime$1, (Function1<String, ZipEntry>)createEntry);
    }

    private static final void addDirectoryEntry$1(String name, ZipOutputStream output$2, Function1 createEntry$1, Option time$1, long now$1, long emptyCRC$1) {
        output$2.putNextEntry(IO$.makeDirectoryEntry$1(name, createEntry$1, time$1, now$1, emptyCRC$1));
        output$2.closeEntry();
    }

    private static final ZipEntry makeDirectoryEntry$1(String name, Function1 createEntry$1, Option time$1, long now$1, long emptyCRC$1) {
        ZipEntry e = (ZipEntry)createEntry$1.apply((Object)name);
        e.setTime(BoxesRunTime.unboxToLong((Object)time$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> now$1)));
        e.setSize(0L);
        e.setMethod(0);
        e.setCrc(emptyCRC$1);
        return e;
    }

    private static final ZipEntry makeFileEntry$1(File file, String name, Function1 createEntry$1, Option time$1) {
        ZipEntry e = (ZipEntry)createEntry$1.apply((Object)name);
        e.setTime(BoxesRunTime.unboxToLong((Object)time$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> MODULE$.getModifiedTimeOrZero(file))));
        return e;
    }

    private final void addFileEntry$1(File file, String name, ZipOutputStream output$2, Function1 createEntry$1, Option time$1) {
        output$2.putNextEntry(IO$.makeFileEntry$1(file, name, createEntry$1, time$1));
        this.transfer(file, (OutputStream)output$2);
        output$2.closeEntry();
    }

    public static final /* synthetic */ void $anonfun$writeZip$6(IO$ $this, ZipOutputStream output$2, Function1 createEntry$1, Option time$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            File file = (File)tuple2._1();
            String name = (String)tuple2._2();
            $this.addFileEntry$1(file, name, output$2, createEntry$1, time$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$directoryPaths$1(String x$8) {
        return x$8.length() > 1;
    }

    public static final /* synthetic */ void $anonfun$withZipOutput$1(Option manifest$2, Option time$2, Function1 f$2, BufferedOutputStream fileOut) {
        Tuple2 tuple2;
        Option option = manifest$2;
        if (option instanceof Some) {
            Some some = (Some)option;
            java.util.jar.Manifest mf = (java.util.jar.Manifest)some.value();
            Attributes main = mf.getMainAttributes();
            Object object = !main.containsKey(Attributes.Name.MANIFEST_VERSION) ? main.put(Attributes.Name.MANIFEST_VERSION, "1.0") : BoxedUnit.UNIT;
            JarOutputStream os = new JarOutputStream(fileOut);
            ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
            e.setTime(BoxesRunTime.unboxToLong((Object)time$2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis())));
            os.putNextEntry(e);
            mf.write(new BufferedOutputStream(os));
            os.closeEntry();
            tuple2 = new Tuple2((Object)os, (Object)"jar");
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)new ZipOutputStream(fileOut), (Object)"zip");
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ZipOutputStream zipOut = (ZipOutputStream)tuple22._1();
        try (ZipOutputStream zipOut2 = zipOut;){
            f$2.apply((Object)zipOut2);
        }
    }

    private static final Path toAbsolutePath$1(File x) {
        Path p = x.toPath();
        if (!p.isAbsolute()) {
            return p.toAbsolutePath();
        }
        return p;
    }

    private final long loop$1(long offset, long total$1, FileChannel out$6, FileChannel in$3, long max$1) {
        while (offset < total$1) {
            offset += out$6.transferFrom(in$3, offset, max$1);
        }
        return offset;
    }

    public static final /* synthetic */ void $anonfun$copyFile$4(IO$ $this, FileChannel in$3, File sourceFile$1, File targetFile$1, FileChannel out) {
        long max = 67076096L;
        long total = in$3.size();
        long copied = $this.loop$1(0L, total, out, in$3, max);
        if (copied != in$3.size()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("Could not copy '").append(sourceFile$1).append("' to '").append(targetFile$1).append("' (").append(copied).append("/").append(in$3.size()).append(" bytes copied)").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$copyFile$3(IO$ $this, File targetFile$1, File sourceFile$1, FileChannel in) {
        ((Using)((Object)Using$.MODULE$.fileOutputChannel())).apply(targetFile$1, (Function1 & Serializable & scala.Serializable)out -> {
            IO$.$anonfun$copyFile$4($this, in, sourceFile$1, targetFile$1, out);
            return BoxedUnit.UNIT;
        });
    }

    private final Object readLine$1(Object accum, BufferedReader in$4, Function2 f$4) {
        String line;
        while ((line = in$4.readLine()) != null) {
            accum = f$4.apply(accum, (Object)line);
        }
        return accum;
    }

    public static final /* synthetic */ void $anonfun$writeLines$3(BufferedWriter w$1, String line) {
        w$1.write(line);
        w$1.newLine();
    }

    public static final /* synthetic */ boolean $anonfun$stashLocations$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    private static final String ensureHeadSlash$1(String name) {
        if (new StringOps(Predef$.MODULE$.augmentString(name)).nonEmpty() && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(name)).head()) != File.separatorChar) {
            return new StringBuilder(0).append(File.separatorChar).append(name).toString();
        }
        return name;
    }

    private IO$() {
        MODULE$ = this;
        this.MaximumTries = 10;
        this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.BufferSize = 8192;
        this.FileScheme = "file";
        this.Newline = System.getProperty("line.separator");
        this.utf8 = Charset.forName("UTF-8");
        this.PathSeparatorPattern = Pattern.compile(File.pathSeparator);
        this.isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        this.excludeFileNotFound = new .colon.colon(FileNotFoundException.class, (List)Nil$.MODULE$);
    }
}

