/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepositories;
import com.swoval.files.TypedPath;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.FileEvent$Update$;
import sbt.internal.nio.FileTreeRepository;
import sbt.internal.nio.FileTreeRepositoryImpl$;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import sbt.internal.nio.Observers;
import sbt.internal.nio.RegisterableObservable$;
import sbt.internal.nio.SwovalConverters$;
import sbt.internal.nio.SwovalConverters$RangeOps$;
import sbt.internal.nio.SwovalConverters$SwovalEitherOps$;
import sbt.internal.nio.TimeSource$default$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileAttributes$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!\u0002\u0007\u000e\u0001E\u0019\u0002\"\u0002\u0014\u0001\t\u0003A\u0003BB\u001b\u0001A\u0003%a\u0007\u0003\u0004C\u0001\u0001\u0006Ia\u0011\u0005\u0007\u0019\u0002\u0001\u000b\u0011B'\t\rM\u0003\u0001\u0015!\u0003U\u0011\u0019\u0011\u0007\u0001)A\u0005G\")a\r\u0001C!O\")1\u000f\u0001C!i\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\t\u0003{\u0001\u0001\u0015\"\u0003\u0002@\t1b)\u001b7f)J,WMU3q_NLGo\u001c:z\u00136\u0004HN\u0003\u0002\u000f\u001f\u0005\u0019a.[8\u000b\u0005A\t\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003I\t1a\u001d2u+\t!BfE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007c\u0001\u000f\u001e?5\tQ\"\u0003\u0002\u001f\u001b\t\u0011b)\u001b7f)J,WMU3q_NLGo\u001c:z!\t\u0001C%D\u0001\"\u0015\t\u00113%\u0001\u0003gS2,'B\u0001\b\u0012\u0013\t)\u0013E\u0001\bGS2,\u0017\t\u001e;sS\n,H/Z:\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u000b\t\u00049\u0001Q\u0003CA\u0016-\u0019\u0001!Q!\f\u0001C\u00029\u0012\u0011\u0001V\t\u0003_I\u0002\"A\u0006\u0019\n\u0005E:\"a\u0002(pi\"Lgn\u001a\t\u0003-MJ!\u0001N\f\u0003\u0007\u0005s\u00170\u0001\u0004dY>\u001cX\r\u001a\t\u0003o\u0001k\u0011\u0001\u000f\u0006\u0003si\na!\u0019;p[&\u001c'BA\u001e=\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!9\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006QQO\u001c3fe2L\u0018N\\4\u0011\u0007\u0011[u$D\u0001F\u0015\t1u)A\u0003gS2,7O\u0003\u0002I\u0013\u000611o^8wC2T\u0011AS\u0001\u0004G>l\u0017B\u0001\u0010F\u0003%y'm]3sm\u0016\u00148\u000fE\u0002\u001d\u001dBK!aT\u0007\u0003\u0013=\u00137/\u001a:wKJ\u001c\bc\u0001\u000fR?%\u0011!+\u0004\u0002\n\r&dW-\u0012<f]R\f!B]3hSN$XM]3e!\r)&\fX\u0007\u0002-*\u0011q\u000bW\u0001\b[V$\u0018M\u00197f\u0015\tIv#\u0001\u0006d_2dWm\u0019;j_:L!a\u0017,\u0003\u0007M+G\u000f\u0005\u0002^A6\taL\u0003\u0002#?*\u0011aBP\u0005\u0003Cz\u0013A\u0001U1uQ\u0006)\u0011n]'bGB\u0011a\u0003Z\u0005\u0003K^\u0011qAQ8pY\u0016\fg.A\u0006bI\u0012|%m]3sm\u0016\u0014HC\u00015o!\tIG.D\u0001k\u0015\tYg(\u0001\u0003mC:<\u0017BA7k\u00055\tU\u000f^8DY>\u001cX-\u00192mK\")qn\u0002a\u0001a\u0006AqNY:feZ,'\u000fE\u0002\u001dcBK!A]\u0007\u0003\u0011=\u00137/\u001a:wKJ\fA\u0001\\5tiR\u0019Q/!\u0003\u0011\tYt\u00181\u0001\b\u0003ort!\u0001_>\u000e\u0003eT!A_\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012BA?\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005\r\u0019V-\u001d\u0006\u0003{^\u0001RAFA\u00039~I1!a\u0002\u0018\u0005\u0019!V\u000f\u001d7fe!1\u00111\u0002\u0005A\u0002q\u000bA\u0001]1uQ\u0006A!/Z4jgR,'\u000f\u0006\u0003\u0002\u0012\u0005%\u0002c\u0002<\u0002\u0014\u0005]\u00111E\u0005\u0005\u0003+\t\tA\u0001\u0004FSRDWM\u001d\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004 \u0002\u0005%|\u0017\u0002BA\u0011\u00037\u00111\"S(Fq\u000e,\u0007\u000f^5p]B!A$!\nQ\u0013\r\t9#\u0004\u0002\u000b\u001f\n\u001cXM\u001d<bE2,\u0007bBA\u0016\u0013\u0001\u0007\u0011QF\u0001\u0005O2|'\rE\u0002!\u0003_I1!!\r\"\u0005\u00119En\u001c2\u0002\u000b\rdwn]3\u0015\u0005\u0005]\u0002c\u0001\f\u0002:%\u0019\u00111H\f\u0003\tUs\u0017\u000e^\u0001\u000ei\"\u0014xn^%g\u00072|7/\u001a3\u0015\t\u0005]\u0012\u0011\t\u0005\b\u0003\u0007Z\u0001\u0019AA#\u0003\u0019iW\r\u001e5pIB!\u0011qIA(\u001d\u0011\tI%a\u0013\u0011\u0005a<\u0012bAA'/\u00051\u0001K]3eK\u001aLA!!\u0015\u0002T\t11\u000b\u001e:j]\u001eT1!!\u0014\u0018\u0001")
public class FileTreeRepositoryImpl<T>
implements FileTreeRepository<FileAttributes> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final com.swoval.files.FileTreeRepository<FileAttributes> underlying = FileTreeRepositories.get(typedPath -> FileAttributes$.MODULE$.apply(typedPath.isDirectory(), false, typedPath.isFile(), typedPath.isSymbolicLink()), (boolean)true);
    public final Observers<FileEvent<FileAttributes>> sbt$internal$nio$FileTreeRepositoryImpl$$observers = new Observers();
    private final Set<Path> registered = (Set)JavaConverters$.MODULE$.asScalaSetConverter(ConcurrentHashMap.newKeySet()).asScala();
    private final boolean isMac = Properties$.MODULE$.isMac();

    @Override
    public AutoCloseable addObserver(Observer<FileEvent<FileAttributes>> observer) {
        this.throwIfClosed("addObserver");
        return this.sbt$internal$nio$FileTreeRepositoryImpl$$observers.addObserver(observer);
    }

    @Override
    public Seq<Tuple2<Path, FileAttributes>> list(Path path) {
        this.throwIfClosed("list");
        VectorBuilder res = new VectorBuilder();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(this.underlying.listEntries(path, 0, Filters.AllPass).iterator()).asScala()).foreach((Function1 & Serializable)e -> {
            Right right;
            FileAttributes t;
            TypedPath tp = e.getTypedPath();
            Path path = tp.getPath();
            Either either = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(SwovalConverters$.MODULE$.SwovalEitherOps(e.getValue()), Predef$.MODULE$.$conforms());
            if (either instanceof Right && (t = (FileAttributes)(right = (Right)either).value()) != null) {
                FileAttributes fileAttributes = t;
                return res.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)fileAttributes));
            }
            return BoxedUnit.UNIT;
        });
        return res.result();
    }

    @Override
    public Either<IOException, Observable<FileEvent<FileAttributes>>> register(Glob glob) {
        Path parent;
        this.throwIfClosed("register");
        Path base = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default());
        Object object = this.isMac ? (!this.registered.contains((Object)(parent = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()).getParent())) ? (this.registered.exists((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileTreeRepositoryImpl.$anonfun$register$1(parent, base, path))) ? this.register(Glob$.MODULE$.apply(parent)) : BoxedUnit.UNIT) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        Either either = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(SwovalConverters$.MODULE$.SwovalEitherOps(this.underlying.register(base, SwovalConverters$RangeOps$.MODULE$.toSwovalDepth$extension(SwovalConverters$.MODULE$.RangeOps(Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(glob)))))), Predef$.MODULE$.$conforms());
        if (either instanceof Right) {
            this.registered.add((Object)base);
            return RegisterableObservable$.MODULE$.register$extension(this.sbt$internal$nio$FileTreeRepositoryImpl$$observers, glob);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            IOException ex = (IOException)left.value();
            return new Left((Object)ex);
        }
        throw new MatchError(either);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.underlying.close();
            return;
        }
    }

    private void throwIfClosed(String method) {
        if (this.closed.get()) {
            IllegalStateException ex = new IllegalStateException(new StringBuilder(39).append("Tried to invoke ").append(method).append(" on closed repostitory ").append(this).toString());
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$register$1(Path parent$1, Path base$1, Path path) {
        Path path2 = path.getParent();
        Path path3 = parent$1;
        if (path2 == null) {
            if (path3 != null) {
                return false;
            }
        } else if (!((Object)path2).equals(path3)) return false;
        String leftFileName = ((Object)path.getFileName()).toString();
        String rightFileName = ((Object)base$1.getFileName()).toString();
        String string = leftFileName;
        String string2 = rightFileName;
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        if (leftFileName.startsWith(rightFileName)) return true;
        if (!rightFileName.startsWith(leftFileName)) return false;
        return true;
    }

    public FileTreeRepositoryImpl() {
        this.underlying.addCacheObserver((FileTreeDataViews.CacheObserver)new FileTreeDataViews.CacheObserver<FileAttributes>(this){
            private final /* synthetic */ FileTreeRepositoryImpl $outer;

            public void onCreate(FileTreeDataViews.Entry<FileAttributes> newEntry) {
                Path path = newEntry.getTypedPath().getPath();
                SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(SwovalConverters$.MODULE$.SwovalEitherOps(newEntry.getValue()), Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable)v -> {
                    $anon$1.$anonfun$onCreate$1(this, path, v);
                    return BoxedUnit.UNIT;
                });
            }

            public void onDelete(FileTreeDataViews.Entry<FileAttributes> oldEntry) {
                Path path = oldEntry.getTypedPath().getPath();
                SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(SwovalConverters$.MODULE$.SwovalEitherOps(oldEntry.getValue()), Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable)v -> {
                    $anon$1.$anonfun$onDelete$1(this, path, v);
                    return BoxedUnit.UNIT;
                });
            }

            public void onUpdate(FileTreeDataViews.Entry<FileAttributes> oldEntry, FileTreeDataViews.Entry<FileAttributes> newEntry) {
                block3: {
                    Path path = newEntry.getTypedPath().getPath();
                    Either<L, R0> oldEither = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(SwovalConverters$.MODULE$.SwovalEitherOps(oldEntry.getValue()), Predef$.MODULE$.$conforms());
                    Either<L, R0> newEither = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(SwovalConverters$.MODULE$.SwovalEitherOps(newEntry.getValue()), Predef$.MODULE$.$conforms());
                    Either<L, R0> either = oldEither;
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        FileAttributes o = (FileAttributes)right.value();
                        Either<L, R0> either2 = newEither;
                        if (either2 instanceof Right) {
                            Right right2 = (Right)either2;
                            FileAttributes n = (FileAttributes)right2.value();
                            this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Update$.MODULE$.apply(path, o, n, TimeSource$default$.MODULE$));
                        } else {
                            this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Deletion$.MODULE$.apply(path, o, TimeSource$default$.MODULE$));
                        }
                        return;
                    }
                    Either<L, R0> either3 = newEither;
                    if (!(either3 instanceof Right)) break block3;
                    Right right = (Right)either3;
                    FileAttributes n = (FileAttributes)right.value();
                    this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Creation$.MODULE$.apply(path, n, TimeSource$default$.MODULE$));
                }
            }

            public void onError(IOException exception) {
            }

            public static final /* synthetic */ void $anonfun$onCreate$1($anon$1 $this, Path path$1, FileAttributes v) {
                $this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Creation$.MODULE$.apply(path$1, v, TimeSource$default$.MODULE$));
            }

            public static final /* synthetic */ void $anonfun$onDelete$1($anon$1 $this, Path path$2, FileAttributes v) {
                $this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Deletion$.MODULE$.apply(path$2, v, TimeSource$default$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCreate$1$adapted(sbt.internal.nio.FileTreeRepositoryImpl$$anon$1 java.nio.file.Path sbt.nio.file.FileAttributes ), $anonfun$onDelete$1$adapted(sbt.internal.nio.FileTreeRepositoryImpl$$anon$1 java.nio.file.Path sbt.nio.file.FileAttributes )}, serializedLambda);
            }
        });
    }
}

