/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import java.io.Writer;
import scala.Function0;
import scala.runtime.BoxedUnit;

public final class DeferredWriter
extends Writer {
    private final Function0<Writer> make;
    private boolean opened;
    private Writer delegate0;

    public DeferredWriter(Function0<Writer> make) {
        this.make = make;
        this.opened = false;
    }

    private Writer delegate() {
        Writer writer;
        DeferredWriter deferredWriter = this;
        synchronized (deferredWriter) {
            if (this.delegate0 == null) {
                this.delegate0 = (Writer)this.make.apply();
                this.opened = true;
            }
            writer = this.delegate0;
        }
        return writer;
    }

    @Override
    public void close() {
        DeferredWriter deferredWriter = this;
        synchronized (deferredWriter) {
            BoxedUnit boxedUnit;
            if (this.opened) {
                this.delegate0.close();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public Writer append(char c) {
        return this.delegate().append(c);
    }

    @Override
    public Writer append(CharSequence csq) {
        return this.delegate().append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        return this.delegate().append(csq, start, end);
    }

    @Override
    public void flush() {
        this.delegate().flush();
    }

    @Override
    public void write(char[] cbuf) {
        this.delegate().write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.delegate().write(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        this.delegate().write(c);
    }

    @Override
    public void write(String s) {
        this.delegate().write(s);
    }

    @Override
    public void write(String s, int off, int len) {
        this.delegate().write(s, off, len);
    }
}

