/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import com.swoval.files.RegisterableWatchService;
import com.swoval.files.RegisterableWatchServices;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.io.Unregisterable;
import sbt.io.WatchService;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MacOSXWatchService
implements WatchService,
Unregisterable {
    private final RegisterableWatchService underlying = RegisterableWatchServices.get();
    private final Map<Path, WatchKey> keys = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Collections.synchronizedMap(new ConcurrentHashMap())).asScala();
    private final Map<Path, WatchKey> parentKeys = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Collections.synchronizedMap(new ConcurrentHashMap())).asScala();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public boolean isOpen() {
        return !this.isClosed.get();
    }

    @Override
    public void init() {
    }

    @Override
    public scala.collection.immutable.Map<WatchKey, Seq<WatchEvent<Path>>> pollEvents() {
        Path p;
        WatchKey watchKey = this.underlying.poll();
        if (watchKey == null) {
            return Predef$.MODULE$.Map().empty();
        }
        WatchKey k = watchKey;
        Watchable watchable = k.watchable();
        if (watchable instanceof Path && this.keys.contains((Object)(p = (Path)watchable))) {
            WatchKey watchKey2 = (WatchKey)Predef$.MODULE$.ArrowAssoc((Object)k);
            Tuple2 res = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)watchKey2, (Object)((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(k.pollEvents()).asScala()).view().map((Function1 & Serializable)_$1 -> _$1).toIndexedSeq());
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{res}));
        }
        return null;
    }

    @Override
    public WatchKey poll(Duration timeout) {
        FiniteDuration d;
        Duration duration = timeout;
        FiniteDuration finiteDuration = duration instanceof FiniteDuration ? (d = (FiniteDuration)duration) : new FiniteDuration(Integer.MAX_VALUE, package$.MODULE$.SECONDS());
        Deadline limit = finiteDuration.fromNow();
        return this.impl$1(limit);
    }

    @Override
    public WatchKey register(Path path, Seq<WatchEvent.Kind<Path>> events) {
        if (!this.isClosed.get()) {
            WatchKey k;
            Option option;
            Option option2 = this.keys.get((Object)path);
            if (option2 instanceof Some) {
                WatchKey k2 = (WatchKey)((Some)option2).value();
                return k2;
            }
            Path resolved = this.resolve(path);
            Path parent = path.getParent();
            if (!this.keys.contains((Object)parent) && this.keys.keys().exists((Function1 & Serializable)p -> {
                Path path = p.getParent();
                Path path2 = parent;
                if (path == null) {
                    if (path2 != null) {
                        return false;
                    }
                } else if (!((Object)path).equals(path2)) return false;
                String leftFileName = p.getFileName().toString();
                String rightFileName = path.getFileName().toString();
                String string = leftFileName;
                String string2 = rightFileName;
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                if (leftFileName.startsWith(rightFileName)) return true;
                if (!rightFileName.startsWith(leftFileName)) return false;
                return true;
            })) {
                this.parentKeys.put((Object)parent, (Object)this.underlying.register(parent, (WatchEvent.Kind[])Arrays$.MODULE$.seqToArray(events, WatchEvent.Kind.class)));
            }
            WatchKey key = (option = this.parentKeys.remove((Object)resolved)) instanceof Some ? (k = (WatchKey)((Some)option).value()) : this.underlying.register(resolved, (WatchEvent.Kind[])Arrays$.MODULE$.seqToArray(events, WatchEvent.Kind.class));
            this.keys.put((Object)resolved, (Object)key);
            return key;
        }
        throw new ClosedWatchServiceException();
    }

    @Override
    public void unregister(Path path) {
        this.keys.remove((Object)this.resolve(path)).foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.cancel());
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.keys.values().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.cancel());
            this.keys.clear();
            this.underlying.close();
            return;
        }
    }

    private Path resolve(Path path) {
        Path path2;
        block3: {
            try {
                path2 = path.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                if (path.isAbsolute()) {
                    path2 = path;
                    break block3;
                }
                path2 = path.toAbsolutePath();
            }
        }
        return path2;
    }

    private final WatchKey impl$1(Deadline limit$1) {
        FiniteDuration remaining;
        while ((remaining = limit$1.$minus(Deadline$.MODULE$.now())).$greater((Object)new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds())) {
            Path p;
            WatchKey watchKey = this.underlying.poll(limit$1.$minus(Deadline$.MODULE$.now()).toNanos(), TimeUnit.NANOSECONDS);
            if (watchKey == null) {
                return null;
            }
            WatchKey k = watchKey;
            Watchable watchable = k.watchable();
            if (!(watchable instanceof Path) || !this.keys.contains((Object)(p = (Path)watchable))) continue;
            return k;
        }
        return null;
    }
}

