/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import java.io.File;
import java.io.Serializable;
import sbt.internal.io.Resources$;
import sbt.io.IO$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.Nothing$;

public final class Resources {
    private final File baseDirectory;

    public static Resources apply(String string) {
        return Resources$.MODULE$.apply(string);
    }

    public static Nothing$ error(String string) {
        return Resources$.MODULE$.error(string);
    }

    public Resources(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public File baseDirectory() {
        return this.baseDirectory;
    }

    public File readOnlyResourceDirectory(String group, String name) {
        File groupDirectory = new File(this.baseDirectory(), group);
        if (groupDirectory.isDirectory()) {
            File resourceDirectory = new File(groupDirectory, name);
            if (resourceDirectory.isDirectory()) {
                return resourceDirectory;
            }
            throw Resources$.MODULE$.error(new StringBuilder(44).append("Resource directory '").append(name).append("' in group '").append(group).append("' not found.").toString());
        }
        throw Resources$.MODULE$.error(new StringBuilder(19).append("Group '").append(group).append("' not found.").toString());
    }

    public <T> T readWriteResourceDirectory(String group, String name, Function1<File, T> withDirectory) {
        File file = this.readOnlyResourceDirectory(group, name);
        return this.readWriteResourceDirectory(file, withDirectory);
    }

    public <T> T readWriteResourceDirectory(File readOnly, Function1<File, T> withDirectory) {
        Predef$.MODULE$.require(readOnly.isDirectory());
        return IO$.MODULE$.withTemporaryDirectory((Function1 & Serializable)temporary -> Resources.readWrite$1(withDirectory, readOnly, temporary));
    }

    private static final Object readWrite$1(Function1 withDirectory$1, File readOnly, File temporary) {
        File readWriteDirectory = new File(temporary, readOnly.getName());
        IO$.MODULE$.copyDirectory(readOnly, readWriteDirectory);
        return withDirectory$1.apply((Object)readWriteDirectory);
    }
}

