/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;

public class PollingWatchEvent
implements WatchEvent<Path> {
    private final Path context;
    private final WatchEvent.Kind kind;
    private final int count;

    public PollingWatchEvent(Path context, WatchEvent.Kind<Path> kind) {
        this.context = context;
        this.kind = kind;
        this.count = 1;
    }

    @Override
    public Path context() {
        return this.context;
    }

    @Override
    public WatchEvent.Kind<Path> kind() {
        return this.kind;
    }

    @Override
    public int count() {
        return this.count;
    }

    public String toString() {
        WatchEvent.Kind<Path> kind = this.kind();
        WatchEvent.Kind<Path> kind2 = StandardWatchEventKinds.ENTRY_CREATE;
        WatchEvent.Kind<Path> kind3 = kind;
        if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
            return new StringBuilder(10).append("Creation(").append(this.context()).append(")").toString();
        }
        WatchEvent.Kind<Path> kind4 = StandardWatchEventKinds.ENTRY_DELETE;
        WatchEvent.Kind<Path> kind5 = kind;
        if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
            return new StringBuilder(10).append("Deletion(").append(this.context()).append(")").toString();
        }
        WatchEvent.Kind<Path> kind6 = StandardWatchEventKinds.ENTRY_MODIFY;
        WatchEvent.Kind<Path> kind7 = kind;
        if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
            return new StringBuilder(8).append("Modify(").append(this.context()).append(")").toString();
        }
        return "Overflow";
    }
}

