/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.nio.Deadline;
import sbt.internal.nio.Deadline$;
import sbt.internal.nio.Deadline$Inf$;
import sbt.internal.nio.FileCache;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.FileEvent$Update$;
import sbt.internal.nio.PollingWatchEvent;
import sbt.internal.nio.PollingWatchService$Overflow$;
import sbt.internal.nio.TimeSource;
import sbt.internal.nio.TimeSource$default$;
import sbt.io.IO$;
import sbt.io.Unregisterable;
import sbt.io.WatchService;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.RelativeGlob;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public class PollingWatchService
implements WatchService,
Unregisterable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PollingWatchService.class.getDeclaredField("Overflow$lzy1"));
    public final FiniteDuration sbt$internal$nio$PollingWatchService$$delay;
    private final TimeSource timeSource;
    private final AtomicBoolean closed;
    public final scala.collection.concurrent.Map<Path, PollingWatchKey> sbt$internal$nio$PollingWatchService$$registered;
    public final Function1<Path, Object> sbt$internal$nio$PollingWatchService$$lastModifiedConverter;
    private final Queue<PollingWatchKey> pollQueue;
    public final Random sbt$internal$nio$PollingWatchService$$random;
    private volatile Object Overflow$lzy1;

    public PollingWatchService(FiniteDuration delay, TimeSource timeSource) {
        this.sbt$internal$nio$PollingWatchService$$delay = delay;
        this.timeSource = timeSource;
        this.closed = new AtomicBoolean(false);
        this.sbt$internal$nio$PollingWatchService$$registered = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.sbt$internal$nio$PollingWatchService$$lastModifiedConverter = (Function1 & Serializable)p -> IO$.MODULE$.getModifiedTimeOrZero(p.toFile());
        this.pollQueue = new LinkedBlockingDeque<PollingWatchKey>();
        this.sbt$internal$nio$PollingWatchService$$random = new Random();
    }

    public PollingWatchService(FiniteDuration delay) {
        this(delay, TimeSource$default$.MODULE$);
    }

    public TimeSource sbt$internal$nio$PollingWatchService$$ts() {
        return this.timeSource;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.sbt$internal$nio$PollingWatchService$$registered.clear();
            return;
        }
    }

    @Override
    public void init() {
        this.ensureNotClosed();
    }

    @Override
    public WatchKey poll(Duration timeout) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.ensureNotClosed();
        int numKeys = this.pollQueue.size();
        Duration duration = timeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration t = (FiniteDuration)duration;
            FiniteDuration finiteDuration = (FiniteDuration)Predef$.MODULE$.ArrowAssoc((Object)t);
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)finiteDuration, (Object)Deadline$.MODULE$.now(this.sbt$internal$nio$PollingWatchService$$ts()).$plus(t));
        } else {
            FiniteDuration finiteDuration = (FiniteDuration)Predef$.MODULE$.ArrowAssoc((Object)package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(numKeys), new package.DurationInt(package$.MODULE$.DurationInt(2)).millis()));
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)finiteDuration, (Object)Deadline$Inf$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FiniteDuration adjustedTimeout = (FiniteDuration)tuple2._1();
        Deadline deadline = (Deadline)tuple2._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)adjustedTimeout, (Object)deadline);
        FiniteDuration adjustedTimeout2 = (FiniteDuration)tuple23._1();
        Deadline deadline2 = (Deadline)tuple23._2();
        long millis = adjustedTimeout2.toMillis();
        Tuple2 tuple24 = (Tuple2)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), Integer.MAX_VALUE).dropWhile((Function1)(JFunction1.mcZI.sp & Serializable)i -> millis * (long)i / (long)numKeys == 0L).headOption().fold(PollingWatchService::$anonfun$2, (Function1 & Serializable)i -> PollingWatchService.$anonfun$3(adjustedTimeout2, BoxesRunTime.unboxToInt((Object)i)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        int batchSize = BoxesRunTime.unboxToInt((Object)tuple24._1());
        FiniteDuration batchTimeout = (FiniteDuration)tuple24._2();
        Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)batchSize), (Object)batchTimeout);
        int batchSize2 = BoxesRunTime.unboxToInt((Object)tuple25._1());
        FiniteDuration batchTimeout2 = (FiniteDuration)tuple25._2();
        return (WatchKey)this.pollImpl(batchSize2, batchTimeout2, deadline2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<WatchKey> pollImpl(int batchSize, FiniteDuration duration, Deadline deadline) {
        while (true) {
            Option<WatchKey> option;
            PollingWatchKey pollingWatchKey;
            if ((pollingWatchKey = this.pollQueue.poll()) == null) {
                return None$.MODULE$;
            }
            PollingWatchKey key = pollingWatchKey;
            this.pollQueue.add(key);
            Option<WatchKey> r = option = key.poll();
            if (r.isDefined()) {
                return r;
            }
            if (batchSize > 1) {
                --batchSize;
                continue;
            }
            if (deadline.isOverdue()) break;
            Thread.sleep(duration.toMillis());
        }
        return None$.MODULE$;
    }

    @Override
    public Map<WatchKey, Seq<WatchEvent<Path>>> pollEvents() {
        this.ensureNotClosed();
        return ((IterableOnceOps)this.sbt$internal$nio$PollingWatchService$$registered.values().map((Function1 & Serializable)k -> {
            WatchKey watchKey = (WatchKey)Predef$.MODULE$.ArrowAssoc(k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)watchKey, (Object)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(k.pollEventsImpl()).asScala()).toVector());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public WatchKey register(Path path, Seq<WatchEvent.Kind<Path>> events) {
        this.ensureNotClosed();
        Option option = this.sbt$internal$nio$PollingWatchService$$registered.get((Object)path);
        if (option instanceof Some) {
            PollingWatchKey k = (PollingWatchKey)((Some)option).value();
            return k;
        }
        if (None$.MODULE$.equals(option)) {
            PollingWatchKey newKey = new PollingWatchKey(this, path, events);
            this.sbt$internal$nio$PollingWatchService$$registered.put((Object)path, (Object)newKey);
            this.pollQueue.add(newKey);
            return newKey;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void unregister(Path path) {
        this.ensureNotClosed();
        this.sbt$internal$nio$PollingWatchService$$registered.remove((Object)path);
        this.pollQueue.removeIf(_$1 -> {
            Path path = _$1.path();
            Path path2 = path;
            return !(path != null ? !((Object)path).equals(path2) : path2 != null);
        });
    }

    private void ensureNotClosed() {
        if (this.closed.get()) {
            throw new ClosedWatchServiceException();
        }
    }

    public final PollingWatchService$Overflow$ sbt$internal$nio$PollingWatchService$$Overflow() {
        Object object = this.Overflow$lzy1;
        if (object instanceof PollingWatchService$Overflow$) {
            return (PollingWatchService$Overflow$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (PollingWatchService$Overflow$)this.Overflow$lzyINIT1();
    }

    private Object Overflow$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Overflow$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    PollingWatchService$Overflow$ pollingWatchService$Overflow$ = null;
                    try {
                        pollingWatchService$Overflow$ = new PollingWatchService$Overflow$();
                        object2 = pollingWatchService$Overflow$ == null ? LazyVals.NullValue$.MODULE$ : pollingWatchService$Overflow$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Overflow$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return pollingWatchService$Overflow$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Tuple2 $anonfun$2() {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)new package.DurationInt(package$.MODULE$.DurationInt(1)).millis());
    }

    private static final /* synthetic */ Tuple2 $anonfun$3(FiniteDuration adjustedTimeout$1, int i) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)adjustedTimeout$1.$div((long)i));
    }

    public static final /* synthetic */ PollingWatchEvent sbt$internal$nio$PollingWatchService$PollingWatchKey$$_$pollEventsImpl$$anonfun$1(FileEvent x$1) {
        FileEvent fileEvent = x$1;
        if (fileEvent instanceof FileEvent.Creation) {
            FileEvent.Creation creation = FileEvent$Creation$.MODULE$.unapply((FileEvent.Creation)fileEvent);
            Path path = creation._1();
            long l = BoxesRunTime.unboxToLong(creation._2());
            Path p = path;
            return new PollingWatchEvent(p, StandardWatchEventKinds.ENTRY_CREATE);
        }
        if (fileEvent instanceof FileEvent.Deletion) {
            FileEvent.Deletion deletion = FileEvent$Deletion$.MODULE$.unapply((FileEvent.Deletion)fileEvent);
            Path path = deletion._1();
            long l = BoxesRunTime.unboxToLong(deletion._2());
            Path p = path;
            return new PollingWatchEvent(p, StandardWatchEventKinds.ENTRY_DELETE);
        }
        if (fileEvent instanceof FileEvent.Update) {
            FileEvent.Update update = FileEvent$Update$.MODULE$.unapply((FileEvent.Update)fileEvent);
            Path path = update._1();
            long l = BoxesRunTime.unboxToLong(update._2());
            long l2 = BoxesRunTime.unboxToLong(update._3());
            Path p = path;
            return new PollingWatchEvent(p, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        throw new MatchError((Object)fileEvent);
    }

    public class PollingWatchKey
    implements WatchKey {
        public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(PollingWatchKey.class.getDeclaredField("acceptModify$lzy1"));
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(PollingWatchKey.class.getDeclaredField("acceptDelete$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PollingWatchKey.class.getDeclaredField("acceptCreate$lzy1"));
        private final Path path;
        private final Seq<WatchEvent.Kind<Path>> eventKinds;
        private final ArrayBlockingQueue<FileEvent<Object>> events;
        private final AtomicBoolean hasOverflow;
        private volatile Object acceptCreate$lzy1;
        private volatile Object acceptDelete$lzy1;
        private volatile Object acceptModify$lzy1;
        private final Glob glob;
        private final FileCache<Object> fileCache;
        private final AtomicReference<Deadline> lastPolled;
        private final /* synthetic */ PollingWatchService $outer;

        public PollingWatchKey(PollingWatchService $outer, Path path, Seq<WatchEvent.Kind<Path>> eventKinds) {
            this.path = path;
            this.eventKinds = eventKinds;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.events = new ArrayBlockingQueue(256);
            this.hasOverflow = new AtomicBoolean(false);
            this.glob = Glob$.MODULE$.apply(path, (RelativeGlob)AnyPath$.MODULE$);
            this.fileCache = new FileCache<Object>($outer.sbt$internal$nio$PollingWatchService$$lastModifiedConverter);
            this.fileCache.register(this.glob);
            this.lastPolled = new AtomicReference<Deadline>(this.nextPollTime());
        }

        public Path path() {
            return this.path;
        }

        private boolean acceptCreate() {
            Object object = this.acceptCreate$lzy1;
            if (object instanceof Boolean) {
                return BoxesRunTime.unboxToBoolean((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToBoolean(null);
            }
            return BoxesRunTime.unboxToBoolean((Object)this.acceptCreate$lzyINIT1());
        }

        private Object acceptCreate$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.acceptCreate$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Boolean bl = null;
                        try {
                            bl = BoxesRunTime.boxToBoolean((boolean)this.eventKinds.contains(StandardWatchEventKinds.ENTRY_CREATE));
                            object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.acceptCreate$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return bl;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private boolean acceptDelete() {
            Object object = this.acceptDelete$lzy1;
            if (object instanceof Boolean) {
                return BoxesRunTime.unboxToBoolean((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToBoolean(null);
            }
            return BoxesRunTime.unboxToBoolean((Object)this.acceptDelete$lzyINIT1());
        }

        private Object acceptDelete$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.acceptDelete$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Boolean bl = null;
                        try {
                            bl = BoxesRunTime.boxToBoolean((boolean)this.eventKinds.contains(StandardWatchEventKinds.ENTRY_DELETE));
                            object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.acceptDelete$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return bl;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private boolean acceptModify() {
            Object object = this.acceptModify$lzy1;
            if (object instanceof Boolean) {
                return BoxesRunTime.unboxToBoolean((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToBoolean(null);
            }
            return BoxesRunTime.unboxToBoolean((Object)this.acceptModify$lzyINIT1());
        }

        private Object acceptModify$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.acceptModify$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Boolean bl = null;
                        try {
                            bl = BoxesRunTime.boxToBoolean((boolean)this.eventKinds.contains(StandardWatchEventKinds.ENTRY_MODIFY));
                            object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.acceptModify$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return bl;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private Deadline nextPollTime() {
            return Deadline$.MODULE$.now(this.$outer.sbt$internal$nio$PollingWatchService$$ts()).$plus(new package.DurationInt(package$.MODULE$.DurationInt(this.$outer.sbt$internal$nio$PollingWatchService$$random.nextInt(2 * (int)this.$outer.sbt$internal$nio$PollingWatchService$$delay.toMillis()))).millis());
        }

        @Override
        public void cancel() {
            this.reset();
            this.$outer.sbt$internal$nio$PollingWatchService$$registered.remove((Object)this.path());
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public List<WatchEvent<?>> pollEvents() {
            return this.pollEventsImpl();
        }

        @Override
        public boolean reset() {
            boolean bl;
            ArrayBlockingQueue<FileEvent<Object>> arrayBlockingQueue = this.events;
            synchronized (arrayBlockingQueue) {
                this.events.clear();
                bl = true;
            }
            return bl;
        }

        @Override
        public Watchable watchable() {
            return this.path();
        }

        public Option<WatchKey> poll() {
            Deadline deadline = this.lastPolled.get();
            Deadline d = deadline;
            if (d.$less(Deadline$.MODULE$.now(this.$outer.sbt$internal$nio$PollingWatchService$$ts()))) {
                Seq<FileEvent<Object>> res = this.fileCache.refresh(this.glob);
                this.lastPolled.set(Deadline$.MODULE$.now(this.$outer.sbt$internal$nio$PollingWatchService$$ts()));
                res.foreach((Function1 & Serializable)event -> this.maybeAddEvent((FileEvent<Object>)event));
                if (this.events.isEmpty()) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply((Object)this);
            }
            return None$.MODULE$;
        }

        public List<WatchEvent<Path>> pollEventsImpl() {
            ArrayList<WatchEvent<Path>> arrayList;
            ArrayBlockingQueue<FileEvent<Object>> arrayBlockingQueue = this.events;
            synchronized (arrayBlockingQueue) {
                boolean overflow = this.hasOverflow.getAndSet(false);
                int size = this.events.size() + (overflow ? 1 : 0);
                ArrayList rawEvents = new ArrayList(size);
                this.events.drainTo(rawEvents);
                ArrayList<WatchEvent<Path>> res = new ArrayList<WatchEvent<Path>>(size);
                res.addAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(rawEvents).asScala()).map(PollingWatchService::sbt$internal$nio$PollingWatchService$PollingWatchKey$$_$pollEventsImpl$$anonfun$1)).asJava());
                if (overflow) {
                    res.add(this.$outer.sbt$internal$nio$PollingWatchService$$Overflow());
                }
                arrayList = res;
            }
            return arrayList;
        }

        public Option<PollingWatchKey> maybeAddEvent(FileEvent<Object> event) {
            FileEvent<Object> fileEvent = event;
            if (fileEvent instanceof FileEvent.Creation && this.acceptCreate()) {
                return this.offer$1(event);
            }
            if (fileEvent instanceof FileEvent.Deletion && this.acceptDelete()) {
                return this.offer$1(event);
            }
            if (fileEvent instanceof FileEvent.Update && this.acceptModify()) {
                return this.offer$1(event);
            }
            return None$.MODULE$;
        }

        public final /* synthetic */ PollingWatchService sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer() {
            return this.$outer;
        }

        private final Option offer$1(FileEvent event) {
            boolean bl;
            ArrayBlockingQueue<FileEvent<Object>> arrayBlockingQueue = this.events;
            synchronized (arrayBlockingQueue) {
                bl = this.events.offer(event);
            }
            if (!bl) {
                this.hasOverflow.set(true);
            }
            return Some$.MODULE$.apply((Object)this);
        }
    }
}

