/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Vector;
import scala.runtime.Arrays$;

public interface RichNioPath {
    public Path asPath();

    public Vector<LinkOption> linkOptions();

    public static scala.collection.immutable.Set permissions$(RichNioPath $this) {
        return $this.permissions();
    }

    default public scala.collection.immutable.Set<PosixFilePermission> permissions() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(Files.getPosixFilePermissions(this.asPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(this.linkOptions(), LinkOption.class))).asScala()).toSet();
    }

    public static String permissionsAsString$(RichNioPath $this) {
        return $this.permissionsAsString();
    }

    default public String permissionsAsString() {
        return PosixFilePermissions.toString((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.permissions()).asJava());
    }

    public static void setPermissions$(RichNioPath $this, scala.collection.immutable.Set permissions) {
        $this.setPermissions((scala.collection.immutable.Set<PosixFilePermission>)permissions);
    }

    default public void setPermissions(scala.collection.immutable.Set<PosixFilePermission> permissions) {
        Files.setPosixFilePermissions(this.asPath(), (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(permissions).asJava());
    }

    public static void addPermission$(RichNioPath $this, PosixFilePermission permission) {
        $this.addPermission(permission);
    }

    default public void addPermission(PosixFilePermission permission) {
        this.setPermissions((scala.collection.immutable.Set<PosixFilePermission>)((scala.collection.immutable.Set)this.permissions().$plus((Object)permission)));
    }

    public static void removePermission$(RichNioPath $this, PosixFilePermission permission) {
        $this.removePermission(permission);
    }

    default public void removePermission(PosixFilePermission permission) {
        this.setPermissions((scala.collection.immutable.Set<PosixFilePermission>)((scala.collection.immutable.Set)this.permissions().$minus((Object)permission)));
    }

    public static boolean testPermission$(RichNioPath $this, PosixFilePermission permission) {
        return $this.testPermission(permission);
    }

    default public boolean testPermission(PosixFilePermission permission) {
        return this.permissions().apply((Object)permission);
    }

    public static boolean isOwnerReadable$(RichNioPath $this) {
        return $this.isOwnerReadable();
    }

    default public boolean isOwnerReadable() {
        return this.testPermission(PosixFilePermission.OWNER_READ);
    }

    public static boolean isOwnerWritable$(RichNioPath $this) {
        return $this.isOwnerWritable();
    }

    default public boolean isOwnerWritable() {
        return this.testPermission(PosixFilePermission.OWNER_WRITE);
    }

    public static boolean isOwnerExecutable$(RichNioPath $this) {
        return $this.isOwnerExecutable();
    }

    default public boolean isOwnerExecutable() {
        return this.testPermission(PosixFilePermission.OWNER_EXECUTE);
    }

    public static boolean isGroupReadable$(RichNioPath $this) {
        return $this.isGroupReadable();
    }

    default public boolean isGroupReadable() {
        return this.testPermission(PosixFilePermission.GROUP_READ);
    }

    public static boolean isGroupWritable$(RichNioPath $this) {
        return $this.isGroupWritable();
    }

    default public boolean isGroupWritable() {
        return this.testPermission(PosixFilePermission.GROUP_WRITE);
    }

    public static boolean isGroupExecutable$(RichNioPath $this) {
        return $this.isGroupExecutable();
    }

    default public boolean isGroupExecutable() {
        return this.testPermission(PosixFilePermission.GROUP_EXECUTE);
    }

    public static boolean isOthersReadable$(RichNioPath $this) {
        return $this.isOthersReadable();
    }

    default public boolean isOthersReadable() {
        return this.testPermission(PosixFilePermission.OTHERS_READ);
    }

    public static boolean isOthersWritable$(RichNioPath $this) {
        return $this.isOthersWritable();
    }

    default public boolean isOthersWritable() {
        return this.testPermission(PosixFilePermission.OTHERS_WRITE);
    }

    public static boolean isOthersExecutable$(RichNioPath $this) {
        return $this.isOthersExecutable();
    }

    default public boolean isOthersExecutable() {
        return this.testPermission(PosixFilePermission.OTHERS_EXECUTE);
    }

    public static BasicFileAttributes attributes$(RichNioPath $this) {
        return $this.attributes();
    }

    default public BasicFileAttributes attributes() {
        return Files.readAttributes(this.asPath(), BasicFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray(this.linkOptions(), LinkOption.class));
    }

    public static PosixFileAttributes posixAttributes$(RichNioPath $this) {
        return $this.posixAttributes();
    }

    default public PosixFileAttributes posixAttributes() {
        return Files.readAttributes(this.asPath(), PosixFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray(this.linkOptions(), LinkOption.class));
    }

    public static DosFileAttributes dosAttributes$(RichNioPath $this) {
        return $this.dosAttributes();
    }

    default public DosFileAttributes dosAttributes() {
        return Files.readAttributes(this.asPath(), DosFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray(this.linkOptions(), LinkOption.class));
    }

    public static AclFileAttributeView aclFileAttributeView$(RichNioPath $this) {
        return $this.aclFileAttributeView();
    }

    default public AclFileAttributeView aclFileAttributeView() {
        return Files.getFileAttributeView(this.asPath(), AclFileAttributeView.class, (LinkOption[])Arrays$.MODULE$.seqToArray(this.linkOptions(), LinkOption.class));
    }

    public static UserPrincipal owner$(RichNioPath $this) {
        return $this.owner();
    }

    default public UserPrincipal owner() {
        return Files.getOwner(this.asPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(this.linkOptions(), LinkOption.class));
    }

    public static String ownerName$(RichNioPath $this) {
        return $this.ownerName();
    }

    default public String ownerName() {
        return this.owner().getName();
    }

    public static GroupPrincipal group$(RichNioPath $this) {
        return $this.group();
    }

    default public GroupPrincipal group() {
        return this.posixAttributes().group();
    }

    public static String groupName$(RichNioPath $this) {
        return $this.groupName();
    }

    default public String groupName() {
        return this.group().getName();
    }

    public static void setOwner$(RichNioPath $this, String owner) {
        $this.setOwner(owner);
    }

    default public void setOwner(String owner) {
        FileSystem fileSystem = this.asPath().getFileSystem();
        Files.setOwner(this.asPath(), fileSystem.getUserPrincipalLookupService().lookupPrincipalByName(owner));
    }

    public static void setGroup$(RichNioPath $this, String group) {
        $this.setGroup(group);
    }

    default public void setGroup(String group) {
        FileSystem fileSystem = this.asPath().getFileSystem();
        Files.setOwner(this.asPath(), fileSystem.getUserPrincipalLookupService().lookupPrincipalByGroupName(group));
    }
}

