/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.TimeUnit;
import sbt.io.Unregisterable;
import sbt.io.WatchService$;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface WatchService {
    public static WatchServiceAdapter WatchServiceAdapter(java.nio.file.WatchService watchService) {
        return WatchService$.MODULE$.WatchServiceAdapter(watchService);
    }

    public static WatchService default() {
        return WatchService$.MODULE$.default();
    }

    public static WatchService polling(FiniteDuration finiteDuration) {
        return WatchService$.MODULE$.polling(finiteDuration);
    }

    public void init();

    public Map<WatchKey, Seq<WatchEvent<Path>>> pollEvents();

    public WatchKey poll(Duration var1);

    public WatchKey register(Path var1, Seq<WatchEvent.Kind<Path>> var2);

    public void close();

    public static final class WatchServiceAdapter
    implements WatchService,
    Unregisterable {
        private final java.nio.file.WatchService service;
        private boolean closed;
        private final scala.collection.mutable.Map<Path, WatchKey> registered;

        public WatchServiceAdapter(java.nio.file.WatchService service) {
            this.service = service;
            this.closed = false;
            this.registered = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        }

        @Override
        public void init() {
        }

        @Override
        public Map<WatchKey, Seq<WatchEvent<Path>>> pollEvents() {
            IndexedSeq indexedSeq;
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered;
            synchronized (map) {
                indexedSeq = this.registered.values().toIndexedSeq();
            }
            IndexedSeq values = indexedSeq;
            return ((IterableOnceOps)values.flatMap(WatchService$::sbt$io$WatchService$WatchServiceAdapter$$_$pollEvents$$anonfun$1)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        @Override
        public WatchKey poll(Duration timeout) {
            WatchKey watchKey;
            do {
                if (!timeout.isFinite()) continue;
                return this.service.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
            } while ((watchKey = this.service.poll(1000L, TimeUnit.MILLISECONDS)) == null);
            WatchKey key = watchKey;
            return key;
        }

        @Override
        public WatchKey register(Path path, Seq<WatchEvent.Kind<Path>> events) {
            WatchKey watchKey;
            if (this.closed) {
                throw new ClosedWatchServiceException();
            }
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered;
            synchronized (map) {
                WatchKey watchKey2;
                Option option = this.registered.get((Object)path);
                if (None$.MODULE$.equals(option)) {
                    WatchKey key = path.register(this.service, (WatchEvent.Kind[])Arrays$.MODULE$.seqToArray(events, WatchEvent.Kind.class));
                    Path path2 = (Path)Predef$.MODULE$.ArrowAssoc((Object)path);
                    this.registered.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path2, (Object)key));
                    watchKey2 = key;
                } else if (option instanceof Some) {
                    WatchKey key;
                    watchKey2 = key = (WatchKey)((Some)option).value();
                } else {
                    throw new MatchError((Object)option);
                }
                watchKey = watchKey2;
            }
            return watchKey;
        }

        @Override
        public void unregister(Path path) {
            if (this.closed) {
                throw new ClosedWatchServiceException();
            }
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered;
            synchronized (map) {
                BoxedUnit boxedUnit;
                Option option = this.registered.get((Object)path);
                if (option instanceof Some) {
                    WatchKey key = (WatchKey)((Some)option).value();
                    key.cancel();
                    boxedUnit = this.registered.$minus$eq((Object)path);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.service.close();
        }

        public String toString() {
            return this.service.toString();
        }
    }
}

