/*
 * Decompiled with CFR 0.152.
 */
package sbt.nio.file;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.io.FileFilter;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$FileOps$;
import sbt.nio.file.Glob$FullFileGlob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$PathFilterOps$;
import sbt.nio.file.Glob$PathOps$;
import sbt.nio.file.Glob$Pattern$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import sbt.nio.file.Glob$Root$;
import sbt.nio.file.PathFilter;
import sbt.nio.file.RelativeGlob;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public interface Glob {
    public static Glob GlobOps(Glob glob) {
        return Glob$.MODULE$.GlobOps(glob);
    }

    public static Glob PathFilterOps(Glob glob) {
        return Glob$.MODULE$.PathFilterOps(glob);
    }

    public static Glob apply(File file) {
        return Glob$.MODULE$.apply(file);
    }

    public static Glob apply(File file, Regex regex) {
        return Glob$.MODULE$.apply(file, regex);
    }

    public static Glob apply(File file, RelativeGlob relativeGlob) {
        return Glob$.MODULE$.apply(file, relativeGlob);
    }

    public static Glob apply(File file, String string) {
        return Glob$.MODULE$.apply(file, string);
    }

    public static Glob apply(Path path) {
        return Glob$.MODULE$.apply(path);
    }

    public static Glob apply(Path path, Regex regex) {
        return Glob$.MODULE$.apply(path, regex);
    }

    public static Glob apply(Path path, RelativeGlob relativeGlob) {
        return Glob$.MODULE$.apply(path, relativeGlob);
    }

    public static Glob apply(Path path, String string) {
        return Glob$.MODULE$.apply(path, string);
    }

    public static Glob apply(String string) {
        return Glob$.MODULE$.apply(string);
    }

    public static Glob apply(String string, boolean bl) {
        return Glob$.MODULE$.apply(string, bl);
    }

    public static Function1<String, Object> hasMeta() {
        return Glob$.MODULE$.hasMeta();
    }

    public static boolean isWin() {
        return Glob$.MODULE$.isWin();
    }

    public static Glob stringToGlob(String string) {
        return Glob$.MODULE$.stringToGlob(string);
    }

    public boolean matches(Path var1);

    public static final class FileOps {
        private final File file;

        public static boolean equals$extension(File file, Object object) {
            return Glob$FileOps$.MODULE$.equals$extension(file, object);
        }

        public static int hashCode$extension(File file) {
            return Glob$FileOps$.MODULE$.hashCode$extension(file);
        }

        public static Glob toGlob$extension(File file) {
            return Glob$FileOps$.MODULE$.toGlob$extension(file);
        }

        public FileOps(File file) {
            this.file = file;
        }

        public int hashCode() {
            return Glob$FileOps$.MODULE$.hashCode$extension(this.file());
        }

        public boolean equals(Object x$0) {
            return Glob$FileOps$.MODULE$.equals$extension(this.file(), x$0);
        }

        public File file() {
            return this.file;
        }

        public Glob toGlob() {
            return Glob$FileOps$.MODULE$.toGlob$extension(this.file());
        }
    }

    public static final class FullFileGlob
    implements Glob,
    Product,
    Serializable {
        private final Path base;
        private final boolean recursive;
        private final FileFilter filter;

        public static FullFileGlob apply(Path path, boolean bl, FileFilter fileFilter) {
            return Glob$FullFileGlob$.MODULE$.apply(path, bl, fileFilter);
        }

        public static FullFileGlob fromProduct(Product product) {
            return Glob$FullFileGlob$.MODULE$.fromProduct(product);
        }

        public static FullFileGlob unapply(FullFileGlob fullFileGlob) {
            return Glob$FullFileGlob$.MODULE$.unapply(fullFileGlob);
        }

        public FullFileGlob(Path base, boolean recursive, FileFilter filter) {
            this.base = base;
            this.recursive = recursive;
            this.filter = filter;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.base()));
            n = Statics.mix((int)n, (int)(this.recursive() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.filter()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FullFileGlob)) return false;
            FullFileGlob fullFileGlob = (FullFileGlob)object;
            if (this.recursive() != fullFileGlob.recursive()) return false;
            Path path = this.base();
            Path path2 = fullFileGlob.base();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            FileFilter fileFilter = this.filter();
            FileFilter fileFilter2 = fullFileGlob.filter();
            if (fileFilter == null) {
                if (fileFilter2 == null) return true;
                return false;
            } else {
                if (!fileFilter.equals(fileFilter2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FullFileGlob;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "FullFileGlob";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "base";
                }
                case 1: {
                    return "recursive";
                }
                case 2: {
                    return "filter";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path base() {
            return this.base;
        }

        public boolean recursive() {
            return this.recursive;
        }

        public FileFilter filter() {
            return this.filter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(Path path) {
            if (!path.startsWith(this.base())) return false;
            if (this.recursive()) {
                if (this.filter().accept(path.toFile())) return true;
                return false;
            }
            Path path2 = path.getParent();
            Path path3 = this.base();
            if (path2 == null) {
                if (path3 != null) {
                    return false;
                }
            } else if (!((Object)path2).equals(path3)) return false;
            if (!this.filter().accept(path.toFile())) return false;
            return true;
        }

        public FullFileGlob copy(Path base, boolean recursive, FileFilter filter) {
            return new FullFileGlob(base, recursive, filter);
        }

        public Path copy$default$1() {
            return this.base();
        }

        public boolean copy$default$2() {
            return this.recursive();
        }

        public FileFilter copy$default$3() {
            return this.filter();
        }

        public Path _1() {
            return this.base();
        }

        public boolean _2() {
            return this.recursive();
        }

        public FileFilter _3() {
            return this.filter();
        }
    }

    public static final class GlobOps {
        private final Glob glob;

        public static Glob $div$extension(Glob glob, Regex regex) {
            return Glob$GlobOps$.MODULE$.$div$extension(glob, regex);
        }

        public static Glob $div$extension(Glob glob, RelativeGlob relativeGlob) {
            return Glob$GlobOps$.MODULE$.$div$extension(glob, relativeGlob);
        }

        public static Glob $div$extension(Glob glob, String string) {
            return Glob$GlobOps$.MODULE$.$div$extension(glob, string);
        }

        public static Path base$extension(Glob glob, RelativeGlobViewOption relativeGlobViewOption) {
            return Glob$GlobOps$.MODULE$.base$extension(glob, relativeGlobViewOption);
        }

        public static boolean descendentMatches$extension(Glob glob, Path path) {
            return Glob$GlobOps$.MODULE$.descendentMatches$extension(glob, path);
        }

        public static boolean equals$extension(Glob glob, Object object) {
            return Glob$GlobOps$.MODULE$.equals$extension(glob, object);
        }

        public static Tuple3<Path, Object, Glob> fileTreeViewListParameters$extension(Glob glob, RelativeGlobViewOption relativeGlobViewOption) {
            return Glob$GlobOps$.MODULE$.fileTreeViewListParameters$extension(glob, relativeGlobViewOption);
        }

        public static int hashCode$extension(Glob glob) {
            return Glob$GlobOps$.MODULE$.hashCode$extension(glob);
        }

        public static Tuple2<Object, Object> range$extension(Glob glob) {
            return Glob$GlobOps$.MODULE$.range$extension(glob);
        }

        public static Path toAbsolutePath$extension(Glob glob, Path path, RelativeGlobViewOption relativeGlobViewOption) {
            return Glob$GlobOps$.MODULE$.toAbsolutePath$extension(glob, path, relativeGlobViewOption);
        }

        public static FileFilter toFileFilter$extension(Glob glob) {
            return Glob$GlobOps$.MODULE$.toFileFilter$extension(glob);
        }

        public GlobOps(Glob glob) {
            this.glob = glob;
        }

        public int hashCode() {
            return Glob$GlobOps$.MODULE$.hashCode$extension(this.glob());
        }

        public boolean equals(Object x$0) {
            return Glob$GlobOps$.MODULE$.equals$extension(this.glob(), x$0);
        }

        public Glob glob() {
            return this.glob;
        }

        public boolean descendentMatches(Path path) {
            return Glob$GlobOps$.MODULE$.descendentMatches$extension(this.glob(), path);
        }

        public FileFilter toFileFilter() {
            return Glob$GlobOps$.MODULE$.toFileFilter$extension(this.glob());
        }

        public Path toAbsolutePath(Path path, RelativeGlobViewOption option) {
            return Glob$GlobOps$.MODULE$.toAbsolutePath$extension(this.glob(), path, option);
        }

        public Tuple3<Path, Object, Glob> fileTreeViewListParameters(RelativeGlobViewOption option) {
            return Glob$GlobOps$.MODULE$.fileTreeViewListParameters$extension(this.glob(), option);
        }

        public Path base(RelativeGlobViewOption option) {
            return Glob$GlobOps$.MODULE$.base$extension(this.glob(), option);
        }

        public Tuple2<Object, Object> range() {
            return Glob$GlobOps$.MODULE$.range$extension(this.glob());
        }

        public Glob $div(String relativeGlob) {
            return Glob$GlobOps$.MODULE$.$div$extension(this.glob(), relativeGlob);
        }

        public Glob $div(Regex regex) {
            return Glob$GlobOps$.MODULE$.$div$extension(this.glob(), regex);
        }

        public Glob $div(RelativeGlob relativeGlob) {
            return Glob$GlobOps$.MODULE$.$div$extension(this.glob(), relativeGlob);
        }
    }

    public static final class PathFilterOps
    implements PathFilter.PathFilterExtensions {
        private final Glob glob;

        public static PathFilter $amp$amp$extension(Glob glob, PathFilter pathFilter) {
            return Glob$PathFilterOps$.MODULE$.$amp$amp$extension(glob, pathFilter);
        }

        public static boolean equals$extension(Glob glob, Object object) {
            return Glob$PathFilterOps$.MODULE$.equals$extension(glob, object);
        }

        public static int hashCode$extension(Glob glob) {
            return Glob$PathFilterOps$.MODULE$.hashCode$extension(glob);
        }

        public static PathFilter unary_$bang$extension(Glob glob) {
            return Glob$PathFilterOps$.MODULE$.unary_$bang$extension(glob);
        }

        public static PathFilter $bar$bar$extension(Glob glob, PathFilter pathFilter) {
            return Glob$PathFilterOps$.MODULE$.$bar$bar$extension(glob, pathFilter);
        }

        public PathFilterOps(Glob glob) {
            this.glob = glob;
        }

        public int hashCode() {
            return Glob$PathFilterOps$.MODULE$.hashCode$extension(this.glob());
        }

        public boolean equals(Object x$0) {
            return Glob$PathFilterOps$.MODULE$.equals$extension(this.glob(), x$0);
        }

        public Glob glob() {
            return this.glob;
        }

        @Override
        public PathFilter $amp$amp(PathFilter other) {
            return Glob$PathFilterOps$.MODULE$.$amp$amp$extension(this.glob(), other);
        }

        @Override
        public PathFilter $bar$bar(PathFilter other) {
            return Glob$PathFilterOps$.MODULE$.$bar$bar$extension(this.glob(), other);
        }

        @Override
        public PathFilter unary_$bang() {
            return Glob$PathFilterOps$.MODULE$.unary_$bang$extension(this.glob());
        }
    }

    public static final class PathOps {
        private final Path path;

        public static Path $div$extension(Path path, String string) {
            return Glob$PathOps$.MODULE$.$div$extension(path, string);
        }

        public static boolean equals$extension(Path path, Object object) {
            return Glob$PathOps$.MODULE$.equals$extension(path, object);
        }

        public static int hashCode$extension(Path path) {
            return Glob$PathOps$.MODULE$.hashCode$extension(path);
        }

        public static Glob toGlob$extension(Path path) {
            return Glob$PathOps$.MODULE$.toGlob$extension(path);
        }

        public PathOps(Path path) {
            this.path = path;
        }

        public int hashCode() {
            return Glob$PathOps$.MODULE$.hashCode$extension(this.path());
        }

        public boolean equals(Object x$0) {
            return Glob$PathOps$.MODULE$.equals$extension(this.path(), x$0);
        }

        public Path path() {
            return this.path;
        }

        public Glob toGlob() {
            return Glob$PathOps$.MODULE$.toGlob$extension(this.path());
        }

        public Path $div(String component) {
            return Glob$PathOps$.MODULE$.$div$extension(this.path(), component);
        }
    }

    public static final class Pattern
    implements Glob,
    Product,
    Serializable {
        private final Path root;
        private final RelativeGlob relative;

        public static Pattern apply(Path path, RelativeGlob relativeGlob) {
            return Glob$Pattern$.MODULE$.apply(path, relativeGlob);
        }

        public static Pattern fromProduct(Product product) {
            return Glob$Pattern$.MODULE$.fromProduct(product);
        }

        public static Ordering<Pattern> ordering() {
            return Glob$Pattern$.MODULE$.ordering();
        }

        public static Pattern unapply(Pattern pattern) {
            return Glob$Pattern$.MODULE$.unapply(pattern);
        }

        public Pattern(Path root, RelativeGlob relative) {
            this.root = root;
            this.relative = relative;
        }

        public boolean canEqual(Object that) {
            return that instanceof Pattern;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Pattern";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "root";
            }
            if (1 == n2) {
                return "relative";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path root() {
            return this.root;
        }

        public RelativeGlob relative() {
            return this.relative;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(Path path) {
            if (!path.startsWith(this.root())) return false;
            Path path2 = path;
            Path path3 = this.root();
            if (path2 == null) {
                if (path3 == null) return false;
            } else if (((Object)path2).equals(path3)) return false;
            if (!this.relative().matches(this.root().relativize(path))) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            Object object = o;
            if (!(object instanceof Pattern)) return false;
            Pattern that = (Pattern)object;
            Path path = this.root();
            Path path2 = that.root();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            RelativeGlob relativeGlob = this.relative();
            RelativeGlob relativeGlob2 = that.relative();
            if (relativeGlob == null) {
                if (relativeGlob2 == null) return true;
                return false;
            } else {
                if (!relativeGlob.equals(relativeGlob2)) return false;
                return true;
            }
        }

        public int hashCode() {
            return this.root().hashCode() * 31 ^ this.relative().hashCode();
        }

        public String toString() {
            return new StringBuilder(0).append(this.root()).append(File.separatorChar).append(this.relative()).toString();
        }

        public Pattern copy(Path root, RelativeGlob relative) {
            return new Pattern(root, relative);
        }

        public Path copy$default$1() {
            return this.root();
        }

        public RelativeGlob copy$default$2() {
            return this.relative();
        }

        public Path _1() {
            return this.root();
        }

        public RelativeGlob _2() {
            return this.relative();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface RelativeGlobViewOption {
        public static RelativeGlobViewOption default() {
            return Glob$RelativeGlobViewOption$.MODULE$.default();
        }

        public static int ordinal(RelativeGlobViewOption relativeGlobViewOption) {
            return Glob$RelativeGlobViewOption$.MODULE$.ordinal(relativeGlobViewOption);
        }

        public static String propName() {
            return Glob$RelativeGlobViewOption$.MODULE$.propName();
        }
    }

    public static final class Root
    implements Glob,
    Product,
    Serializable {
        private final Path root;

        public static Root apply(Path path) {
            return Glob$Root$.MODULE$.apply(path);
        }

        public static Root fromProduct(Product product) {
            return Glob$Root$.MODULE$.fromProduct(product);
        }

        public static Ordering<Root> ordering() {
            return Glob$Root$.MODULE$.ordering();
        }

        public static Root unapply(Root root) {
            return Glob$Root$.MODULE$.unapply(root);
        }

        public Root(Path root) {
            this.root = root;
            Predef$.MODULE$.require(root.isAbsolute(), () -> this.$init$$$anonfun$4(root));
        }

        public boolean canEqual(Object that) {
            return that instanceof Root;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Root";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "root";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path root() {
            return this.root;
        }

        @Override
        public boolean matches(Path path) {
            Path path2 = this.root();
            Path path3 = path;
            return !(path2 != null ? !((Object)path2).equals(path3) : path3 != null);
        }

        public String toString() {
            return this.root().toString();
        }

        public boolean equals(Object o) {
            Object object = o;
            if (object instanceof Root) {
                Root that = (Root)object;
                Path path = this.root();
                Path path2 = that.root();
                return !(path != null ? !((Object)path).equals(path2) : path2 != null);
            }
            return false;
        }

        public int hashCode() {
            return this.root().hashCode();
        }

        public Root copy(Path root) {
            return new Root(root);
        }

        public Path copy$default$1() {
            return this.root();
        }

        public Path _1() {
            return this.root();
        }

        private final Object $init$$$anonfun$4(Path root$1) {
            return new StringBuilder(52).append("Tried to construct absolute glob from relative path ").append(root$1).toString();
        }
    }
}

