/*
 * Decompiled with CFR 0.152.
 */
package sbt.nio.file;

import java.nio.file.Path;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.PathFilter;
import scala.runtime.Statics;

public class OrPathFilter
implements PathFilter {
    private final PathFilter left;
    private final PathFilter right;

    public OrPathFilter(PathFilter left, PathFilter right) {
        this.left = left;
        this.right = right;
    }

    public PathFilter left() {
        return this.left;
    }

    public PathFilter right() {
        return this.right;
    }

    @Override
    public boolean accept(Path path, FileAttributes attributes) {
        return this.left().accept(path, attributes) || this.right().accept(path, attributes);
    }

    public int hashCode() {
        return Statics.anyHash((Object)this.left()) * 31 ^ Statics.anyHash((Object)this.right());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof OrPathFilter)) return false;
        OrPathFilter that = (OrPathFilter)object;
        PathFilter pathFilter = this.left();
        PathFilter pathFilter2 = that.left();
        if (pathFilter == null) {
            if (pathFilter2 != null) {
                return false;
            }
        } else if (!pathFilter.equals(pathFilter2)) return false;
        PathFilter pathFilter3 = this.right();
        PathFilter pathFilter4 = that.right();
        if (pathFilter3 == null) {
            if (pathFilter4 == null) return true;
            return false;
        } else {
            if (!pathFilter3.equals(pathFilter4)) return false;
            return true;
        }
    }

    public String toString() {
        return new StringBuilder(4).append(this.left()).append(" || ").append(this.right()).toString();
    }
}

