/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.impl.ExecPty;
import org.jline.terminal.impl.ExternalTerminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.JnaSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    public static final String PROP_ENCODING = "org.jline.terminal.encoding";
    public static final String PROP_CODEPAGE = "org.jline.terminal.codepage";
    public static final String PROP_TYPE = "org.jline.terminal.type";
    public static final String PROP_JNA = "org.jline.terminal.jna";
    public static final String PROP_JANSI = "org.jline.terminal.jansi";
    public static final String PROP_EXEC = "org.jline.terminal.exec";
    public static final String PROP_DUMB = "org.jline.terminal.dumb";
    public static final String PROP_DUMB_COLOR = "org.jline.terminal.dumb.color";
    public static final String PROP_NON_BLOCKING_READS = "org.jline.terminal.pty.nonBlockingReads";
    public static final String PROP_COLOR_DISTANCE = "org.jline.utils.colorDistance";
    public static final String PROP_DISABLE_ALTERNATE_CHARSET = "org.jline.utils.disableAlternateCharset";
    private static final AtomicReference<Terminal> SYSTEM_TERMINAL = new AtomicReference();
    private static final AtomicReference<Terminal> TERMINAL_OVERRIDE = new AtomicReference();
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Charset encoding;
    private int codepage;
    private Boolean system;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;
    private boolean paused = false;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String string) {
        this.name = string;
        return this;
    }

    public TerminalBuilder streams(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        return this;
    }

    public TerminalBuilder system(boolean bl) {
        this.system = bl;
        return this;
    }

    public TerminalBuilder jna(boolean bl) {
        this.jna = bl;
        return this;
    }

    public TerminalBuilder jansi(boolean bl) {
        this.jansi = bl;
        return this;
    }

    public TerminalBuilder exec(boolean bl) {
        this.exec = bl;
        return this;
    }

    public TerminalBuilder dumb(boolean bl) {
        this.dumb = bl;
        return this;
    }

    public TerminalBuilder type(String string) {
        this.type = string;
        return this;
    }

    public TerminalBuilder encoding(String string) throws UnsupportedCharsetException {
        return this.encoding(string != null ? Charset.forName(string) : null);
    }

    public TerminalBuilder encoding(Charset charset) {
        this.encoding = charset;
        return this;
    }

    @Deprecated
    public TerminalBuilder codepage(int n) {
        this.codepage = n;
        return this;
    }

    public TerminalBuilder attributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public TerminalBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean bl) {
        this.nativeSignals = bl;
        return this;
    }

    public TerminalBuilder signalHandler(Terminal.SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
        return this;
    }

    public TerminalBuilder paused(boolean bl) {
        this.paused = bl;
        return this;
    }

    public Terminal build() throws IOException {
        Terminal terminal;
        Terminal terminal2 = TERMINAL_OVERRIDE.get();
        Terminal terminal3 = terminal = terminal2 != null ? terminal2 : this.doBuild();
        if (terminal2 != null) {
            Log.debug(() -> "Overriding terminal with global value set by TerminalBuilder.setTerminalOverride");
        }
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        String string;
        int n;
        String string2;
        Charset charset;
        String string3 = this.name;
        if (string3 == null) {
            string3 = "JLine terminal";
        }
        if ((charset = this.encoding) == null && (string2 = System.getProperty(PROP_ENCODING)) != null && Charset.isSupported(string2)) {
            charset = Charset.forName(string2);
        }
        if ((n = this.codepage) <= 0 && (string = System.getProperty(PROP_CODEPAGE)) != null) {
            n = Integer.parseInt(string);
        }
        if ((string = this.type) == null) {
            string = System.getProperty(PROP_TYPE);
        }
        if (string == null) {
            string = System.getenv("TERM");
        }
        if ((bl4 = this.jna) == null) {
            bl4 = TerminalBuilder.getBoolean(PROP_JNA, true);
        }
        if ((bl3 = this.jansi) == null) {
            bl3 = TerminalBuilder.getBoolean(PROP_JANSI, true);
        }
        if ((bl2 = this.exec) == null) {
            bl2 = TerminalBuilder.getBoolean(PROP_EXEC, true);
        }
        if ((bl = this.dumb) == null) {
            bl = TerminalBuilder.getBoolean(PROP_DUMB, null);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            boolean bl5;
            if (this.attributes != null || this.size != null) {
                Log.warn("Attributes and size fields are ignored when creating a system terminal");
            }
            IllegalStateException illegalStateException = new IllegalStateException("Unable to create a system terminal");
            Terminal terminal = null;
            if (OSUtils.IS_WINDOWS) {
                Object object;
                bl5 = OSUtils.IS_CONEMU;
                boolean bl6 = true;
                if (terminal == null && bl4.booleanValue()) {
                    try {
                        object = this.load(JnaSupport.class);
                        bl6 = object.isWindowsConsole();
                        terminal = object.winSysTerminal(string3, string, bl5, charset, n, this.nativeSignals, this.signalHandler, this.paused);
                    }
                    catch (Throwable throwable) {
                        Log.debug("Error creating JNA based terminal: ", throwable.getMessage(), throwable);
                        illegalStateException.addSuppressed(throwable);
                    }
                }
                if (terminal == null && bl3.booleanValue()) {
                    try {
                        object = this.load(JansiSupport.class);
                        bl6 = object.isWindowsConsole();
                        terminal = object.winSysTerminal(string3, string, bl5, charset, n, this.nativeSignals, this.signalHandler, this.paused);
                    }
                    catch (Throwable throwable) {
                        Log.debug("Error creating JANSI based terminal: ", throwable.getMessage(), throwable);
                        illegalStateException.addSuppressed(throwable);
                    }
                }
                if (terminal == null && bl2.booleanValue() && (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) && bl6) {
                    try {
                        object = ExecPty.current();
                        if ("xterm".equals(string) && this.type == null && System.getProperty(PROP_TYPE) == null) {
                            string = "xterm-256color";
                        }
                        terminal = new PosixSysTerminal(string3, string, (Pty)object, charset, this.nativeSignals, this.signalHandler);
                    }
                    catch (IOException iOException) {
                        Log.debug("Error creating EXEC based terminal: ", iOException.getMessage(), iOException);
                        illegalStateException.addSuppressed(iOException);
                    }
                }
                if (!(terminal != null || bl4.booleanValue() || bl3.booleanValue() || bl != null && bl.booleanValue())) {
                    throw new IllegalStateException("Unable to create a system terminal. On windows, either JNA or JANSI library is required.  Make sure to add one of those in the classpath.");
                }
            } else {
                Pty pty;
                if (terminal == null && bl4.booleanValue()) {
                    try {
                        pty = this.load(JnaSupport.class).current();
                        terminal = new PosixSysTerminal(string3, string, pty, charset, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable throwable) {
                        Log.debug("Error creating JNA based terminal: ", throwable.getMessage(), throwable);
                        illegalStateException.addSuppressed(throwable);
                    }
                }
                if (terminal == null && bl3.booleanValue()) {
                    try {
                        pty = this.load(JansiSupport.class).current();
                        terminal = new PosixSysTerminal(string3, string, pty, charset, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable throwable) {
                        Log.debug("Error creating JANSI based terminal: ", throwable.getMessage(), throwable);
                        illegalStateException.addSuppressed(throwable);
                    }
                }
                if (terminal == null && bl2.booleanValue()) {
                    try {
                        pty = ExecPty.current();
                        terminal = new PosixSysTerminal(string3, string, pty, charset, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable throwable) {
                        Log.debug("Error creating EXEC based terminal: ", throwable.getMessage(), throwable);
                        illegalStateException.addSuppressed(throwable);
                    }
                }
            }
            if (terminal instanceof AbstractTerminal) {
                final AbstractTerminal abstractTerminal = terminal;
                if (SYSTEM_TERMINAL.compareAndSet(null, abstractTerminal)) {
                    abstractTerminal.setOnClose(new Runnable(){

                        @Override
                        public void run() {
                            SYSTEM_TERMINAL.compareAndSet(abstractTerminal, null);
                        }
                    });
                } else {
                    illegalStateException.addSuppressed(new IllegalStateException("A system terminal is already running. Make sure to use the created system Terminal on the LineReaderBuilder if you're using one or that previously created system Terminals have been correctly closed."));
                    terminal.close();
                    terminal = null;
                }
            }
            if (terminal == null && (bl == null || bl.booleanValue())) {
                bl5 = TerminalBuilder.getBoolean(PROP_DUMB_COLOR, false);
                if (!bl5) {
                    boolean bl7 = bl5 = System.getenv("INSIDE_EMACS") != null;
                }
                if (!bl5) {
                    String string4 = TerminalBuilder.getParentProcessCommand();
                    boolean bl8 = bl5 = string4 != null && string4.contains("idea");
                }
                if (!bl5 && bl == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("Creating a dumb terminal", illegalStateException);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                terminal = new DumbTerminal(string3, bl5 ? "dumb-color" : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), charset, this.signalHandler);
            }
            if (terminal == null) {
                throw illegalStateException;
            }
            return terminal;
        }
        if (bl4.booleanValue()) {
            try {
                Pty pty = this.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(string3, string, pty, this.in, this.out, charset, this.signalHandler, this.paused);
            }
            catch (Throwable throwable) {
                Log.debug("Error creating JNA based terminal: ", throwable.getMessage(), throwable);
            }
        }
        if (bl3.booleanValue()) {
            try {
                Pty pty = this.load(JansiSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(string3, string, pty, this.in, this.out, charset, this.signalHandler, this.paused);
            }
            catch (Throwable throwable) {
                Log.debug("Error creating JANSI based terminal: ", throwable.getMessage(), throwable);
            }
        }
        return new ExternalTerminal(string3, string, this.in, this.out, charset, this.signalHandler, this.paused, this.attributes, this.size);
    }

    private static String getParentProcessCommand() {
        try {
            Class<?> clazz = Class.forName("java.lang.ProcessHandle");
            Object object = clazz.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object var2_3 = ((Optional)clazz.getMethod("parent", new Class[0]).invoke(object, new Object[0])).orElse(null);
            Method method = clazz.getMethod("info", new Class[0]);
            Object object2 = method.invoke(var2_3, new Object[0]);
            Object var5_6 = ((Optional)method.getReturnType().getMethod("command", new Class[0]).invoke(object2, new Object[0])).orElse(null);
            return var5_6;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Boolean getBoolean(String string, Boolean bl) {
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                return Boolean.parseBoolean(string2);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return bl;
    }

    private <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }

    @Deprecated
    public static final void setTerminalOverride(Terminal terminal) {
        TERMINAL_OVERRIDE.set(terminal);
    }
}

