/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.CursorSupport;
import org.jline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final InputStream masterInput;
    protected final Object lock = new Object();
    protected boolean paused = true;
    protected Thread pumpThread;

    public ExternalTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset) throws IOException {
        this(string, string2, inputStream, outputStream, charset, Terminal.SignalHandler.SIG_DFL);
    }

    public ExternalTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset, Terminal.SignalHandler signalHandler) throws IOException {
        this(string, string2, inputStream, outputStream, charset, signalHandler, false);
    }

    public ExternalTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset, Terminal.SignalHandler signalHandler, boolean bl) throws IOException {
        this(string, string2, inputStream, outputStream, charset, signalHandler, bl, null, null);
    }

    public ExternalTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset, Terminal.SignalHandler signalHandler, boolean bl, Attributes attributes, Size size) throws IOException {
        super(string, string2, outputStream, charset, signalHandler);
        this.masterInput = inputStream;
        if (attributes != null) {
            this.setAttributes(attributes);
        }
        if (size != null) {
            this.setSize(size);
        }
        if (!bl) {
            this.resume();
        }
    }

    @Override
    protected void doClose() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.pause();
            super.doClose();
        }
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(boolean bl) throws InterruptedException {
        Thread thread;
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            thread = this.pumpThread;
        }
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.pumpThread == null) {
                this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
                this.pumpThread.setDaemon(true);
                this.pumpThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paused() {
        Object object = this.lock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pump() {
        block23: {
            block22: {
                try {
                    var1_1 /* !! */  = new byte[1024];
                    while (true) {
                        if ((var2_5 = this.masterInput.read(var1_1 /* !! */ )) >= 0) {
                            this.processInputBytes(var1_1 /* !! */ , 0, var2_5);
                        }
                        if (var2_5 < 0 || this.closed.get()) break;
                        var3_6 = this.lock;
                        synchronized (var3_6) {
                            if (this.paused) {
                                this.pumpThread = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 19, 21, 13] lbl11 : MonitorExitStatement: MONITOREXIT : var3_6
                                var4_7 = this.lock;
                                break block22;
                            }
                        }
                    }
                    v0 = this.lock;
                    break block23;
                }
                catch (IOException var1_2) {
                    this.processIOException(var1_2);
                    ** break block24
                }
            }
            synchronized (var4_7) {
                this.pumpThread = null;
                return;
            }
        }
        var1_1 /* !! */  = (byte[])v0;
        synchronized (v0) {
            this.pumpThread = null;
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            ** break block24
        }
        finally {
            var1_3 = this.lock;
            synchronized (var1_3) {
                this.pumpThread = null;
            }
        }
lbl-1000:
        // 2 sources

        {
            try {
                this.slaveInput.close();
                return;
            }
            catch (IOException var1_4) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public Cursor getCursorPosition(IntConsumer intConsumer) {
        return CursorSupport.getCursorPosition(this, intConsumer);
    }
}

