/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.ExecPty;
import org.jline.utils.NonBlocking;
import org.jline.utils.NonBlockingPumpInputStream;
import org.jline.utils.NonBlockingReader;

public class LineDisciplineTerminal
extends AbstractTerminal {
    private static final String DEFAULT_TERMINAL_ATTRIBUTES = "speed 9600 baud; 24 rows; 80 columns;\nlflags: icanon isig iexten echo echoe -echok echoke -echonl echoctl\n\t-echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n\t-extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel iutf8\n\t-ignbrk brkint -inpck -ignpar -parmrk\noflags: opost onlcr -oxtabs -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n\t-dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n\teol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\n\tmin = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\n\tstop = ^S; susp = ^Z; time = 0; werase = ^W;\n";
    private static final int PIPE_SIZE = 1024;
    protected final OutputStream masterOutput;
    protected final OutputStream slaveInputPipe;
    protected final NonBlockingPumpInputStream slaveInput;
    protected final NonBlockingReader slaveReader;
    protected final PrintWriter slaveWriter;
    protected final OutputStream slaveOutput;
    protected final Attributes attributes;
    protected final Size size;

    public LineDisciplineTerminal(String string, String string2, OutputStream outputStream, Charset charset) throws IOException {
        this(string, string2, outputStream, charset, Terminal.SignalHandler.SIG_DFL);
    }

    public LineDisciplineTerminal(String string, String string2, OutputStream outputStream, Charset charset, Terminal.SignalHandler signalHandler) throws IOException {
        super(string, string2, charset, signalHandler);
        NonBlockingPumpInputStream nonBlockingPumpInputStream = NonBlocking.nonBlockingPumpInputStream(1024);
        this.slaveInputPipe = nonBlockingPumpInputStream.getOutputStream();
        this.slaveInput = nonBlockingPumpInputStream;
        this.slaveReader = NonBlocking.nonBlocking(this.getName(), this.slaveInput, this.encoding());
        this.slaveOutput = new FilteringOutputStream();
        this.slaveWriter = new PrintWriter(new OutputStreamWriter(this.slaveOutput, this.encoding()));
        this.masterOutput = outputStream;
        this.attributes = ExecPty.doGetAttr(DEFAULT_TERMINAL_ATTRIBUTES);
        this.size = new Size(160, 50);
        this.parseInfoCmp();
    }

    @Override
    public NonBlockingReader reader() {
        return this.slaveReader;
    }

    @Override
    public PrintWriter writer() {
        return this.slaveWriter;
    }

    @Override
    public InputStream input() {
        return this.slaveInput;
    }

    @Override
    public OutputStream output() {
        return this.slaveOutput;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        attributes.copy(this.attributes);
        return attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes.copy(attributes);
    }

    @Override
    public Size getSize() {
        Size size = new Size();
        size.copy(this.size);
        return size;
    }

    @Override
    public void setSize(Size size) {
        this.size.copy(size);
    }

    @Override
    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        this.echoSignal(signal);
        super.raise(signal);
    }

    public void processInputByte(int n) throws IOException {
        boolean bl = this.doProcessInputByte(n);
        this.slaveInputPipe.flush();
        if (bl) {
            this.masterOutput.flush();
        }
    }

    public void processInputBytes(byte[] byArray) throws IOException {
        this.processInputBytes(byArray, 0, byArray.length);
    }

    public void processInputBytes(byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            bl |= this.doProcessInputByte(byArray[n + i]);
        }
        this.slaveInputPipe.flush();
        if (bl) {
            this.masterOutput.flush();
        }
    }

    protected boolean doProcessInputByte(int n) throws IOException {
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
            if (n == this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                this.raise(Terminal.Signal.INT);
                return false;
            }
            if (n == this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                this.raise(Terminal.Signal.QUIT);
                return false;
            }
            if (n == this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                this.raise(Terminal.Signal.TSTP);
                return false;
            }
            if (n == this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                this.raise(Terminal.Signal.INFO);
            }
        }
        if (n == 13) {
            if (this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) {
                return false;
            }
            if (this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                n = 10;
            }
        } else if (n == 10 && this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
            n = 13;
        }
        boolean bl = false;
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            this.processOutputByte(n);
            bl = true;
        }
        this.slaveInputPipe.write(n);
        return bl;
    }

    protected void processOutputByte(int n) throws IOException {
        if (this.attributes.getOutputFlag(Attributes.OutputFlag.OPOST) && n == 10 && this.attributes.getOutputFlag(Attributes.OutputFlag.ONLCR)) {
            this.masterOutput.write(13);
            this.masterOutput.write(10);
            return;
        }
        this.masterOutput.write(n);
    }

    protected void processIOException(IOException iOException) {
        this.slaveInput.setIoException(iOException);
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        try {
            this.slaveReader.close();
        }
        finally {
            try {
                this.slaveInputPipe.close();
            }
            finally {
                this.slaveWriter.close();
            }
        }
    }

    private class FilteringOutputStream
    extends OutputStream {
        private FilteringOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            LineDisciplineTerminal.this.processOutputByte(n);
            this.flush();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                LineDisciplineTerminal.this.processOutputByte(byArray[n + i]);
            }
            this.flush();
        }

        @Override
        public void flush() throws IOException {
            LineDisciplineTerminal.this.masterOutput.flush();
        }

        @Override
        public void close() throws IOException {
            LineDisciplineTerminal.this.masterOutput.close();
        }
    }
}

