/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Stack;

public final class Curses {
    private static Object[] sv = new Object[26];
    private static Object[] dv = new Object[26];
    private static final int IFTE_NONE = 0;
    private static final int IFTE_IF = 1;
    private static final int IFTE_THEN = 2;
    private static final int IFTE_ELSE = 3;

    private Curses() {
    }

    public static String tputs(String string, Object ... objectArray) {
        if (string != null) {
            StringWriter stringWriter = new StringWriter();
            Curses.tputs(stringWriter, string, objectArray);
            return stringWriter.toString();
        }
        return null;
    }

    public static void tputs(Appendable appendable, String string, Object ... objectArray) {
        try {
            Curses.doTputs(appendable, string, objectArray);
        }
        catch (Exception exception) {
            throw new IOError(exception);
        }
    }

    private static void doTputs(Appendable appendable, String string, Object ... objectArray) throws IOException {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        boolean bl = true;
        Stack<Object> stack = new Stack<Object>();
        block48: while (n < n2) {
            char c = string.charAt(n++);
            block1 : switch (c) {
                case '\\': {
                    int n4;
                    c = string.charAt(n++);
                    if (c >= '0' && c <= '7') {
                        n4 = c - 48;
                        for (int i = 0; i < 2; ++i) {
                            if ((c = string.charAt(n++)) < '0' || c > '7') {
                                throw new IllegalStateException();
                            }
                            n4 = n4 * 8 + (c - 48);
                        }
                        appendable.append((char)n4);
                        break;
                    }
                    switch (c) {
                        case 'E': 
                        case 'e': {
                            if (!bl) continue block48;
                            appendable.append('\u001b');
                            break block1;
                        }
                        case 'n': {
                            appendable.append('\n');
                            break block1;
                        }
                        case 'r': {
                            if (!bl) continue block48;
                            appendable.append('\r');
                            break block1;
                        }
                        case 't': {
                            if (!bl) continue block48;
                            appendable.append('\t');
                            break block1;
                        }
                        case 'b': {
                            if (!bl) continue block48;
                            appendable.append('\b');
                            break block1;
                        }
                        case 'f': {
                            if (!bl) continue block48;
                            appendable.append('\f');
                            break block1;
                        }
                        case 's': {
                            if (!bl) continue block48;
                            appendable.append(' ');
                            break block1;
                        }
                        case ':': 
                        case '\\': 
                        case '^': {
                            if (!bl) continue block48;
                            appendable.append(c);
                            break block1;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case '^': {
                    c = string.charAt(n++);
                    if (!bl) continue block48;
                    appendable.append((char)(c - 64));
                    break;
                }
                case '%': {
                    int n4;
                    c = string.charAt(n++);
                    switch (c) {
                        case '%': {
                            if (!bl) continue block48;
                            appendable.append('%');
                            break block1;
                        }
                        case 'p': {
                            c = string.charAt(n++);
                            if (!bl) continue block48;
                            stack.push(objectArray[c - 49]);
                            break block1;
                        }
                        case 'P': {
                            c = string.charAt(n++);
                            if (c >= 'a' && c <= 'z') {
                                if (!bl) continue block48;
                                Curses.dv[c - 97] = stack.pop();
                                break block1;
                            }
                            if (c >= 'A' && c <= 'Z') {
                                if (!bl) continue block48;
                                Curses.sv[c - 65] = stack.pop();
                                break block1;
                            }
                            throw new IllegalArgumentException();
                        }
                        case 'g': {
                            c = string.charAt(n++);
                            if (c >= 'a' && c <= 'z') {
                                if (!bl) continue block48;
                                stack.push(dv[c - 97]);
                                break block1;
                            }
                            if (c >= 'A' && c <= 'Z') {
                                if (!bl) continue block48;
                                stack.push(sv[c - 65]);
                                break block1;
                            }
                            throw new IllegalArgumentException();
                        }
                        case '\'': {
                            c = string.charAt(n++);
                            if (bl) {
                                stack.push(Integer.valueOf(c));
                            }
                            if ((c = string.charAt(n++)) == '\'') continue block48;
                            throw new IllegalArgumentException();
                        }
                        case '{': {
                            n4 = n;
                            while (string.charAt(n++) != '}') {
                            }
                            if (!bl) continue block48;
                            int n5 = Integer.valueOf(string.substring(n4, n - 1));
                            stack.push(n5);
                            break block1;
                        }
                        case 'l': {
                            if (!bl) continue block48;
                            stack.push(stack.pop().toString().length());
                            break block1;
                        }
                        case '+': {
                            if (!bl) continue block48;
                            int n6 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 + n6);
                            break block1;
                        }
                        case '-': {
                            if (!bl) continue block48;
                            int n8 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 - n8);
                            break block1;
                        }
                        case '*': {
                            if (!bl) continue block48;
                            int n9 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 * n9);
                            break block1;
                        }
                        case '/': {
                            if (!bl) continue block48;
                            int n10 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 / n10);
                            break block1;
                        }
                        case 'm': {
                            if (!bl) continue block48;
                            int n11 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 % n11);
                            break block1;
                        }
                        case '&': {
                            if (!bl) continue block48;
                            int n12 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 & n12);
                            break block1;
                        }
                        case '|': {
                            if (!bl) continue block48;
                            int n13 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 | n13);
                            break block1;
                        }
                        case '^': {
                            if (!bl) continue block48;
                            int n14 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 ^ n14);
                            break block1;
                        }
                        case '=': {
                            if (!bl) continue block48;
                            int n15 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 == n15);
                            break block1;
                        }
                        case '>': {
                            if (!bl) continue block48;
                            int n16 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 > n16);
                            break block1;
                        }
                        case '<': {
                            if (!bl) continue block48;
                            int n17 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 < n17);
                            break block1;
                        }
                        case 'A': {
                            if (!bl) continue block48;
                            int n18 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 != 0 && n18 != 0);
                            break block1;
                        }
                        case '!': {
                            if (!bl) continue block48;
                            int n19 = Curses.toInteger(stack.pop());
                            stack.push(n19 == 0);
                            break block1;
                        }
                        case '~': {
                            if (!bl) continue block48;
                            int n20 = Curses.toInteger(stack.pop());
                            stack.push(~n20);
                            break block1;
                        }
                        case 'O': {
                            if (!bl) continue block48;
                            int n21 = Curses.toInteger(stack.pop());
                            int n7 = Curses.toInteger(stack.pop());
                            stack.push(n7 != 0 || n21 != 0);
                            break block1;
                        }
                        case '?': {
                            if (n3 != 0) {
                                throw new IllegalArgumentException();
                            }
                            n3 = 1;
                            break block1;
                        }
                        case 't': {
                            if (n3 != 1 && n3 != 3) {
                                throw new IllegalArgumentException();
                            }
                            n3 = 2;
                            bl = Curses.toInteger(stack.pop()) != 0;
                            break block1;
                        }
                        case 'e': {
                            if (n3 != 2) {
                                throw new IllegalArgumentException();
                            }
                            n3 = 3;
                            bl = !bl;
                            break block1;
                        }
                        case ';': {
                            if (n3 == 0 || n3 == 1) {
                                throw new IllegalArgumentException();
                            }
                            n3 = 0;
                            bl = true;
                            break block1;
                        }
                        case 'i': {
                            if (objectArray.length >= 1) {
                                objectArray[0] = Curses.toInteger(objectArray[0]) + 1;
                            }
                            if (objectArray.length < 2) continue block48;
                            objectArray[1] = Curses.toInteger(objectArray[1]) + 1;
                            break block1;
                        }
                        case 'd': {
                            appendable.append(Integer.toString(Curses.toInteger(stack.pop())));
                            break block1;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case '$': {
                    int n4;
                    if (n < n2 && string.charAt(n) == '<') {
                        n4 = 0;
                        while ((c = string.charAt(++n)) != '>') {
                            if (c >= '0' && c <= '9') {
                                n4 = n4 * 10 + (c - 48);
                                continue;
                            }
                            if (c == '*' || c != '/') continue;
                        }
                        ++n;
                        try {
                            if (appendable instanceof Flushable) {
                                ((Flushable)((Object)appendable)).flush();
                            }
                            Thread.sleep(n4);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    if (!bl) continue block48;
                    appendable.append(c);
                    break;
                }
                default: {
                    if (!bl) continue block48;
                    appendable.append(c);
                }
            }
        }
    }

    private static int toInteger(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return Integer.valueOf(object.toString());
    }
}

