/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlockingInputStream;

public class NonBlockingPumpInputStream
extends NonBlockingInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final ByteBuffer readBuffer;
    private final ByteBuffer writeBuffer;
    private final OutputStream output;
    private boolean closed;
    private IOException ioException;

    public NonBlockingPumpInputStream() {
        this(4096);
    }

    public NonBlockingPumpInputStream(int n) {
        byte[] byArray = new byte[n];
        this.readBuffer = ByteBuffer.wrap(byArray);
        this.writeBuffer = ByteBuffer.wrap(byArray);
        this.output = new NbpOutputStream();
        this.readBuffer.limit(0);
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    private int wait(ByteBuffer byteBuffer, long l) throws IOException {
        boolean bl = l <= 0L;
        long l2 = 0L;
        if (!bl) {
            l2 = System.currentTimeMillis() + l;
        }
        while (!(this.closed || byteBuffer.hasRemaining() || !bl && l <= 0L)) {
            this.notifyAll();
            try {
                this.wait(l);
                this.checkIoException();
            }
            catch (InterruptedException interruptedException) {
                this.checkIoException();
                throw new InterruptedIOException();
            }
            if (bl) continue;
            l = l2 - System.currentTimeMillis();
        }
        return byteBuffer.hasRemaining() ? 0 : (this.closed ? -1 : -2);
    }

    private static boolean rewind(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.position() > byteBuffer2.position()) {
            byteBuffer2.limit(byteBuffer.position());
        }
        if (byteBuffer.position() == byteBuffer.capacity()) {
            byteBuffer.rewind();
            byteBuffer.limit(byteBuffer2.position());
            return true;
        }
        return false;
    }

    @Override
    public synchronized int available() {
        int n = this.readBuffer.remaining();
        if (this.writeBuffer.position() < this.readBuffer.position()) {
            n += this.writeBuffer.position();
        }
        return n;
    }

    @Override
    public synchronized int read(long l, boolean bl) throws IOException {
        this.checkIoException();
        int n = this.wait(this.readBuffer, l);
        if (n >= 0) {
            n = this.readBuffer.get() & 0xFF;
        }
        NonBlockingPumpInputStream.rewind(this.readBuffer, this.writeBuffer);
        return n;
    }

    @Override
    public synchronized int readBuffered(byte[] byArray) throws IOException {
        this.checkIoException();
        int n = this.wait(this.readBuffer, 0L);
        if (n >= 0) {
            n = 0;
            while (n < byArray.length && this.readBuffer.hasRemaining()) {
                byArray[n++] = (byte)(this.readBuffer.get() & 0xFF);
            }
        }
        NonBlockingPumpInputStream.rewind(this.readBuffer, this.writeBuffer);
        return n;
    }

    public synchronized void setIoException(IOException iOException) {
        this.ioException = iOException;
        this.notifyAll();
    }

    protected synchronized void checkIoException() throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
    }

    synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            if (this.wait(this.writeBuffer, 0L) == -1) {
                throw new ClosedException();
            }
            int n3 = Math.min(n2, this.writeBuffer.remaining());
            this.writeBuffer.put(byArray, n, n3);
            n += n3;
            n2 -= n3;
            NonBlockingPumpInputStream.rewind(this.writeBuffer, this.readBuffer);
        }
    }

    synchronized void flush() {
        if (this.readBuffer.hasRemaining()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }

    private class NbpOutputStream
    extends OutputStream {
        private NbpOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            NonBlockingPumpInputStream.this.write(new byte[]{(byte)n}, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            NonBlockingPumpInputStream.this.write(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
            NonBlockingPumpInputStream.this.flush();
        }

        @Override
        public void close() throws IOException {
            NonBlockingPumpInputStream.this.close();
        }
    }
}

