/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;

public class StyleResolver {
    private static final Logger log = Logger.getLogger(StyleResolver.class.getName());
    private final Function<String, String> source;

    public StyleResolver(Function<String, String> function) {
        this.source = Objects.requireNonNull(function);
    }

    private static Integer color(String string) {
        int n = 0;
        if ((string = string.toLowerCase(Locale.US)).charAt(0) == '!') {
            string = string.substring(1, string.length());
            n = 8;
        } else if (string.startsWith("bright-")) {
            string = string.substring(7, string.length());
            n = 8;
        } else if (string.charAt(0) == '~') {
            try {
                string = string.substring(1, string.length());
                return Colors.rgbColor(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warning("Invalid style-color name: " + string);
                return null;
            }
        }
        switch (string) {
            case "black": 
            case "k": {
                return n + 0;
            }
            case "red": 
            case "r": {
                return n + 1;
            }
            case "green": 
            case "g": {
                return n + 2;
            }
            case "yellow": 
            case "y": {
                return n + 3;
            }
            case "blue": 
            case "b": {
                return n + 4;
            }
            case "magenta": 
            case "m": {
                return n + 5;
            }
            case "cyan": 
            case "c": {
                return n + 6;
            }
            case "white": 
            case "w": {
                return n + 7;
            }
        }
        return null;
    }

    public AttributedStyle resolve(String string) {
        int n;
        Objects.requireNonNull(string);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Resolve: " + string);
        }
        if ((n = string.indexOf(":-")) != -1) {
            String[] stringArray = string.split(":-");
            return this.resolve(stringArray[0].trim(), stringArray[1].trim());
        }
        return this.apply(AttributedStyle.DEFAULT, string);
    }

    public AttributedStyle resolve(String string, String string2) {
        AttributedStyle attributedStyle;
        Objects.requireNonNull(string);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Resolve: %s; default: %s", string, string2));
        }
        if ((attributedStyle = this.apply(AttributedStyle.DEFAULT, string)) == AttributedStyle.DEFAULT && string2 != null) {
            attributedStyle = this.apply(attributedStyle, string2);
        }
        return attributedStyle;
    }

    private AttributedStyle apply(AttributedStyle attributedStyle, String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply: " + string);
        }
        for (String string2 : string.split(",")) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            attributedStyle = string2.startsWith(".") ? this.applyReference(attributedStyle, string2) : (string2.contains(":") ? this.applyColor(attributedStyle, string2) : (string2.matches("[0-9]+(;[0-9]+)*") ? this.applyAnsi(attributedStyle, string2) : this.applyNamed(attributedStyle, string2)));
        }
        return attributedStyle;
    }

    private AttributedStyle applyAnsi(AttributedStyle attributedStyle, String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-ansi: " + string);
        }
        return new AttributedStringBuilder().style(attributedStyle).ansiAppend("\u001b[" + string + "m").style();
    }

    private AttributedStyle applyReference(AttributedStyle attributedStyle, String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-reference: " + string);
        }
        if (string.length() == 1) {
            log.warning("Invalid style-reference; missing discriminator: " + string);
        } else {
            String string2 = string.substring(1, string.length());
            String string3 = this.source.apply(string2);
            if (string3 != null) {
                return this.apply(attributedStyle, string3);
            }
        }
        return attributedStyle;
    }

    private AttributedStyle applyNamed(AttributedStyle attributedStyle, String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-named: " + string);
        }
        switch (string.toLowerCase(Locale.US)) {
            case "default": {
                return AttributedStyle.DEFAULT;
            }
            case "bold": {
                return attributedStyle.bold();
            }
            case "faint": {
                return attributedStyle.faint();
            }
            case "italic": {
                return attributedStyle.italic();
            }
            case "underline": {
                return attributedStyle.underline();
            }
            case "blink": {
                return attributedStyle.blink();
            }
            case "inverse": {
                return attributedStyle.inverse();
            }
            case "inverse-neg": 
            case "inverseneg": {
                return attributedStyle.inverseNeg();
            }
            case "conceal": {
                return attributedStyle.conceal();
            }
            case "crossed-out": 
            case "crossedout": {
                return attributedStyle.crossedOut();
            }
            case "hidden": {
                return attributedStyle.hidden();
            }
        }
        log.warning("Unknown style: " + string);
        return attributedStyle;
    }

    private AttributedStyle applyColor(AttributedStyle attributedStyle, String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-color: " + string);
        }
        String[] stringArray = string.split(":", 2);
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        Integer n = StyleResolver.color(string3);
        if (n == null) {
            log.warning("Invalid color-name: " + string3);
        } else {
            switch (string2.toLowerCase(Locale.US)) {
                case "foreground": 
                case "fg": 
                case "f": {
                    return attributedStyle.foreground(n);
                }
                case "background": 
                case "bg": 
                case "b": {
                    return attributedStyle.background(n);
                }
            }
            log.warning("Invalid color-mode: " + string2);
        }
        return attributedStyle;
    }
}

