/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy$LocalOnly$;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy$Update$;
import lmcoursier.internal.shaded.coursier.credentials.Credentials;
import lmcoursier.internal.shaded.coursier.credentials.DirectCredentials$;
import lmcoursier.internal.shaded.coursier.credentials.FileCredentials$;
import lmcoursier.internal.shaded.coursier.credentials.Password;
import lmcoursier.internal.shaded.coursier.credentials.Password$;
import lmcoursier.internal.shaded.coursier.parse.CachePolicyParser$;
import lmcoursier.internal.shaded.coursier.parse.CredentialsParser$;
import lmcoursier.internal.shaded.coursier.paths.CachePath;
import lmcoursier.internal.shaded.coursier.paths.CoursierPaths;
import lmcoursier.internal.shaded.coursier.util.Sync$;
import lmcoursier.internal.shaded.scala.cli.config.ConfigDb;
import lmcoursier.internal.shaded.scala.cli.config.ConfigDb$;
import lmcoursier.internal.shaded.scala.cli.config.Keys$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CacheDefaults$ {
    public static final CacheDefaults$ MODULE$ = new CacheDefaults$();
    private static File location;
    private static File archiveCacheLocation;
    private static int concurrentDownloadCount;
    private static ExecutorService pool;
    private static Option<Duration> ttl;
    private static int retryCount;
    private static FiniteDuration retryBackoffInitialDelay;
    private static double retryBackoffMultiplier;
    private static Option<Object> maxRedirections;
    private static int sslRetryCount;
    private static final Seq<Option<String>> checksums;
    private static final int bufferSize;
    private static final Seq<CachePolicy.Mixed> noEnvCachePolicies;
    private static volatile int bitmap$0;

    static {
        checksums = new .colon.colon((Object)new Some((Object)"SHA-1"), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$));
        bufferSize = 0x100000;
        noEnvCachePolicies = new .colon.colon((Object)CachePolicy$LocalUpdateChanging$.MODULE$, (List)new .colon.colon((Object)CachePolicy$LocalOnly$.MODULE$, (List)new .colon.colon((Object)CachePolicy$Update$.MODULE$, (List)Nil$.MODULE$)));
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 1) == 0) {
                location = CachePath.defaultCacheDirectory();
                bitmap$0 |= 1;
            }
        }
        return location;
    }

    public File location() {
        if ((bitmap$0 & 1) == 0) {
            return this.location$lzycompute();
        }
        return location;
    }

    private File archiveCacheLocation$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 2) == 0) {
                archiveCacheLocation = CachePath.defaultArchiveCacheDirectory();
                bitmap$0 |= 2;
            }
        }
        return archiveCacheLocation;
    }

    public File archiveCacheLocation() {
        if ((bitmap$0 & 2) == 0) {
            return this.archiveCacheLocation$lzycompute();
        }
        return archiveCacheLocation;
    }

    public void warnLegacyCacheLocation() {
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 4) == 0) {
                concurrentDownloadCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.parallel-download-count").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.defaultConcurrentDownloadCount()));
                bitmap$0 |= 4;
            }
        }
        return concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        if ((bitmap$0 & 4) == 0) {
            return this.concurrentDownloadCount$lzycompute();
        }
        return concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 8) == 0) {
                pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                bitmap$0 |= 8;
            }
        }
        return pool;
    }

    public ExecutorService pool() {
        if ((bitmap$0 & 8) == 0) {
            return this.pool$lzycompute();
        }
        return pool;
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar((Object)x$1))))) {
            return new Right((Object)Duration$.MODULE$.Zero());
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Duration$.MODULE$.apply(s));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Duration s2 = (Duration)success.value();
            return new Right((Object)s2);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return new Left((Object)t);
        }
        throw new MatchError((Object)try_);
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x10) == 0) {
                Option fromEnv = Option$.MODULE$.apply((Object)System.getenv("COURSIER_TTL")).flatMap((Function1 & Serializable)x$2 -> MODULE$.parseDuration((String)x$2).toOption());
                ttl = fromEnv.orElse((Function0 & Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0 & Serializable)() -> new Some((Object)CacheDefaults$.default$1()));
                bitmap$0 |= 0x10;
            }
        }
        return ttl;
    }

    public Option<Duration> ttl() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.ttl$lzycompute();
        }
        return ttl;
    }

    public Seq<Option<String>> checksums() {
        return checksums;
    }

    public int defaultRetryCount() {
        return 5;
    }

    private FiniteDuration defaultRetryBackoffInitialDelay() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).milliseconds();
    }

    private double defaultRetryBackoffMultiplier() {
        return 2.0;
    }

    private int retryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x20) == 0) {
                retryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.exception-retry").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.defaultRetryCount()));
                bitmap$0 |= 0x20;
            }
        }
        return retryCount;
    }

    public int retryCount() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.retryCount$lzycompute();
        }
        return retryCount;
    }

    private FiniteDuration retryBackoffInitialDelay$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x40) == 0) {
                retryBackoffInitialDelay = (FiniteDuration)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.exception-retry-backoff-initial-delay").flatMap((Function1 & Serializable)s -> MODULE$.parseDuration((String)s).toOption()).collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Duration, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof FiniteDuration) {
                            FiniteDuration finiteDuration = (FiniteDuration)A1;
                            return (B1)finiteDuration;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Duration x1) {
                        Duration duration = x1;
                        return duration instanceof FiniteDuration;
                    }
                }).getOrElse((Function0 & Serializable)() -> MODULE$.defaultRetryBackoffInitialDelay());
                bitmap$0 |= 0x40;
            }
        }
        return retryBackoffInitialDelay;
    }

    public FiniteDuration retryBackoffInitialDelay() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.retryBackoffInitialDelay$lzycompute();
        }
        return retryBackoffInitialDelay;
    }

    private double retryBackoffMultiplier$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x80) == 0) {
                retryBackoffMultiplier = BoxesRunTime.unboxToDouble((Object)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.exception-retry-backoff-multiplier").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZD.sp & Serializable)x$5 -> x$5 > 0.0).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> MODULE$.defaultRetryBackoffMultiplier()));
                bitmap$0 |= 0x80;
            }
        }
        return retryBackoffMultiplier;
    }

    public double retryBackoffMultiplier() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.retryBackoffMultiplier$lzycompute();
        }
        return retryBackoffMultiplier;
    }

    private int sslRetryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x200) == 0) {
                sslRetryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.sslexception-retry").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.retryCount()));
                bitmap$0 |= 0x200;
            }
        }
        return sslRetryCount;
    }

    public int sslRetryCount() {
        if ((bitmap$0 & 0x200) == 0) {
            return this.sslRetryCount$lzycompute();
        }
        return sslRetryCount;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x100) == 0) {
                maxRedirections = CacheDefaults$.prop$1("lmcoursier.internal.shaded.coursier.http.maxRedirects").orElse((Function0 & Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0 & Serializable)() -> MODULE$.defaultMaxRedirections());
                bitmap$0 |= 0x100;
            }
        }
        return maxRedirections;
    }

    public Option<Object> maxRedirections() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.maxRedirections$lzycompute();
        }
        return maxRedirections;
    }

    public int bufferSize() {
        return bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return Option$.MODULE$.apply((Object)System.getenv("COURSIER_CREDENTIALS")).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.credentials")).map((Function1 & Serializable)s -> StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$8))))));
    }

    private boolean isPropFile(String s) {
        return s.startsWith("/") || s.startsWith("file:");
    }

    public Seq<Credentials> credentials() {
        Seq seq;
        if (this.credentialPropOpt().isEmpty()) {
            Seq configDirs = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])CoursierPaths.configDirectories()));
            Seq mainCredentialsFiles = (Seq)configDirs.map((Function1 & Serializable)configDir -> new File((File)configDir, "credentials.properties"));
            Seq dirs = (Seq)configDirs.map((Function1 & Serializable)configDir -> new File((File)configDir, "credentials"));
            Seq files = (Seq)dirs.flatMap((Function1 & Serializable)dir2 -> {
                File[] listOrNull = dir2.listFiles((dir, name) -> !name.startsWith(".") && name.endsWith(".properties"));
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)listOrNull)).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            });
            Seq otherFiles = (Seq)((IterableOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)files)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true));
            seq = (Seq)((IterableOps)mainCredentialsFiles.map((Function1 & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true))).$plus$plus((IterableOnce)otherFiles);
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(this.credentialPropOpt()).toSeq().flatMap((Function1 & Serializable)x0$1 -> {
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                if (MODULE$.isPropFile(string)) {
                    String path0 = string.startsWith("file:") ? new File(new URI(string)).getAbsolutePath() : string;
                    return new .colon.colon((Object)FileCredentials$.MODULE$.apply(path0, true), (List)Nil$.MODULE$);
                }
                return (Seq)CredentialsParser$.MODULE$.parseSeq(string).either().toSeq().flatten(Predef$.MODULE$.$conforms());
            });
        }
        Seq legacyCredentials = seq;
        Path configPath = CoursierPaths.scalaConfigFile();
        Seq<Credentials> configCredentials = this.credentialsFromConfig(configPath);
        return (Seq)configCredentials.$plus$plus((IterableOnce)legacyCredentials);
    }

    public Seq<Credentials> credentialsFromConfig(Path configPath) {
        ConfigDb configDb = (ConfigDb)ConfigDb$.MODULE$.open(configPath).fold((Function1 & Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1 & Serializable)x -> (ConfigDb)Predef$.MODULE$.identity(x));
        return (Seq)configDb.get(Keys$.MODULE$.repositoryCredentials()).fold((Function1 & Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1 & Serializable)x$9 -> ((List)x$9.getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable)c -> DirectCredentials$.MODULE$.apply(c.host(), (Option<String>)c.user().map((Function1 & Serializable)x$10 -> x$10.get().value()), (Option<Password<String>>)c.password().map((Function1 & Serializable)p -> Password$.MODULE$.apply(p.get().value())), c.realm(), BoxesRunTime.unboxToBoolean((Object)c.optional().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultOptional())), BoxesRunTime.unboxToBoolean((Object)c.matchHost().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultMatchHost())), BoxesRunTime.unboxToBoolean((Object)c.httpsOnly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultHttpsOnly())), BoxesRunTime.unboxToBoolean((Object)c.passOnRedirect().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultPassOnRedirect())))));
    }

    public Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return noEnvCachePolicies;
    }

    public Seq<CachePolicy> cachePolicies() {
        Option fromEnv = CacheDefaults$.fromOption$1(Option$.MODULE$.apply((Object)System.getenv("COURSIER_MODE")), "COURSIER_MODE environment variable");
        return (Seq)fromEnv.orElse((Function0 & Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0 & Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    private static final Option fromProps$1() {
        return scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.ttl").flatMap((Function1 & Serializable)x$3 -> MODULE$.parseDuration((String)x$3).toOption());
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        return scala.sys.package$.MODULE$.props().get(name).flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 >= 0);
    }

    private static final Option fromOption$1(Option value, String description) {
        return value.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$11)))).flatMap((Function1 & Serializable)str -> {
            boolean bl = false;
            Right right = null;
            Either<.colon.colon<String>, Seq<CachePolicy>> either = CachePolicyParser$.MODULE$.cachePolicies((String)str, (Seq<CachePolicy>)MODULE$.noEnvCachePolicies()).either();
            if (either instanceof Right) {
                SeqOps seqOps;
                bl = true;
                right = (Right)either;
                Seq seq = (Seq)right.value();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description).append(", ignoring it.").toString());
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Seq policies = (Seq)right.value();
                return new Some((Object)policies);
            }
            if (either instanceof Left) {
                Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(description).append(", ignoring it.").toString());
                return None$.MODULE$;
            }
            throw new MatchError(either);
        });
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
    }
}

