/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.credentials;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Properties;
import lmcoursier.internal.shaded.coursier.credentials.DirectCredentials;
import lmcoursier.internal.shaded.coursier.credentials.DirectCredentials$;
import lmcoursier.internal.shaded.coursier.credentials.FileCredentials;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class FileCredentials$
implements Serializable {
    public static final FileCredentials$ MODULE$ = new FileCredentials$();

    public Seq<DirectCredentials> parse(String content, String origin) {
        Properties props = new Properties();
        props.load(new StringReader(content));
        Vector userProps = CollectionConverters$.MODULE$.EnumerationHasAsScala(props.propertyNames()).asScala().map((Function1 & Serializable)x$1 -> (String)x$1).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".username"))).toVector();
        return (Seq)userProps.map((Function1 & Serializable)userProp -> {
            String prefix = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(userProp), ".username");
            String user = props.getProperty((String)userProp);
            String password = (String)Option$.MODULE$.apply((Object)props.getProperty(new StringBuilder(9).append(prefix).append(".password").toString())).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(32).append("Property ").append(prefix).append(".password not found in ").append(origin).toString());
            });
            String host = (String)Option$.MODULE$.apply((Object)props.getProperty(new StringBuilder(5).append(prefix).append(".host").toString())).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(28).append("Property ").append(prefix).append(".host not found in ").append(origin).toString());
            });
            Option realmOpt = Option$.MODULE$.apply((Object)props.getProperty(new StringBuilder(6).append(prefix).append(".realm").toString()));
            boolean matchHost = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)props.getProperty(new StringBuilder(5).append(prefix).append(".auto").toString())).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultMatchHost(), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$3)))));
            boolean httpsOnly = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)props.getProperty(new StringBuilder(11).append(prefix).append(".https-only").toString())).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> DirectCredentials$.MODULE$.defaultHttpsOnly(), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$4)))));
            boolean passOnRedirect = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)props.getProperty(new StringBuilder(17).append(prefix).append(".pass-on-redirect").toString())).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$5)))));
            return DirectCredentials$.MODULE$.apply(host, user, password).withRealm((Option<String>)realmOpt).withMatchHost(matchHost).withHttpsOnly(httpsOnly).withPassOnRedirect(passOnRedirect);
        });
    }

    public FileCredentials apply(String path) {
        return new FileCredentials(path, true);
    }

    public FileCredentials apply(String path, boolean optional) {
        return new FileCredentials(path, optional);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileCredentials$.class);
    }

    private FileCredentials$() {
    }
}

