/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.jniutils;

import java.io.IOException;
import lmcoursier.internal.shaded.coursier.jniutils.CString;
import lmcoursier.internal.shaded.coursier.jniutils.NativeApi;

public final class WindowsEnvironmentVariables {
    public static String get(String string) throws IOException {
        String string2 = CString.fromC(NativeApi.get().GetUserEnvironmentVariable(CString.toC(string)));
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("E")) {
            throw new IOException("Error getting user environment variable " + string + ": " + string2.substring("E".length()));
        }
        return string2.substring(1);
    }

    public static void set(String string, String string2) throws IOException {
        String string3 = CString.fromC(NativeApi.get().SetUserEnvironmentVariable(CString.toC(string), CString.toC(string2)));
        if (string3.startsWith("E")) {
            throw new IOException("Error setting user environment variable " + string + ": " + string3.substring("E".length()));
        }
    }

    public static void delete(String string) throws IOException {
        String string2 = CString.fromC(NativeApi.get().DeleteUserEnvironmentVariable(CString.toC(string)));
        if (string2.startsWith("E")) {
            throw new IOException("Error deleting user environment variable " + string + ": " + string2.substring("E".length()));
        }
    }
}

