/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.librarymanagement;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.install.InstallOptions;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.filter.Filter;
import sbt.internal.librarymanagement.ConvertResolver$;
import sbt.internal.librarymanagement.InternalDefaults$;
import sbt.internal.librarymanagement.IvyActions;
import sbt.internal.librarymanagement.IvyActions$;
import sbt.internal.librarymanagement.IvyRetrieve$;
import sbt.internal.librarymanagement.IvySbt;
import sbt.internal.librarymanagement.IvySbt$;
import sbt.internal.librarymanagement.MakePom;
import sbt.internal.librarymanagement.ResolutionCache$;
import sbt.internal.librarymanagement.UpdateClassifiersUtil$;
import sbt.internal.librarymanagement.ivyint.CachedResolutionResolveEngine;
import sbt.io.IO$;
import sbt.io.PathFinder$;
import sbt.librarymanagement.Artifact;
import sbt.librarymanagement.ArtifactTypeFilter;
import sbt.librarymanagement.ConfigRef;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.CrossVersion$;
import sbt.librarymanagement.DependencyFilter$;
import sbt.librarymanagement.MakePomConfiguration;
import sbt.librarymanagement.MavenRepository;
import sbt.librarymanagement.ModuleDescriptorConfiguration;
import sbt.librarymanagement.ModuleFilter;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.ModuleInfo;
import sbt.librarymanagement.ModuleSettings;
import sbt.librarymanagement.PublishConfiguration;
import sbt.librarymanagement.ResolveException;
import sbt.librarymanagement.RetrieveConfiguration;
import sbt.librarymanagement.SubDepFilter;
import sbt.librarymanagement.UnresolvedWarning;
import sbt.librarymanagement.UnresolvedWarning$;
import sbt.librarymanagement.UnresolvedWarningConfiguration;
import sbt.librarymanagement.UpdateConfiguration;
import sbt.librarymanagement.UpdateLogging;
import sbt.librarymanagement.UpdateReport;
import sbt.librarymanagement.syntax$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;

public final class IvyActions$ {
    public static IvyActions$ MODULE$;

    static {
        new IvyActions$();
    }

    public void install(IvySbt.Module module, String from, String to, Logger log) {
        module.withModule(log, (Function3 & Serializable & scala.Serializable)(ivy, md, string) -> {
            IvyActions$.$anonfun$install$1(module, from, to, log, ivy, md, string);
            return BoxedUnit.UNIT;
        });
    }

    public void cleanCache(IvySbt ivy, Logger log) {
        ivy.withIvy(log, (Function1 & Serializable & scala.Serializable)iv -> {
            IvyActions$.$anonfun$cleanCache$1(iv);
            return BoxedUnit.UNIT;
        });
    }

    public void cleanCachedResolutionCache(IvySbt.Module module, Logger log) {
        module.withModule(log, (Function3 & Serializable & scala.Serializable)(ivy, md, string) -> {
            IvyActions$.$anonfun$cleanCachedResolutionCache$1(module, log, ivy, md, string);
            return BoxedUnit.UNIT;
        });
    }

    public File makePomFile(IvySbt.Module module, MakePomConfiguration configuration, Logger log) {
        File file = (File)configuration.file().getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("file must be specified."));
        ModuleInfo moduleInfo = (ModuleInfo)configuration.moduleInfo().getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("moduleInfo must be specified."));
        NodeSeq extra = (NodeSeq)configuration.extra().getOrElse((Function0 & Serializable & scala.Serializable)() -> NodeSeq$.MODULE$.Empty());
        return (File)module.withModule(log, (Function3 & Serializable & scala.Serializable)(ivy, md, string) -> {
            new MakePom(log).write((Ivy)ivy, (ModuleDescriptor)md, moduleInfo, (Option<Iterable<Configuration>>)configuration.configurations(), (Set<String>)configuration.includeTypes(), extra, (Function1<Node, Node>)configuration.process(), (Function1<MavenRepository, Object>)configuration.filterRepositories(), configuration.allRepositories(), file);
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append("Wrote ").append(file.getAbsolutePath()).toString());
            return file;
        });
    }

    public File deliver(IvySbt.Module module, PublishConfiguration configuration, Logger log) {
        String deliverIvyPattern = (String)configuration.deliverIvyPattern().getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("deliverIvyPattern must be specified."));
        String status = InternalDefaults$.MODULE$.getDeliverStatus(configuration.status());
        return (File)module.withModule(log, (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Ivy ivy = (Ivy)tuple3._1();
            DefaultModuleDescriptor md = (DefaultModuleDescriptor)tuple3._2();
            ModuleRevisionId revID = md.getModuleRevisionId();
            DeliverOptions options = DeliverOptions.newInstance((IvySettings)ivy.getSettings()).setStatus(status);
            options.setConfs(MODULE$.getConfigurations((ModuleDescriptor)md, (Option<Vector<ConfigRef>>)configuration.configurations()));
            ivy.deliver(revID, revID.getRevision(), deliverIvyPattern, options);
            File file = MODULE$.deliveredFile(ivy, deliverIvyPattern, (ModuleDescriptor)md);
            return file;
        });
    }

    public String[] getConfigurations(ModuleDescriptor module, Option<Vector<ConfigRef>> configurations) {
        String[] stringArray;
        Option<Vector<ConfigRef>> option = configurations;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vector confs = (Vector)some.value();
            stringArray = (String[])((TraversableOnce)confs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Vector$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            stringArray = module.getPublicConfigurationsNames();
        } else {
            throw new MatchError(option);
        }
        return stringArray;
    }

    public File deliveredFile(Ivy ivy, String pattern, ModuleDescriptor md) {
        return ivy.getSettings().resolveFile(IvyPatternHelper.substitute((String)pattern, (ModuleRevisionId)md.getResolvedModuleRevisionId()));
    }

    public void publish(IvySbt.Module module, PublishConfiguration configuration, Logger log) {
        String x;
        Option option = configuration.resolverName();
        if (!(option instanceof Some)) {
            throw scala.sys.package$.MODULE$.error("Resolver name is not specified");
        }
        Some some = (Some)option;
        String string = x = (String)some.value();
        String resolverName = string;
        None$ ivyFile = configuration.publishMavenStyle() ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.deliver(module, configuration, log));
        scala.collection.immutable.Map artifacts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)configuration.artifacts());
        Vector checksums = configuration.checksums();
        module.withModule(log, (arg_0, arg_1, arg_2) -> IvyActions$.$anonfun$publish$1$adapted(module, configuration, resolverName, (Option)ivyFile, artifacts, checksums, arg_0, arg_1, arg_2));
    }

    private <T> T withChecksums(DependencyResolver resolver, Vector<String> checksums, Function0<T> act) {
        Object object;
        DependencyResolver dependencyResolver = resolver;
        if (dependencyResolver instanceof BasicResolver) {
            BasicResolver basicResolver = (BasicResolver)dependencyResolver;
            object = this.withChecksums(basicResolver, checksums, act);
        } else {
            object = act.apply();
        }
        return (T)object;
    }

    private <T> T withChecksums(BasicResolver resolver, Vector<String> checksums, Function0<T> act) {
        Object object;
        String[] previous = resolver.getChecksumAlgorithms();
        resolver.setChecksums(checksums.mkString(","));
        try {
            object = act.apply();
        }
        finally {
            resolver.setChecksums(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])previous)).mkString(","));
        }
        return (T)object;
    }

    private Option<Function1<String, String>> crossVersionMap(ModuleSettings moduleSettings) {
        None$ none$;
        ModuleSettings moduleSettings2 = moduleSettings;
        if (moduleSettings2 instanceof ModuleDescriptorConfiguration) {
            ModuleDescriptorConfiguration moduleDescriptorConfiguration = (ModuleDescriptorConfiguration)moduleSettings2;
            none$ = CrossVersion$.MODULE$.apply(moduleDescriptorConfiguration.module(), moduleDescriptorConfiguration.scalaModuleInfo());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Vector<Tuple2<org.apache.ivy.core.module.descriptor.Artifact, File>> mapArtifacts(ModuleDescriptor module, Option<Function1<String, String>> cross, scala.collection.immutable.Map<Artifact, File> artifacts) {
        Vector rawa = artifacts.keys().toVector();
        Vector seqa = CrossVersion$.MODULE$.substituteCross(rawa, cross);
        Vector zipped = (Vector)rawa.zip(IvySbt$.MODULE$.mapArtifacts(module, (Seq<Artifact>)seqa), Vector$.MODULE$.canBuildFrom());
        return (Vector)zipped.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Artifact a = (Artifact)tuple2._1();
            org.apache.ivy.core.module.descriptor.Artifact ivyA = (org.apache.ivy.core.module.descriptor.Artifact)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)ivyA, artifacts.apply((Object)a));
            return tuple22;
        }, Vector$.MODULE$.canBuildFrom());
    }

    public Either<UnresolvedWarning, UpdateReport> updateEither(IvySbt.Module module, UpdateConfiguration configuration, UnresolvedWarningConfiguration uwconfig, Logger log) {
        return (Either)module.withModule(log, (Function3 & Serializable & scala.Serializable)(x0$4, x1$3, x2$3) -> {
            Either<ResolveException, UpdateReport> either;
            Ivy ivy;
            Tuple3 tuple3 = new Tuple3(x0$4, x1$3, x2$3);
            if (tuple3 != null) {
                ivy = (Ivy)tuple3._1();
                DefaultModuleDescriptor moduleDescriptor = (DefaultModuleDescriptor)tuple3._2();
                String defaultConf = (String)tuple3._3();
                List<String> iw = IvySbt$.MODULE$.inconsistentDuplicateWarning(moduleDescriptor);
                iw.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    log.warn((Function0 & Serializable & scala.Serializable)() -> x$3);
                    return BoxedUnit.UNIT;
                });
                Option metadataDirectory = configuration.metadataDirectory();
                IvyActions.ResolutionInputs inputs = new IvyActions.ResolutionInputs(ivy, moduleDescriptor, configuration, log);
                if (module.owner().configuration().updateOptions().cachedResolution() && metadataDirectory.isDefined()) {
                    File cache = (File)metadataDirectory.getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Missing directory for cached resolution."));
                    either = MODULE$.cachedResolveAndRetrieve(inputs, cache);
                } else {
                    either = MODULE$.resolveAndRetrieve(inputs, defaultConf);
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            Either<ResolveException, UpdateReport> resolutionResult = either;
            Either either2 = (Either)resolutionResult.fold((Function1 & Serializable & scala.Serializable)exception -> package$.MODULE$.Left().apply((Object)UnresolvedWarning$.MODULE$.apply(exception, uwconfig)), (Function1 & Serializable & scala.Serializable)ur0 -> {
                UpdateReport updateReport;
                Option option = configuration.retrieveManaged();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    RetrieveConfiguration retrieveConf = (RetrieveConfiguration)some.value();
                    updateReport = MODULE$.retrieve(log, ivy, (UpdateReport)ur0, retrieveConf);
                } else {
                    updateReport = ur0;
                }
                UpdateReport ur = updateReport;
                return package$.MODULE$.Right().apply((Object)ur);
            });
            return either2;
        });
    }

    public <T> scala.collection.immutable.Map<T, Set<String>> groupedConflicts(ModuleFilter moduleFilter, Function1<ModuleID, T> grouping, UpdateReport report) {
        return ((TraversableOnce)report.configurations().flatMap((Function1 & Serializable & scala.Serializable)confReport -> {
            Seq evicted = (Seq)confReport.evicted().filter(DependencyFilter$.MODULE$.subDepFilterToFn((SubDepFilter)moduleFilter));
            Set evictedSet = ((TraversableOnce)evicted.map((Function1 & Serializable & scala.Serializable)m -> new Tuple2((Object)m.organization(), (Object)m.name()), Seq$.MODULE$.canBuildFrom())).toSet();
            Seq conflicted = (Seq)confReport.allModules().filter((Function1 & Serializable & scala.Serializable)mod -> BoxesRunTime.boxToBoolean((boolean)evictedSet.apply((Object)new Tuple2((Object)mod.organization(), (Object)mod.name()))));
            return MODULE$.grouped(grouping, (Seq<ModuleID>)((Seq)conflicted.$plus$plus((GenTraversableOnce)evicted, Seq$.MODULE$.canBuildFrom())));
        }, Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <T> scala.collection.immutable.Map<T, Set<String>> grouped(Function1<ModuleID, T> grouping, Seq<ModuleID> mods) {
        return mods.groupBy(grouping).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.revision(), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public UpdateReport addExcluded(UpdateReport report, Vector<String> classifiers, scala.collection.immutable.Map<ModuleID, Set<String>> exclude) {
        return syntax$.MODULE$.richUpdateReport(report).addMissing((Function1 & Serializable & scala.Serializable)id -> UpdateClassifiersUtil$.MODULE$.classifiedArtifacts(id.name(), (Vector)classifiers.filter(MODULE$.getExcluded((ModuleID)id, exclude))));
    }

    private Set<String> getExcluded(ModuleID id, scala.collection.immutable.Map<ModuleID, Set<String>> exclude) {
        return (Set)exclude.getOrElse((Object)UpdateClassifiersUtil$.MODULE$.restrictedCopy(id, false), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public scala.collection.immutable.Map<ModuleID, Set<String>> extractExcludes(UpdateReport report) {
        return (scala.collection.immutable.Map)((TraversableLike)syntax$.MODULE$.richUpdateReport(report).allMissing().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple3 tuple3 = x0$5;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ModuleID mod = (ModuleID)tuple3._2();
            Artifact art = (Artifact)tuple3._3();
            Iterable iterable = Option$.MODULE$.option2Iterable(art.classifier().map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)UpdateClassifiersUtil$.MODULE$.restrictedCopy(mod, false), c)));
            return iterable;
        }, Vector$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (ModuleID)x$6._1()).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ModuleID mod = (ModuleID)tuple2._1();
            Vector pairs = (Vector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mod, (Object)((TraversableOnce)pairs.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._2(), Vector$.MODULE$.canBuildFrom())).toSet());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Filter toIvyFilter(ArtifactTypeFilter f) {
        return new Filter(f){
            private final ArtifactTypeFilter f$1;

            public boolean accept(Object o) {
                return Option$.MODULE$.apply(o).exists((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$accept$1(this, x0$7)));
            }

            private boolean applyFilter(org.apache.ivy.core.module.descriptor.Artifact a) {
                return this.f$1.types().contains((Object)a.getType()) ^ this.f$1.inverted();
            }

            public static final /* synthetic */ boolean $anonfun$accept$1(anon.1 $this, Object x0$7) {
                Object object = x0$7;
                if (!(object instanceof org.apache.ivy.core.module.descriptor.Artifact)) {
                    throw new MatchError(object);
                }
                org.apache.ivy.core.module.descriptor.Artifact artifact = (org.apache.ivy.core.module.descriptor.Artifact)object;
                boolean bl = $this.applyFilter(artifact);
                return bl;
            }
            {
                this.f$1 = f$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(sbt.internal.librarymanagement.IvyActions$$anon$1 java.lang.Object )}, serializedLambda);
            }
        };
    }

    private Either<ResolveException, UpdateReport> resolveAndRetrieve(IvyActions.ResolutionInputs inputs, String defaultModuleConfiguration) {
        Right right;
        BoxedUnit boxedUnit;
        Ivy ivyInstance = inputs.ivy();
        DefaultModuleDescriptor moduleDescriptor = inputs.module();
        UpdateConfiguration updateConfiguration = inputs.updateConfiguration();
        ResolveOptions resolveOptions = new ResolveOptions();
        String resolveId = ResolveOptions.getDefaultResolveId((ModuleDescriptor)moduleDescriptor);
        ArtifactTypeFilter artifactFilter = InternalDefaults$.MODULE$.getArtifactTypeFilter(updateConfiguration.artifactFilter());
        resolveOptions.setResolveId(resolveId);
        resolveOptions.setArtifactFilter(this.toIvyFilter(artifactFilter));
        resolveOptions.setUseCacheOnly(updateConfiguration.offline());
        resolveOptions.setLog(this.ivyLogLevel(updateConfiguration.logging()));
        if (updateConfiguration.frozen()) {
            resolveOptions.setTransitive(false);
            boxedUnit = resolveOptions.setCheckIfChanged(false);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ResolutionCache$.MODULE$.cleanModule(moduleDescriptor.getModuleRevisionId(), resolveId, ivyInstance.getSettings().getResolutionCacheManager());
        ResolveReport resolveReport = ivyInstance.resolve((ModuleDescriptor)moduleDescriptor, resolveOptions);
        if (resolveReport.hasError() && !updateConfiguration.missingOk()) {
            String[] messages = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(resolveReport.getAllProblemMessages().toArray())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
            scala.collection.immutable.Map failedPaths = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolveReport.getUnresolvedDependencies())).map((Function1 & Serializable & scala.Serializable)node -> {
                ModuleID moduleID = IvyRetrieve$.MODULE$.toModuleID(node.getId());
                List path = (List)IvyRetrieve$.MODULE$.findPath((IvyNode)node, moduleDescriptor.getModuleRevisionId()).map((Function1 & Serializable & scala.Serializable)x -> IvyRetrieve$.MODULE$.toModuleID(x.getId()), List$.MODULE$.canBuildFrom());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)moduleID), (Object)path);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            Seq failedModules = failedPaths.keys().toSeq();
            right = package$.MODULE$.Left().apply((Object)new ResolveException((Seq)Predef$.MODULE$.wrapRefArray((Object[])messages), failedModules, failedPaths));
        } else {
            File cachedDescriptor = ivyInstance.getSettings().getResolutionCacheManager().getResolvedIvyFileInCache(moduleDescriptor.getModuleRevisionId());
            right = package$.MODULE$.Right().apply((Object)IvyRetrieve$.MODULE$.updateReport(resolveReport, cachedDescriptor));
        }
        return right;
    }

    private Either<ResolveException, UpdateReport> cachedResolveAndRetrieve(IvyActions.ResolutionInputs inputs, File cache) {
        BoxedUnit boxedUnit;
        Logger log = inputs.log();
        DefaultModuleDescriptor descriptor = inputs.module();
        UpdateConfiguration updateConfiguration = inputs.updateConfiguration();
        CachedResolutionResolveEngine resolver = (CachedResolutionResolveEngine)inputs.ivy().getResolveEngine();
        ResolveOptions resolveOptions = new ResolveOptions();
        String resolveId = ResolveOptions.getDefaultResolveId((ModuleDescriptor)descriptor);
        ArtifactTypeFilter artifactFilter = InternalDefaults$.MODULE$.getArtifactTypeFilter(updateConfiguration.artifactFilter());
        resolveOptions.setResolveId(resolveId);
        resolveOptions.setArtifactFilter(this.toIvyFilter(artifactFilter));
        resolveOptions.setUseCacheOnly(updateConfiguration.offline());
        resolveOptions.setLog(this.ivyLogLevel(updateConfiguration.logging()));
        if (updateConfiguration.frozen()) {
            resolveOptions.setTransitive(false);
            boxedUnit = resolveOptions.setCheckIfChanged(false);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return resolver.customResolve((ModuleDescriptor)descriptor, updateConfiguration.missingOk(), updateConfiguration.logicalClock(), resolveOptions, cache, log);
    }

    private UpdateReport retrieve(Logger log, Ivy ivy, UpdateReport report, RetrieveConfiguration config) {
        UpdateReport retReport;
        block2: {
            boolean bl;
            Option option = Option$.MODULE$.apply((Object)ivy.getVariable(ConvertResolver$.MODULE$.ManagedChecksums()));
            if (option instanceof Some) {
                Some some = (Some)option;
                String x = (String)some.value();
                bl = new StringOps(Predef$.MODULE$.augmentString(x)).toBoolean();
            } else {
                bl = false;
            }
            boolean copyChecksums = bl;
            Option toRetrieve = config.configurationsToRetrieve();
            File base = InternalDefaults$.MODULE$.getRetrieveDirectory(config.retrieveDirectory());
            String pattern = InternalDefaults$.MODULE$.getRetrievePattern(config.outputPattern());
            Seq existingFiles = (Seq)PathFinder$.MODULE$.apply(base).allPaths().get().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isDirectory()));
            HashSet toCopy = new HashSet();
            retReport = report.retrieve((Function4 & Serializable & scala.Serializable)(conf, mid, art, cached) -> {
                Some some;
                Vector refs;
                Option option = toRetrieve;
                File file = None$.MODULE$.equals(option) ? MODULE$.performRetrieve((ConfigRef)conf, (ModuleID)mid, (Artifact)art, base, pattern, (File)cached, copyChecksums, (HashSet<Tuple2<File, File>>)toCopy) : (option instanceof Some && (refs = (Vector)(some = (Some)option).value()).contains(conf) ? MODULE$.performRetrieve((ConfigRef)conf, (ModuleID)mid, (Artifact)art, base, pattern, (File)cached, copyChecksums, (HashSet<Tuple2<File, File>>)toCopy) : cached);
                return file;
            });
            IO$.MODULE$.copy((Traversable)toCopy);
            HashSet resolvedFiles = (HashSet)toCopy.map((Function1 & Serializable & scala.Serializable)x$10 -> (File)x$10._2(), HashSet$.MODULE$.canBuildFrom());
            if (!config.sync()) break block2;
            Seq filesToDelete = (Seq)existingFiles.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)resolvedFiles.contains((Object)elem)));
            filesToDelete.foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IvyActions$.$anonfun$retrieve$5(log, f)));
        }
        return retReport;
    }

    private File performRetrieve(ConfigRef conf, ModuleID mid, Artifact art, File base, String pattern, File cached, boolean copyChecksums, HashSet<Tuple2<File, File>> toCopy) {
        File to;
        block0: {
            to = this.retrieveTarget(conf, mid, art, base, pattern);
            toCopy.$plus$eq((Object)new Tuple2((Object)cached, (Object)to));
            if (!copyChecksums) break block0;
            String cachePath = cached.getAbsolutePath();
            IvySbt$.MODULE$.DefaultChecksums().foreach((Function1 & Serializable & scala.Serializable)checksum -> {
                BoxedUnit boxedUnit;
                if (cachePath.endsWith(".jar")) {
                    File cacheChecksum = new File(new StringBuilder(1).append(cachePath).append(".").append((String)checksum).toString());
                    if (cacheChecksum.exists()) {
                        File toChecksum = new File(new StringBuilder(1).append(to.getAbsolutePath()).append(".").append((String)checksum).toString());
                        boxedUnit = toCopy.$plus$eq((Object)new Tuple2((Object)cacheChecksum, (Object)toChecksum));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }
        return to;
    }

    private File retrieveTarget(ConfigRef conf, ModuleID mid, Artifact art, File base, String pattern) {
        return new File(base, this.substitute(conf, mid, art, pattern));
    }

    private String substitute(ConfigRef conf, ModuleID mid, Artifact art, String pattern) {
        Map<String, String> mextra = IvySbt$.MODULE$.javaMap((scala.collection.immutable.Map<String, String>)mid.extraAttributes(), true);
        Map<String, String> aextra = IvySbt$.MODULE$.extra(art, true);
        return IvyPatternHelper.substitute((String)pattern, (String)mid.organization(), (String)mid.name(), (String)((String)mid.branchName().orNull(Predef$.MODULE$.$conforms())), (String)mid.revision(), (String)art.name(), (String)art.type(), (String)art.extension(), (String)conf.name(), null, mextra, aextra);
    }

    private String ivyLogLevel(UpdateLogging level) {
        String string;
        UpdateLogging updateLogging = level;
        if (UpdateLogging.Quiet$.MODULE$.equals(updateLogging)) {
            string = "quiet";
        } else if (UpdateLogging.DownloadOnly$.MODULE$.equals(updateLogging)) {
            string = "download-only";
        } else if (UpdateLogging.Full$.MODULE$.equals(updateLogging)) {
            string = "default";
        } else if (UpdateLogging.Default$.MODULE$.equals(updateLogging)) {
            string = "download-only";
        } else {
            throw new MatchError((Object)updateLogging);
        }
        return string;
    }

    public void publish(ModuleDescriptor module, Seq<Tuple2<org.apache.ivy.core.module.descriptor.Artifact, File>> artifacts, DependencyResolver resolver, boolean overwrite) {
        if (artifacts.nonEmpty()) {
            this.checkFilesPresent(artifacts);
            try {
                resolver.beginPublishTransaction(module.getModuleRevisionId(), overwrite);
                artifacts.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IvyActions$.$anonfun$publish$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    IvyActions$.$anonfun$publish$5(resolver, overwrite, x$11);
                    return BoxedUnit.UNIT;
                });
                resolver.commitPublishTransaction();
            }
            catch (Throwable e) {
                try {
                    resolver.abortPublishTransaction();
                }
                finally {
                    throw e;
                }
            }
        }
    }

    private void checkFilesPresent(Seq<Tuple2<org.apache.ivy.core.module.descriptor.Artifact, File>> artifacts) {
        Seq missing = (Seq)artifacts.filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)IvyActions$.$anonfun$checkFilesPresent$1(x0$8)));
        if (missing.nonEmpty()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(31).append("Missing files for publishing:\n\t").append(((TraversableOnce)missing.map((Function1 & Serializable & scala.Serializable)x$12 -> ((File)x$12._2()).getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString("\n\t")).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$install$1(IvySbt.Module module$1, String from$1, String to$1, Logger log$1, Ivy ivy, DefaultModuleDescriptor md, String string) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])md.getDependencies())).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            log$1.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Installing ").append(dependency).toString());
            InstallOptions options = new InstallOptions();
            options.setValidate(module$1.moduleSettings().validate());
            options.setTransitive(dependency.isTransitive());
            return ivy.install(dependency.getDependencyRevisionId(), from$1, to$1, options);
        });
    }

    public static final /* synthetic */ void $anonfun$cleanCache$1(Ivy iv) {
        iv.getSettings().getResolutionCacheManager().clean();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])iv.getSettings().getRepositoryCacheManagers())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.clean();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanCachedResolutionCache$1(IvySbt.Module module$2, Logger log$2, Ivy ivy, DefaultModuleDescriptor md, String string) {
        module$2.owner().cleanCachedResolutionCache((ModuleDescriptor)md, log$2);
    }

    public static final /* synthetic */ void $anonfun$publish$1(IvySbt.Module module$3, PublishConfiguration configuration$3, String resolverName$1, Option ivyFile$1, scala.collection.immutable.Map artifacts$1, Vector checksums$1, Ivy x0$2, DefaultModuleDescriptor x1$2, String x2$2) {
        DependencyResolver resolver;
        DefaultModuleDescriptor md;
        Tuple3 tuple3 = new Tuple3((Object)x0$2, (Object)x1$2, (Object)x2$2);
        if (tuple3 != null) {
            Ivy ivy = (Ivy)tuple3._1();
            md = (DefaultModuleDescriptor)tuple3._2();
            resolver = ivy.getSettings().getResolver(resolverName$1);
            if (resolver == null) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(21).append("Undefined resolver '").append(resolverName$1).append("'").toString());
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        Option ivyArtifact = ivyFile$1.map((Function1 & Serializable & scala.Serializable)file -> new Tuple2((Object)MDArtifact.newIvyArtifact((ModuleDescriptor)md), file));
        Option<Function1<String, String>> cross = MODULE$.crossVersionMap(module$3.moduleSettings());
        Vector as = (Vector)MODULE$.mapArtifacts((ModuleDescriptor)md, cross, (scala.collection.immutable.Map<Artifact, File>)artifacts$1).$plus$plus((GenTraversableOnce)ivyArtifact.toList(), Vector$.MODULE$.canBuildFrom());
        BoxedUnit boxedUnit = (BoxedUnit)MODULE$.withChecksums(resolver, (Vector<String>)checksums$1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.publish((ModuleDescriptor)md, (Seq<Tuple2<org.apache.ivy.core.module.descriptor.Artifact, File>>)as, resolver, configuration$3.overwrite()));
    }

    public static final /* synthetic */ boolean $anonfun$retrieve$5(Logger log$5, File f) {
        log$5.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Deleting old dependency: ").append(f.getAbsolutePath()).toString());
        return f.delete();
    }

    public static final /* synthetic */ boolean $anonfun$publish$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$publish$5(DependencyResolver resolver$2, boolean overwrite$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        org.apache.ivy.core.module.descriptor.Artifact artifact = (org.apache.ivy.core.module.descriptor.Artifact)tuple2._1();
        File file = (File)tuple2._2();
        resolver$2.publish(artifact, file, overwrite$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$checkFilesPresent$1(Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._2();
        boolean bl = !file.exists();
        return bl;
    }

    private IvyActions$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$publish$1$adapted(IvySbt.Module module$3, PublishConfiguration configuration$3, String resolverName$1, Option ivyFile$1, scala.collection.immutable.Map artifacts$1, Vector checksums$1, Ivy x0$2, DefaultModuleDescriptor x1$2, String x2$2) {
        IvyActions$.$anonfun$publish$1(module$3, configuration$3, resolverName$1, ivyFile$1, artifacts$1, checksums$1, x0$2, x1$2, x2$2);
        return BoxedUnit.UNIT;
    }
}

