/*
 * Decompiled with CFR 0.152.
 */
package sbt.librarymanagement.ivy;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.ivy.util.url.CredentialsStore;
import sbt.internal.librarymanagement.IvyUtil$;
import sbt.io.IO$;
import sbt.librarymanagement.ivy.Credentials;
import sbt.librarymanagement.ivy.DirectCredentials;
import sbt.librarymanagement.ivy.FileCredentials;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Credentials$ {
    public static Credentials$ MODULE$;
    private final List<String> RealmKeys;
    private final List<String> HostKeys;
    private final List<String> UserKeys;
    private final List<String> PasswordKeys;

    static {
        new Credentials$();
    }

    public Credentials apply(String realm, String host, String userName, String passwd) {
        return new DirectCredentials(realm, host, userName, passwd);
    }

    public Credentials apply(File file) {
        return new FileCredentials(file);
    }

    public void add(String realm, String host, String userName, String passwd) {
        CredentialsStore.INSTANCE.addCredentials(realm, host, userName, passwd);
    }

    public void add(File path, Logger log) {
        Either<String, DirectCredentials> either = this.loadCredentials(path);
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            log.warn((Function0 & Serializable & scala.Serializable)() -> err);
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            DirectCredentials dc = (DirectCredentials)right.value();
            this.add(dc.realm(), dc.host(), dc.userName(), dc.passwd());
            return;
        }
        throw new MatchError(either);
    }

    public Option<DirectCredentials> forHost(Seq<Credentials> sc, String host) {
        return this.allDirect(sc).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Credentials$.$anonfun$forHost$1(host, x$1)));
    }

    public Seq<DirectCredentials> allDirect(Seq<Credentials> sc) {
        return (Seq)sc.map((Function1 & Serializable & scala.Serializable)c -> MODULE$.toDirect((Credentials)c), Seq$.MODULE$.canBuildFrom());
    }

    public DirectCredentials toDirect(Credentials c) {
        Credentials credentials = c;
        if (credentials instanceof DirectCredentials) {
            DirectCredentials directCredentials = (DirectCredentials)credentials;
            return directCredentials;
        }
        if (credentials instanceof FileCredentials) {
            FileCredentials fileCredentials = (FileCredentials)credentials;
            Either<String, DirectCredentials> either = this.loadCredentials(fileCredentials.path());
            if (either instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                throw scala.sys.package$.MODULE$.error(err);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                DirectCredentials dc = (DirectCredentials)right.value();
                return dc;
            }
            throw new MatchError(either);
        }
        throw new MatchError((Object)credentials);
    }

    public Either<String, DirectCredentials> loadCredentials(File path) {
        if (path.exists()) {
            Map<String, String> properties = this.read(path);
            Tuple2 tuple2 = IvyUtil$.MODULE$.separate((Seq)new .colon.colon(this.HostKeys, (List)new .colon.colon(this.UserKeys, (List)new .colon.colon(this.PasswordKeys, (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)keys -> Credentials$.get$1(keys, properties, path), List$.MODULE$.canBuildFrom()));
            if (tuple2 != null) {
                List list;
                Some some;
                Seq seq = (Seq)tuple2._1();
                Seq seq2 = (Seq)tuple2._2();
                if (Nil$.MODULE$.equals(seq) && seq2 instanceof List && !(some = List$.MODULE$.unapplySeq((Seq)(list = (List)seq2))).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    List list2;
                    Some some2;
                    Seq seq3;
                    String host = (String)((LinearSeqOptimized)some.get()).apply(0);
                    String user = (String)((LinearSeqOptimized)some.get()).apply(1);
                    String pass = (String)((LinearSeqOptimized)some.get()).apply(2);
                    Tuple2 tuple22 = IvyUtil$.MODULE$.separate((Seq)new .colon.colon(this.RealmKeys, (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)keys -> Credentials$.get$1(keys, properties, path), List$.MODULE$.canBuildFrom()));
                    if (tuple22 != null && (seq3 = (Seq)tuple22._2()) instanceof List && !(some2 = List$.MODULE$.unapplySeq((Seq)(list2 = (List)seq3))).isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                        String realm = (String)((LinearSeqOptimized)some2.get()).apply(0);
                        return package$.MODULE$.Right().apply((Object)new DirectCredentials(realm, host, user, pass));
                    }
                    return package$.MODULE$.Right().apply((Object)new DirectCredentials(null, host, user, pass));
                }
            }
            if (tuple2 != null) {
                Seq errors2 = (Seq)tuple2._1();
                return package$.MODULE$.Left().apply((Object)errors2.mkString("\n"));
            }
            throw new MatchError(tuple2);
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(32).append("Credentials file ").append(path).append(" does not exist").toString());
    }

    public void register(Seq<Credentials> cs, Logger log) {
        cs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Credentials$.$anonfun$register$1(log, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, String> read(File from) {
        Properties properties = new Properties();
        IO$.MODULE$.load(properties, from);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.toString(), (Object)v.toString().trim());
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$forHost$1(String host$1, DirectCredentials x$1) {
        String string = x$1.host();
        String string2 = host$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Either get$1(List keys, Map properties$1, File path$1) {
        return ((TraversableLike)keys.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(properties$1.get(key)), List$.MODULE$.canBuildFrom())).headOption().toRight((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append((String)keys.head()).append(" not specified in credentials file: ").append(path$1).toString());
    }

    public static final /* synthetic */ void $anonfun$register$1(Logger log$1, Credentials x0$1) {
        Credentials credentials = x0$1;
        if (credentials instanceof FileCredentials) {
            FileCredentials fileCredentials = (FileCredentials)credentials;
            MODULE$.add(fileCredentials.path(), log$1);
            return;
        }
        if (credentials instanceof DirectCredentials) {
            DirectCredentials directCredentials = (DirectCredentials)credentials;
            MODULE$.add(directCredentials.realm(), directCredentials.host(), directCredentials.userName(), directCredentials.passwd());
            return;
        }
        throw new MatchError((Object)credentials);
    }

    private Credentials$() {
        MODULE$ = this;
        this.RealmKeys = new .colon.colon((Object)"realm", (List)Nil$.MODULE$);
        this.HostKeys = new .colon.colon((Object)"host", (List)new .colon.colon((Object)"hostname", (List)Nil$.MODULE$));
        this.UserKeys = new .colon.colon((Object)"user", (List)new .colon.colon((Object)"user.name", (List)new .colon.colon((Object)"username", (List)Nil$.MODULE$)));
        this.PasswordKeys = new .colon.colon((Object)"password", (List)new .colon.colon((Object)"pwd", (List)new .colon.colon((Object)"pass", (List)new .colon.colon((Object)"passwd", (List)Nil$.MODULE$))));
    }
}

