/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import sbt.AutoPlugin;
import sbt.ClasspathDep;
import sbt.Plugins;
import sbt.ProjectOrigin;
import sbt.ProjectReference;
import sbt.internal.util.Init;
import sbt.librarymanagement.Configuration;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;

public interface ProjectDefinition<PR extends ProjectReference> {
    public String id();

    public File base();

    public Seq<Configuration> configurations();

    public Seq<Init.Setting<?>> settings();

    public Seq<PR> aggregate();

    public Seq<ClasspathDep<PR>> dependencies();

    public static Seq uses$(ProjectDefinition $this) {
        return $this.uses();
    }

    default public Seq<PR> uses() {
        return (Seq)this.aggregate().$plus$plus((IterableOnce)this.dependencies().map((Function1 & Serializable)_$1 -> _$1.project()));
    }

    public static Seq referenced$(ProjectDefinition $this) {
        return $this.referenced();
    }

    default public Seq<PR> referenced() {
        return this.uses();
    }

    public Plugins plugins();

    public ProjectOrigin projectOrigin();

    public Seq<AutoPlugin> autoPlugins();

    public Seq<Init.Setting<?>> commonSettings();

    public static int hashCode$(ProjectDefinition $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        return this.id().hashCode() ^ this.base().hashCode() ^ this.getClass().hashCode();
    }

    public static boolean equals$(ProjectDefinition $this, Object o) {
        return $this.equals(o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof ProjectDefinition)) return false;
        ProjectDefinition p = (ProjectDefinition)object;
        Class<?> clazz = p.getClass();
        Class<?> clazz2 = this.getClass();
        if (clazz == null) {
            if (clazz2 != null) {
                return false;
            }
        } else if (!clazz.equals(clazz2)) return false;
        String string = p.id();
        String string2 = this.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        File file = p.base();
        File file2 = this.base();
        if (file == null) {
            if (file2 == null) return true;
            return false;
        } else {
            if (!((Object)file).equals(file2)) return false;
            return true;
        }
    }

    public static String toString$(ProjectDefinition $this) {
        return $this.toString();
    }

    default public String toString() {
        List<String> agg = this.ifNonEmpty("aggregate", (Iterable)this.aggregate());
        List<String> dep = this.ifNonEmpty("dependencies", (Iterable)this.dependencies());
        List<String> conf = this.ifNonEmpty("configurations", (Iterable)this.configurations());
        List<String> autos = this.ifNonEmpty("autoPlugins", (Iterable)this.autoPlugins().map((Function1 & Serializable)_$2 -> _$2.label()));
        String string = new StringBuilder(3).append("id ").append(this.id()).toString();
        String string2 = new StringBuilder(6).append("base: ").append(this.base()).toString();
        String string3 = new StringBuilder(15).append("plugins: List(").append(this.plugins()).append(")").toString();
        List fields = autos.$colon$colon((Object)string3).$colon$colon$colon(conf).$colon$colon$colon(dep).$colon$colon$colon(agg).$colon$colon((Object)string2).$colon$colon((Object)string);
        return new StringBuilder(9).append("Project(").append(fields.mkString(", ")).append(")").toString();
    }

    private <T> List<String> ifNonEmpty(String label, Iterable<T> ts) {
        if (ts.isEmpty()) {
            return package$.MODULE$.Nil();
        }
        String string = new StringBuilder(2).append(label).append(": ").append(ts).toString();
        return package$.MODULE$.Nil().$colon$colon((Object)string);
    }
}

