/*
 * Decompiled with CFR 0.152.
 */
package sbt.nio;

import java.io.Serializable;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;
import sbt.BasicCommandStrings$;
import sbt.Def$;
import sbt.Exec;
import sbt.Keys$;
import sbt.ProjectRef;
import sbt.Reference;
import sbt.SlashSyntax0$;
import sbt.State;
import sbt.State$;
import sbt.ThisBuild$;
import sbt.Watched$;
import sbt.internal.LabeledFunctions;
import sbt.internal.LabeledFunctions$;
import sbt.internal.util.AttributeMap;
import sbt.internal.util.GlobalLogging;
import sbt.internal.util.Init;
import sbt.internal.util.LinePosition;
import sbt.internal.util.SourcePosition;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.Parser$;
import sbt.nio.Watch;
import sbt.nio.Watch$Action$ordering$;
import sbt.nio.Watch$CancelWatch$;
import sbt.nio.Watch$Ignore$;
import sbt.nio.Watch$InputOption$;
import sbt.nio.Watch$Prompt$;
import sbt.nio.Watch$Reload$;
import sbt.nio.Watch$Run$;
import sbt.nio.Watch$ShowOptions$;
import sbt.nio.Watch$StringToExec$;
import sbt.nio.Watch$Trigger$;
import sbt.std.InitializeInstance$;
import sbt.util.Level$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;
import xsbti.AppConfiguration;

public final class Watch$ {
    public static Watch$ MODULE$;
    public final DateTimeFormatter sbt$nio$Watch$$formatter;
    public final ZoneId sbt$nio$Watch$$timeZone;
    public final String sbt$nio$Watch$$timeZoneName;
    private final Function2<Object, Watch.Event, Watch.Action> trigger;
    private final FiniteDuration defaultAntiEntropy;
    private final FiniteDuration defaultAntiEntropyPollPeriod;
    private final FiniteDuration defaultAntiEntropyRetentionPeriod;
    private final FiniteDuration defaultDeletionQuarantinePeriod;
    private final Seq<Watch.InputOption> defaultInputOptions;
    private final Function3<Object, ProjectRef, Seq<String>, Option<String>> defaultStartWatch;
    private final Function0<BoxedUnit> defaultBeforeCommand;
    private final Function4<Watch.Action, String, Object, State, State> defaultCommandOnTermination;
    private final Function4<Watch.Action, String, Object, State, State> defaultTaskOnTermination;
    private final Function3<Object, Path, Seq<String>, Option<String>> defaultOnTriggerMessage;
    private final Function3<Object, Path, Seq<String>, Option<String>> noTriggerMessage;
    private final FiniteDuration defaultPollInterval;
    private final Function0<BoxedUnit> clearScreen;
    private final Function3<Object, Path, Seq<String>, Option<String>> clearScreenOnTrigger;

    static {
        new Watch$();
    }

    public Duration sbt$nio$Watch$$DurationOps(Duration d) {
        return d;
    }

    public Watch.Event EventOps(Watch.Event event) {
        return event;
    }

    public Watch.Action apply(Function0<BoxedUnit> task, Function0<Watch.Action> onStart, Function0<Watch.Action> nextAction) {
        return this.apply(0, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> task.apply$mcV$sp(), (Function1<Object, Watch.Action>)(Function1 & Serializable & scala.Serializable)x$5 -> Watch$.$anonfun$apply$2(onStart, BoxesRunTime.unboxToInt((Object)x$5)), (Function1<Object, Watch.Action>)(Function1 & Serializable & scala.Serializable)x$6 -> Watch$.$anonfun$apply$3(nextAction, BoxesRunTime.unboxToInt((Object)x$6)), true);
    }

    public Watch.Action apply(int initialCount, Function1<Object, BoxedUnit> task, Function1<Object, Watch.Action> onStart, Function1<Object, Watch.Action> nextAction, boolean recursive) {
        Watch.Action action;
        try {
            action = this.impl$1(initialCount, task, onStart, recursive, nextAction);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                action = new Watch.HandleError(t);
            }
            throw throwable;
        }
        return action;
    }

    public Option<Tuple2<Watch.Action, Watch.Event>> aggregate(Seq<Tuple2<Watch.Action, Watch.Event>> events) {
        if (events.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(events.minBy((Function1 & Serializable & scala.Serializable)x$7 -> (Watch.Action)x$7._1(), (Ordering)Watch$Action$ordering$.MODULE$));
    }

    private String StringToExec(String s) {
        return s;
    }

    public final Function2<Object, Watch.Event, Watch.Action> trigger() {
        return this.trigger;
    }

    public final FiniteDuration defaultAntiEntropy() {
        return this.defaultAntiEntropy;
    }

    public final FiniteDuration defaultAntiEntropyPollPeriod() {
        return this.defaultAntiEntropyPollPeriod;
    }

    public final FiniteDuration defaultAntiEntropyRetentionPeriod() {
        return this.defaultAntiEntropyRetentionPeriod;
    }

    public final FiniteDuration defaultDeletionQuarantinePeriod() {
        return this.defaultDeletionQuarantinePeriod;
    }

    public final Parser<Watch.Action> defaultInputParser(Seq<Watch.InputOption> options) {
        Seq<Watch.InputOption> seq = this.distinctOptions(options);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.literal('\n')).$bar(Parser$.MODULE$.literal('\r'))).$bar(Parser$.MODULE$.literal((char)4))).$up$up$up((Object)Watch$Run$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})));
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) >= 0) {
            Watch.InputOption h = (Watch.InputOption)((SeqLike)some2.get()).apply(0);
            Seq rest = (Seq)((IterableLike)some2.get()).drop(1);
            return (Parser)rest.foldLeft(h.parser(), (Function2 & Serializable & scala.Serializable)(x$10, x$11) -> Parser$.MODULE$.richParser(x$10).$bar(x$11.parser()));
        }
        throw new MatchError(seq);
    }

    public final Seq<Watch.InputOption> defaultInputOptions() {
        return this.defaultInputOptions;
    }

    public String defaultInputOptionsMessage(Seq<Watch.InputOption> options) {
        Seq opts = (Seq)this.distinctOptions(options).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12.input(), (Ordering)Ordering.String$.MODULE$);
        int alignmentLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)opts.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)Watch$.$anonfun$defaultInputOptionsMessage$2(x$13)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) + 1;
        Seq formatted = (Seq)opts.map((Function1 & Serializable & scala.Serializable)o -> new StringBuilder(2).append(o.display()).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(alignmentLength - o.display().length())).append(": ").append(o.description()).toString(), Seq$.MODULE$.canBuildFrom());
        return new StringBuilder(9).append("Options:\n").append(formatted.mkString("  ", "\n  ", "")).toString();
    }

    private Seq<Watch.InputOption> distinctOptions(Seq<Watch.InputOption> options) {
        Set distinctOpts = Set$.MODULE$.empty();
        ArrayBuffer opts = new ArrayBuffer();
        Seq seq = options;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        ((IterableLike)(!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0 ? Option$.MODULE$.option2Iterable(this.defaultInputOptions().headOption()).toSeq() : seq).reverse()).foreach((Function1 & Serializable & scala.Serializable)o -> {
            if (distinctOpts.add((Object)o.input())) {
                return opts.$plus$eq(o);
            }
            return BoxedUnit.UNIT;
        });
        return (Seq)opts.toSeq().reverse();
    }

    private Seq<String> waitMessage(ProjectRef project, Seq<String> commands) {
        String cmds = ((TraversableOnce)commands.map((Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(1).append(project.project()).append("/").append(x$14.trim()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("; ");
        return (Seq)new .colon.colon((Object)new StringBuilder(31).append("Monitoring source files for ").append(cmds).append("...").toString(), (List)new .colon.colon((Object)"Press <enter> to interrupt or '?' for more options.", (List)Nil$.MODULE$));
    }

    public Function3<Object, ProjectRef, Seq<String>, Option<String>> defaultStartWatch() {
        return this.defaultStartWatch;
    }

    public Function0<BoxedUnit> defaultBeforeCommand() {
        return this.defaultBeforeCommand;
    }

    public Function4<Watch.Action, String, Object, State, State> defaultCommandOnTermination() {
        return this.defaultCommandOnTermination;
    }

    public Function4<Watch.Action, String, Object, State, State> defaultTaskOnTermination() {
        return this.defaultTaskOnTermination;
    }

    private Function4<Watch.Action, String, Object, State, State> onTerminationImpl(Seq<String> watchPrefixes) {
        return (Function4 & Serializable & scala.Serializable)(action, command, count, state) -> Watch$.$anonfun$onTerminationImpl$1(watchPrefixes, action, command, BoxesRunTime.unboxToInt((Object)count), state);
    }

    public final Function3<Object, Path, Seq<String>, Option<String>> defaultOnTriggerMessage() {
        return this.defaultOnTriggerMessage;
    }

    public final Function3<Object, Path, Seq<String>, Option<String>> noTriggerMessage() {
        return this.noTriggerMessage;
    }

    public final FiniteDuration defaultPollInterval() {
        return this.defaultPollInterval;
    }

    public final Function0<BoxedUnit> clearScreen() {
        return this.clearScreen;
    }

    public final Function3<Object, Path, Seq<String>, Option<String>> clearScreenOnTrigger() {
        return this.clearScreenOnTrigger;
    }

    public Seq<Init.Setting<?>> defaults() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Init.Setting[]{Keys$.MODULE$.watchAntiEntropy().set(Def$.MODULE$.valueStrict((Object)this.defaultAntiEntropy()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 614)), sbt.nio.Keys$.MODULE$.watchAntiEntropyRetentionPeriod().set(Def$.MODULE$.valueStrict((Object)this.defaultAntiEntropyRetentionPeriod()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 615)), sbt.nio.Keys$.MODULE$.watchLogLevel().set(Def$.MODULE$.valueStrict((Object)Level$.MODULE$.Info()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 616)), sbt.nio.Keys$.MODULE$.watchBeforeCommand().set(Def$.MODULE$.valueStrict(this.defaultBeforeCommand()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 617)), sbt.nio.Keys$.MODULE$.watchOnFileInputEvent().set(Def$.MODULE$.valueStrict(this.trigger()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 618)), sbt.nio.Keys$.MODULE$.watchDeletionQuarantinePeriod().set(Def$.MODULE$.valueStrict((Object)this.defaultDeletionQuarantinePeriod()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 619)), Keys$.MODULE$.watchService().set(Def$.MODULE$.valueStrict((Object)Watched$.MODULE$.newWatchService()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 620)), sbt.nio.Keys$.MODULE$.watchInputOptions().set(Def$.MODULE$.valueStrict(this.defaultInputOptions()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 621)), sbt.nio.Keys$.MODULE$.watchStartMessage().set(Def$.MODULE$.valueStrict(this.defaultStartWatch()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 622)), sbt.nio.Keys$.MODULE$.watchTriggeredMessage().set(Def$.MODULE$.valueStrict(this.defaultOnTriggerMessage()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 623)), sbt.nio.Keys$.MODULE$.watchForceTriggerOnAnyChange().set(Def$.MODULE$.valueStrict((Object)BoxesRunTime.boxToBoolean((boolean)false)), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 624)), sbt.nio.Keys$.MODULE$.watchPersistFileStamps().set(InitializeInstance$.MODULE$.map((Init.Initialize)SlashSyntax0$.MODULE$.sbtSlashSyntaxRichReference((Reference)ThisBuild$.MODULE$).$div(Keys$.MODULE$.turbo()), (Function1 & Serializable & scala.Serializable)$q$macro$1 -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)$q$macro$1))), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 625)), sbt.nio.Keys$.MODULE$.watchTriggers().set(Def$.MODULE$.valueStrict((Object)Nil$.MODULE$), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 626)), sbt.nio.Keys$.MODULE$.watchAntiEntropyPollPeriod().set(InitializeInstance$.MODULE$.pure((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultAntiEntropyPollPeriod()), (SourcePosition)new LinePosition("(sbt.nio.Watch.defaults) Watch.scala", 627))}));
    }

    public static final /* synthetic */ Watch.Action $anonfun$apply$2(Function0 onStart$1, int x$5) {
        return (Watch.Action)onStart$1.apply();
    }

    public static final /* synthetic */ Watch.Action $anonfun$apply$3(Function0 nextAction$1, int x$6) {
        return (Watch.Action)nextAction$1.apply();
    }

    private static final Watch.Action safeNextAction$1(int count, Function1 delegate) {
        Watch.Action action;
        try {
            action = (Watch.Action)delegate.apply((Object)BoxesRunTime.boxToInteger((int)count));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                System.err.println("Watch caught unexpected error:");
                t.printStackTrace(System.err);
                action = new Watch.HandleError(t);
            }
            throw throwable;
        }
        return action;
    }

    private final Watch.Action next$1(int count, Function1 nextAction$2) {
        Watch.Action action;
        while (Watch$Ignore$.MODULE$.equals(action = Watch$.safeNextAction$1(count, nextAction$2))) {
        }
        return action;
    }

    private final Watch.Action impl$1(int count, Function1 task$2, Function1 onStart$2, boolean recursive$1, Function1 nextAction$2) {
        Watch.Action action;
        block4: {
            while (true) {
                task$2.apply$mcVI$sp(count);
                action = Watch$.safeNextAction$1(count, onStart$2);
                if (Watch$Ignore$.MODULE$.equals(action)) {
                    Watch.Action action2 = this.next$1(count, nextAction$2);
                    if (Watch$Trigger$.MODULE$.equals(action2)) {
                        if (recursive$1) {
                            ++count;
                            continue;
                        }
                        task$2.apply$mcVI$sp(count);
                        return Watch$Trigger$.MODULE$;
                    }
                    return action2;
                }
                if (!Watch$Trigger$.MODULE$.equals(action)) break block4;
                if (!recursive$1) break;
                ++count;
            }
            task$2.apply$mcVI$sp(count);
            return Watch$Trigger$.MODULE$;
        }
        return action;
    }

    public static final /* synthetic */ Watch$Trigger$ $anonfun$trigger$1(int x$8, Watch.Event x$9) {
        return Watch$Trigger$.MODULE$;
    }

    public static final /* synthetic */ int $anonfun$defaultInputOptionsMessage$2(Watch.InputOption x$13) {
        return x$13.display().length();
    }

    public static final /* synthetic */ Some $anonfun$defaultStartWatch$1(int count, ProjectRef project, Seq commands) {
        String countStr = new StringBuilder(2).append(count).append(". ").toString();
        return new Some((Object)new StringBuilder(0).append(countStr).append(MODULE$.waitMessage(project, (Seq<String>)commands).mkString(new StringBuilder(1).append("\n").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(countStr.length())).toString())).toString());
    }

    public static final /* synthetic */ boolean $anonfun$onTerminationImpl$2(Seq watchPrefixes$1, Exec c) {
        String string = c.commandLine().trim();
        return watchPrefixes$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.startsWith(x$1)));
    }

    public static final /* synthetic */ State $anonfun$onTerminationImpl$1(Seq watchPrefixes$1, Watch.Action action, String command, int count, State state) {
        Watch.Run run2;
        Option<List<Exec>> option;
        String prefix = (String)watchPrefixes$1.head();
        List rc = (List)state.remainingCommands().filterNot((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Watch$.$anonfun$onTerminationImpl$2(watchPrefixes$1, c)));
        Watch.Action action2 = action;
        if (action2 instanceof Watch.Run && !(option = Watch$Run$.MODULE$.unapply(run2 = (Watch.Run)action2)).isEmpty()) {
            List commands = (List)option.get();
            List x$1 = (List)commands.$plus$plus((GenTraversableOnce)rc, List$.MODULE$.canBuildFrom());
            AppConfiguration x$2 = state.copy$default$1();
            Seq x$3 = state.copy$default$2();
            scala.collection.immutable.Set x$4 = state.copy$default$3();
            Option x$5 = state.copy$default$4();
            State.History x$6 = state.copy$default$6();
            AttributeMap x$7 = state.copy$default$7();
            GlobalLogging x$8 = state.copy$default$8();
            Option x$9 = state.copy$default$9();
            State.Next x$10 = state.copy$default$10();
            return state.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
        }
        if (Watch$Reload$.MODULE$.equals(action2)) {
            Exec exec = Watch$StringToExec$.MODULE$.toExec$extension(MODULE$.StringToExec("reload"));
            Exec exec2 = Watch$StringToExec$.MODULE$.toExec$extension(MODULE$.StringToExec(new StringBuilder(2).append(prefix).append(" ").append(count).append(" ").append(command).toString()));
            List x$11 = rc.$colon$colon((Object)exec2).$colon$colon((Object)exec);
            AppConfiguration x$12 = state.copy$default$1();
            Seq x$13 = state.copy$default$2();
            scala.collection.immutable.Set x$14 = state.copy$default$3();
            Option x$15 = state.copy$default$4();
            State.History x$16 = state.copy$default$6();
            AttributeMap x$17 = state.copy$default$7();
            GlobalLogging x$18 = state.copy$default$8();
            Option x$19 = state.copy$default$9();
            State.Next x$20 = state.copy$default$10();
            return state.copy(x$12, x$13, x$14, x$15, x$11, x$16, x$17, x$18, x$19, x$20);
        }
        if (action2 instanceof Watch.HandleError) {
            List x$21 = rc;
            AppConfiguration x$22 = state.copy$default$1();
            Seq x$23 = state.copy$default$2();
            scala.collection.immutable.Set x$24 = state.copy$default$3();
            Option x$25 = state.copy$default$4();
            State.History x$26 = state.copy$default$6();
            AttributeMap x$27 = state.copy$default$7();
            GlobalLogging x$28 = state.copy$default$8();
            Option x$29 = state.copy$default$9();
            State.Next x$30 = state.copy$default$10();
            return State.StateOpsImpl$.MODULE$.fail$extension(State$.MODULE$.StateOpsImpl(state.copy(x$22, x$23, x$24, x$25, x$21, x$26, x$27, x$28, x$29, x$30)));
        }
        List x$31 = rc;
        AppConfiguration x$32 = state.copy$default$1();
        Seq x$33 = state.copy$default$2();
        scala.collection.immutable.Set x$34 = state.copy$default$3();
        Option x$35 = state.copy$default$4();
        State.History x$36 = state.copy$default$6();
        AttributeMap x$37 = state.copy$default$7();
        GlobalLogging x$38 = state.copy$default$8();
        Option x$39 = state.copy$default$9();
        State.Next x$40 = state.copy$default$10();
        return state.copy(x$32, x$33, x$34, x$35, x$31, x$36, x$37, x$38, x$39, x$40);
    }

    public static final /* synthetic */ Some $anonfun$defaultOnTriggerMessage$1(int x$17, Path path, Seq commands) {
        String msg = new StringBuilder(30).append("Build triggered by ").append(path).append(". ").append("Running ").append(commands.mkString("'", "; ", "'")).append(".").toString();
        return new Some((Object)msg);
    }

    public static final /* synthetic */ None$ $anonfun$noTriggerMessage$1(int x$18, Path x$19, Seq x$20) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$clearScreenOnTrigger$1(int count, Path path, Seq commands) {
        MODULE$.clearScreen().apply$mcV$sp();
        return (Option)MODULE$.defaultOnTriggerMessage().apply((Object)BoxesRunTime.boxToInteger((int)count), (Object)path, (Object)commands);
    }

    private Watch$() {
        MODULE$ = this;
        this.sbt$nio$Watch$$formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd HH:mm:ss.SSS");
        this.sbt$nio$Watch$$timeZone = ZoneId.systemDefault();
        this.sbt$nio$Watch$$timeZoneName = this.sbt$nio$Watch$$timeZone.getDisplayName(TextStyle.SHORT, Locale.getDefault());
        this.trigger = LabeledFunctions.Function2Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function2Ops((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> Watch$.$anonfun$trigger$1(BoxesRunTime.unboxToInt((Object)x$8), x$9)), "Watched.trigger");
        this.defaultAntiEntropy = new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds();
        this.defaultAntiEntropyPollPeriod = new package.DurationInt(package$.MODULE$.DurationInt(5)).milliseconds();
        this.defaultAntiEntropyRetentionPeriod = new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes();
        this.defaultDeletionQuarantinePeriod = new package.DurationInt(package$.MODULE$.DurationInt(50)).milliseconds();
        this.defaultInputOptions = (Seq)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply("<enter>", "interrupt (exits sbt in batch mode)", Watch$CancelWatch$.MODULE$, (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{'\n', '\r'})), (List)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply((char)4, "<ctrl-d>", "interrupt (exits sbt in batch mode)", (Watch.Action)Watch$CancelWatch$.MODULE$), (List)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply('l', "reload the build", (Watch.Action)Watch$Reload$.MODULE$), (List)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply('r', "re-run the command", (Watch.Action)Watch$Trigger$.MODULE$), (List)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply('s', "return to shell", (Watch.Action)Watch$Prompt$.MODULE$), (List)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply('q', "quit sbt", (Watch.Action)Watch$Run$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{BasicCommandStrings$.MODULE$.TerminateAction()}))), (List)new .colon.colon((Object)Watch$InputOption$.MODULE$.apply('?', "print options", (Watch.Action)Watch$ShowOptions$.MODULE$), (List)Nil$.MODULE$)))))));
        this.defaultStartWatch = LabeledFunctions.Function3Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function3Ops((Function3 & Serializable & scala.Serializable)(count, project, commands) -> Watch$.$anonfun$defaultStartWatch$1(BoxesRunTime.unboxToInt((Object)count), project, commands)), "Watched.defaultStartWatch");
        this.defaultBeforeCommand = LabeledFunctions.Function0Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function0Ops((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}), "Watch.defaultBeforeCommand");
        this.defaultCommandOnTermination = LabeledFunctions.Function4Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function4Ops(this.onTerminationImpl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{BasicCommandStrings$.MODULE$.ContinuousExecutePrefix()}))), "Watched.defaultCommandOnTermination");
        this.defaultTaskOnTermination = LabeledFunctions.Function4Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function4Ops(this.onTerminationImpl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"watch", BasicCommandStrings$.MODULE$.ContinuousExecutePrefix()}))), "Watched.defaultTaskOnTermination");
        this.defaultOnTriggerMessage = LabeledFunctions.Function3Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function3Ops((Function3 & Serializable & scala.Serializable)(x$17, path, commands) -> Watch$.$anonfun$defaultOnTriggerMessage$1(BoxesRunTime.unboxToInt((Object)x$17), path, commands)), "Watched.defaultOnTriggerMessage");
        this.noTriggerMessage = (Function3 & Serializable & scala.Serializable)(x$18, x$19, x$20) -> Watch$.$anonfun$noTriggerMessage$1(BoxesRunTime.unboxToInt((Object)x$18), x$19, x$20);
        this.defaultPollInterval = new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds();
        this.clearScreen = LabeledFunctions.Function0Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function0Ops((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.println((Object)"\u001b[2J\u001b[0;0H")), "Watch.clearScreen");
        this.clearScreenOnTrigger = LabeledFunctions.Function3Ops$.MODULE$.label$extension(LabeledFunctions$.MODULE$.Function3Ops((Function3 & Serializable & scala.Serializable)(count, path, commands) -> Watch$.$anonfun$clearScreenOnTrigger$1(BoxesRunTime.unboxToInt((Object)count), path, commands)), "Watch.clearScreenOnTrigger");
    }
}

