/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.BottomClassLoader;
import sbt.internal.ClassLoadingLock;
import sbt.internal.ManagedClassLoader;
import sbt.util.Logger;

final class ReverseLookupClassLoader
extends ManagedClassLoader {
    private final AtomicReference<BottomClassLoader> directDescendant = new AtomicReference();
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private final ClassLoadingLock classLoadingLock = new ClassLoadingLock();
    private final ClassLoader parent;

    ReverseLookupClassLoader(URL[] uRLArray, ClassLoader classLoader, boolean bl, boolean bl2, Logger logger) {
        super(uRLArray, classLoader, bl, bl2, logger);
        this.parent = classLoader;
    }

    boolean isDirty() {
        return this.dirty.get();
    }

    void setDescendant(BottomClassLoader bottomClassLoader) {
        this.directDescendant.set(bottomClassLoader);
    }

    @Override
    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        return uRL != null ? uRL : this.directDescendant.get().findResource(string);
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        final Enumeration<URL> enumeration = super.findResources(string);
        if (this.directDescendant.get() == null) {
            return enumeration;
        }
        final Enumeration<URL> enumeration2 = this.directDescendant.get().findResources(string);
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements() || enumeration2.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (enumeration.hasMoreElements()) {
                    return (URL)enumeration.nextElement();
                }
                return (URL)enumeration2.nextElement();
            }
        };
    }

    void setup(File file) {
        this.setTempDir(file);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClass(string, bl, true);
    }

    Class<?> loadClass(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = this.parent.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.findClass(string, bl2);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private Class<?> findClass(String string, boolean bl) throws ClassNotFoundException {
        return this.classLoadingLock.withLock(string, () -> {
            try {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz != null) {
                    return clazz;
                }
                return this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    BottomClassLoader bottomClassLoader = this.directDescendant.get();
                    if (bottomClassLoader == null) {
                        throw classNotFoundException;
                    }
                    Class<?> clazz = bottomClassLoader.findClass(string);
                    this.dirty.set(true);
                    return clazz;
                }
                throw classNotFoundException;
            }
        });
    }

    static {
        ReverseLookupClassLoader.registerAsParallelCapable();
    }
}

