/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.librarymanagement;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.Command;
import sbt.Command$;
import sbt.Extracted;
import sbt.Keys$;
import sbt.Project$;
import sbt.State;
import sbt.State$;
import sbt.internal.sona.PublishingType;
import sbt.internal.sona.Sona;
import sbt.internal.sona.Sona$;
import sbt.internal.util.MessageOnlyException;
import sbt.io.IO$;
import sbt.io.Path$;
import sbt.librarymanagement.ivy.Credentials;
import sbt.librarymanagement.ivy.Credentials$;
import sbt.librarymanagement.ivy.DirectCredentials;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public final class Publishing$ {
    public static Publishing$ MODULE$;
    private final Command sonaRelease;
    private final Command sonaUpload;

    static {
        new Publishing$();
    }

    public Command sonaRelease() {
        return this.sonaRelease;
    }

    public Command sonaUpload() {
        return this.sonaUpload;
    }

    public Path makeBundle(Path stagingDir, Path bundlePath) {
        if (bundlePath.toFile().exists()) {
            IO$.MODULE$.delete(bundlePath.toFile());
        }
        IO$.MODULE$.zip((Traversable)Path$.MODULE$.contentOf(stagingDir.toFile()), bundlePath.toFile(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        return bundlePath;
    }

    private State sonatypeReleaseAction(PublishingType publishingType, State s0) {
        State state;
        Extracted extracted = Project$.MODULE$.extract(s0);
        Logger log = extracted.get(Keys$.MODULE$.sLog());
        String version = extracted.get(Keys$.MODULE$.version());
        if (version.endsWith("-SNAPSHOT")) {
            log.error((Function0 & Serializable & scala.Serializable)() -> "SNAPSHOTs are not supported on the Central Portal;\nconfigure ThisBuild / publishTo to publish directly to the central-snapshots.\nsee https://www.scala-sbt.org/1.x/docs/Using-Sonatype.html for details.");
            return State.StateOpsImpl$.MODULE$.fail$extension(State$.MODULE$.StateOpsImpl(s0));
        }
        String deploymentName = extracted.get(Keys$.MODULE$.sonaDeploymentName());
        FiniteDuration uploadRequestTimeout = extracted.get(Keys$.MODULE$.sonaUploadRequestTimeout());
        Tuple2<State, File> tuple2 = extracted.runTask(Keys$.MODULE$.sonaBundle(), s0);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        State s1 = (State)tuple2._1();
        File bundle = (File)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)s1, (Object)bundle);
        State s12 = (State)tuple22._1();
        File bundle2 = (File)tuple22._2();
        Tuple2<State, Seq<Credentials>> tuple23 = extracted.runTask(Keys$.MODULE$.credentials(), s12);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        State s2 = (State)tuple23._1();
        Seq creds = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)s2, (Object)creds);
        State s22 = (State)tuple24._1();
        Seq creds2 = (Seq)tuple24._2();
        try (Sona client = this.fromCreds((Seq<Credentials>)creds2, uploadRequestTimeout);){
            client.uploadBundle(bundle2.toPath(), deploymentName, publishingType, log);
            state = s22;
        }
        return state;
    }

    private Sona fromCreds(Seq<Credentials> creds, FiniteDuration uploadRequestTimeout) {
        DirectCredentials cred = (DirectCredentials)Credentials$.MODULE$.forHost(creds, Sona$.MODULE$.host()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MessageOnlyException(new StringBuilder(29).append("no credentials are found for ").append(Sona$.MODULE$.host()).toString());
        });
        return Sona$.MODULE$.oauthClient(cred.userName(), cred.passwd(), uploadRequestTimeout);
    }

    private Publishing$() {
        MODULE$ = this;
        this.sonaRelease = Command$.MODULE$.command("sonaRelease", Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)s0 -> MODULE$.sonatypeReleaseAction((PublishingType)PublishingType.Automatic$.MODULE$, (State)s0));
        this.sonaUpload = Command$.MODULE$.command("sonaUpload", Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)s0 -> MODULE$.sonatypeReleaseAction((PublishingType)PublishingType.UserManaged$.MODULE$, (State)s0));
    }
}

