/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.BottomClassLoader;
import sbt.internal.ClassLoadingLock;
import sbt.internal.ManagedClassLoader;
import sbt.util.Logger;

final class ReverseLookupClassLoader
extends ManagedClassLoader {
    private final AtomicReference<BottomClassLoader> directDescendant = new AtomicReference();
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private final ClassLoadingLock classLoadingLock = new ClassLoadingLock();
    private final ClassLoader parent;

    ReverseLookupClassLoader(URL[] urls, ClassLoader parent, boolean close, boolean allowZombies, Logger logger) {
        super(urls, parent, close, allowZombies, logger);
        this.parent = parent;
    }

    boolean isDirty() {
        return this.dirty.get();
    }

    void setDescendant(BottomClassLoader bottomClassLoader) {
        this.directDescendant.set(bottomClassLoader);
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        return url != null ? url : this.directDescendant.get().findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration<URL> parentResources = super.findResources(name);
        if (this.directDescendant.get() == null) {
            return parentResources;
        }
        final Enumeration<URL> directDescendantResources = this.directDescendant.get().findResources(name);
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return parentResources.hasMoreElements() || directDescendantResources.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (parentResources.hasMoreElements()) {
                    return (URL)parentResources.nextElement();
                }
                return (URL)directDescendantResources.nextElement();
            }
        };
    }

    void setup(File tmpDir) {
        this.setTempDir(tmpDir);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true);
    }

    Class<?> loadClass(String name, boolean resolve, boolean childLookup) throws ClassNotFoundException {
        Class<?> result;
        try {
            result = this.parent.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            result = this.findClass(name, childLookup);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private Class<?> findClass(String name, boolean childLookup) throws ClassNotFoundException {
        return this.classLoadingLock.withLock(name, () -> {
            try {
                Class<?> prev = this.findLoadedClass(name);
                if (prev != null) {
                    return prev;
                }
                return this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                if (childLookup) {
                    BottomClassLoader loader = this.directDescendant.get();
                    if (loader == null) {
                        throw e;
                    }
                    Class<?> clazz = loader.findClass(name);
                    this.dirty.set(true);
                    return clazz;
                }
                throw e;
            }
        });
    }

    static {
        ReverseLookupClassLoader.registerAsParallelCapable();
    }
}

