/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import sbt.BasicCommandStrings$;
import sbt.Help;
import sbt.Help$;
import sbt.State;
import sbt.State$;
import sbt.io.Path$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class CommandStrings$ {
    public static CommandStrings$ MODULE$;
    private final String AboutCommand;
    private final String TasksCommand;
    private final String SettingsCommand;
    private final String ProjectCommand;
    private final String ProjectsCommand;
    private final String ShowCommand;
    private final String PrintCommand;
    private final String MultiTaskCommand;
    private final String BootCommand;
    private final String EvalCommand;
    private final Tuple2<String, String> evalBrief;
    private final String evalDetailed;
    private final String PluginsCommand;
    private final String PluginCommand;
    private final String LastCommand;
    private final String OldLastGrepCommand;
    private final String LastGrepCommand;
    private final String ExportCommand;
    private final String ExportStream;
    private final Tuple2<String, String> oldLastGrepBrief;
    private final String oldLastGrepDetailed;
    private final Tuple2<String, String> lastGrepBrief;
    private final String lastGrepDetailed;
    private final Tuple2<String, String> lastBrief;
    private final String lastDetailed;
    private final Tuple2<String, String> exportBrief;
    private final String exportDetailed;
    private final String InspectCommand;
    private final Tuple2<String, String> inspectBrief;
    private final String inspectDetailed;
    private final String SetCommand;
    private final Tuple2<String, String> setBrief;
    private final String setDetailed;
    private final String CrossCommand;
    private final String CrossRestoreSessionCommand;
    private final String SwitchCommand;
    private final String PluginCrossCommand;
    private final String PluginSwitchCommand;
    private final String JavaCrossCommand;
    private final String JavaSwitchCommand;

    static {
        new CommandStrings$();
    }

    public String AboutCommand() {
        return this.AboutCommand;
    }

    public String TasksCommand() {
        return this.TasksCommand;
    }

    public String SettingsCommand() {
        return this.SettingsCommand;
    }

    public String ProjectCommand() {
        return this.ProjectCommand;
    }

    public String ProjectsCommand() {
        return this.ProjectsCommand;
    }

    public String ShowCommand() {
        return this.ShowCommand;
    }

    public String PrintCommand() {
        return this.PrintCommand;
    }

    public String MultiTaskCommand() {
        return this.MultiTaskCommand;
    }

    public String BootCommand() {
        return this.BootCommand;
    }

    public String EvalCommand() {
        return this.EvalCommand;
    }

    public Tuple2<String, String> evalBrief() {
        return this.evalBrief;
    }

    public String evalDetailed() {
        return this.evalDetailed;
    }

    public Help actHelp() {
        return this.showHelp().$plus$plus(this.multiTaskHelp());
    }

    public Help multiTaskHelp() {
        return Help$.MODULE$.apply(this.MultiTaskCommand(), new Tuple2((Object)this.multiTaskSyntax(), (Object)this.multiTaskBrief()), this.multiTaskDetailed());
    }

    public String multiTaskDetailed() {
        return new StringBuilder(3).append(this.multiTaskSyntax()).append("\n\n\t").append(this.multiTaskBrief()).toString();
    }

    public String multiTaskSyntax() {
        return new StringBuilder(8).append(this.MultiTaskCommand()).append(" <task>+").toString();
    }

    public String multiTaskBrief() {
        return "Executes all of the specified tasks concurrently.";
    }

    public Help showHelp() {
        return Help$.MODULE$.apply(this.ShowCommand(), new Tuple2((Object)new StringBuilder(6).append(this.ShowCommand()).append(" <key>").toString(), (Object)this.showBrief()), this.showDetailed());
    }

    public String showBrief() {
        return "Displays the result of evaluating the setting or task associated with 'key'.";
    }

    public String showDetailed() {
        return new StringBuilder(141).append(this.ShowCommand()).append(" <setting>\n\n\tDisplays the value of the specified setting.\n\n").append(this.ShowCommand()).append(" <task>\n\n\tEvaluates the specified task and display the value returned by the task.").toString();
    }

    public Help printHelp() {
        return Help$.MODULE$.apply(this.PrintCommand(), new Tuple2((Object)new StringBuilder(6).append(this.PrintCommand()).append(" <key>").toString(), (Object)this.printBrief()), this.printDetailed());
    }

    public String printBrief() {
        return "Prints the result of evaluating the setting or task associated with 'key' to standard output.";
    }

    public String printDetailed() {
        return new StringBuilder(137).append(this.PrintCommand()).append(" <setting>\n\n\tPrints the value of the specified setting.\n\n").append(this.PrintCommand()).append(" <task>\n\n\tEvaluates the specified task and print the value returned by the task.").toString();
    }

    public String PluginsCommand() {
        return this.PluginsCommand;
    }

    public String PluginCommand() {
        return this.PluginCommand;
    }

    public String pluginsBrief() {
        return "Lists currently available plugins.";
    }

    public String pluginsDetailed() {
        return this.pluginsBrief();
    }

    public String LastCommand() {
        return this.LastCommand;
    }

    public String OldLastGrepCommand() {
        return this.OldLastGrepCommand;
    }

    public String LastGrepCommand() {
        return this.LastGrepCommand;
    }

    public String ExportCommand() {
        return this.ExportCommand;
    }

    public String ExportStream() {
        return this.ExportStream;
    }

    public Tuple2<String, String> oldLastGrepBrief() {
        return this.oldLastGrepBrief;
    }

    public String oldLastGrepDetailed() {
        return this.oldLastGrepDetailed;
    }

    public Tuple2<String, String> lastGrepBrief() {
        return this.lastGrepBrief;
    }

    public String lastGrepDetailed() {
        return this.lastGrepDetailed;
    }

    public Tuple2<String, String> lastBrief() {
        return this.lastBrief;
    }

    public String lastDetailed() {
        return this.lastDetailed;
    }

    public Tuple2<String, String> exportBrief() {
        return this.exportBrief;
    }

    public String exportDetailed() {
        return this.exportDetailed;
    }

    public String InspectCommand() {
        return this.InspectCommand;
    }

    public Tuple2<String, String> inspectBrief() {
        return this.inspectBrief;
    }

    public String inspectDetailed() {
        return this.inspectDetailed;
    }

    public String SetCommand() {
        return this.SetCommand;
    }

    public Tuple2<String, String> setBrief() {
        return this.setBrief;
    }

    public String setDetailed() {
        return this.setDetailed;
    }

    public String SessionCommand() {
        return "session";
    }

    public Tuple2<String, String> sessionBrief() {
        return new Tuple2((Object)this.SessionCommand(), (Object)new StringBuilder(56).append("Manipulates session settings.  For details, run 'help ").append(this.SessionCommand()).append("'.").toString());
    }

    public String settingsPreamble() {
        return this.commonPreamble("settings");
    }

    public String tasksPreamble() {
        return new StringBuilder(93).append(this.commonPreamble("tasks")).append("\nTasks produce values.  Use the 'show' command to run the task and print the resulting value.").toString();
    }

    public String commonPreamble(String label) {
        return new StringBuilder(137).append("\nThis is a list of ").append(label).append(" defined for the current project.\nIt does not list the scopes the ").append(label).append(" are defined in; use the 'inspect' command for that.").toString();
    }

    public Tuple2<String, String> settingsBrief(String label) {
        return new Tuple2((Object)label, (Object)new StringBuilder(43).append("Lists the ").append(label).append(" defined for the current project.").toString());
    }

    public String settingsDetailed(String label) {
        return new StringBuilder(746).append("\nSyntax summary\n\t").append(label).append(" [-(v|-vv|...|-V)] [<filter>]\n\n").append(label).append("\n\tDisplays the main ").append(label).append(" defined directly or indirectly for the current project.\n\n-v\n\tDisplays additional ").append(label).append(".  More 'v's increase the number of ").append(label).append(" displayed.\n\n-V\n\tdisplays all ").append(label).append("\n\n<filter>\n\tRestricts the ").append(label).append(" that are displayed.  The names of ").append(label).append(" are searched for\n\tan exact match against the filter, in which case only the description of the\n\texact match is displayed.  Otherwise, the filter is interpreted as a regular\n\texpression and all ").append(label).append(" whose name or description match the regular\n\texpression are displayed.  Note that this is an additional filter on top of\n\tthe ").append(label).append(" selected by the -v style switches, so you must specify -V to search\n\tall ").append(label).append(".  Use the ").append(BasicCommandStrings$.MODULE$.HelpCommand()).append(" command to search all commands, tasks, and\n\tsettings at once.\n").toString();
    }

    public String moreAvailableMessage(String label, boolean search) {
        String verb = search ? "searched" : "viewed";
        return new StringBuilder(48).append("More ").append(label).append(" may be ").append(verb).append(" by increasing verbosity.  See '").append(BasicCommandStrings$.MODULE$.HelpCommand()).append(" ").append(label).append("'\n").toString();
    }

    public String aboutBrief() {
        return "Displays basic information about sbt and the build.";
    }

    public String aboutDetailed() {
        return this.aboutBrief();
    }

    public Tuple2<String, String> projectBrief() {
        return new Tuple2((Object)this.ProjectCommand(), (Object)"Displays the current project or changes to the provided `project`.");
    }

    public String projectDetailed() {
        return new StringBuilder(790).append(this.ProjectCommand()).append("\n\n\tDisplays the name of the current project.\n\n").append(this.ProjectCommand()).append(" name\n\n\tChanges to the project with the provided name.\n\tThis command fails if there is no project with the given name.\n\n").append(this.ProjectCommand()).append(" {uri}\n\n\tChanges to the root project in the build defined by `uri`.\n\t`uri` must have already been declared as part of the build, such as with Project.dependsOn.\n\n").append(this.ProjectCommand()).append(" {uri}name\n\n\tChanges to the project `name` in the build defined by `uri`.\n\t`uri` must have already been declared as part of the build, such as with Project.dependsOn.\n\n").append(this.ProjectCommand()).append(" /\n\n\tChanges to the initial project.\n\n").append(this.ProjectCommand()).append(" ..\n\n\tChanges to the parent project of the current project.\n\tIf there is no parent project, the current project is unchanged.\n\n\tUse n+1 dots to change to the nth parent.\n\tFor example, 'project ....' is equivalent to three consecutive 'project ..' commands.").toString();
    }

    public String projectsBrief() {
        return "Lists the names of available projects or temporarily adds/removes extra builds to the session.";
    }

    public String projectsDetailed() {
        return new StringBuilder(433).append(this.ProjectsCommand()).append("\n\tList the names of available builds and the projects defined in those builds.\n\n").append(this.ProjectsCommand()).append(" add <URI>+\n\tAdds the builds at the provided URIs to this session.\n\tThese builds may be selected using the ").append(this.ProjectCommand()).append(" command.\n\tAlternatively, tasks from these builds may be run using the explicit syntax {URI}project/task\n\n").append(this.ProjectsCommand()).append(" remove <URI>+\n\tRemoves extra builds from this session.\n\tBuilds explicitly listed in the build definition are not affected by this command.\n").toString();
    }

    public String sbtrc() {
        return ".sbtrc";
    }

    public String DefaultsCommand() {
        return "addDefaultCommands";
    }

    public Tuple2<String, String> DefaultsBrief() {
        return new Tuple2((Object)this.DefaultsCommand(), (Object)this.DefaultsDetailed());
    }

    public String DefaultsDetailed() {
        return "Registers default built-in commands";
    }

    public String LoadFailed() {
        return "loadFailed";
    }

    public String OldLoadFailed() {
        return "load-failed";
    }

    public String LoadProjectImpl() {
        return "loadp";
    }

    public String LoadProject() {
        return "reload";
    }

    public Tuple2<String, String> LoadProjectBrief() {
        return new Tuple2((Object)this.LoadProject(), (Object)"(Re)loads the current project or changes to plugins project or returns from it.");
    }

    public String LoadProjectDetailed() {
        return new StringBuilder(191).append(this.LoadProject()).append("\n\n\t(Re)loads the project in the current directory.\n\n").append(this.LoadProject()).append(" plugins\n\n\t(Re)loads the plugins project (under project directory).\n\n").append(this.LoadProject()).append(" return\n\n\t(Re)loads the root project (and leaves the plugins project).").toString();
    }

    public String InitCommand() {
        return "initialize";
    }

    public Tuple2<String, String> InitBrief() {
        return new Tuple2((Object)this.InitCommand(), (Object)"Initializes command processing.");
    }

    public String InitDetailed() {
        return new StringBuilder(180).append(this.InitCommand()).append("\n\tInitializes command processing.\n\nRuns the following commands.\n\ndefaults\n\tRegisters default commands.\n\n< ~/.sbtrc\n< .sbtrc\n\tRuns commands from ~/.sbtrc and ./.sbtrc if they exist\n").toString();
    }

    public Seq<File> sbtRCs(State s) {
        File file = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), this.sbtrc());
        File file2 = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(State.StateOpsImpl$.MODULE$.baseDir$extension(State$.MODULE$.StateOpsImpl(s))), this.sbtrc());
        return Nil$.MODULE$.$colon$colon((Object)file2).$colon$colon((Object)file);
    }

    public String CrossCommand() {
        return this.CrossCommand;
    }

    public String CrossRestoreSessionCommand() {
        return this.CrossRestoreSessionCommand;
    }

    public String SwitchCommand() {
        return this.SwitchCommand;
    }

    public Help crossHelp() {
        return Help$.MODULE$.more(this.CrossCommand(), this.CrossDetailed());
    }

    public Help crossRestoreSessionHelp() {
        return Help$.MODULE$.more(this.CrossRestoreSessionCommand(), this.CrossRestoreSessionDetailed());
    }

    public Help switchHelp() {
        return Help$.MODULE$.more(this.SwitchCommand(), this.SwitchDetailed());
    }

    public String CrossDetailed() {
        return new StringBuilder(486).append(this.CrossCommand()).append(" [-v] <command>\n\tRuns <command> for each Scala version specified for cross-building.\n\n\tFor each string in `crossScalaVersions` in each project project, this command sets\n\tthe `scalaVersion` of all projects that list that Scala version with that Scala\n  version reloads the build, and then executes <command> for those projects.  When\n  finished, it resets the build to its original state.\n\n  If -v is supplied, verbose logging of the Scala version switching is done.\n\n\tSee also `help ").append(this.SwitchCommand()).append("`\n").toString();
    }

    public String CrossRestoreSessionDetailed() {
        return new StringBuilder(66).append(this.CrossRestoreSessionCommand()).append("\n\n  Restores a session that was captured by the cross command, +.\n").toString();
    }

    public String SwitchDetailed() {
        return new StringBuilder(1491).append(this.SwitchCommand()).append(" <scala-version>[!] [-v] [<command>]\n\tChanges the Scala version and runs a command.\n\n\tSets the `scalaVersion` of all projects that define a Scala cross version that is binary\n  compatible with <scala-version> and reloads the build.  If ! is supplied, then the\n  version is forced on all projects regardless of whether they are binary compatible or\n  not.\n\n  If -v is supplied, verbose logging of the Scala version switching is done.\n\n\tIf <command> is provided, it is then executed.\n\n").append(this.SwitchCommand()).append(" [<scala-version>=]<scala-home>[!] [-v] [<command>]\n\tUses the Scala installation at <scala-home> by configuring the scalaHome setting for\n\tall projects.\n\n\tIf <scala-version> is specified, it is used to select the value of the scalaVersion setting\n  from one of the values of crossScalaVersions setting.\n\tThis is important when using managed dependencies.  This version will determine the\n\tcross-version used as well as transitive dependencies.\n\n  <scala-version> may be an actual Scala version such as 3.1.3, or a Semantic Version selector\n  pattern such as 2.13.x. Only subprojects that are listed to match the version pattern\n  have their Scala version switched.  If ! is supplied, then all projects projects have\n  their Scala version switched.\n\n  If -v is supplied, verbose logging of the Scala version switching is done.\n\n\tIf <command> is provided, it is then executed. For example:\n\n    ++ 2.13.x test\n\n  The above will run test on all subprojects that contain a 2.13 Scala version.\n\n\tSee also `help ").append(this.CrossCommand()).append("`\n").toString();
    }

    public String PluginCrossCommand() {
        return this.PluginCrossCommand;
    }

    public String PluginSwitchCommand() {
        return this.PluginSwitchCommand;
    }

    public Help pluginCrossHelp() {
        return Help$.MODULE$.more(this.PluginCrossCommand(), this.PluginCrossDetailed());
    }

    public Help pluginSwitchHelp() {
        return Help$.MODULE$.more(this.PluginSwitchCommand(), this.PluginSwitchDetailed());
    }

    public String PluginCrossDetailed() {
        return new StringBuilder(371).append(this.PluginCrossCommand()).append(" <command>\n  Runs <command> for each sbt version specified for cross-building.\n\n  For each string in `crossSbtVersions` in the current project, this command sets the\n  `sbtVersion in pluginCrossBuild` of all projects to that version, reloads the build,\n  and executes <command>.  When finished, it reloads the build with the original\n  Scala version.\n\n  See also `help ").append(this.PluginSwitchCommand()).append("`\n").toString();
    }

    public String PluginSwitchDetailed() {
        return new StringBuilder(243).append(this.PluginSwitchCommand()).append(" <sbt-version> [<command>]\n  Changes the sbt version and runs a command.\n\n  Sets the `sbtVersion in pluginCrossBuild` of all projects to <sbt-version> and\n  reloads the build. If <command> is provided, it is then executed.\n\n  See also `help ").append(this.CrossCommand()).append("`\n").toString();
    }

    public String JavaCrossCommand() {
        return this.JavaCrossCommand;
    }

    public String JavaSwitchCommand() {
        return this.JavaSwitchCommand;
    }

    public Help javaCrossHelp() {
        return Help$.MODULE$.more(this.JavaCrossCommand(), this.JavaCrossDetailed());
    }

    public Help javaSwitchHelp() {
        return Help$.MODULE$.more(this.JavaSwitchCommand(), this.JavaSwitchDetailed());
    }

    public String JavaCrossDetailed() {
        return new StringBuilder(439).append(this.JavaCrossCommand()).append(" <command>\n  Runs <command> for each JDK version specified for cross-JDK testing.\n  For each string in `crossJavaVersions` in the current project, this command sets the\n  `javaHome` of all projects to the corresponding Java home, reloads the build,\n  and executes <command>.  When finished, it reloads the build with the original\n  `javaHome`.\n  Note that `Test / fork := true` is needed for `javaHome` to be effective.\n  See also `help ").append(this.JavaSwitchCommand()).append("`\n").toString();
    }

    public String JavaSwitchDetailed() {
        return new StringBuilder(209).append(this.JavaSwitchCommand()).append(" <java-version>\n  Changes the JDK version and runs a command.\n  Sets the `javaHome` of all projects to <java-version> and\n  reloads the build. If <command> is provided, it is then executed.\n  See also `help ").append(this.JavaSwitchCommand()).append("`\n").toString();
    }

    private CommandStrings$() {
        MODULE$ = this;
        this.AboutCommand = "about";
        this.TasksCommand = "tasks";
        this.SettingsCommand = "settings";
        this.ProjectCommand = "project";
        this.ProjectsCommand = "projects";
        this.ShowCommand = "show";
        this.PrintCommand = "print";
        this.MultiTaskCommand = "all";
        this.BootCommand = "boot";
        this.EvalCommand = "eval";
        this.evalBrief = new Tuple2((Object)new StringBuilder(13).append(this.EvalCommand()).append(" <expression>").toString(), (Object)"Evaluates a Scala expression and prints the result and type.");
        this.evalDetailed = new StringBuilder(84).append(this.EvalCommand()).append(" <expression>\n\n\tEvaluates the given Scala expression and prints the result and type.").toString();
        this.PluginsCommand = "plugins";
        this.PluginCommand = "plugin";
        this.LastCommand = "last";
        this.OldLastGrepCommand = "last-grep";
        this.LastGrepCommand = "lastGrep";
        this.ExportCommand = "export";
        this.ExportStream = "export";
        this.oldLastGrepBrief = new Tuple2((Object)this.OldLastGrepCommand(), (Object)"Shows lines from the last output for 'key' that match 'pattern'.");
        this.oldLastGrepDetailed = new StringBuilder(488).append(this.OldLastGrepCommand()).append(" <pattern>\n\tDisplays lines from the logging of previous commands that match `pattern`.\n\n").append(this.OldLastGrepCommand()).append(" <pattern> [key]\n\tDisplays lines from logging associated with `key` that match `pattern`.  The key typically refers to a task (for example, test:compile).  The logging that is displayed is restricted to the logging for that particular task.\n\n\t<pattern> is a regular expression interpreted by java.util.Pattern.  Matching text is highlighted (when highlighting is supported and enabled).\n\tSee also '").append(this.LastCommand()).append("'.").toString();
        this.lastGrepBrief = new Tuple2((Object)this.LastGrepCommand(), (Object)"Shows lines from the last output for 'key' that match 'pattern'.");
        this.lastGrepDetailed = new StringBuilder(488).append(this.LastGrepCommand()).append(" <pattern>\n\tDisplays lines from the logging of previous commands that match `pattern`.\n\n").append(this.LastGrepCommand()).append(" <pattern> [key]\n\tDisplays lines from logging associated with `key` that match `pattern`.  The key typically refers to a task (for example, test:compile).  The logging that is displayed is restricted to the logging for that particular task.\n\n\t<pattern> is a regular expression interpreted by java.util.Pattern.  Matching text is highlighted (when highlighting is supported and enabled).\n\tSee also '").append(this.LastCommand()).append("'.").toString();
        this.lastBrief = new Tuple2((Object)this.LastCommand(), (Object)"Displays output from a previous command or the output from a specific task.");
        this.lastDetailed = new StringBuilder(309).append(this.LastCommand()).append("\n\tPrints the logging for the previous command, typically at a more verbose level.\n\n").append(this.LastCommand()).append(" <key>\n\tPrints the logging associated with the provided key.  The key typically refers to a task (for example, test:compile).  The logging that is displayed is restricted to the logging for that particular task.\n\n\tSee also '").append(this.LastGrepCommand()).append("'.").toString();
        this.exportBrief = new Tuple2((Object)new StringBuilder(9).append(this.ExportCommand()).append(" <tasks>+").toString(), (Object)"Executes tasks and displays the equivalent command lines.");
        this.exportDetailed = new StringBuilder(563).append(this.ExportCommand()).append(" [--last] <task>+\n\tRuns the specified tasks and prints the equivalent command lines or other exportable information for those runs.\n\n\t--last\n\t\tUses information from the previous execution\n\n\tNOTES: These command lines are necessarily approximate.  Usually tasks do not actually\n\texecute the command line and the actual command line program may not be installed or\n\ton the PATH.  Incremental tasks will typically show the command line for an\n\tincremental run and not for a full run.  Many tasks have no direct command line\n\tequivalent and will show nothing at all.\n").toString();
        this.InspectCommand = "inspect";
        this.inspectBrief = new Tuple2((Object)new StringBuilder(37).append(this.InspectCommand()).append(" [tree|uses|definitions|actual] <key>").toString(), (Object)"Prints the value for 'key', the defining scope, delegates, related definitions, and dependencies.");
        this.inspectDetailed = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1495).append("\n    |").append(this.InspectCommand()).append(" [-] <key>\n    |\n    |\tFor a plain setting, the value bound to the key argument is displayed using its toString method.\n    |\tFor an alias, the command bound to the alias is displayed.\n    |\tOtherwise, the type of the key (\"Task\" or \"Input task\") is displayed.\n    |\n    |\t\"Dependencies\" shows the settings that this setting depends on.\n    |\n    |\t\"Reverse dependencies\" shows the settings that depend on this setting.\n    |\n    |\tWhen a key is resolved to a value, it may not actually be defined in the requested scope.\n    |\tIn this case, there is a defined search sequence.\n    |\t\"Delegates\" shows the scopes that are searched for the key.\n    |\t\"Provided by\" shows the scope that contained the value returned for the key.\n    |\n    |\t\"Related\" shows all of the scopes in which the key is defined.\n    |\n    |").append(this.InspectCommand()).append(" tree <key>\n    |\n    |\tDisplays `key` and its dependencies in a tree structure.\n    |\tFor settings, the value bound to the setting is displayed and for tasks, the type of the task is shown.\n    |\n    |").append(this.InspectCommand()).append(" uses <key>\n    |\n    |\tDisplays the settings and tasks that directly depend on `key`.\n    |\n    |").append(this.InspectCommand()).append(" definitions <key>\n    |\n    |\tDisplays the scopes in which `key` is defined.\n    |\n    |").append(this.InspectCommand()).append(" actual <key>\n    |\n    |\tDisplays the actual dependencies used by `key`.\n    |\tThis is useful because delegation means that a dependency can come from a scope other than the requested one.\n    |\tUsing `inspect actual` will show exactly which scope is providing a value for a setting.\n  ").toString())).stripMargin().trim();
        this.SetCommand = "set";
        this.setBrief = new Tuple2((Object)new StringBuilder(18).append(this.SetCommand()).append(" [every] <setting>").toString(), (Object)"Evaluates a Setting and applies it to the current project.");
        this.setDetailed = new StringBuilder(664).append(this.SetCommand()).append(" [every] <setting-expression>\n\n\tApplies the given setting to the current project:\n\t  1) Constructs the expression provided as an argument by compiling and loading it.\n\t  2) Appends the new setting to the current project's settings.\n\t  3) Re-evaluates the build's settings.\n\n\tThis command does not rebuild the build definitions, plugins, or configurations.\n\tIt does not automatically persist the setting(s) either.\n\tTo persist the setting(s), run 'session save' or 'session save-all'.\n\n\tIf 'every' is specified, the setting is evaluated in the current context\n\tand the resulting value is used in every scope.  This overrides the value\n\tbound to the key everywhere.\n").toString();
        this.CrossCommand = "+";
        this.CrossRestoreSessionCommand = "+-";
        this.SwitchCommand = "++";
        this.PluginCrossCommand = "^";
        this.PluginSwitchCommand = "^^";
        this.JavaCrossCommand = "java+";
        this.JavaSwitchCommand = "java++";
    }
}

