/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import sbt.internal.ClassLoadingLock;
import sbt.internal.ManagedClassLoader;
import sbt.internal.ReverseLookupClassLoader;
import sbt.internal.ReverseLookupClassLoaderHolder;
import sbt.util.Logger;

final class BottomClassLoader
extends ManagedClassLoader {
    private final ReverseLookupClassLoaderHolder holder;
    private final ReverseLookupClassLoader parent;
    private final ClassLoadingLock classLoadingLock = new ClassLoadingLock();

    BottomClassLoader(ReverseLookupClassLoaderHolder holder, URL[] dynamicClasspath, ReverseLookupClassLoader reverseLookupClassLoader, File tempDir, boolean close, boolean allowZombies, Logger logger) {
        super(dynamicClasspath, reverseLookupClassLoader, close, allowZombies, logger);
        this.setTempDir(tempDir);
        this.holder = holder;
        this.parent = reverseLookupClassLoader;
        this.parent.setDescendant(this);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.classLoadingLock.withLock(name, () -> {
            Class<?> prev = this.findLoadedClass(name);
            if (prev != null) {
                return prev;
            }
            return super.findClass(name);
        });
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.parent.loadClass(name, resolve, false);
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz = this.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @Override
    public void close() throws IOException {
        this.holder.checkin(this.parent);
        super.close();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

