/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.NativeLoader;
import sbt.internal.NativeLookup;
import sbt.util.Logger;

abstract class ManagedClassLoader
extends URLClassLoader
implements NativeLoader {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean printedWarning = new AtomicBoolean(false);
    private final AtomicReference<ZombieClassLoader> zombieLoader = new AtomicReference();
    private final boolean close;
    private final boolean allowZombies;
    private final Logger logger;
    private final NativeLookup nativeLookup = new NativeLookup();

    ManagedClassLoader(URL[] urls, ClassLoader parent, boolean close, boolean allowZombies, Logger logger) {
        super(urls, parent);
        this.close = close;
        this.allowZombies = allowZombies;
        this.logger = logger;
    }

    private ZombieClassLoader getZombieLoader(String name) {
        ZombieClassLoader maybeLoader;
        if (this.printedWarning.compareAndSet(false, true) && !this.allowZombies) {
            String msg = Thread.currentThread() + " loading " + name + " after test or run " + "has completed. This is a likely resource leak";
            this.logger.warn(() -> msg);
        }
        if ((maybeLoader = this.zombieLoader.get()) != null) {
            return maybeLoader;
        }
        ZombieClassLoader zb = new ZombieClassLoader(this.getURLs());
        this.zombieLoader.set(zb);
        return zb;
    }

    @Override
    public URL findResource(String name) {
        return this.closed.get() ? this.getZombieLoader(name).findResource(name) : super.findResource(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (this.closed.get()) {
                return this.getZombieLoader(name).lookupClass(name);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        ZombieClassLoader zb = this.zombieLoader.getAndSet(null);
        if (zb != null && this.close) {
            zb.close();
        }
        if (this.close && this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    @Override
    public String findLibrary(String name) {
        return this.nativeLookup.findLibrary(name);
    }

    @Override
    public void setTempDir(File file) {
        this.nativeLookup.setTempDir(file);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class ZombieClassLoader
    extends URLClassLoader {
        private final URL[] urls;

        ZombieClassLoader(URL[] urls) {
            super(urls, ManagedClassLoader.this.getParent());
            this.urls = urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Class<?> lookupClass(String name) throws ClassNotFoundException {
            try {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> previous = this.findLoadedClass(name);
                    return previous != null ? previous : this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                StringBuilder builder = new StringBuilder();
                for (URL u : this.urls) {
                    File f = new File(u.getPath());
                    if (!f.exists()) continue;
                    builder.append(f.toString()).append('\n');
                }
                String deleted = builder.toString();
                if (!deleted.isEmpty()) {
                    String msg = "Couldn't load class $name. The following urls on the classpath do not exist:\n" + deleted + "This may be due to shutdown hooks added during an invocation of `run`.";
                    System.err.println(msg);
                }
                throw e;
            }
        }
    }
}

