/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001m4Aa\u0003\u0007\u0001#!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003%\u0001\u0011\u0005Q\u0005\u0003\u0004*\u0001\u0001\u0006IA\u000b\u0005\u0007i\u0001\u0001\u000b\u0011B\u001b\t\re\u0002\u0001\u0015!\u0003;\u0011\u00191\u0005\u0001)A\u0005\u000f\"1\u0001\u000b\u0001Q\u0005\nECqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004y\u0001\u0001\u0006I!\u001c\u0005\u0006s\u0002!\tE\u001f\u0002\n\u000f\u000ekuN\\5u_JT!!\u0004\b\u0002\u0011%tG/\u001a:oC2T\u0011aD\u0001\u0004g\n$8\u0001A\n\u0004\u0001IQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005MY\u0012B\u0001\u000f\u0015\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u00061An\\4hKJ\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\b\u0002\tU$\u0018\u000e\\\u0005\u0003G\u0001\u0012a\u0001T8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002'QA\u0011q\u0005A\u0007\u0002\u0019!)QD\u0001a\u0001=\u00051q/\u001b8e_^\u0004\"a\u000b\u001a\u000e\u00031R!!\f\u0018\u0002\u0011\u0011,(/\u0019;j_:T!a\f\u0019\u0002\u0015\r|gnY;se\u0016tGOC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019DF\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u000bI\fG/[8\u0011\u0005Y:T\"\u0001\u0019\n\u0005a\u0002$A\u0002#pk\ndW-A\u0003rk\u0016,X\rE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0003_uR!!\t\f\n\u0005}b$a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007\u0003\u0002\u001cBU\rK!A\u0011\u0019\u0003\rQ+\b\u000f\\33!\t1D)\u0003\u0002Fa\t!Aj\u001c8h\u0003)a\u0017m\u001d;XCJtW\r\u001a\t\u0004\u0011.kU\"A%\u000b\u0005)c\u0014AB1u_6L7-\u0003\u0002M\u0013\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002,\u001d&\u0011q\n\f\u0002\t\t\u0016\fG\r\\5oK\u0006\u0011\u0002.\u00198eY\u0016tu\u000e^5gS\u000e\fG/[8o)\u0011\u0011Vk\u00184\u0011\u0005Y\u001a\u0016B\u0001+1\u0005\u0011)f.\u001b;\t\u000bY;\u0001\u0019A,\u0002\u00199|G/\u001b4jG\u0006$\u0018n\u001c8\u0011\u0005akV\"A-\u000b\u0005i[\u0016AC7b]\u0006<W-\\3oi*\tA,A\u0003kCZ\f\u00070\u0003\u0002_3\naaj\u001c;jM&\u001c\u0017\r^5p]\")\u0001m\u0002a\u0001C\u0006!!-Z1o!\t\u0011G-D\u0001d\u0015\tQF#\u0003\u0002fG\n1r)\u0019:cC\u001e,7i\u001c7mK\u000e$xN]'Y\u0005\u0016\fg\u000eC\u0003h\u000f\u0001\u0007\u0001.A\nu_R\fGnQ8mY\u0016\u001cG/[8o)&lW\r\u0005\u0002IS&\u0011!.\u0013\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001\u0003:f[>4XM]:\u0016\u00035\u00042A\\:v\u001b\u0005y'B\u00019r\u0003\u001diW\u000f^1cY\u0016T!A\u001d\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002u_\n1!)\u001e4gKJ\u00042A\u000e<S\u0013\t9\bGA\u0005Gk:\u001cG/[8oa\u0005I!/Z7pm\u0016\u00148\u000fI\u0001\u0006G2|7/\u001a\u000b\u0002%\u0002")
public class GCMonitor
implements AutoCloseable {
    private final Logger logger;
    private final FiniteDuration window;
    private final double ratio;
    private final LinkedBlockingQueue<Tuple2<FiniteDuration, Object>> queue;
    private final AtomicReference<Deadline> lastWarned;
    private final Buffer<Function0<BoxedUnit>> removers;

    private void handleNotification(Notification notification, GarbageCollectorMXBean bean, AtomicLong totalCollectionTime) {
        block0: {
            FiniteDuration now = new package.DurationLong(package$.MODULE$.DurationLong(notification.getTimeStamp())).millis();
            long collectionTime = bean.getCollectionTime();
            long elapsed = collectionTime - totalCollectionTime.getAndSet(collectionTime);
            this.queue.removeIf(x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                FiniteDuration whenEventHappened = (FiniteDuration)tuple2._1();
                boolean bl = now.$greater((Object)whenEventHappened.$plus($this.window));
                return bl;
            });
            this.queue.add((Tuple2<FiniteDuration, Object>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)now), (Object)BoxesRunTime.boxToLong((long)elapsed)));
            long total = BoxesRunTime.unboxToLong((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.queue).asScala()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToLong((long)GCMonitor.$anonfun$handleNotification$2(BoxesRunTime.unboxToLong((Object)x0$2), x1$1))));
            if (!((double)total > (double)this.window.toMillis() * this.ratio) || !this.lastWarned.get().$plus(this.window).isOverdue()) break block0;
            this.lastWarned.set(Deadline$.MODULE$.now());
            String msg = new StringBuilder(193).append((double)total / 1000.0).append(" seconds of the last ").append(this.window).append(" were spent in garbage ").append("collection. You may want to increase the project heap size using `-Xmx` or try ").append("a different gc algorithm, e.g. `-XX:+UseG1GC`, for better performance.").toString();
            this.logger.warn((Function0 & Serializable & scala.Serializable)() -> msg);
        }
    }

    public Buffer<Function0<BoxedUnit>> removers() {
        return this.removers;
    }

    @Override
    public void close() {
        this.removers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$handleNotification$2(long x0$2, Tuple2 x1$1) {
        Tuple2 tuple2;
        long total;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
                if (tuple22 == null) break block2;
                total = tuple22._1$mcJ$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        long t = tuple2._2$mcJ$sp();
        long l = total + t;
        return l;
    }

    public GCMonitor(Logger logger) {
        this.logger = logger;
        this.window = new package.DurationInt(package$.MODULE$.DurationInt(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(System.getProperty("sbt.gc.monitor.window", "10"))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10)))).seconds();
        this.ratio = BoxesRunTime.unboxToDouble((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(System.getProperty("sbt.gc.monitor.ratio", "0.5"))).toDouble()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.5));
        this.queue = new LinkedBlockingQueue();
        this.lastWarned = new AtomicReference<Deadline>(Deadline$.MODULE$.apply(new package.DurationInt(package$.MODULE$.DurationInt(0)).millis()));
        this.removers = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            GarbageCollectorMXBean garbageCollectorMXBean = x0$1;
            if (garbageCollectorMXBean instanceof NotificationEmitter) {
                GarbageCollectorMXBean garbageCollectorMXBean2 = garbageCollectorMXBean;
                AtomicLong elapsedTime = new AtomicLong(garbageCollectorMXBean2.getCollectionTime());
                NotificationListener listener = (notification, x$1) -> this.handleNotification(notification, garbageCollectorMXBean2, elapsedTime);
                ((NotificationBroadcaster)((Object)garbageCollectorMXBean2)).addNotificationListener(listener, null, null);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((NotificationBroadcaster)((Object)garbageCollectorMXBean2)).removeNotificationListener(listener)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom());
    }
}

