/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.InMemoryCacheStore$;
import sbt.io.IO$;
import sbt.util.CacheStore;
import sbt.util.CacheStoreFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sjsonnew.IsoString;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.SupportConverter;

@ScalaSignature(bytes="\u0006\u0001\tmqA\u0002\u0013&\u0011\u00039\u0013F\u0002\u0004,K!\u0005q\u0005\f\u0005\u0006g\u0005!\t!\u000e\u0004\u0007W\u0005\u0001\u000b\u0011\u0002\u001c\t\u0011\t\u001b!\u0011!Q\u0001\n\rCQaM\u0002\u0005\u0002\u0019CaAS\u0002!\u0002\u0013Y\u0005B\u00026\u0004A\u0003%1\u000eC\u0003o\u0007\u0011\u0005q\u000eC\u0004\u0002\u0004\r!\t!!\u0002\t\u000f\u0005]1\u0001\"\u0001\u0002\u001a!9\u0011QD\u0002\u0005B\u0005}a\u0001CA\u0011\u0003\u0001\u0006I!a\t\t\u0013\u0005\u0005AB!A!\u0002\u0013I\u0006\"CA\u0019\u0019\t\u0005\t\u0015!\u0003H\u0011)\t\u0019\u0004\u0004B\u0001B\u0003%\u0011Q\u0005\u0005\u0007g1!\t!!\u000e\t\u000f\u0005}B\u0002\"\u0011\u0002 !9\u0011\u0011\t\u0007\u0005B\u0005\r\u0003bBA/\u0019\u0011\u0005\u0013q\f\u0005\b\u0003;aA\u0011IA\u0010\u0011!\t)(\u0001Q\u0005\n\u0005]dACAQ\u0003A\u0005\u0019\u0013A\u0014\u0002$\"9\u0011Q\u0015\f\u0007\u0002\u0005\u001df\u0001CA`\u0003\u0001\u0006I!!1\t\u0013\u0005\u0015\u0007D!A!\u0002\u0013\u0019\u0005BB\u001a\u0019\t\u0003\t9\r\u0003\u0005\u0002Nb\u0001\u000b\u0011BAh\u0011\u001d\ti\u0002\u0007C!\u0003?Aq!!*\u0019\t\u0003\t\to\u0002\u0005\u0002x\u0006\u0001\u000b\u0012BA}\r!\tY0\u0001Q\t\n\u0005u\bBB\u001a \t\u0003\ty\u0010C\u0004\u0002&~!\tE!\u0001\t\u000f\u0005uq\u0004\"\u0011\u0002 !9\u0011QO\u0001\u0005\u0002\t]\u0011AE%o\u001b\u0016lwN]=DC\u000eDWm\u0015;pe\u0016T!AJ\u0014\u0002\u0011%tG/\u001a:oC2T\u0011\u0001K\u0001\u0004g\n$\bC\u0001\u0016\u0002\u001b\u0005)#AE%o\u001b\u0016lwN]=DC\u000eDWm\u0015;pe\u0016\u001c\"!A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u0015\u0014\u0007\r9t\b\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!A.\u00198h\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001d\u0003\r=\u0013'.Z2u!\tA\u0004)\u0003\u0002Bs\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\fq!\\1y'&TX\r\u0005\u0002/\t&\u0011Qi\f\u0002\u0005\u0019>tw\r\u0006\u0002H\u0013B\u0011\u0001jA\u0007\u0002\u0003!)!)\u0002a\u0001\u0007\u00069q/Z5hQ\u0016\u0014\b\u0003\u0002'X3\u0006l\u0011!\u0014\u0006\u0003\u001d>\u000bQaY1dQ\u0016T!\u0001U)\u0002\u0011\r\fgMZ3j]\u0016T!AU*\u0002\u0011\t,g.\\1oKNT!\u0001V+\u0002\r\u001dLG\u000f[;c\u0015\u00051\u0016aA2p[&\u0011\u0001,\u0014\u0002\b/\u0016Lw\r[3s!\tQv,D\u0001\\\u0015\taV,\u0001\u0003gS2,'B\u00010<\u0003\rq\u0017n\\\u0005\u0003An\u0013A\u0001U1uQB)aF\u00193DO&\u00111m\f\u0002\u0007)V\u0004H.Z\u001a\u0011\u00059*\u0017B\u000140\u0005\r\te.\u001f\t\u0003]!L!![\u0018\u0003\u0007%sG/A\u0003gS2,7\u000f\u0005\u0003MYf\u000b\u0017BA7N\u0005\u0015\u0019\u0015m\u00195f\u0003\r9W\r^\u000b\u0003af$\"!]@\u0011\u00079\u0012H/\u0003\u0002t_\t1q\n\u001d;j_:\u0004BAL;x\u0007&\u0011ao\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005aLH\u0002\u0001\u0003\u0006u\"\u0011\ra\u001f\u0002\u0002)F\u0011A\u0010\u001a\t\u0003]uL!A`\u0018\u0003\u000f9{G\u000f[5oO\"1\u0011\u0011\u0001\u0005A\u0002e\u000bA\u0001]1uQ\u0006\u0019\u0001/\u001e;\u0015\u0011\u0005\u001d\u0011QBA\b\u0003'\u00012ALA\u0005\u0013\r\tYa\f\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0002%\u0001\r!\u0017\u0005\u0007\u0003#I\u0001\u0019\u00013\u0002\u000bY\fG.^3\t\r\u0005U\u0011\u00021\u0001D\u00031a\u0017m\u001d;N_\u0012Lg-[3e\u0003\u0019\u0011X-\\8wKR!\u0011qAA\u000e\u0011\u0019\t\tA\u0003a\u00013\u0006)1\r\\8tKR\u0011\u0011q\u0001\u0002\u000f\u0007\u0006\u001c\u0007.Z*u_J,\u0017*\u001c9m'\ra\u0011Q\u0005\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\tIC\u0001\u0006DC\u000eDWm\u0015;pe\u0016\fQa\u001d;pe\u0016\f!bY1dQ\u0016\u001cFo\u001c:f)!\t9$!\u000f\u0002<\u0005u\u0002C\u0001%\r\u0011\u0019\t\t\u0001\u0005a\u00013\"1\u0011\u0011\u0007\tA\u0002\u001dCq!a\r\u0011\u0001\u0004\t)#\u0001\u0004eK2,G/Z\u0001\u0005e\u0016\fG-\u0006\u0003\u0002F\u0005-CCAA$)\u0011\tI%!\u0014\u0011\u0007a\fY\u0005B\u0003{%\t\u00071\u0010C\u0004\u0002PI\u0001\u001d!!\u0015\u0002\rI,\u0017\rZ3s!\u0019\t\u0019&!\u0017\u0002J5\u0011\u0011Q\u000b\u0006\u0003\u0003/\n\u0001b\u001d6t_:tWm^\u0005\u0005\u00037\n)F\u0001\u0006Kg>t'+Z1eKJ\fQa\u001e:ji\u0016,B!!\u0019\u0002rQ!\u00111MA:)\u0011\t9!!\u001a\t\u000f\u0005\u001d4\u0003q\u0001\u0002j\u00051qO]5uKJ\u0004b!a\u0015\u0002l\u0005=\u0014\u0002BA7\u0003+\u0012!BS:p]^\u0013\u0018\u000e^3s!\rA\u0018\u0011\u000f\u0003\u0006uN\u0011\ra\u001f\u0005\b\u0003#\u0019\u0002\u0019AA8\u0003\u001d1\u0017m\u0019;pef,B!!\u001f\u0002\u0010RA\u00111PAJ\u0003+\u000b9\n\u0006\u0003\u0002~\u0005\r\u0005\u0003BA\u0014\u0003\u007fJA!!!\u0002*\t\t2)Y2iKN#xN]3GC\u000e$xN]=\t\u0013\u0005\u0015U#!AA\u0004\u0005\u001d\u0015AC3wS\u0012,gnY3%cA1\u00111KAE\u0003\u001bKA!a#\u0002V\tI\u0011j]8TiJLgn\u001a\t\u0004q\u0006=EABAI+\t\u00071PA\u0001K\u0011\u0019\t\t$\u0006a\u0001\u000f\"1\u0011\u0011A\u000bA\u0002eCq!!'\u0016\u0001\u0004\tY*A\u0005d_:4XM\u001d;feB1\u00111KAO\u0003\u001bKA!a(\u0002V\t\u00012+\u001e9q_J$8i\u001c8wKJ$XM\u001d\u0002\u0019\u0007\u0006\u001c\u0007.Z*u_J,g)Y2u_JLh)Y2u_JL8c\u0001\f8\u007f\u0005)\u0011\r\u001d9msV!\u0011\u0011VA[)\u0019\tY+a.\u0002:R!\u0011QPAW\u0011%\tykFA\u0001\u0002\b\t\t,\u0001\u0006fm&$WM\\2fII\u0002b!a\u0015\u0002\n\u0006M\u0006c\u0001=\u00026\u00121\u0011\u0011S\fC\u0002mDa!!\u0001\u0018\u0001\u0004I\u0006bBA^/\u0001\u0007\u0011QX\u0001\u0011gV\u0004\bo\u001c:u\u0007>tg/\u001a:uKJ\u0004b!a\u0015\u0002\u001e\u0006M&\u0001H\"bG\",7\u000b^8sK\u001a\u000b7\r^8ss\u001a\u000b7\r^8ss&k\u0007\u000f\\\n\u00051]\n\u0019\r\u0005\u0002I-\u0005!1/\u001b>f)\u0011\tI-a3\u0011\u0005!C\u0002BBAc5\u0001\u00071)\u0001\u0005ti>\u0014XMU3g!\u0015\t\t.!8H\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017AB1u_6L7M\u0003\u0003\u0002Z\u0006m\u0017AC2p]\u000e,(O]3oi*\u0019\u00111F\u001e\n\t\u0005}\u00171\u001b\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKV!\u00111]Ax)\u0019\t)/!=\u0002tR!\u0011QPAt\u0011%\tI/HA\u0001\u0002\b\tY/\u0001\u0006fm&$WM\\2fIM\u0002b!a\u0015\u0002\n\u00065\bc\u0001=\u0002p\u00121\u0011\u0011S\u000fC\u0002mDa!!\u0001\u001e\u0001\u0004I\u0006bBA^;\u0001\u0007\u0011Q\u001f\t\u0007\u0003'\ni*!<\u0002!\u0011K'/Z2u_JLh)Y2u_JL\bC\u0001% \u0005A!\u0015N]3di>\u0014\u0018PR1di>\u0014\u0018p\u0005\u0003 o\u0005\rGCAA}+\u0011\u0011\u0019Aa\u0004\u0015\r\t\u0015!\u0011\u0003B\n)\u0011\tiHa\u0002\t\u0013\t%\u0011%!AA\u0004\t-\u0011AC3wS\u0012,gnY3%iA1\u00111KAE\u0005\u001b\u00012\u0001\u001fB\b\t\u0019\t\t*\tb\u0001w\"1\u0011\u0011A\u0011A\u0002eCq!a/\"\u0001\u0004\u0011)\u0002\u0005\u0004\u0002T\u0005u%Q\u0002\u000b\u0005\u0003\u0007\u0014I\u0002\u0003\u0004\u0002F\u000e\u0002\ra\u0011")
public final class InMemoryCacheStore {
    public static CacheStoreFactoryFactory factory(long l) {
        return InMemoryCacheStore$.MODULE$.factory(l);
    }

    public static interface CacheStoreFactoryFactory
    extends AutoCloseable {
        public <J> CacheStoreFactory apply(Path var1, SupportConverter<J> var2, IsoString<J> var3);
    }

    public static class CacheStoreFactoryFactoryImpl
    implements CacheStoreFactoryFactory {
        private final long size;
        private final AtomicReference<InMemoryCacheStore> storeRef;

        @Override
        public void close() {
            Option$.MODULE$.apply((Object)this.storeRef.get()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <J> CacheStoreFactory apply(Path path, SupportConverter<J> supportConverter, IsoString<J> evidence$3) {
            InMemoryCacheStore inMemoryCacheStore;
            InMemoryCacheStore inMemoryCacheStore2 = this.storeRef.get();
            if (inMemoryCacheStore2 == null) {
                InMemoryCacheStore inMemoryCacheStore3;
                AtomicReference<InMemoryCacheStore> atomicReference = this.storeRef;
                synchronized (atomicReference) {
                    InMemoryCacheStore inMemoryCacheStore4;
                    InMemoryCacheStore inMemoryCacheStore5 = this.storeRef.get();
                    if (inMemoryCacheStore5 == null) {
                        InMemoryCacheStore s = new InMemoryCacheStore(this.size);
                        this.storeRef.set(s);
                        inMemoryCacheStore4 = s;
                    } else {
                        inMemoryCacheStore4 = inMemoryCacheStore5;
                    }
                    inMemoryCacheStore3 = inMemoryCacheStore4;
                }
                inMemoryCacheStore = inMemoryCacheStore3;
            } else {
                inMemoryCacheStore = inMemoryCacheStore2;
            }
            InMemoryCacheStore store = inMemoryCacheStore;
            return InMemoryCacheStore$.MODULE$.sbt$internal$InMemoryCacheStore$$factory(store, path, supportConverter, evidence$3);
        }

        public CacheStoreFactoryFactoryImpl(long size) {
            this.size = size;
            this.storeRef = new AtomicReference();
        }
    }

    public static class CacheStoreImpl
    extends CacheStore {
        private final Path path;
        private final InMemoryCacheStore store;
        private final CacheStore cacheStore;

        public void delete() {
            this.cacheStore.delete();
        }

        /*
         * Enabled aggressive block sorting
         */
        public <T> T read(JsonReader<T> reader2) {
            Object object;
            Some some;
            Tuple2 tuple2;
            long lastModified = IO$.MODULE$.getModifiedTimeOrZero(this.path.toFile());
            Option option = this.store.get(this.path);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Object value = tuple2._1();
                long l = tuple2._2$mcJ$sp();
                if (lastModified == l) {
                    object = value;
                    return (T)object;
                }
            }
            object = this.cacheStore.read(reader2);
            return (T)object;
        }

        /*
         * Enabled aggressive block sorting
         */
        public <T> void write(T value, JsonWriter<T> writer) {
            Some some;
            Tuple2 tuple2;
            long lastModified = IO$.MODULE$.getModifiedTimeOrZero(this.path.toFile());
            Option option = this.store.get(this.path);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Object v = tuple2._1();
                long l = tuple2._2$mcJ$sp();
                if (lastModified == l && BoxesRunTime.equals((Object)v, value)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            this.store.remove(this.path);
            this.cacheStore.write(value, writer);
            long newLastModified = System.currentTimeMillis();
            IO$.MODULE$.setModifiedTimeOrFalse(this.path.toFile(), newLastModified);
            this.store.put(this.path, value, newLastModified);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public void close() {
            this.store.remove(this.path);
            this.cacheStore.close();
        }

        public CacheStoreImpl(Path path, InMemoryCacheStore store, CacheStore cacheStore) {
            this.path = path;
            this.store = store;
            this.cacheStore = cacheStore;
        }
    }

    public static class InMemoryCacheStore
    implements AutoCloseable {
        private final Weigher<Path, Tuple3<Object, Object, Object>> weigher = (x0$1, x1$1) -> {
            int size;
            Tuple3 tuple3;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null || (tuple3 = (Tuple3)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            int n = size = BoxesRunTime.unboxToInt((Object)tuple3._3());
            return n;
        };
        private final Cache<Path, Tuple3<Object, Object, Object>> files;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public <T> Option<Tuple2<T, Object>> get(Path path) {
            Tuple3 tuple3 = (Tuple3)this.files.getIfPresent((Object)path);
            if (tuple3 == null) {
                return None$.MODULE$;
            }
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            Object value = tuple3._1();
            long lastModified = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (!(value instanceof Object)) throw new MatchError((Object)tuple3);
            Object object = value;
            return new Some((Object)new Tuple2(object, (Object)BoxesRunTime.boxToLong((long)lastModified)));
        }

        public void put(Path path, Object value, long lastModified) {
            try {
                if (lastModified > 0L) {
                    BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    this.files.put((Object)path, (Object)new Tuple3(value, (Object)BoxesRunTime.boxToLong((long)lastModified), (Object)BoxesRunTime.boxToInteger((int)Math.toIntExact(attributes.size()))));
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof ArithmeticException;
                if (bl) {
                    this.files.invalidate((Object)path);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        public void remove(Path path) {
            this.files.invalidate((Object)path);
        }

        @Override
        public void close() {
            this.files.invalidateAll();
            this.files.cleanUp();
        }

        public InMemoryCacheStore(long maxSize) {
            this.files = Caffeine.newBuilder().maximumWeight(maxSize).weigher(this.weigher).build();
        }
    }
}

