/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import sbt.internal.GCMonitorBase;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001i4AAD\b\u0001)!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u00033\u0001\u0011E3\u0007C\u0003=\u0001\u0011ES\bC\u0004B\u0001\t\u0007IQ\u0001\"\t\r\u0015\u0003\u0001\u0015!\u0004D\u0011\u001d1\u0005A1A\u0005\u0002\u001dCaa\u0013\u0001!\u0002\u0013A\u0005\"\u0002'\u0001\t\u0003i\u0005\"\u00020\u0001\t#z\u0006b\u00026\u0001\u0005\u0004%\ta\u001b\u0005\u0007o\u0002\u0001\u000b\u0011\u00027\t\u000ba\u0004A\u0011I=\u0003\u0013\u001d\u001bUj\u001c8ji>\u0014(B\u0001\t\u0012\u0003!Ig\u000e^3s]\u0006d'\"\u0001\n\u0002\u0007M\u0014Go\u0001\u0001\u0014\t\u0001)2d\b\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"A\b\n\u0005yy!!D$D\u001b>t\u0017\u000e^8s\u0005\u0006\u001cX\r\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005!A.\u00198h\u0015\u0005!\u0013\u0001\u00026bm\u0006L!AJ\u0011\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f\u0003\u0019awnZ4feB\u0011\u0011\u0006L\u0007\u0002U)\u00111&E\u0001\u0005kRLG.\u0003\u0002.U\t1Aj\\4hKJ\fa\u0001P5oSRtDC\u0001\u00192!\ta\u0002\u0001C\u0003(\u0005\u0001\u0007\u0001&\u0001\u0004xS:$wn^\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011hF\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u001e7\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fQA]1uS>,\u0012A\u0010\t\u0003-}J!\u0001Q\f\u0003\r\u0011{WO\u00197f\u0003\t9%)F\u0001D\u001f\u0005!\u0005\u0005C!Q\u0002\u0001\u0001\u0001\u0001\u0001\u0001\u0002\u0007\u001d\u0013\u0005%A\u0004sk:$\u0018.\\3\u0016\u0003!\u0003\"\u0001I%\n\u0005)\u000b#a\u0002*v]RLW.Z\u0001\teVtG/[7fA\u0005AqMY*ue&tw\r\u0006\u0002O3B\u0011qJ\u0016\b\u0003!R\u0003\"!U\f\u000e\u0003IS!aU\n\u0002\rq\u0012xn\u001c;?\u0013\t)v#\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u0018\u0011\u0015Q\u0016\u00021\u0001\\\u0003\u0005q\u0007C\u0001\f]\u0013\tivC\u0001\u0003M_:<\u0017aC3nSR<\u0016M\u001d8j]\u001e$2\u0001Y2f!\t1\u0012-\u0003\u0002c/\t!QK\\5u\u0011\u0015!'\u00021\u0001\\\u0003\u0015!x\u000e^1m\u0011\u00151'\u00021\u0001h\u0003\u0011yg/\u001a:\u0011\u0007YA7,\u0003\u0002j/\t1q\n\u001d;j_:\f\u0001B]3n_Z,'o]\u000b\u0002YB\u0019QN\u001d;\u000e\u00039T!a\u001c9\u0002\u000f5,H/\u00192mK*\u0011\u0011oF\u0001\u000bG>dG.Z2uS>t\u0017BA:o\u0005\u0019\u0011UO\u001a4feB\u0019a#\u001e1\n\u0005Y<\"!\u0003$v]\u000e$\u0018n\u001c81\u0003%\u0011X-\\8wKJ\u001c\b%A\u0003dY>\u001cX\rF\u0001a\u0001")
public class GCMonitor
implements GCMonitorBase,
AutoCloseable {
    private final Logger logger;
    private final Runtime runtime;
    private final Buffer<Function0<BoxedUnit>> removers;
    private final LinkedBlockingQueue<Tuple2<FiniteDuration, Object>> queue;
    private final Iterable<Tuple2<FiniteDuration, Object>> queueScala;
    private final AtomicReference<Deadline> sbt$internal$GCMonitorBase$$lastWarned;
    private final long startTime;

    @Override
    public void totalCollectionTimeChanged(long nowMillis, long collectionTime, AtomicReference<Tuple2<FiniteDuration, Object>> collectionTimeStore) {
        GCMonitorBase.totalCollectionTimeChanged$(this, nowMillis, collectionTime, collectionTimeStore);
    }

    @Override
    public LinkedBlockingQueue<Tuple2<FiniteDuration, Object>> queue() {
        return this.queue;
    }

    @Override
    public Iterable<Tuple2<FiniteDuration, Object>> queueScala() {
        return this.queueScala;
    }

    @Override
    public AtomicReference<Deadline> sbt$internal$GCMonitorBase$$lastWarned() {
        return this.sbt$internal$GCMonitorBase$$lastWarned;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public void sbt$internal$GCMonitorBase$_setter_$queue_$eq(LinkedBlockingQueue<Tuple2<FiniteDuration, Object>> x$1) {
        this.queue = x$1;
    }

    @Override
    public void sbt$internal$GCMonitorBase$_setter_$queueScala_$eq(Iterable<Tuple2<FiniteDuration, Object>> x$1) {
        this.queueScala = x$1;
    }

    @Override
    public final void sbt$internal$GCMonitorBase$_setter_$sbt$internal$GCMonitorBase$$lastWarned_$eq(AtomicReference<Deadline> x$1) {
        this.sbt$internal$GCMonitorBase$$lastWarned = x$1;
    }

    @Override
    public void sbt$internal$GCMonitorBase$_setter_$startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    @Override
    public FiniteDuration window() {
        return new package.DurationInt(package$.MODULE$.DurationInt(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(System.getProperty("sbt.gc.monitor.window", "10"))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10)))).seconds();
    }

    @Override
    public double ratio() {
        return BoxesRunTime.unboxToDouble((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(System.getProperty("sbt.gc.monitor.ratio", "0.5"))).toDouble()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.5));
    }

    public final double GB() {
        return 1.073741824E9;
    }

    public Runtime runtime() {
        return this.runtime;
    }

    public String gbString(long n) {
        double arg$macro$1 = (double)n / 1.073741824E9;
        return new StringOps("%.2fGB").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
    }

    @Override
    public void emitWarning(long total, Option<Object> over) {
        double totalSeconds = (double)total / 1000.0;
        String amountMsg = (String)over.fold((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append(totalSeconds).append(" seconds").toString(), (Function1 & Serializable & scala.Serializable)d -> GCMonitor.$anonfun$emitWarning$2(totalSeconds, total, BoxesRunTime.unboxToLong((Object)d)));
        String msg = new StringBuilder(163).append(amountMsg).append(" were spent in GC. ").append("[Heap: ").append(this.gbString(this.runtime().freeMemory())).append(" free ").append("of ").append(this.gbString(this.runtime().totalMemory())).append(", ").append("max ").append(this.gbString(this.runtime().maxMemory())).append("] ").append("Consider increasing the JVM heap using `-Xmx` or try ").append("a different collector, e.g. `-XX:+UseG1GC`, for better performance.").toString();
        this.logger.warn((Function0 & Serializable & scala.Serializable)() -> msg);
    }

    public Buffer<Function0<BoxedUnit>> removers() {
        return this.removers;
    }

    @Override
    public void close() {
        this.removers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$emitWarning$2(double totalSeconds$1, long total$1, long d) {
        Double arg$macro$1 = BoxesRunTime.boxToDouble((double)totalSeconds$1);
        double arg$macro$2 = (double)total$1 / (double)d * (double)100;
        return new StringBuilder(12).append("In the last ").append((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)d / 1000.0))).append(new StringOps(" seconds, %s (%.1f%%)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}))).toString();
    }

    public GCMonitor(Logger logger) {
        this.logger = logger;
        GCMonitorBase.$init$(this);
        this.runtime = Runtime.getRuntime();
        this.removers = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            GarbageCollectorMXBean garbageCollectorMXBean = x0$1;
            if (garbageCollectorMXBean instanceof NotificationEmitter) {
                GarbageCollectorMXBean garbageCollectorMXBean2 = garbageCollectorMXBean;
                AtomicReference<Tuple2> collectionTimeStore = new AtomicReference<Tuple2>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new package.DurationLong(package$.MODULE$.DurationLong(System.currentTimeMillis())).millis()), (Object)BoxesRunTime.boxToLong((long)garbageCollectorMXBean2.getCollectionTime())));
                NotificationListener listener = (notification, x$3) -> this.totalCollectionTimeChanged(notification.getTimeStamp(), garbageCollectorMXBean2.getCollectionTime(), collectionTimeStore);
                ((NotificationBroadcaster)((Object)garbageCollectorMXBean2)).addNotificationListener(listener, null, null);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((NotificationBroadcaster)((Object)garbageCollectorMXBean2)).removeNotificationListener(listener)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom());
    }
}

