/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.Serializable;
import sbt.ProjectRef;
import sbt.StandardMain$;
import sbt.internal.CommandExchange;
import sbt.internal.bsp.BuildServerTasks$;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.BuildTargetName$;
import sbt.internal.bsp.CompileReport;
import sbt.internal.bsp.CompileReport$;
import sbt.internal.bsp.TaskId;
import sbt.internal.bsp.TaskId$;
import sbt.internal.io.Retry$;
import sbt.internal.server.BspCompileTask;
import sbt.librarymanagement.Configuration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import xsbti.CompileFailed;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.compile.CompileResult;

public final class BspCompileTask$
implements scala.Serializable {
    public static BspCompileTask$ MODULE$;
    private CommandExchange sbt$internal$server$BspCompileTask$$exchange;
    private volatile boolean bitmap$0;

    static {
        new BspCompileTask$();
    }

    private CommandExchange exchange$lzycompute() {
        BspCompileTask$ bspCompileTask$ = this;
        synchronized (bspCompileTask$) {
            if (!this.bitmap$0) {
                this.sbt$internal$server$BspCompileTask$$exchange = StandardMain$.MODULE$.exchange();
                this.bitmap$0 = true;
            }
        }
        return this.sbt$internal$server$BspCompileTask$$exchange;
    }

    public CommandExchange sbt$internal$server$BspCompileTask$$exchange() {
        return !this.bitmap$0 ? this.exchange$lzycompute() : this.sbt$internal$server$BspCompileTask$$exchange;
    }

    public CompileResult compute(BuildTargetIdentifier targetId, ProjectRef project, Configuration config, Function1<BspCompileTask, CompileResult> compile) {
        CompileResult compileResult;
        BspCompileTask task = this.apply(targetId, project, config);
        try {
            task.notifyStart();
            CompileResult result = (CompileResult)Retry$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CompileResult)compile.apply((Object)task), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[0]));
            task.notifySuccess(result);
            compileResult = result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                None$ none$;
                Throwable cause = (Throwable)option.get();
                Throwable throwable3 = cause;
                if (throwable3 instanceof CompileFailed) {
                    CompileFailed compileFailed = (CompileFailed)throwable3;
                    none$ = new Some((Object)compileFailed);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ compileFailed = none$;
                task.notifyFailure((Option<CompileFailed>)compileFailed);
                throw cause;
            }
            throw throwable;
        }
        return compileResult;
    }

    private BspCompileTask apply(BuildTargetIdentifier targetId, ProjectRef project, Configuration config) {
        TaskId taskId = TaskId$.MODULE$.apply(BuildServerTasks$.MODULE$.uniqueId(), (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$));
        String targetName = BuildTargetName$.MODULE$.fromScope(project.project(), config.name());
        return this.apply(targetId, targetName, taskId, System.currentTimeMillis());
    }

    public CompileReport sbt$internal$server$BspCompileTask$$compileReport(Seq<Problem> problems, BuildTargetIdentifier targetId, long elapsedTimeMillis) {
        Map countBySeverity = problems.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.severity()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()));
        int warnings = BoxesRunTime.unboxToInt((Object)countBySeverity.getOrElse((Object)Severity.Warn, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int errors = BoxesRunTime.unboxToInt((Object)countBySeverity.getOrElse((Object)Severity.Error, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return CompileReport$.MODULE$.apply(targetId, (Option)None$.MODULE$, errors, warnings, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((int)elapsedTimeMillis))));
    }

    public BspCompileTask apply(BuildTargetIdentifier targetId, String targetName, TaskId id, long startTimeMillis) {
        return new BspCompileTask(targetId, targetName, id, startTimeMillis);
    }

    public Option<Tuple4<BuildTargetIdentifier, String, TaskId, Object>> unapply(BspCompileTask x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.targetId(), (Object)x$0.targetName(), (Object)x$0.id(), (Object)BoxesRunTime.boxToLong((long)x$0.startTimeMillis())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BspCompileTask$() {
        MODULE$ = this;
    }
}

