/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import sbt.BuildPaths$;
import sbt.BuiltinCommands$;
import sbt.Command$;
import sbt.Extracted;
import sbt.Keys$;
import sbt.Project$;
import sbt.ProjectRef;
import sbt.ProjectReference;
import sbt.Reference$;
import sbt.ResolvedProject;
import sbt.State;
import sbt.State$;
import sbt.compiler.Eval;
import sbt.internal.BuildStructure;
import sbt.internal.SessionSettings;
import sbt.internal.parser.SbtRefactorings$;
import sbt.internal.util.Init;
import sbt.internal.util.LineRange;
import sbt.internal.util.RangePosition;
import sbt.internal.util.SourcePosition;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SessionSettings$
implements scala.Serializable {
    public static SessionSettings$ MODULE$;
    private Parser<SessionSettings.SessionCommand> parser;
    private Parser<SessionSettings.Remove> remove;
    private volatile byte bitmap$0;

    static {
        new SessionSettings$();
    }

    public State reapply(SessionSettings session, State s) {
        return BuiltinCommands$.MODULE$.reapply(session, Project$.MODULE$.structure(s), s);
    }

    public State clearSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            Map x$1 = (Map)session.append().$minus((Object)session.current());
            URI x$2 = session.copy$default$1();
            Map<URI, String> x$3 = session.copy$default$2();
            Seq<Init.Setting<?>> x$4 = session.copy$default$3();
            Seq<Init.Setting<?>> x$5 = session.copy$default$5();
            Function0<Eval> x$6 = session.copy$default$6();
            return MODULE$.reapply(session.copy(x$2, x$3, x$4, x$1, x$5, x$6), s);
        });
    }

    public State clearAllSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> MODULE$.reapply(session.clearExtraSettings(), s));
    }

    public State withSettings(State s, Function1<SessionSettings, State> f) {
        Extracted extracted = Project$.MODULE$.extract(s);
        if (extracted.session().append().isEmpty()) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> "No session settings defined.");
            return s;
        }
        return (State)f.apply((Object)extracted.session());
    }

    public String pluralize(int size, String of) {
        return new StringBuilder(0).append(Integer.toString(size)).append((Object)(size == 1 ? of : new StringBuilder(1).append(of).append("s").toString())).toString();
    }

    public void checkSession(SessionSettings newSession, State oldState) {
        List oldSettings = (List)((List)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(oldState), Keys$.MODULE$.sessionSettings()).toList().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.append(), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4._2(), List$.MODULE$.canBuildFrom());
        if (newSession.append().isEmpty() && oldSettings.nonEmpty()) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(oldState)).warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Discarding ").append(MODULE$.pluralize(oldSettings.size(), " session setting")).append(".  Use 'session save' to persist session settings.").toString());
            return;
        }
    }

    public <T> Seq<T> removeRanges(Seq<T> in, Seq<Tuple2<Object, Object>> ranges) {
        Set asSet = (Set)ranges.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Set s = (Set)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    int hi = tuple22._1$mcI$sp();
                    int lo = tuple22._2$mcI$sp();
                    return (Set)s.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(hi), lo));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return (Seq)((TraversableLike)in.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object t = tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (asSet.apply((Object)BoxesRunTime.boxToInteger((int)(index + 1)))) {
                    return Nil$.MODULE$;
                }
                Object object = t;
                return Nil$.MODULE$.$colon$colon(object);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public State removeSettings(State s, Seq<Tuple2<Object, Object>> ranges) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            Map newAppend;
            ProjectRef current = session.current();
            Map x$1 = newAppend = session.append().updated((Object)current, MODULE$.removeRanges((Seq)session.append().getOrElse((Object)current, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), ranges));
            URI x$2 = session.copy$default$1();
            Map<URI, String> x$3 = session.copy$default$2();
            Seq<Init.Setting<?>> x$4 = session.copy$default$3();
            Seq<Init.Setting<?>> x$5 = session.copy$default$5();
            Function0<Eval> x$6 = session.copy$default$6();
            return MODULE$.reapply(session.copy(x$2, x$3, x$4, x$1, x$5, x$6), s);
        });
    }

    public State saveAllSettings(State s) {
        return this.saveSomeSettings(s, (Function1<ProjectRef, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveAllSettings$1(x$6)));
    }

    public State saveSettings(State s) {
        ProjectRef current = Project$.MODULE$.session(s).current();
        return this.saveSomeSettings(s, (Function1<ProjectRef, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveSettings$1(current, x$7)));
    }

    public State saveSomeSettings(State s, Function1<ProjectRef, Object> include) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            Map newSettings = (Map)session.append().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveSomeSettings$2(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveSomeSettings$3(include, x$9))).map((Function1 & Serializable & scala.Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 != null) {
                    Seq settings;
                    ProjectRef ref = (ProjectRef)tuple2._1();
                    Tuple2<Seq<Tuple2<Init.Setting<?>, Seq<String>>>, Seq<Init.Setting<?>>> tuple22 = MODULE$.writeSettings(ref, (settings = (Seq)tuple2._2()).toList(), session.original(), Project$.MODULE$.structure(s));
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Seq news = (Seq)tuple22._1();
                    Seq olds = (Seq)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)news, (Object)olds);
                    Seq news2 = (Seq)tuple23._1();
                    Seq olds2 = (Seq)tuple23._2();
                    return new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ref), (Object)news2), (Object)olds2);
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            Tuple2 tuple2 = newSettings.unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable newAppend = (Iterable)tuple2._1();
            Iterable newOriginal = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newAppend, (Object)newOriginal);
            Iterable newAppend2 = (Iterable)tuple22._1();
            Iterable newOriginal2 = (Iterable)tuple22._2();
            Map x$1 = newAppend2.toMap(Predef$.MODULE$.$conforms());
            Seq x$2 = ((TraversableOnce)newOriginal2.flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            URI x$3 = session.copy$default$1();
            Map<URI, String> x$4 = session.copy$default$2();
            Seq<Init.Setting<?>> x$5 = session.copy$default$5();
            Function0<Eval> x$6 = session.copy$default$6();
            SessionSettings newSession = session.copy(x$3, x$4, x$2, x$1, x$5, x$6);
            Seq<Init.Setting<?>> x$7 = newSession.mergeSettings();
            Map x$8 = Predef$.MODULE$.Map().empty();
            URI x$92 = newSession.copy$default$1();
            Map<URI, String> x$102 = newSession.copy$default$2();
            Seq<Init.Setting<?>> x$11 = newSession.copy$default$5();
            Function0<Eval> x$12 = newSession.copy$default$6();
            return MODULE$.reapply(newSession.copy(x$92, x$102, x$7, x$8, x$11, x$12), s);
        });
    }

    public Tuple2<Seq<Tuple2<Init.Setting<?>, Seq<String>>>, Seq<Init.Setting<?>>> writeSettings(ProjectRef pref, List<Tuple2<Init.Setting<?>, Seq<String>>> settings, Seq<Init.Setting<?>> original, BuildStructure structure) {
        ResolvedProject project = (ResolvedProject)Project$.MODULE$.getProject(pref, structure).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(26).append("Invalid project reference ").append(pref).toString()));
        File writeTo = (File)BuildPaths$.MODULE$.configurationSources(project.base()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> new File(project.base(), "build.sbt"));
        writeTo.createNewFile();
        String path = writeTo.getAbsolutePath();
        Tuple3 tuple3 = (Tuple3)((TraversableOnce)original.reverse()).foldLeft((Object)new Tuple3((Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Init.Setting s = (Init.Setting)tuple2._2();
                if (tuple3 != null) {
                    List in = (List)tuple3._1();
                    List oth = (List)tuple3._2();
                    Set keys = (Set)tuple3._3();
                    SourcePosition sourcePosition = s.pos();
                    if (sourcePosition instanceof RangePosition) {
                        RangePosition rangePosition = (RangePosition)sourcePosition;
                        String string = rangePosition.path();
                        String string2 = path;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && !keys.contains((Object)s.key())) {
                            Init.Setting setting = s;
                            return new Tuple3((Object)in.$colon$colon((Object)setting), (Object)oth, (Object)keys.$plus((Object)s.key()));
                        }
                    }
                    Init.Setting setting = s;
                    return new Tuple3((Object)in, (Object)oth.$colon$colon((Object)setting), (Object)keys);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        List inFile = (List)tuple3._1();
        List other = (List)tuple3._2();
        Tuple2 tuple2 = new Tuple2((Object)inFile, (Object)other);
        List inFile2 = (List)tuple2._1();
        List other2 = (List)tuple2._2();
        Tuple3 tuple32 = (Tuple3)inFile2.foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)Nil$.MODULE$, (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Init.Setting s = (Init.Setting)tuple2._2();
                if (tuple3 != null) {
                    Init.Setting shifted;
                    Some some;
                    Tuple2 ss;
                    RangePosition rangePosition;
                    LineRange r;
                    int offs = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    List olds = (List)tuple3._2();
                    Seq repl = (Seq)tuple3._3();
                    SourcePosition sourcePosition = s.pos();
                    if (!(sourcePosition instanceof RangePosition) || (r = (rangePosition = (RangePosition)sourcePosition).range()) == null) {
                        throw new MatchError((Object)sourcePosition);
                    }
                    int start = r.start();
                    int end = r.end();
                    Tuple3 tuple32 = new Tuple3((Object)r, (Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)end));
                    LineRange r2 = (LineRange)tuple32._1();
                    int start2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
                    int end2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                    Option option = settings.find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$writeSettings$5(s, x$16)));
                    if (option instanceof Some && (ss = (Tuple2)(some = (Some)option).value()) != null) {
                        Init.Setting ns = (Init.Setting)ss._1();
                        Seq newLines = (Seq)ss._2();
                        if (!ns.init().dependencies().contains((Object)ns.key())) {
                            Init.Setting shifted2;
                            Init.Setting setting = shifted2 = ns.withPos((SourcePosition)new RangePosition(path, new LineRange(start2 - offs, start2 - offs + newLines.size())));
                            Tuple2 tuple22 = ss;
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(offs + end2 - start2 - newLines.size())), (Object)olds.$colon$colon((Object)setting), repl.$plus$colon((Object)tuple22, Seq$.MODULE$.canBuildFrom()));
                        }
                    }
                    Init.Setting setting = shifted = s.withPos((SourcePosition)new RangePosition(path, r2.shift(-offs)));
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)offs), (Object)olds.$colon$colon((Object)setting), (Object)repl);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        List oldShifted = (List)tuple32._2();
        Seq replace = (Seq)tuple32._3();
        Tuple2 tuple22 = new Tuple2((Object)oldShifted, (Object)replace);
        List oldShifted2 = (List)tuple22._1();
        Seq replace2 = (Seq)tuple22._2();
        List newSettings = (List)settings.diff((GenSeq)replace2);
        List oldContent = IO$.MODULE$.readLines(writeTo, IO$.MODULE$.readLines$default$2());
        Tuple2<File, Seq<String>> tuple23 = SbtRefactorings$.MODULE$.applySessionSettings((Tuple2<File, Seq<String>>)new Tuple2((Object)writeTo, (Object)oldContent), replace2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Seq exist = (Seq)tuple23._2();
        Seq exist2 = exist;
        Seq adjusted = newSettings.nonEmpty() && this.needsTrailingBlank((Seq<String>)exist2) ? (Seq)exist2.$colon$plus((Object)"", Seq$.MODULE$.canBuildFrom()) : exist2;
        Seq lines = (Seq)adjusted.$plus$plus((GenTraversableOnce)newSettings.flatMap((Function1 & Serializable & scala.Serializable)x -> (Seq)((SeqLike)x._2()).$colon$plus((Object)"", Seq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        IO$.MODULE$.writeLines(writeTo, lines, IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
        Tuple2 tuple24 = (Tuple2)newSettings.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(adjusted.size() + 1))), (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    List acc = (List)tuple22._1();
                    int line = tuple22._2$mcI$sp();
                    if (tuple23 != null) {
                        Init.Setting s = (Init.Setting)tuple23._1();
                        Seq newLines = (Seq)tuple23._2();
                        int endLine = line + newLines.size();
                        Tuple2 tuple24 = new Tuple2((Object)s.withPos((SourcePosition)new RangePosition(path, new LineRange(line, endLine))), (Object)newLines);
                        return new Tuple2((Object)acc.$colon$colon((Object)tuple24), (Object)BoxesRunTime.boxToInteger((int)(endLine + 1)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        List newWithPos = (List)tuple24._1();
        List newWithPos2 = newWithPos;
        return new Tuple2((Object)newWithPos2.reverse(), other2.$plus$plus((GenTraversableOnce)oldShifted2, List$.MODULE$.canBuildFrom()));
    }

    public boolean needsTrailingBlank(Seq<String> lines) {
        return lines.nonEmpty() && !((IterableLike)lines.takeRight(1)).exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$needsTrailingBlank$1(x$22)));
    }

    public State printAllSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            session.append().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$printAllSettings$2(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$printAllSettings$3(x$23))).foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
                SessionSettings$.$anonfun$printAllSettings$4(x$24);
                return BoxedUnit.UNIT;
            });
            return s;
        });
    }

    public State printSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            MODULE$.printSettings((Seq)session.append().getOrElse((Object)session.current(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            return s;
        });
    }

    public void printSettings(Seq<Tuple2<Init.Setting<?>, Seq<String>>> settings) {
        ((TraversableLike)settings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$printSettings$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            SessionSettings$.$anonfun$printSettings$4(x$25);
            return BoxedUnit.UNIT;
        });
    }

    public String Help() {
        return "session <command>\n\nManipulates session settings, which are temporary settings that do not persist past the current sbt execution (that is, the current session).\nValid commands are:\n\nclear, clear-all\n\n\tRemoves temporary settings added using 'set' and re-evaluates all settings.\n\tFor 'clear', only the settings defined for the current project are cleared.\n\tFor 'clear-all', all settings in all projects are cleared.\n\nlist, list-all\n\n\tPrints a numbered list of session settings defined.\n\tThe numbers may be used to remove individual settings or ranges of settings using 'remove'.\n\tFor 'list', only the settings for the current project are printed.\n\tFor 'list-all', all settings in all projets are printed.\n\nremove <range-spec>\n\n\t<range-spec> is a comma-separated list of individual numbers or ranges of numbers.\n\tFor example, 'remove 1,3,5-7'.\n\tThe temporary settings at the given indices for the current project are removed and all settings are re-evaluated.\n\tUse the 'list' command to see a numbered list of settings for the current project.\n\nsave, save-all\n\n\tMakes the session settings permanent by writing them to a '.sbt' configuration file.\n\tFor 'save', only the current project's settings are saved (the settings for other projects are left alone).\n\tFor 'save-all', the session settings are saved for all projects.\n\tThe session settings defined for a project are appended to the first '.sbt' configuration file in that project.\n\tIf no '.sbt' configuration file exists, the settings are written to 'build.sbt' in the project's base directory.";
    }

    private Parser<SessionSettings.SessionCommand> parser$lzycompute() {
        SessionSettings$ sessionSettings$ = this;
        synchronized (sessionSettings$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.parser = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("list-all").$up$up$up((Object)new SessionSettings.Print(true)))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("list").$up$up$up((Object)new SessionSettings.Print(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("clear").$up$up$up((Object)new SessionSettings.Clear(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("save-all").$up$up$up((Object)new SessionSettings.Save(true))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("save").$up$up$up((Object)new SessionSettings.Save(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("clear-all").$up$up$up((Object)new SessionSettings.Clear(true))))).$bar(this.remove()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.parser;
    }

    public Parser<SessionSettings.SessionCommand> parser() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    private Parser<SessionSettings.Remove> remove$lzycompute() {
        SessionSettings$ sessionSettings$ = this;
        synchronized (sessionSettings$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.remove = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literal("remove"))).$tilde$greater(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space()))).$tilde$greater(DefaultParsers$.MODULE$.richParser(this.natSelect()).map((Function1 & Serializable & scala.Serializable)ranges -> new SessionSettings.Remove((Seq<Tuple2<Object, Object>>)ranges)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.remove;
    }

    public Parser<SessionSettings.Remove> remove() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.remove$lzycompute();
        }
        return this.remove;
    }

    public Parser<Seq<Tuple2<Object, Object>>> natSelect() {
        return DefaultParsers$.MODULE$.rep1sep(DefaultParsers$.MODULE$.token(this.range(), "<range>"), DefaultParsers$.MODULE$.literal(','));
    }

    public Parser<Tuple2<Object, Object>> range() {
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.NatBasic()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichCharParser('-').$tilde$greater(DefaultParsers$.MODULE$.NatBasic())).$qmark())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            Some some = DefaultParsers$.MODULE$.$tilde().unapply(tuple2);
            if (!some.isEmpty()) {
                int lo = ((Tuple2)some.get())._1$mcI$sp();
                Option hi = (Option)((Tuple2)some.get())._2();
                return new Tuple2.mcII.sp(lo, BoxesRunTime.unboxToInt((Object)hi.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> lo)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Parser<Function0<State>> command(State s) {
        return Command$.MODULE$.applyEffect(this.parser(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            SessionSettings.SessionCommand sessionCommand = x0$1;
            if (sessionCommand instanceof SessionSettings.Print) {
                SessionSettings.Print print = (SessionSettings.Print)sessionCommand;
                if (print.all()) {
                    return MODULE$.printAllSettings(s);
                }
                return MODULE$.printSettings(s);
            }
            if (sessionCommand instanceof SessionSettings.Save) {
                SessionSettings.Save save = (SessionSettings.Save)sessionCommand;
                if (save.all()) {
                    return MODULE$.saveAllSettings(s);
                }
                return MODULE$.saveSettings(s);
            }
            if (sessionCommand instanceof SessionSettings.Clear) {
                SessionSettings.Clear clear = (SessionSettings.Clear)sessionCommand;
                if (clear.all()) {
                    return MODULE$.clearAllSettings(s);
                }
                return MODULE$.clearSettings(s);
            }
            if (sessionCommand instanceof SessionSettings.Remove) {
                SessionSettings.Remove remove = (SessionSettings.Remove)sessionCommand;
                return MODULE$.removeSettings(s, remove.ranges());
            }
            throw new MatchError((Object)sessionCommand);
        });
    }

    public SessionSettings apply(URI currentBuild, Map<URI, String> currentProject, Seq<Init.Setting<?>> original, Map<ProjectRef, Seq<Tuple2<Init.Setting<?>, Seq<String>>>> append, Seq<Init.Setting<?>> rawAppend, Function0<Eval> currentEval) {
        return new SessionSettings(currentBuild, currentProject, original, append, rawAppend, currentEval);
    }

    public Option<Tuple6<URI, Map<URI, String>, Seq<Init.Setting<?>>, Map<ProjectRef, Seq<Tuple2<Init.Setting<?>, Seq<String>>>>, Seq<Init.Setting<?>>, Function0<Eval>>> unapply(SessionSettings x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.currentBuild(), x$0.currentProject(), x$0.original(), x$0.append(), x$0.rawAppend(), x$0.currentEval()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$saveAllSettings$1(ProjectRef x$6) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$saveSettings$1(ProjectRef current$1, ProjectRef x$7) {
        ProjectRef projectRef = x$7;
        ProjectRef projectRef2 = current$1;
        return !(projectRef != null ? !projectRef.equals(projectRef2) : projectRef2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$saveSomeSettings$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$saveSomeSettings$3(Function1 include$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            ProjectRef ref = (ProjectRef)tuple2._1();
            Seq settings = (Seq)tuple2._2();
            return settings.nonEmpty() && BoxesRunTime.unboxToBoolean((Object)include$1.apply((Object)ref));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$writeSettings$5(Init.Setting s$6, Tuple2 x$16) {
        Init.ScopedKey scopedKey = ((Init.Setting)x$16._1()).key();
        Init.ScopedKey scopedKey2 = s$6.key();
        return !(scopedKey != null ? !scopedKey.equals(scopedKey2) : scopedKey2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$needsTrailingBlank$1(String x$22) {
        return x$22.trim().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$printAllSettings$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$printAllSettings$3(Tuple2 x$23) {
        Tuple2 tuple2 = x$23;
        if (tuple2 != null) {
            Seq settings = (Seq)tuple2._2();
            return settings.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$printAllSettings$4(Tuple2 x$24) {
        Tuple2 tuple2 = x$24;
        if (tuple2 != null) {
            ProjectRef ref = (ProjectRef)tuple2._1();
            Seq settings = (Seq)tuple2._2();
            Predef$.MODULE$.println((Object)new StringBuilder(3).append("In ").append(Reference$.MODULE$.display((ProjectReference)ref)).toString());
            MODULE$.printSettings(settings);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$printSettings$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$3;
        return tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
    }

    public static final /* synthetic */ void $anonfun$printSettings$4(Tuple2 x$25) {
        Tuple2 tuple2 = x$25;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                Seq stringRep = (Seq)tuple22._2();
                Predef$.MODULE$.println((Object)new StringBuilder(4).append("  ").append(index + 1).append(". ").append(stringRep.mkString("\n")).toString());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private SessionSettings$() {
        MODULE$ = this;
    }
}

