/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.graph;

import java.io.File;
import java.io.Serializable;
import sbt.internal.graph.GraphModuleId;
import sbt.internal.graph.Module;
import sbt.internal.graph.ModuleGraph;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;

public final class GraphTransformations$ {
    public static GraphTransformations$ MODULE$;

    static {
        new GraphTransformations$();
    }

    public ModuleGraph reverseGraphStartingAt(ModuleGraph graph, GraphModuleId root) {
        Map<GraphModuleId, Seq<Module>> deps = graph.reverseDependencyMap();
        Seq edges = GraphTransformations$.visit$1(root, Predef$.MODULE$.Set().empty(), deps);
        Set nodes = (Set)((SetLike)edges.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(set, edge) -> (Set)set.$plus(edge._1()).$plus(edge._2()))).map((Function1 & Serializable & scala.Serializable)id -> graph.module((GraphModuleId)id), Set$.MODULE$.canBuildFrom());
        return new ModuleGraph((Seq<Module>)nodes.toSeq(), (Seq<Tuple2<GraphModuleId, GraphModuleId>>)edges);
    }

    public ModuleGraph ignoreScalaLibrary(String scalaVersion, ModuleGraph graph) {
        Seq newNodes = (Seq)((TraversableLike)graph.nodes().map((Function1 & Serializable & scala.Serializable)m -> GraphTransformations$.addScalaLibraryAnnotation$1(m, graph), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)GraphTransformations$.isScalaLibrary$1(m)));
        Seq newEdges = (Seq)graph.edges().filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)GraphTransformations$.isScalaLibraryId$1((GraphModuleId)e._2())));
        return new ModuleGraph((Seq<Module>)newNodes, (Seq<Tuple2<GraphModuleId, GraphModuleId>>)newEdges);
    }

    private static final Seq visit$1(GraphModuleId module, Set visited, Map deps$1) {
        if (visited.apply((Object)module)) {
            return Nil$.MODULE$;
        }
        Option option = deps$1.get((Object)module);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq deps = (Seq)some.value();
            return (Seq)deps.flatMap((Function1 & Serializable & scala.Serializable)to -> {
                Tuple2 tuple2 = new Tuple2((Object)module, (Object)to.id());
                return (Seq)GraphTransformations$.visit$1(to.id(), (Set)visited.$plus((Object)module), deps$1).$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom());
        }
        if (None$.MODULE$.equals(option)) {
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private static final boolean isScalaLibrary$1(Module m) {
        return GraphTransformations$.isScalaLibraryId$1(m.id());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isScalaLibraryId$1(GraphModuleId id) {
        String string = id.organization();
        String string2 = "org.scala-lang";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = id.name();
        String string4 = "scala-library";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    private static final boolean dependsOnScalaLibrary$1(Module m2, ModuleGraph graph$2) {
        return ((IterableLike)graph$2.dependencyMap().apply((Object)m2.id())).exists((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)GraphTransformations$.isScalaLibrary$1(m)));
    }

    private static final Module addScalaLibraryAnnotation$1(Module m, ModuleGraph graph$2) {
        if (GraphTransformations$.dependsOnScalaLibrary$1(m, graph$2)) {
            String x$1 = new StringBuilder(4).append(m.extraInfo()).append(" [S]").toString();
            GraphModuleId x$2 = m.copy$default$1();
            Option<String> x$3 = m.copy$default$2();
            Option<String> x$4 = m.copy$default$4();
            Option<File> x$5 = m.copy$default$5();
            Option<String> x$6 = m.copy$default$6();
            return m.copy(x$2, x$3, x$1, x$4, x$5, x$6);
        }
        return m;
    }

    private GraphTransformations$() {
        MODULE$ = this;
    }
}

