/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import sbt.AutoPlugin;
import sbt.BasicCommandStrings$;
import sbt.BasicCommands$;
import sbt.BuildPaths$;
import sbt.Command;
import sbt.Command$;
import sbt.CommandUtil$;
import sbt.Cross$;
import sbt.Exec;
import sbt.Exec$;
import sbt.Extracted;
import sbt.Help;
import sbt.Help$;
import sbt.InputTask;
import sbt.Keys$;
import sbt.PluginCross$;
import sbt.Project$;
import sbt.Project$LoadAction$;
import sbt.ProjectRef;
import sbt.ProjectReference;
import sbt.Reference$;
import sbt.ResolvedReference;
import sbt.Select;
import sbt.SessionVar$;
import sbt.StandardMain$;
import sbt.State;
import sbt.State$;
import sbt.Task;
import sbt.TemplateCommandUtil$;
import sbt.compiler.Eval;
import sbt.compiler.EvalException;
import sbt.compiler.EvalImports;
import sbt.compiler.EvalResult;
import sbt.internal.Act$;
import sbt.internal.Aggregation;
import sbt.internal.Aggregation$;
import sbt.internal.Banner$;
import sbt.internal.BuildStructure;
import sbt.internal.CommandChannel;
import sbt.internal.CommandExchange;
import sbt.internal.CommandStrings$;
import sbt.internal.ConsoleChannel$;
import sbt.internal.ConsolePromptEvent;
import sbt.internal.Continuous$;
import sbt.internal.ContinuousCommands$;
import sbt.internal.CrossJava$;
import sbt.internal.DefinedSbtValues;
import sbt.internal.EvaluateConfigurations$;
import sbt.internal.GCUtil$;
import sbt.internal.InMemoryCacheStore$;
import sbt.internal.Inspect$;
import sbt.internal.IvyConsole$;
import sbt.internal.LintUnused$;
import sbt.internal.Load$;
import sbt.internal.LoadedBuildUnit;
import sbt.internal.LogManager$;
import sbt.internal.Output$;
import sbt.internal.PluginsDebug$;
import sbt.internal.ProjectNavigation$;
import sbt.internal.Script$;
import sbt.internal.SessionSettings;
import sbt.internal.SessionSettings$;
import sbt.internal.SetResult;
import sbt.internal.SettingCompletions$;
import sbt.internal.StructureIndex;
import sbt.internal.SysProp$;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.nio.CheckBuildSources$;
import sbt.internal.nio.FileTreeRepository$;
import sbt.internal.server.BuildServerProtocol$;
import sbt.internal.server.NetworkChannel;
import sbt.internal.server.NetworkChannel$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.internal.util.AttributeMap;
import sbt.internal.util.AttributeMap$;
import sbt.internal.util.ConsoleAppender$;
import sbt.internal.util.GlobalLogBacking;
import sbt.internal.util.GlobalLogging;
import sbt.internal.util.Init;
import sbt.internal.util.LineRange;
import sbt.internal.util.ProgressState;
import sbt.internal.util.Prompt;
import sbt.internal.util.Terminal$;
import sbt.internal.util.Types$;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.SizeParser$;
import sbt.io.IO$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.std.Streams;
import sbt.util.Level$;
import sbt.util.Logger;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import sbt.util.Show;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import xsbti.AppConfiguration;
import xsbti.AppProvider;
import xsbti.compile.CompilerCache;

public final class BuiltinCommands$ {
    public static BuiltinCommands$ MODULE$;
    private final Function1<State, Parser<Seq<Init.ScopedKey<Object>>>> spacedAggregatedParser;
    private final Function1<State, Parser<Option<Seq<Aggregation.KeyValue<Object>>>>> aggregatedKeyValueParser;
    private final Function1<State, Parser<Function0<State>>> exportParser;
    private final Function1<State, Parser<AutoPlugin>> pluginParser;
    private final Function1<State, State> setupGlobalFileTreeRepository;
    private final Function1<State, State> addSuperShellParams;
    private final Function1<State, State> addCacheStoreFactoryFactory;
    private final Regex sbtVersionRegex;
    private final AttributeKey<Object> bannerHasBeenShown;
    private final String SkipBannerFileName;
    private final String SkipBanner;

    static {
        new BuiltinCommands$();
    }

    public AttributeMap initialAttributes() {
        return AttributeMap$.MODULE$.empty();
    }

    public Seq<Command> ConsoleCommands() {
        return (Seq)new .colon.colon((Object)BasicCommands$.MODULE$.ignore(), (List)new .colon.colon((Object)BasicCommands$.MODULE$.exit(), (List)new .colon.colon((Object)IvyConsole$.MODULE$.command(), (List)new .colon.colon((Object)this.setLogLevel(), (List)new .colon.colon((Object)BasicCommands$.MODULE$.early(), (List)new .colon.colon((Object)this.act(), (List)new .colon.colon((Object)BasicCommands$.MODULE$.nop(), (List)Nil$.MODULE$)))))));
    }

    public Seq<Command> ScriptCommands() {
        return (Seq)new .colon.colon((Object)BasicCommands$.MODULE$.ignore(), (List)new .colon.colon((Object)BasicCommands$.MODULE$.exit(), (List)new .colon.colon((Object)Script$.MODULE$.command(), (List)new .colon.colon((Object)this.setLogLevel(), (List)new .colon.colon((Object)BasicCommands$.MODULE$.early(), (List)new .colon.colon((Object)this.act(), (List)new .colon.colon((Object)BasicCommands$.MODULE$.nop(), (List)Nil$.MODULE$)))))));
    }

    public Seq<Command> DefaultCommands() {
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Command[]{BasicCommands$.MODULE$.multi(), this.about(), this.tasks(), this.settingsCommand(), this.loadProject(), TemplateCommandUtil$.MODULE$.templateCommand(), this.projects(), this.project(), this.set(), this.sessionCommand(), this.inspect(), this.loadProjectImpl(), this.loadFailed(), this.oldLoadFailed(), Cross$.MODULE$.crossBuild(), Cross$.MODULE$.switchVersion(), CrossJava$.MODULE$.switchJavaHome(), CrossJava$.MODULE$.crossJavaHome(), PluginCross$.MODULE$.pluginCross(), PluginCross$.MODULE$.pluginSwitch(), Cross$.MODULE$.crossRestoreSession(), this.setLogLevel(), this.plugin(), this.plugins(), BasicCommands$.MODULE$.addPluginSbtFile(), this.writeSbtVersion(), this.skipBanner(), this.notifyUsersAboutShell(), this.shell(), this.rebootNetwork(), this.startServer(), this.eval(), this.last(), this.oldLastGrep(), this.lastGrep(), this.export(), this.boot(), this.initialize(), this.act(), this.continuous(), this.clearCaches(), NetworkChannel$.MODULE$.disconnect(), this.waitCmd(), this.promptChannel()}))).$plus$plus((GenTraversableOnce)BasicCommands$.MODULE$.allBasicCommands(), Seq$.MODULE$.canBuildFrom())).$plus$plus(ContinuousCommands$.MODULE$.value(), Seq$.MODULE$.canBuildFrom())).$plus$plus(BuildServerProtocol$.MODULE$.commands(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> DefaultBootCommands() {
        String string = this.WriteSbtVersion();
        String string2 = CommandStrings$.MODULE$.LoadProject();
        String string3 = this.NotifyUsersAboutShell();
        String string4 = new StringBuilder(1).append(BasicCommandStrings$.MODULE$.IfLast()).append(" ").append(BasicCommandStrings$.MODULE$.Shell()).toString();
        return Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string);
    }

    public Command boot() {
        return Command$.MODULE$.make(CommandStrings$.MODULE$.BootCommand(), Command$.MODULE$.make$default$2(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.bootParser((State)s));
    }

    public Command about() {
        return Command$.MODULE$.command(CommandStrings$.MODULE$.AboutCommand(), CommandStrings$.MODULE$.aboutBrief(), CommandStrings$.MODULE$.aboutDetailed(), (Function1 & Serializable & scala.Serializable)s -> {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> MODULE$.aboutString((State)s));
            return s;
        });
    }

    public Command setLogLevel() {
        return Command$.MODULE$.arb(Types$.MODULE$.const(this.logLevelParser()), BasicCommandStrings$.MODULE$.logLevelHelp(), (Function2 & Serializable & scala.Serializable)(s, level) -> LogManager$.MODULE$.setGlobalLogLevel((State)s, (Enumeration.Value)level));
    }

    private Parser<Enumeration.Value> logLevelParser() {
        return DefaultParsers$.MODULE$.oneOf((Seq)Level$.MODULE$.values().toSeq().map((Function1 & Serializable & scala.Serializable)v -> DefaultParsers$.MODULE$.literalRichStringParser(v.toString()).$up$up$up(v), Seq$.MODULE$.canBuildFrom()));
    }

    public Parser<Function0<State>> bootParser(State s) {
        Function0 & Serializable & scala.Serializable orElse = (Function0 & Serializable & scala.Serializable)() -> {
            List list = MODULE$.DefaultBootCommands().toList();
            return State.StateOpsImpl$.MODULE$.$colon$colon$colon$extension(State$.MODULE$.StateOpsImpl(s), list);
        };
        return BasicCommands$.MODULE$.delegateToAlias(CommandStrings$.MODULE$.BootCommand(), DefaultParsers$.MODULE$.success((Object)orElse), s);
    }

    public String sbtName(State s) {
        return s.configuration().provider().id().name();
    }

    public String sbtVersion(State s) {
        return s.configuration().provider().id().version();
    }

    public String scalaVersion(State s) {
        return s.configuration().provider().scalaProvider().version();
    }

    public String aboutProject(State s) {
        if (Project$.MODULE$.isProjectLoaded(s)) {
            String string;
            Extracted e = Project$.MODULE$.extract(s);
            Option<String> option = e.getOpt(Keys$.MODULE$.version());
            if (None$.MODULE$.equals(option)) {
                string = "";
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String v = (String)some.value();
                string = new StringBuilder(1).append(" ").append(v).toString();
            } else {
                throw new MatchError(option);
            }
            String version = string;
            String current = new StringBuilder(24).append("The current project is ").append(Reference$.MODULE$.display((ProjectReference)e.currentRef())).append(version).append("\n").toString();
            String sc = this.aboutScala(s, e);
            String built = sc.isEmpty() ? "" : new StringBuilder(38).append("The current project is built against ").append(sc).append("\n").toString();
            return new StringBuilder(0).append(current).append(built).append(this.aboutPlugins(e)).toString();
        }
        return "No project is currently loaded";
    }

    public String aboutPlugins(Extracted e) {
        List allPluginNames = (List)((SeqLike)((TraversableOnce)e.structure().units().values().flatMap((Function1 & Serializable & scala.Serializable)lbu -> BuiltinCommands$.plugins$1(lbu), Iterable$.MODULE$.canBuildFrom())).toList().distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        if (allPluginNames.isEmpty()) {
            return "";
        }
        String string = "Available Plugins";
        return ((TraversableOnce)allPluginNames.$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).mkString("\n - ");
    }

    public String aboutScala(State s, Extracted e) {
        Option instance;
        Option scalaHome;
        Option<String> scalaVersion = e.getOpt(Keys$.MODULE$.scalaVersion());
        Tuple3 tuple3 = new Tuple3(scalaVersion, (Object)(scalaHome = e.getOpt(Keys$.MODULE$.scalaHome()).flatMap(Types$.MODULE$.idFun())), (Object)(instance = e.getOpt(Keys$.MODULE$.scalaInstance()).flatMap((Function1 & Serializable & scala.Serializable)x$25 -> MODULE$.quiet((Function0 & Serializable & scala.Serializable)() -> (ScalaInstance)e.runTask(Keys$.MODULE$.scalaInstance(), s)._2()))));
        if (tuple3 != null) {
            Option sv = (Option)tuple3._1();
            Option option = (Option)tuple3._2();
            Option option2 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                File home = (File)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    ScalaInstance si = (ScalaInstance)some2.value();
                    return new StringBuilder(24).append("local Scala version ").append(this.selectScalaVersion((Option<String>)sv, si)).append(" at ").append(home.getAbsolutePath()).toString();
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                File home = (File)some.value();
                if (None$.MODULE$.equals(option3)) {
                    return new StringBuilder(23).append("a local Scala build at ").append(home.getAbsolutePath()).toString();
                }
            }
        }
        if (tuple3 != null) {
            Option sv = (Option)tuple3._1();
            Option option = (Option)tuple3._2();
            Option option4 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                ScalaInstance si = (ScalaInstance)some.value();
                return new StringBuilder(6).append("Scala ").append(this.selectScalaVersion((Option<String>)sv, si)).toString();
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option5 = (Option)tuple3._2();
            Option option6 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                String sv = (String)some.value();
                if (None$.MODULE$.equals(option5) && None$.MODULE$.equals(option6)) {
                    return new StringBuilder(6).append("Scala ").append(sv).toString();
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option7 = (Option)tuple3._2();
            Option option8 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option7) && None$.MODULE$.equals(option8)) {
                return "";
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public String aboutString(State s) {
        Tuple4 tuple4 = new Tuple4((Object)this.sbtName(s), (Object)this.sbtVersion(s), (Object)this.scalaVersion(s), (Object)this.aboutProject(s));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String name = (String)tuple4._1();
        String ver = (String)tuple4._2();
        String scalaVer = (String)tuple4._3();
        String about = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)name, (Object)ver, (Object)scalaVer, (Object)about);
        String name2 = (String)tuple42._1();
        String ver2 = (String)tuple42._2();
        String scalaVer2 = (String)tuple42._3();
        String about2 = (String)tuple42._4();
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("This is %s %s\n\t\t\t|%s\n\t\t\t|%s, %s plugins, and build definitions are using Scala %s\n\t\t\t|")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2, ver2, about2, name2, name2, scalaVer2}));
    }

    private String selectScalaVersion(Option<String> sv, ScalaInstance si) {
        Option<String> option = sv;
        if (option instanceof Some) {
            Some some = (Some)option;
            String string = (String)some.value();
            String string2 = si.version();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return si.version();
            }
        }
        return si.actualVersion();
    }

    private <T> Option<T> quiet(Function0<T> t) {
        Some some;
        try {
            some = new Some(t.apply());
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Command settingsCommand() {
        return this.showSettingLike(CommandStrings$.MODULE$.SettingsCommand(), CommandStrings$.MODULE$.settingsPreamble(), 11, (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$settingsCommand$1(key)));
    }

    public Command tasks() {
        return this.showSettingLike(CommandStrings$.MODULE$.TasksCommand(), CommandStrings$.MODULE$.tasksPreamble(), 6, (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.MODULE$.isTask(key.manifest(), ManifestFactory$.MODULE$.classType(Task.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), ManifestFactory$.MODULE$.classType(InputTask.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))));
    }

    public Command showSettingLike(String command, String preamble, int cutoff, Function1<AttributeKey<?>, Object> keep) {
        return Command$.MODULE$.apply(command, CommandStrings$.MODULE$.settingsBrief(command), CommandStrings$.MODULE$.settingsDetailed(command), (Function1 & Serializable & scala.Serializable)s -> MODULE$.showSettingParser(keep, (State)s), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (s != null) {
                    State state = s;
                    if (tuple22 != null) {
                        int verbosity = tuple22._1$mcI$sp();
                        Option selected = (Option)tuple22._2();
                        int n = verbosity;
                        if (selected != null) {
                            Option option = selected;
                            if (option.isEmpty()) {
                                System.out.println(preamble);
                            }
                            boolean prominentOnly = n <= 1;
                            Function1<Seq<AttributeKey<?>>, Seq<AttributeKey<?>>> verboseFilter = prominentOnly ? MODULE$.highPass(cutoff) : MODULE$.topNRanked(25 * n);
                            System.out.println(MODULE$.tasksHelp(state, (Function1 & Serializable & scala.Serializable)keys -> (Seq)verboseFilter.apply(keys.filter(keep)), (Option<String>)option));
                            System.out.println();
                            if (prominentOnly) {
                                System.out.println(CommandStrings$.MODULE$.moreAvailableMessage(command, option.isDefined()));
                            }
                            return state;
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Parser<Tuple2<Object, Option<String>>> showSettingParser(Function1<AttributeKey<?>, Object> keepKeys, State s) {
        return DefaultParsers$.MODULE$.richParser(this.verbosityParser()).$tilde(DefaultParsers$.MODULE$.richParser(this.selectedParser(s, keepKeys)).$qmark());
    }

    public Parser<String> selectedParser(State s, Function1<AttributeKey<?>, Object> keepKeys) {
        return CommandUtil$.MODULE$.singleArgument(((TraversableOnce)((TraversableLike)this.allTaskAndSettingKeys(s).filter(keepKeys)).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.label(), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public Parser<Object> verbosityParser() {
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.success((Object)BoxesRunTime.boxToInteger((int)1))).$bar(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.Space()).$tilde(DefaultParsers$.MODULE$.literal("-"))).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichCharParser('v').id()).$plus()).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)BuiltinCommands$.$anonfun$verbosityParser$1(x$28)))).$bar(DefaultParsers$.MODULE$.literalRichStringParser("V").$up$up$up((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)))));
    }

    public Seq<Tuple2<String, String>> taskDetail(Seq<AttributeKey<?>> keys, boolean firstOnly) {
        return (Seq)this.sortByLabel(this.withDescription(keys)).flatMap((Function1 & Serializable & scala.Serializable)t -> Option$.MODULE$.option2Iterable(MODULE$.taskStrings((AttributeKey<?>)t, firstOnly)), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, String>> taskDetail(Seq<AttributeKey<?>> keys) {
        return this.taskDetail(keys, false);
    }

    public Seq<AttributeKey<?>> allTaskAndSettingKeys(State s) {
        Extracted extracted = Project$.MODULE$.extract(s);
        StructureIndex index = extracted.structure().index();
        return (Seq)((SeqLike)((TraversableLike)index.keyIndex().keys((Option<ResolvedReference>)new Some((Object)extracted.currentRef())).toSeq().map((Function1 & Serializable & scala.Serializable)key -> {
            Some some;
            try {
                some = new Some(index.keyMap().apply(key));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).debug((Function0 & Serializable & scala.Serializable)() -> ex.getMessage());
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }, Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<AttributeKey<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    AttributeKey s = (AttributeKey)some.value();
                    return (B1)s;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<AttributeKey<Object>> x1) {
                Option<AttributeKey<Object>> option = x1;
                return option instanceof Some;
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public Seq<AttributeKey<?>> sortByLabel(Seq<AttributeKey<?>> keys) {
        return (Seq)keys.sortBy((Function1 & Serializable & scala.Serializable)x$29 -> x$29.label(), (Ordering)Ordering.String$.MODULE$);
    }

    public Seq<AttributeKey<?>> sortByRank(Seq<AttributeKey<?>> keys) {
        return (Seq)keys.sortBy((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToInteger((int)x$30.rank()), (Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<AttributeKey<?>> withDescription(Seq<AttributeKey<?>> keys) {
        return (Seq)keys.filter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$withDescription$1(x$31)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTask(Manifest<?> mf, Manifest<Task<?>> taskMF, Manifest<InputTask<?>> inputMF) {
        Class clazz = mf.runtimeClass();
        Class clazz2 = taskMF.runtimeClass();
        if (clazz == null) {
            if (clazz2 == null) return true;
        } else if (clazz.equals(clazz2)) return true;
        Class clazz3 = mf.runtimeClass();
        Class clazz4 = inputMF.runtimeClass();
        if (clazz3 != null) {
            if (!clazz3.equals(clazz4)) return false;
            return true;
        }
        if (clazz4 == null) return true;
        return false;
    }

    public Function1<Seq<AttributeKey<?>>, Seq<AttributeKey<?>>> topNRanked(int n) {
        return (Function1 & Serializable & scala.Serializable)keys -> (Seq)MODULE$.sortByRank((Seq<AttributeKey<?>>)keys).take(n);
    }

    public Function1<Seq<AttributeKey<?>>, Seq<AttributeKey<?>>> highPass(int rankCutoff) {
        return (Function1 & Serializable & scala.Serializable)keys -> (Seq)MODULE$.sortByRank((Seq<AttributeKey<?>>)keys).takeWhile((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$highPass$2(rankCutoff, x$32)));
    }

    public String tasksHelp(State s, Function1<Seq<AttributeKey<?>>, Seq<AttributeKey<?>>> filter, Option<String> arg) {
        Seq<Tuple2<String, String>> commandAndDescription = this.taskDetail((Seq)filter.apply(this.allTaskAndSettingKeys(s)), true);
        Option<String> option = arg;
        if (option instanceof Some) {
            Some some = (Some)option;
            String selected = (String)some.value();
            return CommandUtil$.MODULE$.detail(selected, commandAndDescription.toMap(Predef$.MODULE$.$conforms()));
        }
        if (None$.MODULE$.equals(option)) {
            return CommandUtil$.MODULE$.aligned("  ", "   ", commandAndDescription).mkString("\n", "\n", "");
        }
        throw new MatchError(option);
    }

    public Option<Tuple2<String, String>> taskStrings(AttributeKey<?> key, boolean firstOnly) {
        return key.description().map((Function1 & Serializable & scala.Serializable)d -> {
            if (firstOnly) {
                return new Tuple2((Object)key.label(), (Object)d.split("\r?\n")[0]);
            }
            return new Tuple2((Object)key.label(), d);
        });
    }

    public Option<Tuple2<String, String>> taskStrings(AttributeKey<?> key) {
        return this.taskStrings(key, false);
    }

    public Command defaults() {
        return Command$.MODULE$.command(CommandStrings$.MODULE$.DefaultsCommand(), Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)s -> {
            Seq<Command> x$1 = MODULE$.DefaultCommands();
            AppConfiguration x$2 = s.copy$default$1();
            Set x$3 = s.copy$default$3();
            Option x$4 = s.copy$default$4();
            List x$5 = s.copy$default$5();
            State.History x$6 = s.copy$default$6();
            AttributeMap x$7 = s.copy$default$7();
            GlobalLogging x$8 = s.copy$default$8();
            Option x$9 = s.copy$default$9();
            State.Next x$10 = s.copy$default$10();
            return s.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        });
    }

    public Command initialize() {
        return Command$.MODULE$.command(CommandStrings$.MODULE$.InitCommand(), Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)s -> {
            List list = CommandUtil$.MODULE$.readLines(CommandUtil$.MODULE$.readable(CommandStrings$.MODULE$.sbtRCs((State)s))).toList();
            return State.StateOpsImpl$.MODULE$.$colon$colon$colon$extension(State$.MODULE$.StateOpsImpl(s), list);
        });
    }

    public Command eval() {
        return Command$.MODULE$.single(CommandStrings$.MODULE$.EvalCommand(), Help$.MODULE$.more(CommandStrings$.MODULE$.EvalCommand(), CommandStrings$.MODULE$.evalDetailed()), (Function2 & Serializable & scala.Serializable)(s, arg) -> {
            if (Project$.MODULE$.isProjectLoaded((State)s)) {
                MODULE$.loadedEval((State)s, (String)arg);
            } else {
                MODULE$.rawEval((State)s, (String)arg);
            }
            return s;
        });
    }

    public Command continuous() {
        return Continuous$.MODULE$.continuous();
    }

    private void loadedEval(State s, String arg) {
        Extracted extracted = Project$.MODULE$.extract(s);
        Eval qual$1 = (Eval)extracted.session().currentEval().apply();
        String x$1 = arg;
        String x$2 = "<eval>";
        EvalImports x$3 = this.autoImports(extracted);
        Option x$4 = qual$1.eval$default$3();
        int x$5 = qual$1.eval$default$5();
        EvalResult result = qual$1.eval(x$1, x$3, x$4, x$2, x$5);
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("ans: ").append(result.tpe()).append(" = ").append(result.getValue().apply((Object)extracted.currentLoader())).toString());
    }

    private void rawEval(State s, String arg) {
        AppProvider app = s.configuration().provider();
        File[] classpath = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])app.mainClasspath())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])app.scalaProvider().jars())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        Eval qual$1 = Load$.MODULE$.mkEval((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])classpath), State.StateOpsImpl$.MODULE$.baseDir$extension(State$.MODULE$.StateOpsImpl(s)), (Seq<String>)Nil$.MODULE$);
        String x$1 = arg;
        String x$2 = "<eval>";
        EvalImports x$3 = new EvalImports((Seq)Nil$.MODULE$, "");
        Option x$4 = qual$1.eval$default$3();
        int x$5 = qual$1.eval$default$5();
        EvalResult result = qual$1.eval(x$1, x$3, x$4, x$2, x$5);
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("ans: ").append(result.tpe()).append(" = ").append(result.getValue().apply((Object)app.loader())).toString());
    }

    public Command sessionCommand() {
        return Command$.MODULE$.make(CommandStrings$.MODULE$.SessionCommand(), CommandStrings$.MODULE$.sessionBrief(), SessionSettings$.MODULE$.Help(), (Function1 & Serializable & scala.Serializable)s -> SessionSettings$.MODULE$.command((State)s));
    }

    public State reapply(SessionSettings newSession, BuildStructure structure, State s) {
        Init.Setting<?> loggerInject;
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> "Reapplying settings...");
        Init.Setting<?> setting = loggerInject = LogManager$.MODULE$.settingsLogger(s);
        SessionSettings withLogger = newSession.appendRaw((Seq<Init.Setting<?>>)Nil$.MODULE$.$colon$colon(setting));
        Show<Init.ScopedKey<?>> show = Project$.MODULE$.showContextKey2(newSession, Project$.MODULE$.showContextKey2$default$2());
        BuildStructure newStructure = Load$.MODULE$.reapply(withLogger.mergeSettings(), structure, show);
        return Project$.MODULE$.setProject(newSession, newStructure, s);
    }

    public Command set() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.SetCommand(), CommandStrings$.MODULE$.setBrief(), CommandStrings$.MODULE$.setDetailed(), this.setParser(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    boolean all = tuple22._1$mcZ$sp();
                    String arg = (String)tuple22._2();
                    Extracted extracted = Project$.MODULE$.extract(s);
                    DefinedSbtValues dslVals = extracted.currentUnit().unit().definitions().dslDefinitions();
                    Seq ims = (Seq)MODULE$.imports(extracted).$plus$plus((GenTraversableOnce)dslVals.imports().map((Function1 & Serializable & scala.Serializable)i -> new Tuple2(i, (Object)BoxesRunTime.boxToInteger((int)-1)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    ClassLoader cl = dslVals.classloader(extracted.currentLoader());
                    Seq settings = (Seq)EvaluateConfigurations$.MODULE$.evaluateSetting((Eval)extracted.session().currentEval().apply(), "<set>", (Seq<Tuple2<String, Object>>)ims, arg, new LineRange(0, 0)).apply((Object)cl);
                    SetResult setResult = all ? SettingCompletions$.MODULE$.setAll(extracted, settings) : SettingCompletions$.MODULE$.setThis(extracted, settings, arg);
                    State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> setResult.quietSummary());
                    State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).debug((Function0 & Serializable & scala.Serializable)() -> setResult.verboseSummary());
                    return MODULE$.reapply(setResult.session(), extracted.structure(), s);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public SetResult setThis(State s, Extracted extracted, Seq<Init.Setting<?>> settings, String arg) {
        return this.setThis(extracted, settings, arg);
    }

    public SetResult setThis(Extracted extracted, Seq<Init.Setting<?>> settings, String arg) {
        return SettingCompletions$.MODULE$.setThis(extracted, settings, arg);
    }

    public Command inspect() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.InspectCommand(), CommandStrings$.MODULE$.inspectBrief(), CommandStrings$.MODULE$.inspectDetailed(), Inspect$.MODULE$.parser(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Function0 f = (Function0)tuple2._2();
                State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info(f);
                return s;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Command oldLastGrep() {
        return this.lastGrepCommand(CommandStrings$.MODULE$.OldLastGrepCommand(), CommandStrings$.MODULE$.oldLastGrepBrief(), CommandStrings$.MODULE$.oldLastGrepDetailed(), (Function1<State, Parser<Tuple2<String, Option<Seq<Aggregation.KeyValue<Object>>>>>>)(Function1 & Serializable & scala.Serializable)s -> MODULE$.lastGrepParser((State)s));
    }

    public Command lastGrep() {
        return this.lastGrepCommand(CommandStrings$.MODULE$.LastGrepCommand(), CommandStrings$.MODULE$.lastGrepBrief(), CommandStrings$.MODULE$.lastGrepDetailed(), (Function1<State, Parser<Tuple2<String, Option<Seq<Aggregation.KeyValue<Object>>>>>>)(Function1 & Serializable & scala.Serializable)s -> MODULE$.lastGrepParser((State)s));
    }

    private Command lastGrepCommand(String name, Tuple2<String, String> briefHelp, String detail, Function1<State, Parser<Tuple2<String, Option<Seq<Aggregation.KeyValue<Object>>>>>> parser) {
        return Command$.MODULE$.apply(name, briefHelp, detail, parser, (Function2 & Serializable & scala.Serializable)(s, sks) -> {
            Tuple2 tuple2;
            String string = name;
            String string2 = CommandStrings$.MODULE$.OldLastGrepCommand();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.deprecationWarningText(CommandStrings$.MODULE$.OldLastGrepCommand(), CommandStrings$.MODULE$.LastGrepCommand()));
            }
            if ((tuple2 = new Tuple2(s, sks)) != null) {
                State s2 = (State)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String pattern = (String)tuple22._1();
                    Option option = (Option)tuple22._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Seq sks2 = (Seq)some.value();
                        Tuple3<BuildStructure, Select<ProjectRef>, Show<Init.ScopedKey<?>>> tuple3 = MODULE$.extractLast(s2);
                        if (tuple3 == null) {
                            throw new MatchError(tuple3);
                        }
                        BuildStructure str = (BuildStructure)tuple3._1();
                        Show display = (Show)tuple3._3();
                        Tuple2 tuple23 = new Tuple2((Object)str, (Object)display);
                        BuildStructure str2 = (BuildStructure)tuple23._1();
                        Show display2 = (Show)tuple23._2();
                        Output$.MODULE$.lastGrep((Seq<Aggregation.KeyValue<Object>>)sks2, (Streams)str2.streams().apply((Object)s2), pattern, MODULE$.printLast(), display2);
                        return MODULE$.keepLastLog(s2);
                    }
                }
            }
            if (tuple2 != null) {
                State s3 = (State)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    String pattern = (String)tuple24._1();
                    Option option = (Option)tuple24._2();
                    if (None$.MODULE$.equals(option)) {
                        MODULE$.lastLogFile(s3).map((Function1 & Serializable & scala.Serializable)logFile -> {
                            Output$.MODULE$.lastGrep(logFile, pattern, BuiltinCommands$.MODULE$.printLast(), Output$.MODULE$.lastGrep$default$4());
                            return BoxedUnit.UNIT;
                        });
                        return MODULE$.keepLastLog(s3);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Tuple3<BuildStructure, Select<ProjectRef>, Show<Init.ScopedKey<?>>> extractLast(State s) {
        Extracted ext = Project$.MODULE$.extract(s);
        return new Tuple3((Object)ext.structure(), (Object)new Select((Object)ext.currentRef()), ext.showKey());
    }

    public Function1<State, Parser<Tuple2<Object, String>>> setParser() {
        return (Function1 & Serializable & scala.Serializable)s -> {
            Extracted extracted = Project$.MODULE$.extract((State)s);
            return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.Space()).$tilde$greater(DefaultParsers$.MODULE$.flag(DefaultParsers$.MODULE$.literalRichStringParser("every").$tilde(DefaultParsers$.MODULE$.Space()))))).$tilde(SettingCompletions$.MODULE$.settingParser(extracted.structure().data(), extracted.structure().index().keyMap(), extracted.currentProject()));
        };
    }

    public Function1<State, Parser<Seq<Init.ScopedKey<Object>>>> spacedAggregatedParser() {
        return this.spacedAggregatedParser;
    }

    public Function1<State, Parser<Option<Seq<Aggregation.KeyValue<Object>>>>> aggregatedKeyValueParser() {
        return this.aggregatedKeyValueParser;
    }

    public Function1<State, Parser<Function0<State>>> exportParser() {
        return this.exportParser;
    }

    public Parser<Function0<State>> exportParser0(State s) {
        Extracted extracted = Project$.MODULE$.extract(s);
        Parser keysParser = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.flag(DefaultParsers$.MODULE$.literalRichStringParser("--last").$less$tilde(DefaultParsers$.MODULE$.Space())))).$tilde(Act$.MODULE$.aggregatedKeyParser(extracted));
        Aggregation.ShowConfig show = new Aggregation.ShowConfig(true, false, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$36 -> {
            Predef$.MODULE$.println((Object)x$36);
            return BoxedUnit.UNIT;
        }, false);
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(keysParser).map((Function1 & Serializable & scala.Serializable)lastOnly_keys -> {
            Seq kvs = Act$.MODULE$.keyValues(extracted.structure(), (Seq)lastOnly_keys._2());
            return new Tuple2(lastOnly_keys, kvs);
        })).flatMap((Function1 & Serializable & scala.Serializable)x$37 -> {
            Tuple2 tuple2 = x$37;
            if (tuple2 != null) {
                Tuple2 lastOnly_keys = (Tuple2)tuple2._1();
                Seq kvs = (Seq)tuple2._2();
                return DefaultParsers$.MODULE$.richParser((Parser)(lastOnly_keys._1$mcZ$sp() ? DefaultParsers$.MODULE$.success((Function0 & Serializable & scala.Serializable)() -> s) : Aggregation$.MODULE$.evaluatingParser(s, show, kvs, extracted.showKey()))).map((Function1 & Serializable & scala.Serializable)f -> (Function0 & Serializable & scala.Serializable)() -> {
                    State state;
                    try {
                        state = (State)f.apply();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            try {
                                State state2 = BuiltinCommands$.export0$1(s, kvs);
                            }
                            finally {
                                throw e;
                            }
                        }
                        throw throwable;
                    }
                    State newS = state;
                    return BuiltinCommands$.export0$1(newS, kvs);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Parser<Tuple2<String, Option<Seq<Aggregation.KeyValue<Object>>>>> lastGrepParser(State s) {
        return Act$.MODULE$.requireSession(s, (Function0 & Serializable & scala.Serializable)() -> DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.NotSpace(), "<pattern>"))).$tilde((Parser)MODULE$.aggregatedKeyValueParser().apply((Object)s)));
    }

    public Command last() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.LastCommand(), CommandStrings$.MODULE$.lastBrief(), CommandStrings$.MODULE$.lastDetailed(), this.aggregatedKeyValueParser(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq sks = (Seq)some.value();
                    return MODULE$.lastImpl(s, (Seq<Aggregation.KeyValue<Object>>)sks, (Option<String>)None$.MODULE$);
                }
            }
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    MODULE$.lastLogFile(s).map((Function1 & Serializable & scala.Serializable)logFile -> {
                        Output$.MODULE$.last(logFile, BuiltinCommands$.MODULE$.printLast(), Output$.MODULE$.last$default$3());
                        return BoxedUnit.UNIT;
                    });
                    return MODULE$.keepLastLog(s);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Command export() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.ExportCommand(), CommandStrings$.MODULE$.exportBrief(), CommandStrings$.MODULE$.exportDetailed(), this.exportParser(), (Function2 & Serializable & scala.Serializable)(x$38, f) -> (State)f.apply());
    }

    private State lastImpl(State s, Seq<Aggregation.KeyValue<Object>> sks, Option<String> sid) {
        Tuple3<BuildStructure, Select<ProjectRef>, Show<Init.ScopedKey<?>>> tuple3 = this.extractLast(s);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        BuildStructure str = (BuildStructure)tuple3._1();
        Show display = (Show)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)str, (Object)display);
        BuildStructure str2 = (BuildStructure)tuple2._1();
        Show display2 = (Show)tuple2._2();
        Output$.MODULE$.last(sks, (Streams)str2.streams().apply((Object)s), this.printLast(), sid, display2);
        return this.keepLastLog(s);
    }

    public Option<File> lastLogFile(State s) {
        GlobalLogBacking backing = s.globalLogging().backing();
        if (this.isLastOnly(s)) {
            return backing.last();
        }
        return new Some((Object)backing.file());
    }

    public State keepLastLog(State s) {
        if (this.isLastOnly(s)) {
            return State.StateOpsImpl$.MODULE$.keepLastLog$extension(State$.MODULE$.StateOpsImpl(s));
        }
        return s;
    }

    public boolean isLastOnly(State s) {
        return s.history().previous().forall((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$isLastOnly$1(x$40)));
    }

    public Function1<Seq<String>, BoxedUnit> printLast(State s) {
        return this.printLast();
    }

    public Function1<Seq<String>, BoxedUnit> printLast() {
        return (Function1 & Serializable & scala.Serializable)x$41 -> {
            x$41.foreach((Function1 & Serializable & scala.Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
    }

    public EvalImports autoImports(Extracted extracted) {
        return new EvalImports(this.imports(extracted), "<auto-imports>");
    }

    public Seq<Tuple2<String, Object>> imports(Extracted extracted) {
        URI curi = extracted.currentRef().build();
        return (Seq)((LoadedBuildUnit)extracted.structure().units().apply((Object)curi)).imports().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, (Object)BoxesRunTime.boxToInteger((int)-1)), Seq$.MODULE$.canBuildFrom());
    }

    public void listBuild(URI uri, LoadedBuildUnit build, boolean current, String currentID, Logger log) {
        log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append("In ").append(uri).toString());
        ((IterableLike)build.defined().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)id -> {
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\t").append(BuiltinCommands$.prefix$1(id, currentID$1, current$1)).append(id).toString());
            return BoxedUnit.UNIT;
        });
    }

    public Command act() {
        return Command$.MODULE$.customHelp((Function1 & Serializable & scala.Serializable)s -> Act$.MODULE$.actParser((State)s), this.actHelp());
    }

    public Function1<State, Help> actHelp() {
        return (Function1 & Serializable & scala.Serializable)s -> CommandStrings$.MODULE$.showHelp().$plus$plus(CommandStrings$.MODULE$.printHelp()).$plus$plus(CommandStrings$.MODULE$.multiTaskHelp()).$plus$plus(MODULE$.keysHelp((State)s));
    }

    public Help keysHelp(State s) {
        if (Project$.MODULE$.isProjectLoaded(s)) {
            return Help$.MODULE$.detailOnly(this.taskDetail(this.allTaskAndSettingKeys(s)));
        }
        return Help$.MODULE$.empty();
    }

    public Command plugins() {
        return Command$.MODULE$.command(CommandStrings$.MODULE$.PluginsCommand(), CommandStrings$.MODULE$.pluginsBrief(), CommandStrings$.MODULE$.pluginsDetailed(), (Function1 & Serializable & scala.Serializable)s -> {
            String helpString = PluginsDebug$.MODULE$.helpAll((State)s);
            System.out.println(helpString);
            return s;
        });
    }

    public Function1<State, Parser<AutoPlugin>> pluginParser() {
        return this.pluginParser;
    }

    public Command plugin() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.PluginCommand(), Command$.MODULE$.apply$default$2(), this.pluginParser(), (Function2 & Serializable & scala.Serializable)(s, plugin) -> {
            String helpString = PluginsDebug$.MODULE$.help((AutoPlugin)plugin, (State)s);
            System.out.println(helpString);
            return s;
        });
    }

    public Command projects() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.ProjectsCommand(), new Tuple2((Object)CommandStrings$.MODULE$.ProjectsCommand(), (Object)CommandStrings$.MODULE$.projectsBrief()), CommandStrings$.MODULE$.projectsDetailed(), (Function1 & Serializable & scala.Serializable)s -> DefaultParsers$.MODULE$.richParser(MODULE$.projectsParser((State)s)).$qmark(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Function1 modifyBuilds = (Function1)some.value();
                    return MODULE$.transformExtraBuilds(s, (Function1<List<URI>, List<URI>>)modifyBuilds);
                }
            }
            if (tuple2 != null) {
                State s = (State)tuple2._1();
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    MODULE$.showProjects(s);
                    return s;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void showProjects(State s) {
        Extracted extracted = Project$.MODULE$.extract(s);
        this.listBuild(extracted.currentRef().build(), (LoadedBuildUnit)extracted.structure().units().apply((Object)extracted.currentRef().build()), true, extracted.currentRef().project(), (Logger)State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)));
        extracted.structure().units().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$showProjects$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$showProjects$2(extracted, x$42))).foreach((Function1 & Serializable & scala.Serializable)x$43 -> {
            BuiltinCommands$.$anonfun$showProjects$3(extracted, s, x$43);
            return BoxedUnit.UNIT;
        });
    }

    public State transformExtraBuilds(State s, Function1<List<URI>, List<URI>> f) {
        State state;
        List<URI> original = Project$.MODULE$.extraBuilds(s);
        State extraUpdated = Project$.MODULE$.updateExtraBuilds(s, f);
        try {
            state = this.doLoadProject(extraUpdated, Project$LoadAction$.MODULE$.Current());
        }
        catch (Exception exception) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).error((Function0 & Serializable & scala.Serializable)() -> "Project loading failed: reverting to previous state.");
            state = Project$.MODULE$.setExtraBuilds(s, original);
        }
        return state;
    }

    public Parser<Function1<List<URI>, List<URI>>> projectsParser(State s) {
        Parser addBase = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.Space()).$tilde$greater(DefaultParsers$.MODULE$.literal("add")))).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.Space()).$tilde$greater(DefaultParsers$.MODULE$.basicUri()), "<build URI>")).$plus());
        Parser removeBase = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.Space()).$tilde$greater(DefaultParsers$.MODULE$.literal("remove")))).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.Space()).$tilde$greater(DefaultParsers$.MODULE$.Uri(Project$.MODULE$.extraBuilds(s).toSet())))).$plus());
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(addBase).map((Function1 & Serializable & scala.Serializable)toAdd -> (Function1 & Serializable & scala.Serializable)xs -> {
            List list = toAdd.toList();
            return (List)xs.$colon$colon$colon(list).distinct();
        })).$bar(DefaultParsers$.MODULE$.richParser(removeBase).map((Function1 & Serializable & scala.Serializable)toRemove -> (Function1 & Serializable & scala.Serializable)xs -> (List)xs.filterNot((Function1)toRemove.toSet())));
    }

    public Command project() {
        return Command$.MODULE$.make(CommandStrings$.MODULE$.ProjectCommand(), CommandStrings$.MODULE$.projectBrief(), CommandStrings$.MODULE$.projectDetailed(), (Function1 & Serializable & scala.Serializable)s -> ProjectNavigation$.MODULE$.command((State)s));
    }

    public Command loadFailed() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.LoadFailed(), Command$.MODULE$.apply$default$2(), this.loadProjectParser(), (Function2 & Serializable & scala.Serializable)(s, loadArg) -> MODULE$.doLoadFailed((State)s, (String)loadArg));
    }

    public Command oldLoadFailed() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.OldLoadFailed(), Command$.MODULE$.apply$default$2(), (Function1 & Serializable & scala.Serializable)s -> (Parser)MODULE$.loadProjectParser().apply(s), (Function2 & Serializable & scala.Serializable)(s, loadArg) -> {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.deprecationWarningText(CommandStrings$.MODULE$.OldLoadFailed(), CommandStrings$.MODULE$.LoadFailed()));
            return MODULE$.doLoadFailed((State)s, (String)loadArg);
        });
    }

    private String deprecationWarningText(String oldCommand, String newCommand) {
        return new StringBuilder(82).append("The `").append(oldCommand).append("` command is deprecated in favor of `").append(newCommand).append("` and will be removed in a later version").toString();
    }

    private State doLoadFailed(State s, String loadArg) {
        while (true) {
            int n;
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).warn((Function0 & Serializable & scala.Serializable)() -> "Project loading failed: (r)etry, (q)uit, (l)ast, or (i)gnore? (default: r)");
            try {
                int n2 = BoxesRunTime.unboxToInt((Object)Terminal$.MODULE$.get().withRawInput((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> System.in.read()));
                switch (n2) {
                    case -1: {
                        n = 113;
                        break;
                    }
                    default: {
                        n = n2;
                        break;
                    }
                }
            }
            catch (ClosedChannelException closedChannelException) {
                n = 113;
            }
            int result = n;
            char c = (char)result;
            switch (c) {
                case '\n': 
                case '\r': {
                    return this.retry$1(loadArg, s);
                }
                case 'R': 
                case 'r': {
                    return this.retry$1(loadArg, s);
                }
                case 'Q': 
                case 'q': {
                    return State.StateOpsImpl$.MODULE$.exit$extension(State$.MODULE$.StateOpsImpl(s), false);
                }
                case 'I': 
                case 'i': {
                    State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Ignoring load failure: ").append(BuiltinCommands$.ignoreMsg$1(s)).append(".").toString());
                    return s;
                }
                case 'L': 
                case 'l': {
                    String string = CommandStrings$.MODULE$.LastCommand();
                    String string2 = this.loadProjectCommand(CommandStrings$.MODULE$.LoadFailed(), loadArg);
                    return State.StateOpsImpl$.MODULE$.$colon$colon$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.$colon$colon$extension(State$.MODULE$.StateOpsImpl(s), string2)), string);
                }
            }
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("Invalid response: '").append(c).append("'").toString());
        }
    }

    public List<String> loadProjectCommands(String arg) {
        String string = BasicCommandStrings$.MODULE$.StashOnFailure();
        String string2 = new StringBuilder(1).append(BasicCommandStrings$.MODULE$.OnFailure()).append(" ").append(this.loadProjectCommand(CommandStrings$.MODULE$.LoadFailed(), arg)).toString();
        String string3 = this.loadProjectCommand(CommandStrings$.MODULE$.LoadProjectImpl(), arg);
        String string4 = BasicCommandStrings$.MODULE$.PopOnFailure();
        String string5 = State$.MODULE$.FailureWall();
        return Nil$.MODULE$.$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string);
    }

    public Command loadProject() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.LoadProject(), CommandStrings$.MODULE$.LoadProjectBrief(), CommandStrings$.MODULE$.LoadProjectDetailed(), this.loadProjectParser(), (Function2 & Serializable & scala.Serializable)(s, arg) -> {
            List<String> list = MODULE$.loadProjectCommands((String)arg);
            return State.StateOpsImpl$.MODULE$.$colon$colon$colon$extension(State$.MODULE$.StateOpsImpl(s), list);
        });
    }

    private Function1<State, Parser<String>> loadProjectParser() {
        return (Function1 & Serializable & scala.Serializable)x$54 -> DefaultParsers$.MODULE$.matched(Project$.MODULE$.loadActionParser(), DefaultParsers$.MODULE$.matched$default$2(), DefaultParsers$.MODULE$.matched$default$3());
    }

    private String loadProjectCommand(String command, String arg) {
        return new StringBuilder(1).append(command).append(" ").append(arg).toString().trim();
    }

    public Command loadProjectImpl() {
        return Command$.MODULE$.apply(CommandStrings$.MODULE$.LoadProjectImpl(), Command$.MODULE$.apply$default$2(), (Function1 & Serializable & scala.Serializable)x$55 -> Project$.MODULE$.loadActionParser(), (Function2 & Serializable & scala.Serializable)(s0, action) -> MODULE$.doLoadProject((State)s0, (Enumeration.Value)action));
    }

    public void checkSBTVersionChanged(State state) {
        None$ none$;
        String sbtVersionProperty = "sbt.version";
        Option sbtVersionSystemOpt = Option$.MODULE$.apply((Object)System.getProperty(sbtVersionProperty));
        File buildProps = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(State.StateOpsImpl$.MODULE$.baseDir$extension(State$.MODULE$.StateOpsImpl(state))), "project")), "build.properties");
        if (buildProps.exists()) {
            Properties buildProperties = new Properties();
            IO$.MODULE$.load(buildProperties, buildProps);
            none$ = Option$.MODULE$.apply((Object)buildProperties.getProperty(sbtVersionProperty));
        } else {
            none$ = None$.MODULE$;
        }
        None$ sbtVersionBuildOpt = none$;
        Option sbtVersionOpt = sbtVersionSystemOpt.orElse(() -> BuiltinCommands$.$anonfun$checkSBTVersionChanged$1((Option)sbtVersionBuildOpt));
        sbtVersionOpt.foreach((Function1 & Serializable & scala.Serializable)version -> {
            BuiltinCommands$.$anonfun$checkSBTVersionChanged$2(state, version);
            return BoxedUnit.UNIT;
        });
    }

    private void welcomeBanner(State state) {
        String appVersion = state.configuration().provider().id().version();
        String javaVersion = new StringBuilder(6).append(Properties$.MODULE$.javaVendor()).append(" Java ").append(Properties$.MODULE$.javaVersion()).toString();
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("welcome to sbt ").append(appVersion).append(" (").append(javaVersion).append(")").toString());
    }

    public State doLoadProject(State s0, Enumeration.Value action) {
        this.welcomeBanner(s0);
        this.checkSBTVersionChanged(s0);
        Tuple2<State, File> tuple2 = Project$.MODULE$.loadAction(SessionVar$.MODULE$.clear(s0), action);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        State s1 = (State)tuple2._1();
        File base = (File)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)s1, (Object)base);
        State s12 = (State)tuple22._1();
        File base2 = (File)tuple22._2();
        IO$.MODULE$.createDirectory(base2);
        State s2 = State.StateOpsImpl$.MODULE$.has$extension(State$.MODULE$.StateOpsImpl(s12), Keys$.MODULE$.stateCompilerCache()) ? s12 : this.registerCompilerCache(s12);
        Tuple2 tuple23 = BuiltinCommands$.liftedTree1$1(s2, base2, s0);
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Function0 eval = (Function0)tuple23._1();
        BuildStructure structure = (BuildStructure)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)eval, (Object)structure);
        Function0 eval2 = (Function0)tuple24._1();
        BuildStructure structure2 = (BuildStructure)tuple24._2();
        SessionSettings session = Load$.MODULE$.initialSession(structure2, (Function0<Eval>)eval2, s0);
        SessionSettings$.MODULE$.checkSession(session, s2);
        State s3 = Project$.MODULE$.setProject(session, structure2, s2, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)st -> (State)MODULE$.setupGlobalFileTreeRepository().apply(MODULE$.addCacheStoreFactoryFactory().apply(st)));
        State s4 = State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(s3), Keys$.MODULE$.useLog4J().key(), Project$.MODULE$.extract(s3).get(Keys$.MODULE$.useLog4J()));
        return (State)this.addSuperShellParams().apply((Object)CheckBuildSources$.MODULE$.init(LintUnused$.MODULE$.lintUnusedFunc(s4)));
    }

    private Function1<State, State> setupGlobalFileTreeRepository() {
        return this.setupGlobalFileTreeRepository;
    }

    private Function1<State, State> addSuperShellParams() {
        return this.addSuperShellParams;
    }

    private Function1<State, State> addCacheStoreFactoryFactory() {
        return this.addCacheStoreFactoryFactory;
    }

    public State registerCompilerCache(State s) {
        State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.stateCompilerCache()).foreach((Function1 & Serializable & scala.Serializable)x$62 -> {
            x$62.clear();
            return BoxedUnit.UNIT;
        });
        return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.stateCompilerCache(), (Object)CompilerCache.fresh());
    }

    public Command clearCaches() {
        Help help = Help$.MODULE$.more(BasicCommandStrings$.MODULE$.ClearCaches(), BasicCommandStrings$.MODULE$.ClearCachesDetailed());
        Function1 f = ((Function1 & Serializable & scala.Serializable)(Function1 & Serializable & scala.Serializable)s -> MODULE$.registerCompilerCache((State)s)).andThen((Function1 & Serializable & scala.Serializable)x$63 -> State.StateOpsImpl$.MODULE$.initializeClassLoaderCache$extension(State$.MODULE$.StateOpsImpl(x$63))).andThen(this.addCacheStoreFactoryFactory());
        return Command$.MODULE$.command(BasicCommandStrings$.MODULE$.ClearCaches(), help, f);
    }

    public Command waitCmd() {
        return Command$.MODULE$.arb((Function1 & Serializable & scala.Serializable)x$64 -> DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichStringParser(ContinuousCommands$.MODULE$.waitWatch()).examples((Seq)Nil$.MODULE$)).$tilde$greater(DefaultParsers$.MODULE$.literalRichStringParser(" ").examples((Seq)Nil$.MODULE$))).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.matched(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.any()).$times(), DefaultParsers$.MODULE$.matched$default$2(), DefaultParsers$.MODULE$.matched$default$3())).examples((Seq)Nil$.MODULE$)), Command$.MODULE$.arb$default$2(), (Function2 & Serializable & scala.Serializable)(s0, channel) -> {
            Some some;
            CommandChannel c;
            CommandExchange exchange = StandardMain$.MODULE$.exchange();
            Option<CommandChannel> option = exchange.channelForName((String)channel);
            if (option instanceof Some && ContinuousCommands$.MODULE$.isInWatch((State)s0, c = (CommandChannel)(some = (Some)option).value())) {
                Prompt prompt = c.terminal().prompt();
                Prompt.Watch$ watch$ = Prompt.Watch$.MODULE$;
                if (prompt == null ? watch$ != null : !prompt.equals(watch$)) {
                    c.terminal().setPrompt((Prompt)Prompt.Watch$.MODULE$);
                    c.prompt(new ConsolePromptEvent(s0));
                } else if (c.terminal().isSupershellEnabled()) {
                    c.terminal().printStream().print(ConsoleAppender$.MODULE$.ClearScreenAfterCursor());
                    c.terminal().printStream().flush();
                }
                State s1 = exchange.run((State)s0);
                Exec exec = MODULE$.getExec(s1, (Duration)Duration$.MODULE$.Inf());
                String wait = new StringBuilder(1).append(ContinuousCommands$.MODULE$.waitWatch()).append(" ").append((String)channel).toString();
                Option onFailure = s1.onFailure().map((Function1 & Serializable & scala.Serializable)of -> {
                    String string = of.commandLine();
                    String string2 = BasicCommandStrings$.MODULE$.Shell();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return of.withCommandLine(wait);
                    }
                    return of;
                });
                Exec waitExec = Exec$.MODULE$.apply(wait, (Option)None$.MODULE$);
                Exec exec2 = Exec$.MODULE$.apply(BasicCommandStrings$.MODULE$.FailureWall(), (Option)None$.MODULE$);
                Exec exec3 = waitExec;
                List remaining = s1.remainingCommands().$colon$colon((Object)exec3).$colon$colon((Object)exec2);
                Exec exec4 = exec;
                List x$1 = (List)remaining.$plus$colon((Object)exec4, List$.MODULE$.canBuildFrom());
                Option x$2 = onFailure;
                AppConfiguration x$3 = s1.copy$default$1();
                Seq x$4 = s1.copy$default$2();
                Set x$5 = s1.copy$default$3();
                State.History x$6 = s1.copy$default$6();
                AttributeMap x$7 = s1.copy$default$7();
                GlobalLogging x$8 = s1.copy$default$8();
                Option x$9 = s1.copy$default$9();
                State.Next x$10 = s1.copy$default$10();
                State newState = s1.copy(x$3, x$4, x$5, x$2, x$1, x$6, x$7, x$8, x$9, x$10);
                if (exec.commandLine().trim().isEmpty()) {
                    return newState;
                }
                return State.StateOpsImpl$.MODULE$.clearGlobalLog$extension(State$.MODULE$.StateOpsImpl(newState));
            }
            return s0;
        });
    }

    public Command promptChannel() {
        return Command$.MODULE$.arb((Function1 & Serializable & scala.Serializable)x$68 -> BasicCommands$.MODULE$.reportParser(BasicCommandStrings$.MODULE$.PromptChannel()), Command$.MODULE$.arb$default$2(), (Function2 & Serializable & scala.Serializable)(state, channel) -> {
            block2: {
                Some some;
                CommandChannel nc;
                String string = channel;
                String string2 = ConsoleChannel$.MODULE$.defaultName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!state.remainingCommands().exists((Function1 & Serializable & scala.Serializable)x$69 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$promptChannel$3(x$69)))) {
                        List list = state.remainingCommands();
                        Exec exec = Exec$.MODULE$.apply(BasicCommandStrings$.MODULE$.Shell(), (Option)None$.MODULE$);
                        List x$1 = Nil$.MODULE$.$colon$colon((Object)exec).$colon$colon$colon(list);
                        AppConfiguration x$2 = state.copy$default$1();
                        Seq x$3 = state.copy$default$2();
                        Set x$4 = state.copy$default$3();
                        Option x$5 = state.copy$default$4();
                        State.History x$6 = state.copy$default$6();
                        AttributeMap x$7 = state.copy$default$7();
                        GlobalLogging x$8 = state.copy$default$8();
                        Option x$9 = state.copy$default$9();
                        State.Next x$10 = state.copy$default$10();
                        return state.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
                    }
                    return state;
                }
                Option<CommandChannel> option = StandardMain$.MODULE$.exchange().channelForName((String)channel);
                if (!(option instanceof Some) || !((nc = (CommandChannel)(some = (Some)option).value()) instanceof NetworkChannel)) break block2;
                NetworkChannel networkChannel = (NetworkChannel)nc;
                networkChannel.prompt();
            }
            return state;
        });
    }

    private Exec getExec(State state, Duration interval) {
        return StandardMain$.MODULE$.exchange().blockUntilNextExec(interval, (Option<State>)new Some((Object)state), (Logger)state.globalLogging().full());
    }

    public Command shell() {
        return Command$.MODULE$.command(BasicCommandStrings$.MODULE$.Shell(), Help$.MODULE$.more(BasicCommandStrings$.MODULE$.Shell(), BasicCommandStrings$.MODULE$.ShellDetailed()), (Function1 & Serializable & scala.Serializable)s0 -> {
            CommandExchange exchange = StandardMain$.MODULE$.exchange();
            State welcomeState = MODULE$.displayWelcomeBanner((State)s0);
            State s1 = exchange.run(welcomeState);
            if (Terminal$.MODULE$.startedByRemoteClient() && !exchange.hasServer()) {
                Exec exec = Exec$.MODULE$.apply(BasicCommandStrings$.MODULE$.Shutdown(), (Option)None$.MODULE$);
                return State.StateOpsImpl$.MODULE$.$plus$colon$extension(State$.MODULE$.StateOpsImpl(s1), exec);
            }
            Prompt prompt = Terminal$.MODULE$.console().prompt();
            Prompt.Batch$ batch$ = Prompt.Batch$.MODULE$;
            if (!(prompt != null ? !prompt.equals(batch$) : batch$ != null)) {
                Terminal$.MODULE$.console().setPrompt((Prompt)Prompt.Pending$.MODULE$);
            }
            exchange.prompt(new ConsolePromptEvent(s0));
            Duration minGCInterval = (Duration)Project$.MODULE$.extract(s1).getOpt(Keys$.MODULE$.minForcegcInterval()).getOrElse((Function0 & Serializable & scala.Serializable)() -> GCUtil$.MODULE$.defaultMinForcegcInterval());
            Exec exec = MODULE$.getExec(s1, minGCInterval);
            Some x$1 = new Some((Object)Exec$.MODULE$.apply(BasicCommandStrings$.MODULE$.Shell(), (Option)None$.MODULE$));
            Exec exec2 = exec;
            Exec exec3 = Exec$.MODULE$.apply(BasicCommandStrings$.MODULE$.Shell(), (Option)None$.MODULE$);
            List x$2 = (List)((List)s1.remainingCommands().$plus$colon((Object)exec3, List$.MODULE$.canBuildFrom())).$plus$colon((Object)exec2, List$.MODULE$.canBuildFrom());
            AppConfiguration x$3 = s1.copy$default$1();
            Seq x$4 = s1.copy$default$2();
            Set x$5 = s1.copy$default$3();
            State.History x$6 = s1.copy$default$6();
            AttributeMap x$7 = s1.copy$default$7();
            GlobalLogging x$8 = s1.copy$default$8();
            Option x$9 = s1.copy$default$9();
            State.Next x$10 = s1.copy$default$10();
            State newState = State.StateOpsImpl$.MODULE$.setInteractive$extension(State$.MODULE$.StateOpsImpl(s1.copy(x$3, x$4, x$5, (Option)x$1, x$2, x$6, x$7, x$8, x$9, x$10)), true);
            State res = exec.commandLine().trim().isEmpty() ? newState : State.StateOpsImpl$.MODULE$.clearGlobalLog$extension(State$.MODULE$.StateOpsImpl(newState));
            return res;
        });
    }

    public Command rebootNetwork() {
        return Command$.MODULE$.arb((Function1 & Serializable & scala.Serializable)x$75 -> DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literal(BasicCommandStrings$.MODULE$.RebootNetwork())).examples((Seq)Nil$.MODULE$), Command$.MODULE$.arb$default$2(), (Function2 & Serializable & scala.Serializable)(s, x$76) -> {
            StandardMain$.MODULE$.exchange().reboot((State)s);
            return s;
        });
    }

    public Command startServer() {
        return Command$.MODULE$.command(BasicCommandStrings$.MODULE$.StartServer(), Help$.MODULE$.more(BasicCommandStrings$.MODULE$.StartServer(), BasicCommandStrings$.MODULE$.StartServerDetailed()), (Function1 & Serializable & scala.Serializable)s0 -> {
            CommandExchange exchange = StandardMain$.MODULE$.exchange();
            return exchange.runServer((State)s0);
        });
    }

    private Regex sbtVersionRegex() {
        return this.sbtVersionRegex;
    }

    private boolean isSbtVersionLine(String s) {
        return this.sbtVersionRegex().pattern().matcher(s).matches();
    }

    private void writeSbtVersionUnconditionally(State state) {
        File baseDir = State.StateOpsImpl$.MODULE$.baseDir$extension(State$.MODULE$.StateOpsImpl(state));
        String sbtVersion = this.sbtVersion(state);
        File projectDir = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(baseDir), "project");
        File buildProps = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(projectDir), "build.properties");
        Object buildPropsLines = buildProps.canRead() ? IO$.MODULE$.readLines(buildProps, IO$.MODULE$.readLines$default$2()) : Nil$.MODULE$;
        boolean sbtVersionAbsent = buildPropsLines.forall((Function1 & Serializable & scala.Serializable)x$77 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$writeSbtVersionUnconditionally$1(x$77)));
        if (sbtVersionAbsent) {
            String warnMsg = new StringBuilder(64).append("No sbt.version set in project/build.properties, base directory: ").append(baseDir).toString();
            try {
                if (CommandUtil$.MODULE$.isSbtBuild(baseDir)) {
                    String line;
                    String string = line = new StringBuilder(12).append("sbt.version=").append(sbtVersion).toString();
                    IO$.MODULE$.writeLines(buildProps, (Seq)buildPropsLines.$colon$colon((Object)string), IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
                    State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Updated file ").append(buildProps).append(": set sbt.version to ").append(sbtVersion).toString());
                } else {
                    State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).warn((Function0 & Serializable & scala.Serializable)() -> warnMsg);
                }
            }
            catch (IOException iOException) {
                State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).warn((Function0 & Serializable & scala.Serializable)() -> warnMsg);
            }
            return;
        }
    }

    private boolean intendsToInvokeNew(State state) {
        return state.remainingCommands().exists((Function1 & Serializable & scala.Serializable)x$79 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$intendsToInvokeNew$1(x$79)));
    }

    private void writeSbtVersion(State state) {
        if (SysProp$.MODULE$.genBuildProps() && !this.intendsToInvokeNew(state)) {
            this.writeSbtVersionUnconditionally(state);
            return;
        }
    }

    private void checkRoot(State state) {
        if (SysProp$.MODULE$.allowRootDir()) {
            return;
        }
        File baseDir = State.StateOpsImpl$.MODULE$.baseDir$extension(State$.MODULE$.StateOpsImpl(state));
        Option rootOpt = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(FileSystems.getDefault().getRootDirectories()).asScala()).toList().headOption();
        rootOpt.foreach((Function1 & Serializable & scala.Serializable)root -> {
            BuiltinCommands$.$anonfun$checkRoot$1(baseDir, root);
            return BoxedUnit.UNIT;
        });
    }

    private String WriteSbtVersion() {
        return "writeSbtVersion";
    }

    private Command writeSbtVersion() {
        return Command$.MODULE$.command(this.WriteSbtVersion(), Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)state -> {
            MODULE$.checkRoot((State)state);
            MODULE$.writeSbtVersion((State)state);
            return state;
        });
    }

    private boolean intendsToInvokeCompile(State state) {
        return state.remainingCommands().exists((Function1 & Serializable & scala.Serializable)x$80 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$intendsToInvokeCompile$1(x$80)));
    }

    private boolean hasRebooted(State state) {
        return state.remainingCommands().exists((Function1 & Serializable & scala.Serializable)x$81 -> BoxesRunTime.boxToBoolean((boolean)BuiltinCommands$.$anonfun$hasRebooted$1(x$81)));
    }

    private void notifyUsersAboutShell(State state) {
        boolean suppress = BoxesRunTime.unboxToBoolean((Object)Project$.MODULE$.extract(state).getOpt(Keys$.MODULE$.suppressSbtShellNotification()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (!suppress && this.intendsToInvokeCompile(state) && !this.hasRebooted(state)) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).info((Function0 & Serializable & scala.Serializable)() -> "Executing in batch mode. For better performance use sbt's shell");
            return;
        }
    }

    private String NotifyUsersAboutShell() {
        return "notifyUsersAboutShell";
    }

    private Command notifyUsersAboutShell() {
        return Command$.MODULE$.command(this.NotifyUsersAboutShell(), Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)state -> {
            MODULE$.notifyUsersAboutShell((State)state);
            return state;
        });
    }

    private Path skipWelcomeFile(State state, String version) {
        Path base = BuildPaths$.MODULE$.getGlobalBase(state).toPath();
        return base.resolve("preferences").resolve(version).resolve(this.SkipBannerFileName);
    }

    private State displayWelcomeBanner(State state) {
        if (!BoxesRunTime.unboxToBoolean((Object)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), this.bannerHasBeenShown).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            try {
                boolean suppress;
                String version = this.sbtVersion(state);
                Path skipFile = this.skipWelcomeFile(state, version);
                Files.createDirectories(skipFile.getParent(), new FileAttribute[0]);
                boolean bl = suppress = !SysProp$.MODULE$.banner() || Files.exists(skipFile, new LinkOption[0]);
                if (!suppress) {
                    Banner$.MODULE$.apply(version).foreach((Function1 & Serializable & scala.Serializable)banner -> {
                        BuiltinCommands$.$anonfun$displayWelcomeBanner$2(state, banner);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            catch (IOException iOException) {}
            return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state), this.bannerHasBeenShown, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return state;
    }

    private Command skipBanner() {
        return Command$.MODULE$.command(this.SkipBanner, Command$.MODULE$.command$default$2(), (Function1 & Serializable & scala.Serializable)state -> MODULE$.skipBanner((State)state));
    }

    private State skipBanner(State state) {
        Object object;
        Path skipFile = this.skipWelcomeFile(state, this.sbtVersion(state));
        try {
            object = Files.createFile(skipFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            object = BoxedUnit.UNIT;
        }
        catch (IOException e) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state)).error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Couldn't create file ").append(skipFile).append(": ").append(e).toString());
            object = BoxedUnit.UNIT;
        }
        return state;
    }

    private static final Seq plugins$1(LoadedBuildUnit lbu) {
        return (Seq)lbu.unit().plugins().detected().autoPlugins().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.value().label(), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$settingsCommand$1(AttributeKey key) {
        return !MODULE$.isTask(key.manifest(), ManifestFactory$.MODULE$.classType(Task.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), ManifestFactory$.MODULE$.classType(InputTask.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public static final /* synthetic */ int $anonfun$verbosityParser$1(Seq x$28) {
        return x$28.size() + 1;
    }

    public static final /* synthetic */ boolean $anonfun$withDescription$1(AttributeKey x$31) {
        return x$31.description().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$highPass$2(int rankCutoff$1, AttributeKey x$32) {
        return x$32.rank() <= rankCutoff$1;
    }

    private static final State export0$1(State s, Seq kvs$1) {
        return MODULE$.lastImpl(s, (Seq<Aggregation.KeyValue<Object>>)kvs$1, (Option<String>)new Some((Object)CommandStrings$.MODULE$.ExportStream()));
    }

    public static final /* synthetic */ boolean $anonfun$isLastOnly$1(Exec x$40) {
        String string = x$40.commandLine();
        String string2 = BasicCommandStrings$.MODULE$.Shell();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String prefix$1(String id, String currentID$1, boolean current$1) {
        String string = currentID$1;
        String string2 = id;
        if (string == null ? string2 != null : !string.equals(string2)) {
            return "   ";
        }
        if (current$1) {
            return " * ";
        }
        return "(*)";
    }

    public static final /* synthetic */ boolean $anonfun$showProjects$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$showProjects$2(Extracted extracted$3, Tuple2 x$42) {
        Tuple2 tuple2 = x$42;
        if (tuple2 != null) {
            URI uri = (URI)tuple2._1();
            URI uRI = extracted$3.currentRef().build();
            URI uRI2 = uri;
            return uRI == null ? uRI2 != null : !((Object)uRI).equals(uRI2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(Extracted extracted$3, State s$10, Tuple2 x$43) {
        Tuple2 tuple2 = x$43;
        if (tuple2 != null) {
            URI uri = (URI)tuple2._1();
            LoadedBuildUnit build = (LoadedBuildUnit)tuple2._2();
            MODULE$.listBuild(uri, build, false, extracted$3.currentRef().project(), (Logger)State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s$10)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final State retry$1(String loadArg$1, State s$11) {
        String string = this.loadProjectCommand(CommandStrings$.MODULE$.LoadProject(), loadArg$1);
        return State.StateOpsImpl$.MODULE$.$colon$colon$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.clearGlobalLog$extension(State$.MODULE$.StateOpsImpl(s$11))), string);
    }

    private static final String ignoreMsg$1(State s$11) {
        if (Project$.MODULE$.isProjectLoaded(s$11)) {
            return "using previously loaded project";
        }
        return "no project loaded";
    }

    public static final /* synthetic */ Option $anonfun$checkSBTVersionChanged$1(Option sbtVersionBuildOpt$1) {
        return sbtVersionBuildOpt$1;
    }

    public static final /* synthetic */ void $anonfun$checkSBTVersionChanged$2(State state$1, String version) {
        String appVersion = state$1.configuration().provider().id().version();
        String string = version;
        String string2 = appVersion;
        if (string == null ? string2 != null : !string.equals(string2)) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state$1)).warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("sbt version mismatch, using: ").append(appVersion).append(", ").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("in build.properties: \"").append(version).append("\", use 'reboot' to use the new value.").toString())).stripMargin()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoadProject$3(State s0$1, String x$57) {
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s0$1)).debug((Function0 & Serializable & scala.Serializable)() -> x$57);
    }

    private static final /* synthetic */ Tuple2 liftedTree1$1(State s2$1, File base$1, State s0$1) {
        Tuple2<Function0<Eval>, BuildStructure> tuple2;
        try {
            tuple2 = Load$.MODULE$.defaultLoad(s2$1, base$1, (Logger)State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s2$1)), Project$.MODULE$.inPluginProject(s2$1), Project$.MODULE$.extraBuilds(s2$1));
        }
        catch (EvalException ex) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s0$1)).debug((Function0 & Serializable & scala.Serializable)() -> ex.getMessage());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ex.getStackTrace())).map((Function1 & Serializable & scala.Serializable)ste -> new StringBuilder(4).append("\tat ").append(ste).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)x$57 -> {
                BuiltinCommands$.$anonfun$doLoadProject$3(s0$1, x$57);
                return BoxedUnit.UNIT;
            });
            ex.setStackTrace((StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class)));
            throw ex;
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$promptChannel$3(Exec x$69) {
        String string = x$69.commandLine();
        String string2 = BasicCommandStrings$.MODULE$.Shell();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$writeSbtVersionUnconditionally$1(String x$77) {
        return !MODULE$.isSbtVersionLine(x$77);
    }

    public static final /* synthetic */ boolean $anonfun$intendsToInvokeNew$1(Exec x$79) {
        String string = x$79.commandLine();
        String string2 = BasicCommandStrings$.MODULE$.TemplateCommand();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$checkRoot$1(File baseDir$1, Path root) {
        String string = baseDir$1.getAbsolutePath();
        String string2 = ((Object)root).toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalStateException("cannot run sbt from root directory without -Dsbt.rootdir=true; see sbt/sbt#1458");
        }
    }

    public static final /* synthetic */ boolean $anonfun$intendsToInvokeCompile$1(Exec x$80) {
        String string = x$80.commandLine();
        String string2 = Keys$.MODULE$.compile().key().label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasRebooted$1(Exec x$81) {
        String string = x$81.commandLine();
        String string2 = BasicCommandStrings$.MODULE$.StartServer();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$displayWelcomeBanner$2(State state$2, String banner) {
        State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(state$2)).info((Function0 & Serializable & scala.Serializable)() -> banner);
    }

    private BuiltinCommands$() {
        MODULE$ = this;
        this.spacedAggregatedParser = (Function1 & Serializable & scala.Serializable)s -> Act$.MODULE$.requireSession((State)s, (Function0 & Serializable & scala.Serializable)() -> DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(Act$.MODULE$.aggregatedKeyParser((State)s)));
        this.aggregatedKeyValueParser = (Function1 & Serializable & scala.Serializable)s -> DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser((Parser)MODULE$.spacedAggregatedParser().apply(s)).map((Function1 & Serializable & scala.Serializable)x -> Act$.MODULE$.keyValues((State)s, x))).$qmark();
        this.exportParser = (Function1 & Serializable & scala.Serializable)s -> Act$.MODULE$.requireSession((State)s, (Function0 & Serializable & scala.Serializable)() -> DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(MODULE$.exportParser0((State)s)));
        this.pluginParser = (Function1 & Serializable & scala.Serializable)s -> {
            Map<String, AutoPlugin> autoPlugins = PluginsDebug$.MODULE$.autoPluginMap((State)s);
            return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(Act$.MODULE$.knownPluginParser(autoPlugins, "plugin"));
        };
        this.setupGlobalFileTreeRepository = (Function1 & Serializable & scala.Serializable)state -> {
            State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), sbt.nio.Keys$.MODULE$.globalFileTreeRepository()).foreach((Function1 & Serializable & scala.Serializable)x$59 -> {
                x$59.close();
                return BoxedUnit.UNIT;
            });
            return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(state), sbt.nio.Keys$.MODULE$.globalFileTreeRepository(), (Object)FileTreeRepository$.MODULE$.default());
        };
        this.addSuperShellParams = (Function1 & Serializable & scala.Serializable)s -> {
            Extracted extracted = Project$.MODULE$.extract((State)s);
            FiniteDuration sleep = (FiniteDuration)extracted.getOpt(Keys$.MODULE$.superShellSleep()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationLong(package$.MODULE$.DurationLong(SysProp$.MODULE$.supershellSleep())).millis());
            FiniteDuration threshold = (FiniteDuration)extracted.getOpt(Keys$.MODULE$.superShellThreshold()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SysProp$.MODULE$.supershellThreshold());
            int maxItems = BoxesRunTime.unboxToInt((Object)extracted.getOpt(Keys$.MODULE$.superShellMaxTasks()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> SysProp$.MODULE$.supershellMaxTasks()));
            Terminal$.MODULE$.setConsoleProgressState(new ProgressState(1, maxItems));
            return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.superShellSleep().key(), (Object)sleep)), Keys$.MODULE$.superShellThreshold().key(), (Object)threshold)), Keys$.MODULE$.superShellMaxTasks().key(), (Object)BoxesRunTime.boxToInteger((int)maxItems));
        };
        this.addCacheStoreFactoryFactory = (Function1 & Serializable & scala.Serializable)s -> {
            long size = BoxesRunTime.unboxToLong((Object)Project$.MODULE$.extract((State)s).getOpt(Keys$.MODULE$.fileCacheSize()).flatMap((Function1 & Serializable & scala.Serializable)x$60 -> SizeParser$.MODULE$.apply(x$60)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> SysProp$.MODULE$.fileCacheSize()));
            State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.cacheStoreFactoryFactory()).foreach((Function1 & Serializable & scala.Serializable)x$61 -> {
                x$61.close();
                return BoxedUnit.UNIT;
            });
            return State.StateOpsImpl$.MODULE$.put$extension(State$.MODULE$.StateOpsImpl(s), Keys$.MODULE$.cacheStoreFactoryFactory(), (Object)InMemoryCacheStore$.MODULE$.factory(size));
        };
        this.sbtVersionRegex = new StringOps(Predef$.MODULE$.augmentString("sbt\\.version\\s*=.*")).r();
        this.bannerHasBeenShown = AttributeKey$.MODULE$.apply("banner-has-been-shown", Integer.MAX_VALUE, (Manifest)ManifestFactory$.MODULE$.Boolean(), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.SkipBannerFileName = "skip-banner";
        this.SkipBanner = "skipBanner";
    }
}

