/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import sbt.AutoPlugin;
import sbt.PluginData;
import sbt.Plugins$;
import sbt.ScriptedPlugin$;
import sbt.Tests$;
import sbt.internal.BuildDef;
import sbt.internal.BuildDef$;
import sbt.internal.DetectedAutoPlugin;
import sbt.internal.DetectedModules;
import sbt.internal.DetectedPlugins;
import sbt.internal.IncompatiblePluginsException;
import sbt.internal.PluginDiscovery;
import sbt.internal.inc.ModuleUtilities$;
import sbt.internal.util.Attributed;
import sbt.internal.util.Attributed$;
import sbt.io.IO$;
import sbt.plugins.CorePlugin$;
import sbt.plugins.Giter8TemplatePlugin$;
import sbt.plugins.IvyPlugin$;
import sbt.plugins.JUnitXmlReportPlugin$;
import sbt.plugins.JvmPlugin$;
import sbt.plugins.MiniDependencyTreePlugin$;
import sbt.plugins.SbtPlugin$;
import sbt.plugins.SemanticdbPlugin$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import xsbt.api.Discovered;
import xsbt.api.Discovery$;
import xsbti.api.Definition;
import xsbti.compile.CompileAnalysis;

public final class PluginDiscovery$ {
    public static PluginDiscovery$ MODULE$;

    static {
        new PluginDiscovery$();
    }

    public PluginDiscovery.DiscoveredNames emptyDiscoveredNames() {
        return new PluginDiscovery.DiscoveredNames((Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
    }

    public DetectedPlugins discoverAll(PluginData data, ClassLoader loader) {
        Seq defaultAutoPlugins = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.IvyPlugin"), (Object)IvyPlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.JvmPlugin"), (Object)JvmPlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.CorePlugin"), (Object)CorePlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.ScriptedPlugin"), (Object)ScriptedPlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.SbtPlugin"), (Object)SbtPlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.SemanticdbPlugin"), (Object)SemanticdbPlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.JUnitXmlReportPlugin"), (Object)JUnitXmlReportPlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.Giter8TemplatePlugin"), (Object)Giter8TemplatePlugin$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sbt.plugins.MiniDependencyTreePlugin"), (Object)MiniDependencyTreePlugin$.MODULE$)}));
        DetectedModules detectedAutoPlugins = this.discover$1("sbt/sbt.autoplugins", ClassTag$.MODULE$.apply(AutoPlugin.class), data, loader);
        Seq allAutoPlugins = (Seq)((TraversableLike)defaultAutoPlugins.$plus$plus(detectedAutoPlugins.modules(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                AutoPlugin value = (AutoPlugin)tuple2._2();
                return new DetectedAutoPlugin(name, value, Plugins$.MODULE$.hasAutoImportGetter(value, loader));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return new DetectedPlugins((Seq<DetectedAutoPlugin>)allAutoPlugins, this.discover$1("sbt/sbt.builds", ClassTag$.MODULE$.apply(BuildDef.class), data, loader));
    }

    public PluginDiscovery.DiscoveredNames discoverSourceAll(CompileAnalysis analysis) {
        return new PluginDiscovery.DiscoveredNames((Seq<String>)this.discover$2(ClassTag$.MODULE$.apply(AutoPlugin.class), analysis), (Seq<String>)this.discover$2(ClassTag$.MODULE$.apply(BuildDef.class), analysis));
    }

    public Seq<File> writeDescriptors(PluginDiscovery.DiscoveredNames names, File dir) {
        Option<File> option = this.writeDescriptor(names.autoPlugins(), dir, "sbt/sbt.autoplugins");
        Option<File> option2 = this.writeDescriptor(names.builds(), dir, "sbt/sbt.builds");
        List files = Nil$.MODULE$.$colon$colon(option2).$colon$colon(option);
        return (Seq)files.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toList(), List$.MODULE$.canBuildFrom());
    }

    public Option<File> writeDescriptor(Seq<String> names, File dir, String path) {
        File descriptor = new File(dir, path);
        if (names.isEmpty()) {
            IO$.MODULE$.delete(descriptor);
            return None$.MODULE$;
        }
        IO$.MODULE$.writeLines(descriptor, (Seq)((SeqLike)names.distinct()).sorted((Ordering)Ordering.String$.MODULE$), IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
        return new Some((Object)descriptor);
    }

    public Seq<String> binarySourceModuleNames(Seq<Attributed<File>> classpath, ClassLoader loader, String resourceName, Seq<String> subclasses) {
        return (Seq)((SeqLike)this.binaryModuleNames((Seq<File>)Attributed$.MODULE$.data(classpath), loader, resourceName).$plus$plus((GenTraversableOnce)BuildDef$.MODULE$.analyzed(classpath).flatMap((Function1 & Serializable & scala.Serializable)a -> MODULE$.sourceModuleNames((CompileAnalysis)a, subclasses), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public Seq<String> sourceModuleNames(CompileAnalysis analysis, Seq<String> subclasses) {
        Set subclassSet = subclasses.toSet();
        Seq defs = Tests$.MODULE$.allDefs(analysis);
        Seq ds = Discovery$.MODULE$.apply(subclassSet, Predef$.MODULE$.Set().empty(), defs);
        return (Seq)ds.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Definition definition = (Definition)tuple2._1();
                Discovered discovered = (Discovered)tuple2._2();
                if (discovered != null) {
                    Set subs = discovered.baseClasses();
                    boolean bl = discovered.isModule();
                    if (bl) {
                        if (((SetLike)subs.$amp((GenSet)subclassSet)).isEmpty()) {
                            return Nil$.MODULE$;
                        }
                        String string = definition.name();
                        return Nil$.MODULE$.$colon$colon((Object)string);
                    }
                }
            }
            return Nil$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> binaryModuleNames(Seq<File> classpath, ClassLoader loader, String resourceName) {
        return (Seq)((TraversableLike)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(loader.getResources(resourceName)).asScala()).toSeq().filter((Function1 & Serializable & scala.Serializable)url -> BoxesRunTime.boxToBoolean((boolean)PluginDiscovery$.MODULE$.onClasspath((Seq<File>)classpath, url)))).flatMap((Function1 & Serializable & scala.Serializable)u -> (List)((TraversableLike)IO$.MODULE$.readLinesURL(u, IO$.MODULE$.readLinesURL$default$2()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PluginDiscovery$.$anonfun$binaryModuleNames$4(x$6))), Seq$.MODULE$.canBuildFrom());
    }

    public boolean onClasspath(Seq<File> classpath, URL url) {
        return IO$.MODULE$.urlAsFile(url).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpath.contains(elem)));
    }

    public <T> DetectedModules<T> binarySourceModules(PluginData data, ClassLoader loader, String resourceName, ClassTag<T> classTag) {
        Seq<Tuple2<String, T>> seq;
        Seq<Attributed<File>> classpath = data.classpath();
        if (classpath.isEmpty()) {
            seq = Nil$.MODULE$;
        } else {
            Seq<String> names = this.binarySourceModuleNames(classpath, loader, resourceName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{classTag.runtimeClass().getName()}));
            seq = this.loadModules(data, names, loader, classTag);
        }
        Seq<Tuple2<String, T>> namesAndValues = seq;
        return new DetectedModules(namesAndValues);
    }

    private <T> Seq<Tuple2<String, T>> loadModules(PluginData data, Seq<String> names, ClassLoader loader, ClassTag<T> evidence$1) {
        Seq seq;
        try {
            seq = ModuleUtilities$.MODULE$.getCheckedObjects(names, loader, evidence$1);
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            throw cause;
        }
        catch (LinkageError e) {
            throw this.incompatiblePlugins(data, e);
        }
        return seq;
    }

    private Nothing$ incompatiblePlugins(PluginData data, LinkageError t) {
        List evicted = (List)data.report().toList().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Vector)x$7.configurations().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.evicted(), Vector$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        List evictedModules = (List)((SeqLike)evicted.map((Function1 & Serializable & scala.Serializable)id -> new Tuple2((Object)id.organization(), (Object)id.name()), List$.MODULE$.canBuildFrom())).distinct();
        List evictedStrings = (List)evictedModules.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String o = (String)tuple2._1();
                String n = (String)tuple2._2();
                return new StringBuilder(1).append(o).append(":").append(n).toString();
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        String msgBase = "Binary incompatibility in plugins detected.";
        String msgExtra = evictedStrings.isEmpty() ? "" : new StringBuilder(59).append("\nNote that conflicts were resolved for some dependencies:\n\t").append(evictedStrings.mkString("\n\t")).toString();
        throw new IncompatiblePluginsException(new StringBuilder(0).append(msgBase).append(msgExtra).toString(), t);
    }

    private final DetectedModules discover$1(String resource, ClassTag classTag, PluginData data$1, ClassLoader loader$1) {
        return this.binarySourceModules(data$1, loader$1, resource, classTag);
    }

    private final Seq discover$2(ClassTag classTag, CompileAnalysis analysis$1) {
        return this.sourceModuleNames(analysis$1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{classTag.runtimeClass().getName()}));
    }

    public static final /* synthetic */ boolean $anonfun$binaryModuleNames$4(String x$6) {
        return !x$6.isEmpty();
    }

    private PluginDiscovery$() {
        MODULE$ = this;
    }
}

